<?php
/**
 * TaxSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: api-support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.5
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * TaxSettings Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TaxSettings implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'TaxSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'chargeTax' => 'bool',
        'productsIncludeTax' => 'bool',
        'productsPriceIncludeExcludeTax' => 'bool',
        'deliveryTax' => 'string',
        'deliveryShowTax' => 'bool',
        'taxRates' => '\EKM\Model\TaxRateModel[]',
        'countryCodes' => '\EKM\Model\CountryCodeModel[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'chargeTax' => null,
        'productsIncludeTax' => null,
        'productsPriceIncludeExcludeTax' => null,
        'deliveryTax' => null,
        'deliveryShowTax' => null,
        'taxRates' => null,
        'countryCodes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'chargeTax' => 'charge_tax',
        'productsIncludeTax' => 'products_include_tax',
        'productsPriceIncludeExcludeTax' => 'products_price_include_exclude_tax',
        'deliveryTax' => 'delivery_tax',
        'deliveryShowTax' => 'delivery_show_tax',
        'taxRates' => 'tax_rates',
        'countryCodes' => 'country_codes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'chargeTax' => 'setChargeTax',
        'productsIncludeTax' => 'setProductsIncludeTax',
        'productsPriceIncludeExcludeTax' => 'setProductsPriceIncludeExcludeTax',
        'deliveryTax' => 'setDeliveryTax',
        'deliveryShowTax' => 'setDeliveryShowTax',
        'taxRates' => 'setTaxRates',
        'countryCodes' => 'setCountryCodes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'chargeTax' => 'getChargeTax',
        'productsIncludeTax' => 'getProductsIncludeTax',
        'productsPriceIncludeExcludeTax' => 'getProductsPriceIncludeExcludeTax',
        'deliveryTax' => 'getDeliveryTax',
        'deliveryShowTax' => 'getDeliveryShowTax',
        'taxRates' => 'getTaxRates',
        'countryCodes' => 'getCountryCodes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    const DELIVERY_TAX_NON = 'Non';
    const DELIVERY_TAX_EXCLUDES = 'Excludes';
    const DELIVERY_TAX_INCLUDES = 'Includes';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDeliveryTaxAllowableValues()
    {
        return [
            self::DELIVERY_TAX_NON,
            self::DELIVERY_TAX_EXCLUDES,
            self::DELIVERY_TAX_INCLUDES,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['chargeTax'] = isset($data['chargeTax']) ? $data['chargeTax'] : null;
        $this->container['productsIncludeTax'] = isset($data['productsIncludeTax']) ? $data['productsIncludeTax'] : null;
        $this->container['productsPriceIncludeExcludeTax'] = isset($data['productsPriceIncludeExcludeTax']) ? $data['productsPriceIncludeExcludeTax'] : null;
        $this->container['deliveryTax'] = isset($data['deliveryTax']) ? $data['deliveryTax'] : null;
        $this->container['deliveryShowTax'] = isset($data['deliveryShowTax']) ? $data['deliveryShowTax'] : null;
        $this->container['taxRates'] = isset($data['taxRates']) ? $data['taxRates'] : null;
        $this->container['countryCodes'] = isset($data['countryCodes']) ? $data['countryCodes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDeliveryTaxAllowableValues();
        if (!is_null($this->container['deliveryTax']) && !in_array($this->container['deliveryTax'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'deliveryTax', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets chargeTax
     *
     * @return bool
     */
    public function getChargeTax()
    {
        return $this->container['chargeTax'];
    }

    /**
     * Sets chargeTax
     *
     * @param bool $chargeTax chargeTax
     *
     * @return $this
     */
    public function setChargeTax($chargeTax)
    {
        $this->container['chargeTax'] = $chargeTax;

        return $this;
    }

    /**
     * Gets productsIncludeTax
     *
     * @return bool
     */
    public function getProductsIncludeTax()
    {
        return $this->container['productsIncludeTax'];
    }

    /**
     * Sets productsIncludeTax
     *
     * @param bool $productsIncludeTax productsIncludeTax
     *
     * @return $this
     */
    public function setProductsIncludeTax($productsIncludeTax)
    {
        $this->container['productsIncludeTax'] = $productsIncludeTax;

        return $this;
    }

    /**
     * Gets productsPriceIncludeExcludeTax
     *
     * @return bool
     */
    public function getProductsPriceIncludeExcludeTax()
    {
        return $this->container['productsPriceIncludeExcludeTax'];
    }

    /**
     * Sets productsPriceIncludeExcludeTax
     *
     * @param bool $productsPriceIncludeExcludeTax productsPriceIncludeExcludeTax
     *
     * @return $this
     */
    public function setProductsPriceIncludeExcludeTax($productsPriceIncludeExcludeTax)
    {
        $this->container['productsPriceIncludeExcludeTax'] = $productsPriceIncludeExcludeTax;

        return $this;
    }

    /**
     * Gets deliveryTax
     *
     * @return string
     */
    public function getDeliveryTax()
    {
        return $this->container['deliveryTax'];
    }

    /**
     * Sets deliveryTax
     *
     * @param string $deliveryTax deliveryTax
     *
     * @return $this
     */
    public function setDeliveryTax($deliveryTax)
    {
        $allowedValues = $this->getDeliveryTaxAllowableValues();
        if (!is_null($deliveryTax) && !in_array($deliveryTax, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'deliveryTax', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['deliveryTax'] = $deliveryTax;

        return $this;
    }

    /**
     * Gets deliveryShowTax
     *
     * @return bool
     */
    public function getDeliveryShowTax()
    {
        return $this->container['deliveryShowTax'];
    }

    /**
     * Sets deliveryShowTax
     *
     * @param bool $deliveryShowTax deliveryShowTax
     *
     * @return $this
     */
    public function setDeliveryShowTax($deliveryShowTax)
    {
        $this->container['deliveryShowTax'] = $deliveryShowTax;

        return $this;
    }

    /**
     * Gets taxRates
     *
     * @return \EKM\Model\TaxRateModel[]
     */
    public function getTaxRates()
    {
        return $this->container['taxRates'];
    }

    /**
     * Sets taxRates
     *
     * @param \EKM\Model\TaxRateModel[] $taxRates taxRates
     *
     * @return $this
     */
    public function setTaxRates($taxRates)
    {
        $this->container['taxRates'] = $taxRates;

        return $this;
    }

    /**
     * Gets countryCodes
     *
     * @return \EKM\Model\CountryCodeModel[]
     */
    public function getCountryCodes()
    {
        return $this->container['countryCodes'];
    }

    /**
     * Sets countryCodes
     *
     * @param \EKM\Model\CountryCodeModel[] $countryCodes countryCodes
     *
     * @return $this
     */
    public function setCountryCodes($countryCodes)
    {
        $this->container['countryCodes'] = $countryCodes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


