<?php
/**
 * ProductVariant
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: api-support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.5
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * ProductVariant Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProductVariant implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ProductVariant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'parentProductId' => 'int',
        'productCode' => 'string',
        'isDefaultVariant' => 'bool',
        'numberInStock' => 'int',
        'price' => 'double',
        'condition' => 'string',
        'gtin' => 'string',
        'mpn' => 'string',
        'live' => 'bool',
        'variantCombinations' => '\EKM\Model\VariantCombination[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
        'parentProductId' => 'int64',
        'productCode' => null,
        'isDefaultVariant' => null,
        'numberInStock' => 'int64',
        'price' => 'double',
        'condition' => null,
        'gtin' => null,
        'mpn' => null,
        'live' => null,
        'variantCombinations' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'parentProductId' => 'parent_product_id',
        'productCode' => 'product_code',
        'isDefaultVariant' => 'is_default_variant',
        'numberInStock' => 'number_in_stock',
        'price' => 'price',
        'condition' => 'condition',
        'gtin' => 'gtin',
        'mpn' => 'mpn',
        'live' => 'live',
        'variantCombinations' => 'variant_combinations'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'parentProductId' => 'setParentProductId',
        'productCode' => 'setProductCode',
        'isDefaultVariant' => 'setIsDefaultVariant',
        'numberInStock' => 'setNumberInStock',
        'price' => 'setPrice',
        'condition' => 'setCondition',
        'gtin' => 'setGtin',
        'mpn' => 'setMpn',
        'live' => 'setLive',
        'variantCombinations' => 'setVariantCombinations'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'parentProductId' => 'getParentProductId',
        'productCode' => 'getProductCode',
        'isDefaultVariant' => 'getIsDefaultVariant',
        'numberInStock' => 'getNumberInStock',
        'price' => 'getPrice',
        'condition' => 'getCondition',
        'gtin' => 'getGtin',
        'mpn' => 'getMpn',
        'live' => 'getLive',
        'variantCombinations' => 'getVariantCombinations'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['parentProductId'] = isset($data['parentProductId']) ? $data['parentProductId'] : null;
        $this->container['productCode'] = isset($data['productCode']) ? $data['productCode'] : null;
        $this->container['isDefaultVariant'] = isset($data['isDefaultVariant']) ? $data['isDefaultVariant'] : null;
        $this->container['numberInStock'] = isset($data['numberInStock']) ? $data['numberInStock'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['condition'] = isset($data['condition']) ? $data['condition'] : null;
        $this->container['gtin'] = isset($data['gtin']) ? $data['gtin'] : null;
        $this->container['mpn'] = isset($data['mpn']) ? $data['mpn'] : null;
        $this->container['live'] = isset($data['live']) ? $data['live'] : null;
        $this->container['variantCombinations'] = isset($data['variantCombinations']) ? $data['variantCombinations'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['price']) && ($this->container['price'] < 0)) {
            $invalidProperties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets parentProductId
     *
     * @return int
     */
    public function getParentProductId()
    {
        return $this->container['parentProductId'];
    }

    /**
     * Sets parentProductId
     *
     * @param int $parentProductId parentProductId
     *
     * @return $this
     */
    public function setParentProductId($parentProductId)
    {
        $this->container['parentProductId'] = $parentProductId;

        return $this;
    }

    /**
     * Gets productCode
     *
     * @return string
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     *
     * @param string $productCode productCode
     *
     * @return $this
     */
    public function setProductCode($productCode)
    {
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets isDefaultVariant
     *
     * @return bool
     */
    public function getIsDefaultVariant()
    {
        return $this->container['isDefaultVariant'];
    }

    /**
     * Sets isDefaultVariant
     *
     * @param bool $isDefaultVariant isDefaultVariant
     *
     * @return $this
     */
    public function setIsDefaultVariant($isDefaultVariant)
    {
        $this->container['isDefaultVariant'] = $isDefaultVariant;

        return $this;
    }

    /**
     * Gets numberInStock
     *
     * @return int
     */
    public function getNumberInStock()
    {
        return $this->container['numberInStock'];
    }

    /**
     * Sets numberInStock
     *
     * @param int $numberInStock numberInStock
     *
     * @return $this
     */
    public function setNumberInStock($numberInStock)
    {
        $this->container['numberInStock'] = $numberInStock;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double $price price
     *
     * @return $this
     */
    public function setPrice($price)
    {

        if (!is_null($price) && ($price < 0)) {
            throw new \InvalidArgumentException('invalid value for $price when calling ProductVariant., must be bigger than or equal to 0.');
        }

        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string $condition condition
     *
     * @return $this
     */
    public function setCondition($condition)
    {
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets gtin
     *
     * @return string
     */
    public function getGtin()
    {
        return $this->container['gtin'];
    }

    /**
     * Sets gtin
     *
     * @param string $gtin gtin
     *
     * @return $this
     */
    public function setGtin($gtin)
    {
        $this->container['gtin'] = $gtin;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string $mpn mpn
     *
     * @return $this
     */
    public function setMpn($mpn)
    {
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets live
     *
     * @return bool
     */
    public function getLive()
    {
        return $this->container['live'];
    }

    /**
     * Sets live
     *
     * @param bool $live live
     *
     * @return $this
     */
    public function setLive($live)
    {
        $this->container['live'] = $live;

        return $this;
    }

    /**
     * Gets variantCombinations
     *
     * @return \EKM\Model\VariantCombination[]
     */
    public function getVariantCombinations()
    {
        return $this->container['variantCombinations'];
    }

    /**
     * Sets variantCombinations
     *
     * @param \EKM\Model\VariantCombination[] $variantCombinations variantCombinations
     *
     * @return $this
     */
    public function setVariantCombinations($variantCombinations)
    {
        $this->container['variantCombinations'] = $variantCombinations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


