<?php
/**
 * Customer
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: api-support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.5
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Customer implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'emailAddress' => 'string',
        'firstName' => 'string',
        'lastName' => 'string',
        'orderCount' => 'int',
        'loyaltyPoints' => 'double',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'lastLoginDate' => '\DateTime',
        'lastLoginAttemptDate' => '\DateTime',
        'locked' => 'bool',
        'lockedDate' => '\DateTime',
        'lockedEndDate' => '\DateTime',
        'isSubscribedToNewsletter' => 'bool',
        'addresses' => '\EKM\Model\CustomerAddress[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
        'emailAddress' => null,
        'firstName' => null,
        'lastName' => null,
        'orderCount' => 'int32',
        'loyaltyPoints' => 'double',
        'createdDate' => 'date-time',
        'modifiedDate' => 'date-time',
        'lastLoginDate' => 'date-time',
        'lastLoginAttemptDate' => 'date-time',
        'locked' => null,
        'lockedDate' => 'date-time',
        'lockedEndDate' => 'date-time',
        'isSubscribedToNewsletter' => null,
        'addresses' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'emailAddress' => 'email_address',
        'firstName' => 'first_name',
        'lastName' => 'last_name',
        'orderCount' => 'order_count',
        'loyaltyPoints' => 'loyalty_points',
        'createdDate' => 'created_date',
        'modifiedDate' => 'modified_date',
        'lastLoginDate' => 'last_login_date',
        'lastLoginAttemptDate' => 'last_login_attempt_date',
        'locked' => 'locked',
        'lockedDate' => 'locked_date',
        'lockedEndDate' => 'locked_end_date',
        'isSubscribedToNewsletter' => 'is_subscribed_to_newsletter',
        'addresses' => 'addresses'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'emailAddress' => 'setEmailAddress',
        'firstName' => 'setFirstName',
        'lastName' => 'setLastName',
        'orderCount' => 'setOrderCount',
        'loyaltyPoints' => 'setLoyaltyPoints',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'lastLoginDate' => 'setLastLoginDate',
        'lastLoginAttemptDate' => 'setLastLoginAttemptDate',
        'locked' => 'setLocked',
        'lockedDate' => 'setLockedDate',
        'lockedEndDate' => 'setLockedEndDate',
        'isSubscribedToNewsletter' => 'setIsSubscribedToNewsletter',
        'addresses' => 'setAddresses'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'emailAddress' => 'getEmailAddress',
        'firstName' => 'getFirstName',
        'lastName' => 'getLastName',
        'orderCount' => 'getOrderCount',
        'loyaltyPoints' => 'getLoyaltyPoints',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'lastLoginDate' => 'getLastLoginDate',
        'lastLoginAttemptDate' => 'getLastLoginAttemptDate',
        'locked' => 'getLocked',
        'lockedDate' => 'getLockedDate',
        'lockedEndDate' => 'getLockedEndDate',
        'isSubscribedToNewsletter' => 'getIsSubscribedToNewsletter',
        'addresses' => 'getAddresses'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['emailAddress'] = isset($data['emailAddress']) ? $data['emailAddress'] : null;
        $this->container['firstName'] = isset($data['firstName']) ? $data['firstName'] : null;
        $this->container['lastName'] = isset($data['lastName']) ? $data['lastName'] : null;
        $this->container['orderCount'] = isset($data['orderCount']) ? $data['orderCount'] : null;
        $this->container['loyaltyPoints'] = isset($data['loyaltyPoints']) ? $data['loyaltyPoints'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['lastLoginDate'] = isset($data['lastLoginDate']) ? $data['lastLoginDate'] : null;
        $this->container['lastLoginAttemptDate'] = isset($data['lastLoginAttemptDate']) ? $data['lastLoginAttemptDate'] : null;
        $this->container['locked'] = isset($data['locked']) ? $data['locked'] : null;
        $this->container['lockedDate'] = isset($data['lockedDate']) ? $data['lockedDate'] : null;
        $this->container['lockedEndDate'] = isset($data['lockedEndDate']) ? $data['lockedEndDate'] : null;
        $this->container['isSubscribedToNewsletter'] = isset($data['isSubscribedToNewsletter']) ? $data['isSubscribedToNewsletter'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['firstName'] === null) {
            $invalidProperties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalidProperties[] = "'lastName' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets emailAddress
     *
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->container['emailAddress'];
    }

    /**
     * Sets emailAddress
     *
     * @param string $emailAddress emailAddress
     *
     * @return $this
     */
    public function setEmailAddress($emailAddress)
    {
        $this->container['emailAddress'] = $emailAddress;

        return $this;
    }

    /**
     * Gets firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     *
     * @param string $firstName firstName
     *
     * @return $this
     */
    public function setFirstName($firstName)
    {
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets lastName
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     *
     * @param string $lastName lastName
     *
     * @return $this
     */
    public function setLastName($lastName)
    {
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets orderCount
     *
     * @return int
     */
    public function getOrderCount()
    {
        return $this->container['orderCount'];
    }

    /**
     * Sets orderCount
     *
     * @param int $orderCount orderCount
     *
     * @return $this
     */
    public function setOrderCount($orderCount)
    {
        $this->container['orderCount'] = $orderCount;

        return $this;
    }

    /**
     * Gets loyaltyPoints
     *
     * @return double
     */
    public function getLoyaltyPoints()
    {
        return $this->container['loyaltyPoints'];
    }

    /**
     * Sets loyaltyPoints
     *
     * @param double $loyaltyPoints loyaltyPoints
     *
     * @return $this
     */
    public function setLoyaltyPoints($loyaltyPoints)
    {
        $this->container['loyaltyPoints'] = $loyaltyPoints;

        return $this;
    }

    /**
     * Gets createdDate
     *
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     *
     * @param \DateTime $createdDate createdDate
     *
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     *
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     *
     * @param \DateTime $modifiedDate modifiedDate
     *
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets lastLoginDate
     *
     * @return \DateTime
     */
    public function getLastLoginDate()
    {
        return $this->container['lastLoginDate'];
    }

    /**
     * Sets lastLoginDate
     *
     * @param \DateTime $lastLoginDate lastLoginDate
     *
     * @return $this
     */
    public function setLastLoginDate($lastLoginDate)
    {
        $this->container['lastLoginDate'] = $lastLoginDate;

        return $this;
    }

    /**
     * Gets lastLoginAttemptDate
     *
     * @return \DateTime
     */
    public function getLastLoginAttemptDate()
    {
        return $this->container['lastLoginAttemptDate'];
    }

    /**
     * Sets lastLoginAttemptDate
     *
     * @param \DateTime $lastLoginAttemptDate lastLoginAttemptDate
     *
     * @return $this
     */
    public function setLastLoginAttemptDate($lastLoginAttemptDate)
    {
        $this->container['lastLoginAttemptDate'] = $lastLoginAttemptDate;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return bool
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param bool $locked locked
     *
     * @return $this
     */
    public function setLocked($locked)
    {
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets lockedDate
     *
     * @return \DateTime
     */
    public function getLockedDate()
    {
        return $this->container['lockedDate'];
    }

    /**
     * Sets lockedDate
     *
     * @param \DateTime $lockedDate lockedDate
     *
     * @return $this
     */
    public function setLockedDate($lockedDate)
    {
        $this->container['lockedDate'] = $lockedDate;

        return $this;
    }

    /**
     * Gets lockedEndDate
     *
     * @return \DateTime
     */
    public function getLockedEndDate()
    {
        return $this->container['lockedEndDate'];
    }

    /**
     * Sets lockedEndDate
     *
     * @param \DateTime $lockedEndDate lockedEndDate
     *
     * @return $this
     */
    public function setLockedEndDate($lockedEndDate)
    {
        $this->container['lockedEndDate'] = $lockedEndDate;

        return $this;
    }

    /**
     * Gets isSubscribedToNewsletter
     *
     * @return bool
     */
    public function getIsSubscribedToNewsletter()
    {
        return $this->container['isSubscribedToNewsletter'];
    }

    /**
     * Sets isSubscribedToNewsletter
     *
     * @param bool $isSubscribedToNewsletter isSubscribedToNewsletter
     *
     * @return $this
     */
    public function setIsSubscribedToNewsletter($isSubscribedToNewsletter)
    {
        $this->container['isSubscribedToNewsletter'] = $isSubscribedToNewsletter;

        return $this;
    }

    /**
     * Gets addresses
     *
     * @return \EKM\Model\CustomerAddress[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \EKM\Model\CustomerAddress[] $addresses addresses
     *
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


