<?php
/**
 * AddProduct
 *
 * PHP version 5
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * EKM Partner API
 *
 * Our new API allows partners to build significantly better integrations with the EKM platform.    To try out the below endpoints, or for full up to date representations of the request / response models, please see the [swagger page](https://api.ekm.net/swagger/index.html). (We display examples here, but the swagger page is guaranteed to show the complete model.)    To keep up to date with the latest updates, please see our [RSS feed](https://partners.ekm.net/ChangeLog/Feed) or the [partner dashboard](https://partners.ekm.net/).
 *
 * OpenAPI spec version: v1
 * Contact: api-support@ekm.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.5
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EKM\Model;

use \ArrayAccess;
use \EKM\ObjectSerializer;

/**
 * AddProduct Class Doc Comment
 *
 * @category Class
 * @package  EKM
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AddProduct implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'AddProduct';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'categoryId' => 'int',
        'name' => 'string',
        'description' => 'string',
        'shortDescription' => 'string',
        'numberInStock' => 'int',
        'price' => 'double',
        'rrp' => 'double',
        'productCode' => 'string',
        'chargeDelivery' => 'bool',
        'specialOffer' => 'bool',
        'brand' => 'string',
        'condition' => 'string',
        'gtin' => 'string',
        'mpn' => 'string',
        'productWeight' => 'double',
        'canBeAddedToCart' => 'bool',
        'taxApplicable' => 'bool',
        'live' => 'bool',
        'orderNote' => 'string',
        'redirectUrl' => 'string',
        'lastModified' => '\DateTime',
        'metaDescription' => 'string',
        'metaKeywords' => 'string',
        'metaTitle' => 'string',
        'totalProductStock' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'categoryId' => 'int64',
        'name' => null,
        'description' => null,
        'shortDescription' => null,
        'numberInStock' => 'int64',
        'price' => 'double',
        'rrp' => 'double',
        'productCode' => null,
        'chargeDelivery' => null,
        'specialOffer' => null,
        'brand' => null,
        'condition' => null,
        'gtin' => null,
        'mpn' => null,
        'productWeight' => 'double',
        'canBeAddedToCart' => null,
        'taxApplicable' => null,
        'live' => null,
        'orderNote' => null,
        'redirectUrl' => null,
        'lastModified' => 'date-time',
        'metaDescription' => null,
        'metaKeywords' => null,
        'metaTitle' => null,
        'totalProductStock' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'categoryId' => 'category_id',
        'name' => 'name',
        'description' => 'description',
        'shortDescription' => 'short_description',
        'numberInStock' => 'number_in_stock',
        'price' => 'price',
        'rrp' => 'rrp',
        'productCode' => 'product_code',
        'chargeDelivery' => 'charge_delivery',
        'specialOffer' => 'special_offer',
        'brand' => 'brand',
        'condition' => 'condition',
        'gtin' => 'gtin',
        'mpn' => 'mpn',
        'productWeight' => 'product_weight',
        'canBeAddedToCart' => 'can_be_added_to_cart',
        'taxApplicable' => 'tax_applicable',
        'live' => 'live',
        'orderNote' => 'order_note',
        'redirectUrl' => 'redirect_url',
        'lastModified' => 'last_modified',
        'metaDescription' => 'meta_description',
        'metaKeywords' => 'meta_keywords',
        'metaTitle' => 'meta_title',
        'totalProductStock' => 'total_product_stock'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'categoryId' => 'setCategoryId',
        'name' => 'setName',
        'description' => 'setDescription',
        'shortDescription' => 'setShortDescription',
        'numberInStock' => 'setNumberInStock',
        'price' => 'setPrice',
        'rrp' => 'setRrp',
        'productCode' => 'setProductCode',
        'chargeDelivery' => 'setChargeDelivery',
        'specialOffer' => 'setSpecialOffer',
        'brand' => 'setBrand',
        'condition' => 'setCondition',
        'gtin' => 'setGtin',
        'mpn' => 'setMpn',
        'productWeight' => 'setProductWeight',
        'canBeAddedToCart' => 'setCanBeAddedToCart',
        'taxApplicable' => 'setTaxApplicable',
        'live' => 'setLive',
        'orderNote' => 'setOrderNote',
        'redirectUrl' => 'setRedirectUrl',
        'lastModified' => 'setLastModified',
        'metaDescription' => 'setMetaDescription',
        'metaKeywords' => 'setMetaKeywords',
        'metaTitle' => 'setMetaTitle',
        'totalProductStock' => 'setTotalProductStock'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'categoryId' => 'getCategoryId',
        'name' => 'getName',
        'description' => 'getDescription',
        'shortDescription' => 'getShortDescription',
        'numberInStock' => 'getNumberInStock',
        'price' => 'getPrice',
        'rrp' => 'getRrp',
        'productCode' => 'getProductCode',
        'chargeDelivery' => 'getChargeDelivery',
        'specialOffer' => 'getSpecialOffer',
        'brand' => 'getBrand',
        'condition' => 'getCondition',
        'gtin' => 'getGtin',
        'mpn' => 'getMpn',
        'productWeight' => 'getProductWeight',
        'canBeAddedToCart' => 'getCanBeAddedToCart',
        'taxApplicable' => 'getTaxApplicable',
        'live' => 'getLive',
        'orderNote' => 'getOrderNote',
        'redirectUrl' => 'getRedirectUrl',
        'lastModified' => 'getLastModified',
        'metaDescription' => 'getMetaDescription',
        'metaKeywords' => 'getMetaKeywords',
        'metaTitle' => 'getMetaTitle',
        'totalProductStock' => 'getTotalProductStock'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['categoryId'] = isset($data['categoryId']) ? $data['categoryId'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['shortDescription'] = isset($data['shortDescription']) ? $data['shortDescription'] : null;
        $this->container['numberInStock'] = isset($data['numberInStock']) ? $data['numberInStock'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['rrp'] = isset($data['rrp']) ? $data['rrp'] : null;
        $this->container['productCode'] = isset($data['productCode']) ? $data['productCode'] : null;
        $this->container['chargeDelivery'] = isset($data['chargeDelivery']) ? $data['chargeDelivery'] : null;
        $this->container['specialOffer'] = isset($data['specialOffer']) ? $data['specialOffer'] : null;
        $this->container['brand'] = isset($data['brand']) ? $data['brand'] : null;
        $this->container['condition'] = isset($data['condition']) ? $data['condition'] : null;
        $this->container['gtin'] = isset($data['gtin']) ? $data['gtin'] : null;
        $this->container['mpn'] = isset($data['mpn']) ? $data['mpn'] : null;
        $this->container['productWeight'] = isset($data['productWeight']) ? $data['productWeight'] : null;
        $this->container['canBeAddedToCart'] = isset($data['canBeAddedToCart']) ? $data['canBeAddedToCart'] : null;
        $this->container['taxApplicable'] = isset($data['taxApplicable']) ? $data['taxApplicable'] : null;
        $this->container['live'] = isset($data['live']) ? $data['live'] : null;
        $this->container['orderNote'] = isset($data['orderNote']) ? $data['orderNote'] : null;
        $this->container['redirectUrl'] = isset($data['redirectUrl']) ? $data['redirectUrl'] : null;
        $this->container['lastModified'] = isset($data['lastModified']) ? $data['lastModified'] : null;
        $this->container['metaDescription'] = isset($data['metaDescription']) ? $data['metaDescription'] : null;
        $this->container['metaKeywords'] = isset($data['metaKeywords']) ? $data['metaKeywords'] : null;
        $this->container['metaTitle'] = isset($data['metaTitle']) ? $data['metaTitle'] : null;
        $this->container['totalProductStock'] = isset($data['totalProductStock']) ? $data['totalProductStock'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (!is_null($this->container['price']) && ($this->container['price'] < 0)) {
            $invalidProperties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['rrp']) && ($this->container['rrp'] < 0)) {
            $invalidProperties[] = "invalid value for 'rrp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['productWeight']) && ($this->container['productWeight'] < 0)) {
            $invalidProperties[] = "invalid value for 'productWeight', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets categoryId
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->container['categoryId'];
    }

    /**
     * Sets categoryId
     *
     * @param int $categoryId categoryId
     *
     * @return $this
     */
    public function setCategoryId($categoryId)
    {
        $this->container['categoryId'] = $categoryId;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets shortDescription
     *
     * @return string
     */
    public function getShortDescription()
    {
        return $this->container['shortDescription'];
    }

    /**
     * Sets shortDescription
     *
     * @param string $shortDescription shortDescription
     *
     * @return $this
     */
    public function setShortDescription($shortDescription)
    {
        $this->container['shortDescription'] = $shortDescription;

        return $this;
    }

    /**
     * Gets numberInStock
     *
     * @return int
     */
    public function getNumberInStock()
    {
        return $this->container['numberInStock'];
    }

    /**
     * Sets numberInStock
     *
     * @param int $numberInStock numberInStock
     *
     * @return $this
     */
    public function setNumberInStock($numberInStock)
    {
        $this->container['numberInStock'] = $numberInStock;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double $price price
     *
     * @return $this
     */
    public function setPrice($price)
    {

        if (!is_null($price) && ($price < 0)) {
            throw new \InvalidArgumentException('invalid value for $price when calling AddProduct., must be bigger than or equal to 0.');
        }

        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets rrp
     *
     * @return double
     */
    public function getRrp()
    {
        return $this->container['rrp'];
    }

    /**
     * Sets rrp
     *
     * @param double $rrp rrp
     *
     * @return $this
     */
    public function setRrp($rrp)
    {

        if (!is_null($rrp) && ($rrp < 0)) {
            throw new \InvalidArgumentException('invalid value for $rrp when calling AddProduct., must be bigger than or equal to 0.');
        }

        $this->container['rrp'] = $rrp;

        return $this;
    }

    /**
     * Gets productCode
     *
     * @return string
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     *
     * @param string $productCode productCode
     *
     * @return $this
     */
    public function setProductCode($productCode)
    {
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets chargeDelivery
     *
     * @return bool
     */
    public function getChargeDelivery()
    {
        return $this->container['chargeDelivery'];
    }

    /**
     * Sets chargeDelivery
     *
     * @param bool $chargeDelivery chargeDelivery
     *
     * @return $this
     */
    public function setChargeDelivery($chargeDelivery)
    {
        $this->container['chargeDelivery'] = $chargeDelivery;

        return $this;
    }

    /**
     * Gets specialOffer
     *
     * @return bool
     */
    public function getSpecialOffer()
    {
        return $this->container['specialOffer'];
    }

    /**
     * Sets specialOffer
     *
     * @param bool $specialOffer specialOffer
     *
     * @return $this
     */
    public function setSpecialOffer($specialOffer)
    {
        $this->container['specialOffer'] = $specialOffer;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string $brand brand
     *
     * @return $this
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string $condition condition
     *
     * @return $this
     */
    public function setCondition($condition)
    {
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets gtin
     *
     * @return string
     */
    public function getGtin()
    {
        return $this->container['gtin'];
    }

    /**
     * Sets gtin
     *
     * @param string $gtin gtin
     *
     * @return $this
     */
    public function setGtin($gtin)
    {
        $this->container['gtin'] = $gtin;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string $mpn mpn
     *
     * @return $this
     */
    public function setMpn($mpn)
    {
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets productWeight
     *
     * @return double
     */
    public function getProductWeight()
    {
        return $this->container['productWeight'];
    }

    /**
     * Sets productWeight
     *
     * @param double $productWeight productWeight
     *
     * @return $this
     */
    public function setProductWeight($productWeight)
    {

        if (!is_null($productWeight) && ($productWeight < 0)) {
            throw new \InvalidArgumentException('invalid value for $productWeight when calling AddProduct., must be bigger than or equal to 0.');
        }

        $this->container['productWeight'] = $productWeight;

        return $this;
    }

    /**
     * Gets canBeAddedToCart
     *
     * @return bool
     */
    public function getCanBeAddedToCart()
    {
        return $this->container['canBeAddedToCart'];
    }

    /**
     * Sets canBeAddedToCart
     *
     * @param bool $canBeAddedToCart canBeAddedToCart
     *
     * @return $this
     */
    public function setCanBeAddedToCart($canBeAddedToCart)
    {
        $this->container['canBeAddedToCart'] = $canBeAddedToCart;

        return $this;
    }

    /**
     * Gets taxApplicable
     *
     * @return bool
     */
    public function getTaxApplicable()
    {
        return $this->container['taxApplicable'];
    }

    /**
     * Sets taxApplicable
     *
     * @param bool $taxApplicable taxApplicable
     *
     * @return $this
     */
    public function setTaxApplicable($taxApplicable)
    {
        $this->container['taxApplicable'] = $taxApplicable;

        return $this;
    }

    /**
     * Gets live
     *
     * @return bool
     */
    public function getLive()
    {
        return $this->container['live'];
    }

    /**
     * Sets live
     *
     * @param bool $live live
     *
     * @return $this
     */
    public function setLive($live)
    {
        $this->container['live'] = $live;

        return $this;
    }

    /**
     * Gets orderNote
     *
     * @return string
     */
    public function getOrderNote()
    {
        return $this->container['orderNote'];
    }

    /**
     * Sets orderNote
     *
     * @param string $orderNote orderNote
     *
     * @return $this
     */
    public function setOrderNote($orderNote)
    {
        $this->container['orderNote'] = $orderNote;

        return $this;
    }

    /**
     * Gets redirectUrl
     *
     * @return string
     */
    public function getRedirectUrl()
    {
        return $this->container['redirectUrl'];
    }

    /**
     * Sets redirectUrl
     *
     * @param string $redirectUrl redirectUrl
     *
     * @return $this
     */
    public function setRedirectUrl($redirectUrl)
    {
        $this->container['redirectUrl'] = $redirectUrl;

        return $this;
    }

    /**
     * Gets lastModified
     *
     * @return \DateTime
     */
    public function getLastModified()
    {
        return $this->container['lastModified'];
    }

    /**
     * Sets lastModified
     *
     * @param \DateTime $lastModified lastModified
     *
     * @return $this
     */
    public function setLastModified($lastModified)
    {
        $this->container['lastModified'] = $lastModified;

        return $this;
    }

    /**
     * Gets metaDescription
     *
     * @return string
     */
    public function getMetaDescription()
    {
        return $this->container['metaDescription'];
    }

    /**
     * Sets metaDescription
     *
     * @param string $metaDescription metaDescription
     *
     * @return $this
     */
    public function setMetaDescription($metaDescription)
    {
        $this->container['metaDescription'] = $metaDescription;

        return $this;
    }

    /**
     * Gets metaKeywords
     *
     * @return string
     */
    public function getMetaKeywords()
    {
        return $this->container['metaKeywords'];
    }

    /**
     * Sets metaKeywords
     *
     * @param string $metaKeywords metaKeywords
     *
     * @return $this
     */
    public function setMetaKeywords($metaKeywords)
    {
        $this->container['metaKeywords'] = $metaKeywords;

        return $this;
    }

    /**
     * Gets metaTitle
     *
     * @return string
     */
    public function getMetaTitle()
    {
        return $this->container['metaTitle'];
    }

    /**
     * Sets metaTitle
     *
     * @param string $metaTitle metaTitle
     *
     * @return $this
     */
    public function setMetaTitle($metaTitle)
    {
        $this->container['metaTitle'] = $metaTitle;

        return $this;
    }

    /**
     * Gets totalProductStock
     *
     * @return int
     */
    public function getTotalProductStock()
    {
        return $this->container['totalProductStock'];
    }

    /**
     * Sets totalProductStock
     *
     * @param int $totalProductStock totalProductStock
     *
     * @return $this
     */
    public function setTotalProductStock($totalProductStock)
    {
        $this->container['totalProductStock'] = $totalProductStock;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


