# EKM\TaxApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1SettingsTaxGet**](TaxApi.md#apiV1SettingsTaxGet) | **GET** /api/v1/settings/tax | Get the current Tax Settings
[**apiV1SettingsTaxPut**](TaxApi.md#apiV1SettingsTaxPut) | **PUT** /api/v1/settings/tax | Update the current Tax Settings
[**apiV1SettingsTaxRatesByIdDelete**](TaxApi.md#apiV1SettingsTaxRatesByIdDelete) | **DELETE** /api/v1/settings/tax/rates/{id} | Delete a Tax Rate
[**apiV1SettingsTaxRatesByIdGet**](TaxApi.md#apiV1SettingsTaxRatesByIdGet) | **GET** /api/v1/settings/tax/rates/{id} | Get a specific Tax Rate
[**apiV1SettingsTaxRatesByIdPut**](TaxApi.md#apiV1SettingsTaxRatesByIdPut) | **PUT** /api/v1/settings/tax/rates/{id} | Update a Tax Rate
[**apiV1SettingsTaxRatesGet**](TaxApi.md#apiV1SettingsTaxRatesGet) | **GET** /api/v1/settings/tax/rates | Get a list of Tax Rates
[**apiV1SettingsTaxRatesPost**](TaxApi.md#apiV1SettingsTaxRatesPost) | **POST** /api/v1/settings/tax/rates | Add a Tax Rate
[**apiV1SettingsTaxRatesStandardGet**](TaxApi.md#apiV1SettingsTaxRatesStandardGet) | **GET** /api/v1/settings/tax/rates/standard | Get the standard Tax Rate


# **apiV1SettingsTaxGet**
> \EKM\Model\TempestResponseTaxSettings apiV1SettingsTaxGet()

Get the current Tax Settings

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsTaxGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseTaxSettings**](../Model/TempestResponseTaxSettings.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxPut**
> \EKM\Model\TempestResponseTaxSettings apiV1SettingsTaxPut($taxSettings)

Update the current Tax Settings

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$taxSettings = new \EKM\Model\TaxSettings(); // \EKM\Model\TaxSettings | 

try {
    $result = $apiInstance->apiV1SettingsTaxPut($taxSettings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **taxSettings** | [**\EKM\Model\TaxSettings**](../Model/TaxSettings.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseTaxSettings**](../Model/TempestResponseTaxSettings.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesByIdDelete**
> \EKM\Model\TempestResponseTaxRateModel apiV1SettingsTaxRatesByIdDelete($id)

Delete a Tax Rate

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $result = $apiInstance->apiV1SettingsTaxRatesByIdDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesByIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\EKM\Model\TempestResponseTaxRateModel**](../Model/TempestResponseTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesByIdGet**
> \EKM\Model\TempestResponseTaxRateModel apiV1SettingsTaxRatesByIdGet($id)

Get a specific Tax Rate

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $result = $apiInstance->apiV1SettingsTaxRatesByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesByIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\EKM\Model\TempestResponseTaxRateModel**](../Model/TempestResponseTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesByIdPut**
> \EKM\Model\TempestResponseTaxRateModel apiV1SettingsTaxRatesByIdPut($id, $taxRate)

Update a Tax Rate

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$taxRate = new \EKM\Model\TaxRateModel(); // \EKM\Model\TaxRateModel | 

try {
    $result = $apiInstance->apiV1SettingsTaxRatesByIdPut($id, $taxRate);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesByIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **taxRate** | [**\EKM\Model\TaxRateModel**](../Model/TaxRateModel.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseTaxRateModel**](../Model/TempestResponseTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesGet**
> \EKM\Model\TempestResponseListTaxRateModel apiV1SettingsTaxRatesGet()

Get a list of Tax Rates

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsTaxRatesGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseListTaxRateModel**](../Model/TempestResponseListTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesPost**
> \EKM\Model\TempestResponseTaxRateModel apiV1SettingsTaxRatesPost($taxRate)

Add a Tax Rate

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$taxRate = new \EKM\Model\TaxRateModel(); // \EKM\Model\TaxRateModel | 

try {
    $result = $apiInstance->apiV1SettingsTaxRatesPost($taxRate);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **taxRate** | [**\EKM\Model\TaxRateModel**](../Model/TaxRateModel.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseTaxRateModel**](../Model/TempestResponseTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1SettingsTaxRatesStandardGet**
> \EKM\Model\TempestResponseTaxRateModel apiV1SettingsTaxRatesStandardGet()

Get the standard Tax Rate

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\TaxApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1SettingsTaxRatesStandardGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxApi->apiV1SettingsTaxRatesStandardGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\EKM\Model\TempestResponseTaxRateModel**](../Model/TempestResponseTaxRateModel.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

