# EKM\ProductsApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1ProductsByIdCategorymanagedByCategoryIdDelete**](ProductsApi.md#apiV1ProductsByIdCategorymanagedByCategoryIdDelete) | **DELETE** /api/v1/products/{id}/categorymanaged/{categoryId} | Stops a product from being managed by another category
[**apiV1ProductsByIdCategorymanagedByCategoryIdPost**](ProductsApi.md#apiV1ProductsByIdCategorymanagedByCategoryIdPost) | **POST** /api/v1/products/{id}/categorymanaged/{categoryId} | Set a product to be managed by another category
[**apiV1ProductsByIdDelete**](ProductsApi.md#apiV1ProductsByIdDelete) | **DELETE** /api/v1/products/{id} | Delete a Product
[**apiV1ProductsByIdGet**](ProductsApi.md#apiV1ProductsByIdGet) | **GET** /api/v1/products/{id} | Get a product
[**apiV1ProductsByIdImagesByImageNumberPost**](ProductsApi.md#apiV1ProductsByIdImagesByImageNumberPost) | **POST** /api/v1/products/{id}/images/{imageNumber} | Assign an image by Url to a product
[**apiV1ProductsByIdImagesGet**](ProductsApi.md#apiV1ProductsByIdImagesGet) | **GET** /api/v1/products/{id}/images | Get a product&#39;s images.
[**apiV1ProductsByIdPut**](ProductsApi.md#apiV1ProductsByIdPut) | **PUT** /api/v1/products/{id} | Update a Product
[**apiV1ProductsGet**](ProductsApi.md#apiV1ProductsGet) | **GET** /api/v1/products | Get a paginated set of products
[**apiV1ProductsPost**](ProductsApi.md#apiV1ProductsPost) | **POST** /api/v1/products | Add a Product
[**apiV1ProductsSearchGet**](ProductsApi.md#apiV1ProductsSearchGet) | **GET** /api/v1/products/search | Searches products based on search criteria


# **apiV1ProductsByIdCategorymanagedByCategoryIdDelete**
> \EKM\Model\TempestResponseProductCategory apiV1ProductsByIdCategorymanagedByCategoryIdDelete($id, $categoryId)

Stops a product from being managed by another category

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | 
$categoryId = 789; // int | 

try {
    $result = $apiInstance->apiV1ProductsByIdCategorymanagedByCategoryIdDelete($id, $categoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdCategorymanagedByCategoryIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **categoryId** | **int**|  |

### Return type

[**\EKM\Model\TempestResponseProductCategory**](../Model/TempestResponseProductCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdCategorymanagedByCategoryIdPost**
> \EKM\Model\TempestResponseProductCategory apiV1ProductsByIdCategorymanagedByCategoryIdPost($id, $categoryId)

Set a product to be managed by another category

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | 
$categoryId = 789; // int | 

try {
    $result = $apiInstance->apiV1ProductsByIdCategorymanagedByCategoryIdPost($id, $categoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdCategorymanagedByCategoryIdPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **categoryId** | **int**|  |

### Return type

[**\EKM\Model\TempestResponseProductCategory**](../Model/TempestResponseProductCategory.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdDelete**
> \EKM\Model\TempestResponseProduct apiV1ProductsByIdDelete($id, $categoryId)

Delete a Product

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$categoryId = 789; // int | The category ID - Passing a category ID deletes the product from the specific category only

try {
    $result = $apiInstance->apiV1ProductsByIdDelete($id, $categoryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **categoryId** | **int**| The category ID - Passing a category ID deletes the product from the specific category only | [optional]

### Return type

[**\EKM\Model\TempestResponseProduct**](../Model/TempestResponseProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdGet**
> \EKM\Model\TempestResponseProduct apiV1ProductsByIdGet($id)

Get a product

The SEOFriendlyUrl property can be combined with the primary shop domain to get the shop page url for a Product in the format:  {primary_domain}/{SEOFriendlyUrl}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |

### Return type

[**\EKM\Model\TempestResponseProduct**](../Model/TempestResponseProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdImagesByImageNumberPost**
> \EKM\Model\TempestResponseProductImages apiV1ProductsByIdImagesByImageNumberPost($id, $imageNumber, $imageUrl)

Assign an image by Url to a product

An example URL request path would look something like:                    https://api.ekm.net/api/v1/products/5/images/1?imageurl=https://www.ekm.com/images/design/en-AU/logo.svg

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | 
$imageNumber = 56; // int | 
$imageUrl = "imageUrl_example"; // string | 

try {
    $result = $apiInstance->apiV1ProductsByIdImagesByImageNumberPost($id, $imageNumber, $imageUrl);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdImagesByImageNumberPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **imageNumber** | **int**|  |
 **imageUrl** | **string**|  |

### Return type

[**\EKM\Model\TempestResponseProductImages**](../Model/TempestResponseProductImages.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdImagesGet**
> \EKM\Model\TempestResponseProductImages apiV1ProductsByIdImagesGet($id)

Get a product's images.

Images stored on EKM servers will have the location property of the response set to the path of the image file. This will need to be prepended with the shop's domain.  Remote images will have the remote property of the reponse set to the URL of the image.  Images that have been deleted will have the location property of the reponse set to \"No image available.\"

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdImagesGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdImagesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |

### Return type

[**\EKM\Model\TempestResponseProductImages**](../Model/TempestResponseProductImages.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdPut**
> \EKM\Model\TempestResponseProduct apiV1ProductsByIdPut($id, $model)

Update a Product

Options and variants must be updated separately

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$model = new \EKM\Model\UpdateProduct(); // \EKM\Model\UpdateProduct | 

try {
    $result = $apiInstance->apiV1ProductsByIdPut($id, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsByIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **model** | [**\EKM\Model\UpdateProduct**](../Model/UpdateProduct.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseProduct**](../Model/TempestResponseProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsGet**
> \EKM\Model\TempestResponseListProduct apiV1ProductsGet($page, $limit)

Get a paginated set of products

The SEOFriendlyUrl property can be combined with the primary shop domain to get the shop page url for a Product in the format:  {primary_domain}/{SEOFriendlyUrl}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)

try {
    $result = $apiInstance->apiV1ProductsGet($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10]

### Return type

[**\EKM\Model\TempestResponseListProduct**](../Model/TempestResponseListProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsPost**
> \EKM\Model\TempestResponseProduct apiV1ProductsPost($model)

Add a Product

Options and variants must be added separately

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$model = new \EKM\Model\AddProduct(); // \EKM\Model\AddProduct | 

try {
    $result = $apiInstance->apiV1ProductsPost($model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **model** | [**\EKM\Model\AddProduct**](../Model/AddProduct.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseProduct**](../Model/TempestResponseProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsSearchGet**
> \EKM\Model\TempestResponseListProduct apiV1ProductsSearchGet($page, $limit, $query, $orderby)

Searches products based on search criteria

The SEOFriendlyUrl property can be combined with the primary shop domain to get the shop page url for a Product in the format:  {primary_domain}/{SEOFriendlyUrl}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)
$query = "query_example"; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. live eq true
$orderby = "orderby_example"; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1ProductsSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->apiV1ProductsSearchGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10]
 **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true | [optional]
 **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional]

### Return type

[**\EKM\Model\TempestResponseListProduct**](../Model/TempestResponseListProduct.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

