# EKM\ProductVariantsApi

All URIs are relative to *https://api.ekm.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**apiV1ProductsByIdVariantsByVariantIdDelete**](ProductVariantsApi.md#apiV1ProductsByIdVariantsByVariantIdDelete) | **DELETE** /api/v1/products/{id}/variants/{variantId} | Delete a variant
[**apiV1ProductsByIdVariantsByVariantIdGet**](ProductVariantsApi.md#apiV1ProductsByIdVariantsByVariantIdGet) | **GET** /api/v1/products/{id}/variants/{variantId} | Get a product variant
[**apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost**](ProductVariantsApi.md#apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost) | **POST** /api/v1/products/{id}/variants/{variantId}/images/{imageNumber} | Set a variants image to a URL
[**apiV1ProductsByIdVariantsByVariantIdImagesGet**](ProductVariantsApi.md#apiV1ProductsByIdVariantsByVariantIdImagesGet) | **GET** /api/v1/products/{id}/variants/{variantId}/images | Get a variant&#39;s images.
[**apiV1ProductsByIdVariantsByVariantIdPut**](ProductVariantsApi.md#apiV1ProductsByIdVariantsByVariantIdPut) | **PUT** /api/v1/products/{id}/variants/{variantId} | Update a product variant
[**apiV1ProductsByIdVariantsGet**](ProductVariantsApi.md#apiV1ProductsByIdVariantsGet) | **GET** /api/v1/products/{id}/variants | Get a products variants
[**apiV1ProductsByIdVariantsPost**](ProductVariantsApi.md#apiV1ProductsByIdVariantsPost) | **POST** /api/v1/products/{id}/variants | Add a variant to a product
[**apiV1ProductsVariantsByVariantIdGet**](ProductVariantsApi.md#apiV1ProductsVariantsByVariantIdGet) | **GET** /api/v1/products/variants/{variantId} | Get a product variant
[**apiV1VariantsSearchGet**](ProductVariantsApi.md#apiV1VariantsSearchGet) | **GET** /api/v1/variants/search | Searches variants based on search criteria


# **apiV1ProductsByIdVariantsByVariantIdDelete**
> \EKM\Model\TempestResponseProductVariant apiV1ProductsByIdVariantsByVariantIdDelete($id, $variantId)

Delete a variant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$variantId = 789; // int | The variant ID

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdDelete($id, $variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsByVariantIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The variant ID |

### Return type

[**\EKM\Model\TempestResponseProductVariant**](../Model/TempestResponseProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsByVariantIdGet**
> \EKM\Model\TempestResponseProductVariant apiV1ProductsByIdVariantsByVariantIdGet($id, $variantId)

Get a product variant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$variantId = 789; // int | The variant ID

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdGet($id, $variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsByVariantIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The variant ID |

### Return type

[**\EKM\Model\TempestResponseProductVariant**](../Model/TempestResponseProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost**
> \EKM\Model\TempestResponseProductImages apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost($id, $variantId, $imageNumber, $imageUrl)

Set a variants image to a URL

An example URL request path would look something like:                    https://api.ekm.net/api/v1/products/5/variants/42/images/1?imageurl=https://www.ekm.com/images/design/en-AU/logo.svg

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$variantId = 789; // int | The variant ID
$imageNumber = 56; // int | The image number
$imageUrl = "imageUrl_example"; // string | The URL of the image

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost($id, $variantId, $imageNumber, $imageUrl);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsByVariantIdImagesByImageNumberPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The variant ID |
 **imageNumber** | **int**| The image number |
 **imageUrl** | **string**| The URL of the image |

### Return type

[**\EKM\Model\TempestResponseProductImages**](../Model/TempestResponseProductImages.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsByVariantIdImagesGet**
> \EKM\Model\TempestResponseProductImages apiV1ProductsByIdVariantsByVariantIdImagesGet($id, $variantId)

Get a variant's images.

Images stored on EKM servers will have the location property of the response set to the path of the image file. This will need to be prepended with the shop's domain.  Remote images will have the remote property of the reponse set to the URL of the image.  Images that have been deleted will have the location property of the reponse set to \"No image available.\"

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$variantId = 789; // int | The variant ID

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdImagesGet($id, $variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsByVariantIdImagesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The variant ID |

### Return type

[**\EKM\Model\TempestResponseProductImages**](../Model/TempestResponseProductImages.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsByVariantIdPut**
> \EKM\Model\TempestResponseProductVariant apiV1ProductsByIdVariantsByVariantIdPut($id, $variantId, $model)

Update a product variant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$variantId = 789; // int | The varaint ID
$model = new \EKM\Model\ProductVariant(); // \EKM\Model\ProductVariant | 

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsByVariantIdPut($id, $variantId, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsByVariantIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **variantId** | **int**| The varaint ID |
 **model** | [**\EKM\Model\ProductVariant**](../Model/ProductVariant.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseProductVariant**](../Model/TempestResponseProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsGet**
> \EKM\Model\TempestResponseListProductVariant apiV1ProductsByIdVariantsGet($id)

Get a products variants

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |

### Return type

[**\EKM\Model\TempestResponseListProductVariant**](../Model/TempestResponseListProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsByIdVariantsPost**
> \EKM\Model\TempestResponseListProductVariant apiV1ProductsByIdVariantsPost($id, $model)

Add a variant to a product

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 789; // int | The product ID
$model = new \EKM\Model\ProductVariant(); // \EKM\Model\ProductVariant | 

try {
    $result = $apiInstance->apiV1ProductsByIdVariantsPost($id, $model);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsByIdVariantsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The product ID |
 **model** | [**\EKM\Model\ProductVariant**](../Model/ProductVariant.md)|  | [optional]

### Return type

[**\EKM\Model\TempestResponseListProductVariant**](../Model/TempestResponseListProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1ProductsVariantsByVariantIdGet**
> \EKM\Model\TempestResponseProductVariant apiV1ProductsVariantsByVariantIdGet($variantId)

Get a product variant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$variantId = 789; // int | The variant ID

try {
    $result = $apiInstance->apiV1ProductsVariantsByVariantIdGet($variantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1ProductsVariantsByVariantIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **variantId** | **int**| The variant ID |

### Return type

[**\EKM\Model\TempestResponseProductVariant**](../Model/TempestResponseProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **apiV1VariantsSearchGet**
> \EKM\Model\TempestResponseListProductVariant apiV1VariantsSearchGet($page, $limit, $query, $orderby)

Searches variants based on search criteria

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: OAuth
$config = EKM\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$apiInstance = new EKM\Api\ProductVariantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 1; // int | Page number to display
$limit = 10; // int | Items per page (maximum 20)
$query = "query_example"; // string | A <a href=\"#tag/OData\" target=\"_blank\">search</a> query e.g. live eq true
$orderby = "orderby_example"; // string | Field to order results. Prefix with a - (dash) for descending e.g. -id

try {
    $result = $apiInstance->apiV1VariantsSearchGet($page, $limit, $query, $orderby);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariantsApi->apiV1VariantsSearchGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| Page number to display | [optional] [default to 1]
 **limit** | **int**| Items per page (maximum 20) | [optional] [default to 10]
 **query** | **string**| A &lt;a href&#x3D;\&quot;#tag/OData\&quot; target&#x3D;\&quot;_blank\&quot;&gt;search&lt;/a&gt; query e.g. live eq true | [optional]
 **orderby** | **string**| Field to order results. Prefix with a - (dash) for descending e.g. -id | [optional]

### Return type

[**\EKM\Model\TempestResponseListProductVariant**](../Model/TempestResponseListProductVariant.md)

### Authorization

[OAuth](../../README.md#OAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

