<?php
/**
 * Regulatory
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.
 *
 * The version of the OpenAPI document: 1.17.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Inventory\Model;

use \ArrayAccess;
use \Ebay\Inventory\ObjectSerializer;

/**
 * Regulatory Class Doc Comment
 *
 * @category Class
 * @description Type defining regulatory information that the seller is required to disclose.
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Regulatory implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Regulatory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'economic_operator' => '\Ebay\Inventory\Model\EconomicOperator',
        'energy_efficiency_label' => '\Ebay\Inventory\Model\EnergyEfficiencyLabel',
        'hazmat' => '\Ebay\Inventory\Model\Hazmat',
        'repair_score' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'economic_operator' => null,
        'energy_efficiency_label' => null,
        'hazmat' => null,
        'repair_score' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'economic_operator' => false,
        'energy_efficiency_label' => false,
        'hazmat' => false,
        'repair_score' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'economic_operator' => 'economicOperator',
        'energy_efficiency_label' => 'energyEfficiencyLabel',
        'hazmat' => 'hazmat',
        'repair_score' => 'repairScore'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'economic_operator' => 'setEconomicOperator',
        'energy_efficiency_label' => 'setEnergyEfficiencyLabel',
        'hazmat' => 'setHazmat',
        'repair_score' => 'setRepairScore'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'economic_operator' => 'getEconomicOperator',
        'energy_efficiency_label' => 'getEnergyEfficiencyLabel',
        'hazmat' => 'getHazmat',
        'repair_score' => 'getRepairScore'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('economic_operator', $data ?? [], null);
        $this->setIfExists('energy_efficiency_label', $data ?? [], null);
        $this->setIfExists('hazmat', $data ?? [], null);
        $this->setIfExists('repair_score', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets economic_operator
     *
     * @return \Ebay\Inventory\Model\EconomicOperator|null
     */
    public function getEconomicOperator()
    {
        return $this->container['economic_operator'];
    }

    /**
     * Sets economic_operator
     *
     * @param \Ebay\Inventory\Model\EconomicOperator|null $economic_operator economic_operator
     *
     * @return self
     */
    public function setEconomicOperator($economic_operator)
    {
        if (is_null($economic_operator)) {
            throw new \InvalidArgumentException('non-nullable economic_operator cannot be null');
        }
        $this->container['economic_operator'] = $economic_operator;

        return $this;
    }

    /**
     * Gets energy_efficiency_label
     *
     * @return \Ebay\Inventory\Model\EnergyEfficiencyLabel|null
     */
    public function getEnergyEfficiencyLabel()
    {
        return $this->container['energy_efficiency_label'];
    }

    /**
     * Sets energy_efficiency_label
     *
     * @param \Ebay\Inventory\Model\EnergyEfficiencyLabel|null $energy_efficiency_label energy_efficiency_label
     *
     * @return self
     */
    public function setEnergyEfficiencyLabel($energy_efficiency_label)
    {
        if (is_null($energy_efficiency_label)) {
            throw new \InvalidArgumentException('non-nullable energy_efficiency_label cannot be null');
        }
        $this->container['energy_efficiency_label'] = $energy_efficiency_label;

        return $this;
    }

    /**
     * Gets hazmat
     *
     * @return \Ebay\Inventory\Model\Hazmat|null
     */
    public function getHazmat()
    {
        return $this->container['hazmat'];
    }

    /**
     * Sets hazmat
     *
     * @param \Ebay\Inventory\Model\Hazmat|null $hazmat hazmat
     *
     * @return self
     */
    public function setHazmat($hazmat)
    {
        if (is_null($hazmat)) {
            throw new \InvalidArgumentException('non-nullable hazmat cannot be null');
        }
        $this->container['hazmat'] = $hazmat;

        return $this;
    }

    /**
     * Gets repair_score
     *
     * @return float|null
     */
    public function getRepairScore()
    {
        return $this->container['repair_score'];
    }

    /**
     * Sets repair_score
     *
     * @param float|null $repair_score This field represents the repair index for the listing.<br><br>The repair index identifies the manufacturer's repair score for a product (i.e., how easy is it to repair the product.) This field is a floating point value between 0.0 (i.e., difficult to repair,) and 10.0 (i.e., easily repaired.)<br><br><span class=\"tablenote\"><b>Note:</b> <code>0</code> should not be used as a default value, as it implies the product is not repairable.</span><br>The format for <b>repairScore</b> is limited to one decimal place. For example:<ul><li><code>7.9</code> and <code>0.0</code> are both valid scores</li><li><code>5.645</code> and <code>2.10</code> are both invalid scores</li></ul><br><span class=\"tablenote\"><b>Note:</b> Repair score is not applicable to all categories. Use the <a href=\"/api-docs/sell/metadata/resources/marketplace/methods/getExtendedProducerResponsibilityPolicies\" target=\"_blank\">getExtendedProducerResponsibilityPolicies</a> method of the <b>Metadata API</b> to see where repair score is applicable.</span>
     *
     * @return self
     */
    public function setRepairScore($repair_score)
    {
        if (is_null($repair_score)) {
            throw new \InvalidArgumentException('non-nullable repair_score cannot be null');
        }
        $this->container['repair_score'] = $repair_score;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


