<?php
/**
 * ListingPolicies
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.
 *
 * The version of the OpenAPI document: 1.17.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Inventory\Model;

use \ArrayAccess;
use \Ebay\Inventory\ObjectSerializer;

/**
 * ListingPolicies Class Doc Comment
 *
 * @category Class
 * @description This type is used to identify business policies including payment, return, and fulfillment policies, as well as to identify custom policies. These policies are, or will be, associated with the listing. Every published offer must have a payment, return, and fulfillment business policy associated with it. Additionally, depending on the country/countries in which sellers are offering products and/or services to consumers (e.g., residents of the European Union,) specifying additional polices may be required.&lt;br&gt;&lt;br&gt;This type is also used to override the shipping costs of one or more shipping service options that are associated with the fulfillment policy, to enable eBay Plus eligibility for a listing, or to enable the Best Offer feature on the listing.
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ListingPolicies implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ListingPolicies';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'best_offer_terms' => '\Ebay\Inventory\Model\BestOffer',
        'e_bay_plus_if_eligible' => 'bool',
        'fulfillment_policy_id' => 'string',
        'payment_policy_id' => 'string',
        'product_compliance_policy_ids' => 'string[]',
        'regional_product_compliance_policies' => '\Ebay\Inventory\Model\RegionalProductCompliancePolicies',
        'regional_take_back_policies' => '\Ebay\Inventory\Model\RegionalTakeBackPolicies',
        'return_policy_id' => 'string',
        'shipping_cost_overrides' => '\Ebay\Inventory\Model\ShippingCostOverride[]',
        'take_back_policy_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'best_offer_terms' => null,
        'e_bay_plus_if_eligible' => null,
        'fulfillment_policy_id' => null,
        'payment_policy_id' => null,
        'product_compliance_policy_ids' => null,
        'regional_product_compliance_policies' => null,
        'regional_take_back_policies' => null,
        'return_policy_id' => null,
        'shipping_cost_overrides' => null,
        'take_back_policy_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'best_offer_terms' => false,
        'e_bay_plus_if_eligible' => false,
        'fulfillment_policy_id' => false,
        'payment_policy_id' => false,
        'product_compliance_policy_ids' => false,
        'regional_product_compliance_policies' => false,
        'regional_take_back_policies' => false,
        'return_policy_id' => false,
        'shipping_cost_overrides' => false,
        'take_back_policy_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'best_offer_terms' => 'bestOfferTerms',
        'e_bay_plus_if_eligible' => 'eBayPlusIfEligible',
        'fulfillment_policy_id' => 'fulfillmentPolicyId',
        'payment_policy_id' => 'paymentPolicyId',
        'product_compliance_policy_ids' => 'productCompliancePolicyIds',
        'regional_product_compliance_policies' => 'regionalProductCompliancePolicies',
        'regional_take_back_policies' => 'regionalTakeBackPolicies',
        'return_policy_id' => 'returnPolicyId',
        'shipping_cost_overrides' => 'shippingCostOverrides',
        'take_back_policy_id' => 'takeBackPolicyId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'best_offer_terms' => 'setBestOfferTerms',
        'e_bay_plus_if_eligible' => 'setEBayPlusIfEligible',
        'fulfillment_policy_id' => 'setFulfillmentPolicyId',
        'payment_policy_id' => 'setPaymentPolicyId',
        'product_compliance_policy_ids' => 'setProductCompliancePolicyIds',
        'regional_product_compliance_policies' => 'setRegionalProductCompliancePolicies',
        'regional_take_back_policies' => 'setRegionalTakeBackPolicies',
        'return_policy_id' => 'setReturnPolicyId',
        'shipping_cost_overrides' => 'setShippingCostOverrides',
        'take_back_policy_id' => 'setTakeBackPolicyId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'best_offer_terms' => 'getBestOfferTerms',
        'e_bay_plus_if_eligible' => 'getEBayPlusIfEligible',
        'fulfillment_policy_id' => 'getFulfillmentPolicyId',
        'payment_policy_id' => 'getPaymentPolicyId',
        'product_compliance_policy_ids' => 'getProductCompliancePolicyIds',
        'regional_product_compliance_policies' => 'getRegionalProductCompliancePolicies',
        'regional_take_back_policies' => 'getRegionalTakeBackPolicies',
        'return_policy_id' => 'getReturnPolicyId',
        'shipping_cost_overrides' => 'getShippingCostOverrides',
        'take_back_policy_id' => 'getTakeBackPolicyId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('best_offer_terms', $data ?? [], null);
        $this->setIfExists('e_bay_plus_if_eligible', $data ?? [], null);
        $this->setIfExists('fulfillment_policy_id', $data ?? [], null);
        $this->setIfExists('payment_policy_id', $data ?? [], null);
        $this->setIfExists('product_compliance_policy_ids', $data ?? [], null);
        $this->setIfExists('regional_product_compliance_policies', $data ?? [], null);
        $this->setIfExists('regional_take_back_policies', $data ?? [], null);
        $this->setIfExists('return_policy_id', $data ?? [], null);
        $this->setIfExists('shipping_cost_overrides', $data ?? [], null);
        $this->setIfExists('take_back_policy_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets best_offer_terms
     *
     * @return \Ebay\Inventory\Model\BestOffer|null
     */
    public function getBestOfferTerms()
    {
        return $this->container['best_offer_terms'];
    }

    /**
     * Sets best_offer_terms
     *
     * @param \Ebay\Inventory\Model\BestOffer|null $best_offer_terms best_offer_terms
     *
     * @return self
     */
    public function setBestOfferTerms($best_offer_terms)
    {
        if (is_null($best_offer_terms)) {
            throw new \InvalidArgumentException('non-nullable best_offer_terms cannot be null');
        }
        $this->container['best_offer_terms'] = $best_offer_terms;

        return $this;
    }

    /**
     * Gets e_bay_plus_if_eligible
     *
     * @return bool|null
     */
    public function getEBayPlusIfEligible()
    {
        return $this->container['e_bay_plus_if_eligible'];
    }

    /**
     * Sets e_bay_plus_if_eligible
     *
     * @param bool|null $e_bay_plus_if_eligible This field is included in an offer and set to <code>true</code> if a Top-Rated seller is opted in to the eBay Plus program. With the eBay Plus program, qualified sellers must commit to next-day delivery of the item, and the buyers must have an eBay Plus subscription to be eligible to receive the benefits of this program, which are free, next-day delivery, as well as free returns.<br><br><span class=\"tablenote\"><b>Note:</b> Currently, this program is only available on the Germany and Australian sites.</span><br>This field will be returned in the <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffer\" target=\"_blank\">getOffer</a> and <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffers\" target=\"_blank\">getOffers</a> methods if set for the offer.
     *
     * @return self
     */
    public function setEBayPlusIfEligible($e_bay_plus_if_eligible)
    {
        if (is_null($e_bay_plus_if_eligible)) {
            throw new \InvalidArgumentException('non-nullable e_bay_plus_if_eligible cannot be null');
        }
        $this->container['e_bay_plus_if_eligible'] = $e_bay_plus_if_eligible;

        return $this;
    }

    /**
     * Gets fulfillment_policy_id
     *
     * @return string|null
     */
    public function getFulfillmentPolicyId()
    {
        return $this->container['fulfillment_policy_id'];
    }

    /**
     * Sets fulfillment_policy_id
     *
     * @param string|null $fulfillment_policy_id This unique identifier indicates the fulfillment business policy that will be used once an offer is published and converted to an eBay listing. This fulfillment business policy will set all fulfillment-related settings for the eBay listing.<br><br>Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the fulfillment business policy before assigning it to the offer to make sure it is compatible with the inventory item and the offer settings. The seller may also want to review the shipping service costs in the fulfillment policy, and that seller might decide to override the shipping costs for one or more shipping service options by using the <strong>shippingCostOverrides</strong> container.<br><br>Business policies can be created and managed in My eBay or with the <a href=\"/api-docs/sell/account/overview.html\" target=\"_blank\">Account API</a>. To get a list of all return policies associated with a seller's account on a specific eBay Marketplace, use the Account API's <a href=\"/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\" target=\"_blank\">getFulfillmentPolicies</a> method. There are also calls in the <strong>Account API</strong> to retrieve a fulfillment policy by policy ID or policy name.<br><br>This field will be returned in the <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffer\" target=\"_blank\">getOffer</a> and <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffers\" target=\"_blank\">getOffers</a> methods if set for the offer.
     *
     * @return self
     */
    public function setFulfillmentPolicyId($fulfillment_policy_id)
    {
        if (is_null($fulfillment_policy_id)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_policy_id cannot be null');
        }
        $this->container['fulfillment_policy_id'] = $fulfillment_policy_id;

        return $this;
    }

    /**
     * Gets payment_policy_id
     *
     * @return string|null
     */
    public function getPaymentPolicyId()
    {
        return $this->container['payment_policy_id'];
    }

    /**
     * Sets payment_policy_id
     *
     * @param string|null $payment_policy_id This unique identifier indicates the payment business policy that will be used once an offer is published and converted to an eBay listing. This payment business policy will set all payment-related settings for the eBay listing.<br><br>Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the payment business policy to make sure that it is compatible with the marketplace and listing category before assigning it to the offer.<br><br>Business policies can be created and managed in My eBay or with the <a href=\"/api-docs/sell/account/overview.html\" target=\"_blank\">Account API</a>. To get a list of all payment policies associated with a seller's account on a specific eBay Marketplace, use the Account API's <a href=\"/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\" target=\"_blank\">getPaymentPolicies</a> method. There are also calls in the <strong>Account API</strong> to retrieve a payment policy by policy ID or policy name.<br><br>This field will be returned in the <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffer\" target=\"_blank\">getOffer</a> and <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffers\" target=\"_blank\">getOffers</a> methods if set for the offer.
     *
     * @return self
     */
    public function setPaymentPolicyId($payment_policy_id)
    {
        if (is_null($payment_policy_id)) {
            throw new \InvalidArgumentException('non-nullable payment_policy_id cannot be null');
        }
        $this->container['payment_policy_id'] = $payment_policy_id;

        return $this;
    }

    /**
     * Gets product_compliance_policy_ids
     *
     * @return string[]|null
     */
    public function getProductCompliancePolicyIds()
    {
        return $this->container['product_compliance_policy_ids'];
    }

    /**
     * Sets product_compliance_policy_ids
     *
     * @param string[]|null $product_compliance_policy_ids This field contains the array of unique identifiers indicating the seller-created <i>global</i> product compliance policies that will be used once an offer is published and converted to a listing.<br><br>Product compliance policies provide buyers with important information and disclosures about products. For example, if you sell batteries and specific disclosures are required to be shared with all potential buyers, your global product compliance policy could contain the required disclosures.<br><br>A maximum of six (6) global product compliance policies may apply to <i>each offer</i>.<span class=\"tablenote\"><b>Note:</b> For countries that support country-specific policies, use <a href=\"#request.listingPolicies.regionalProductCompliancePolicies\">regionalProductCompliancePolicies</a> to apply them to an offer.</span>
     *
     * @return self
     */
    public function setProductCompliancePolicyIds($product_compliance_policy_ids)
    {
        if (is_null($product_compliance_policy_ids)) {
            throw new \InvalidArgumentException('non-nullable product_compliance_policy_ids cannot be null');
        }
        $this->container['product_compliance_policy_ids'] = $product_compliance_policy_ids;

        return $this;
    }

    /**
     * Gets regional_product_compliance_policies
     *
     * @return \Ebay\Inventory\Model\RegionalProductCompliancePolicies|null
     */
    public function getRegionalProductCompliancePolicies()
    {
        return $this->container['regional_product_compliance_policies'];
    }

    /**
     * Sets regional_product_compliance_policies
     *
     * @param \Ebay\Inventory\Model\RegionalProductCompliancePolicies|null $regional_product_compliance_policies regional_product_compliance_policies
     *
     * @return self
     */
    public function setRegionalProductCompliancePolicies($regional_product_compliance_policies)
    {
        if (is_null($regional_product_compliance_policies)) {
            throw new \InvalidArgumentException('non-nullable regional_product_compliance_policies cannot be null');
        }
        $this->container['regional_product_compliance_policies'] = $regional_product_compliance_policies;

        return $this;
    }

    /**
     * Gets regional_take_back_policies
     *
     * @return \Ebay\Inventory\Model\RegionalTakeBackPolicies|null
     */
    public function getRegionalTakeBackPolicies()
    {
        return $this->container['regional_take_back_policies'];
    }

    /**
     * Sets regional_take_back_policies
     *
     * @param \Ebay\Inventory\Model\RegionalTakeBackPolicies|null $regional_take_back_policies regional_take_back_policies
     *
     * @return self
     */
    public function setRegionalTakeBackPolicies($regional_take_back_policies)
    {
        if (is_null($regional_take_back_policies)) {
            throw new \InvalidArgumentException('non-nullable regional_take_back_policies cannot be null');
        }
        $this->container['regional_take_back_policies'] = $regional_take_back_policies;

        return $this;
    }

    /**
     * Gets return_policy_id
     *
     * @return string|null
     */
    public function getReturnPolicyId()
    {
        return $this->container['return_policy_id'];
    }

    /**
     * Sets return_policy_id
     *
     * @param string|null $return_policy_id This unique identifier indicates the return business policy that will be used once an offer is published and converted to an eBay listing. This return business policy will set all return policy settings for the eBay listing.<br><br><span class=\"tablenote\"><b>Note:</b> As a part of Digital Services Act (DSA) requirements, as of April 3, 2023, buyers in the EU must be allowed to return an item within 14 days or more, unless the item is exempt. Where applicable, sellers should update their return policies to reflect this requirement of accepting returns from EU buyers.</span><br>Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the return business policy before assigning it to the offer to make sure it is compatible with the inventory item and the offer settings.<br><br>Business policies can be created and managed in My eBay or with the <a href=\"/developer.ebay.com/api-docs/sell/account/overview.html\" target=\"_blank\">Account API</a>. To get a list of all return policies associated with a seller's account on a specific eBay Marketplace, use the Account API's <a href=\"/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\" target=\"_blank\">getReturnPolicies</a> call. There are also calls in the <strong>Account API</strong> to retrieve a return policy by policy ID or policy name.<br><br>This field will be returned in the <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffer\" target=\"_blank\">getOffer</a> and <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffers\" target=\"_blank\">getOffers</a> methods if set for the offer.
     *
     * @return self
     */
    public function setReturnPolicyId($return_policy_id)
    {
        if (is_null($return_policy_id)) {
            throw new \InvalidArgumentException('non-nullable return_policy_id cannot be null');
        }
        $this->container['return_policy_id'] = $return_policy_id;

        return $this;
    }

    /**
     * Gets shipping_cost_overrides
     *
     * @return \Ebay\Inventory\Model\ShippingCostOverride[]|null
     */
    public function getShippingCostOverrides()
    {
        return $this->container['shipping_cost_overrides'];
    }

    /**
     * Sets shipping_cost_overrides
     *
     * @param \Ebay\Inventory\Model\ShippingCostOverride[]|null $shipping_cost_overrides This container is used if the seller wishes to override the shipping costs or surcharge for one or more domestic or international shipping service options defined in the fulfillment listing policy. To override the costs of a specific domestic or international shipping service option, the seller must know the priority/order of that shipping service in the fulfillment listing policy. The name of a shipping service option can be found in the <strong>shippingOptions.shippingServices.shippingServiceCode</strong> field of the fulfillment policy, and the priority/order of that shipping service option is found in the <strong>shippingOptions.shippingServices.sortOrderId</strong> field. Both of these values can be retrieved by searching for that fulfillment policy with the <strong>getFulfillmentPolicies</strong> or <strong>getFulfillmentPolicyByName</strong> calls of the <strong>Account API</strong>. The <strong>shippingCostOverrides.priority</strong> value should match the <strong>shippingOptions.shippingServices.sortOrderId</strong> in order to override the shipping costs for that shipping service option. The seller must also ensure that the <strong>shippingServiceType</strong> value is set to <code>DOMESTIC</code> to override a domestic shipping service option, or to <code>INTERNATIONAL</code> to override an international shipping service option.<br><br>A separate <strong>ShippingCostOverrides</strong> node is needed for each shipping service option whose costs are being overridden. All defined fields of the <strong>shippingCostOverrides</strong> container should be included, even if the shipping costs and surcharge values are not changing.<br><br>The <strong>shippingCostOverrides</strong> container is returned in the <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffer\" target=\"_blank\">getOffer</a> and <a href=\"/api-docs/sell/inventory/resources/offer/methods/getOffers\" target=\"_blank\">getOffers</a> calls if one or more shipping cost overrides are being applied to the fulfillment policy.
     *
     * @return self
     */
    public function setShippingCostOverrides($shipping_cost_overrides)
    {
        if (is_null($shipping_cost_overrides)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost_overrides cannot be null');
        }
        $this->container['shipping_cost_overrides'] = $shipping_cost_overrides;

        return $this;
    }

    /**
     * Gets take_back_policy_id
     *
     * @return string|null
     */
    public function getTakeBackPolicyId()
    {
        return $this->container['take_back_policy_id'];
    }

    /**
     * Sets take_back_policy_id
     *
     * @param string|null $take_back_policy_id This unique identifier indicates the seller-created <i>global</i> take-back policy that will be used once an offer is published and converted to a listing.<br><br>One (1) global take-back policy may be specified <i>per offer</i>.<br><span class=\"tablenote\"><b>Note:</b> For countries that support country-specific policies, use <a href=\"#request.listingPolicies.regionalTakeBackPolicies\">regionalTakeBackPolicies</a> to apply them to an offer.</span>
     *
     * @return self
     */
    public function setTakeBackPolicyId($take_back_policy_id)
    {
        if (is_null($take_back_policy_id)) {
            throw new \InvalidArgumentException('non-nullable take_back_policy_id cannot be null');
        }
        $this->container['take_back_policy_id'] = $take_back_policy_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


