<?php
/**
 * Hazmat
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.
 *
 * The version of the OpenAPI document: 1.17.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Inventory\Model;

use \ArrayAccess;
use \Ebay\Inventory\ObjectSerializer;

/**
 * Hazmat Class Doc Comment
 *
 * @category Class
 * @description This container is used by the seller to provide hazardous material information for the listing.&lt;br&gt;&lt;br&gt;Three elements are required to complete the Hazmat section of a listing:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Pictograms&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;SignalWord&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Statements&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;&lt;br&gt;A fourth element, &lt;b&gt;Component&lt;/b&gt;, is optional.
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Hazmat implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Hazmat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'component' => 'string',
        'pictograms' => 'string[]',
        'signal_word' => 'string',
        'statements' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'component' => null,
        'pictograms' => null,
        'signal_word' => null,
        'statements' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'component' => false,
        'pictograms' => false,
        'signal_word' => false,
        'statements' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'component' => 'component',
        'pictograms' => 'pictograms',
        'signal_word' => 'signalWord',
        'statements' => 'statements'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'component' => 'setComponent',
        'pictograms' => 'setPictograms',
        'signal_word' => 'setSignalWord',
        'statements' => 'setStatements'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'component' => 'getComponent',
        'pictograms' => 'getPictograms',
        'signal_word' => 'getSignalWord',
        'statements' => 'getStatements'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('component', $data ?? [], null);
        $this->setIfExists('pictograms', $data ?? [], null);
        $this->setIfExists('signal_word', $data ?? [], null);
        $this->setIfExists('statements', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets component
     *
     * @return string|null
     */
    public function getComponent()
    {
        return $this->container['component'];
    }

    /**
     * Sets component
     *
     * @param string|null $component This field is used by the seller to provide component information for the listing. For example, component information can provide the specific material of Hazmat concern.<br><br><b>Max length:</b> 120
     *
     * @return self
     */
    public function setComponent($component)
    {
        if (is_null($component)) {
            throw new \InvalidArgumentException('non-nullable component cannot be null');
        }
        $this->container['component'] = $component;

        return $this;
    }

    /**
     * Gets pictograms
     *
     * @return string[]|null
     */
    public function getPictograms()
    {
        return $this->container['pictograms'];
    }

    /**
     * Sets pictograms
     *
     * @param string[]|null $pictograms An array of comma-separated string values listing applicable pictogram code(s) for Hazard Pictogram(s).<br><br>If your product contains hazardous substances or mixtures, please select the values corresponding to the hazard pictograms that are stated on your product's Safety Data Sheet. The selected hazard information will be displayed on your listing.<br><br><span class=\"tablenote\"><b>Note:</b> Use the <a href=\"/api-docs/sell/metadata/resources/marketplace/methods/getHazardousMaterialsLabels \" target=\"_blank\">getHazardousMaterialsLabels</a> method in the Metadata API to find supported values for a specific marketplace/site. Refer to <a href=\"/api-docs/sell/static/metadata/feature-regulatorhazmatcontainer.html#Pictogra\" target=\"_blank\">Pictogram sample values</a> for additional information.</span>
     *
     * @return self
     */
    public function setPictograms($pictograms)
    {
        if (is_null($pictograms)) {
            throw new \InvalidArgumentException('non-nullable pictograms cannot be null');
        }
        $this->container['pictograms'] = $pictograms;

        return $this;
    }

    /**
     * Gets signal_word
     *
     * @return string|null
     */
    public function getSignalWord()
    {
        return $this->container['signal_word'];
    }

    /**
     * Sets signal_word
     *
     * @param string|null $signal_word This field sets the signal word for hazardous materials in the listing.<br><br>If your product contains hazardous substances or mixtures, please select a value corresponding to the signal word that is stated on your product's Safety Data Sheet. The selected hazard information will be displayed on your listing.<br><br><span class=\"tablenote\"><b>Note:</b> Use the <a href=\"/api-docs/sell/metadata/resources/marketplace/methods/getHazardousMaterialsLabels \" target=\"_blank\">getHazardousMaterialsLabels</a> method in the <a href=\"/api-docs/sell/metadata/resources/methods \" target=\"_blank\">Metadata API</a> to find supported values for a specific marketplace/site. Refer to <a href=\"/api-docs/sell/static/metadata/feature-regulatorhazmatcontainer.html#Signal\" target=\"_blank\">Signal word information</a> for additional information.</span>
     *
     * @return self
     */
    public function setSignalWord($signal_word)
    {
        if (is_null($signal_word)) {
            throw new \InvalidArgumentException('non-nullable signal_word cannot be null');
        }
        $this->container['signal_word'] = $signal_word;

        return $this;
    }

    /**
     * Gets statements
     *
     * @return string[]|null
     */
    public function getStatements()
    {
        return $this->container['statements'];
    }

    /**
     * Sets statements
     *
     * @param string[]|null $statements An array of comma-separated string values specifying applicable statement code(s) for hazard statement(s) for the listing.<br><br>If your product contains hazardous substances or mixtures, please select the values corresponding to the hazard statements that are stated on your product's Safety Data Sheet. The selected hazard information will be displayed on your listing.<br><br><span class=\"tablenote\"><b>Note:</b> Use the <a href=\"/api-docs/sell/metadata/resources/marketplace/methods/getHazardousMaterialsLabels \" target=\"_blank\">getHazardousMaterialsLabels</a> method in the Metadata API to find supported values for a specific marketplace/site. Refer to <a href=\"/api-docs/sell/static/metadata/feature-regulatorhazmatcontainer.html#Hazard\" target=\"_blank\">Hazard statement sample values</a> for additional information.</span>
     *
     * @return self
     */
    public function setStatements($statements)
    {
        if (is_null($statements)) {
            throw new \InvalidArgumentException('non-nullable statements cannot be null');
        }
        $this->container['statements'] = $statements;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


