<?php
/**
 * ExtendedProducerResponsibility
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.
 *
 * The version of the OpenAPI document: 1.17.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Inventory\Model;

use \ArrayAccess;
use \Ebay\Inventory\ObjectSerializer;

/**
 * ExtendedProducerResponsibility Class Doc Comment
 *
 * @category Class
 * @description This type provides IDs for the producer or importer related to the new item, packaging, added documentation, or an eco-participation fee. In some markets, such as in France, this may be the importer of the item.
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ExtendedProducerResponsibility implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ExtendedProducerResponsibility';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'eco_participation_fee' => '\Ebay\Inventory\Model\Amount',
        'producer_product_id' => 'string',
        'product_documentation_id' => 'string',
        'product_package_id' => 'string',
        'shipment_package_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'eco_participation_fee' => null,
        'producer_product_id' => null,
        'product_documentation_id' => null,
        'product_package_id' => null,
        'shipment_package_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'eco_participation_fee' => false,
        'producer_product_id' => false,
        'product_documentation_id' => false,
        'product_package_id' => false,
        'shipment_package_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'eco_participation_fee' => 'ecoParticipationFee',
        'producer_product_id' => 'producerProductId',
        'product_documentation_id' => 'productDocumentationId',
        'product_package_id' => 'productPackageId',
        'shipment_package_id' => 'shipmentPackageId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'eco_participation_fee' => 'setEcoParticipationFee',
        'producer_product_id' => 'setProducerProductId',
        'product_documentation_id' => 'setProductDocumentationId',
        'product_package_id' => 'setProductPackageId',
        'shipment_package_id' => 'setShipmentPackageId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'eco_participation_fee' => 'getEcoParticipationFee',
        'producer_product_id' => 'getProducerProductId',
        'product_documentation_id' => 'getProductDocumentationId',
        'product_package_id' => 'getProductPackageId',
        'shipment_package_id' => 'getShipmentPackageId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('eco_participation_fee', $data ?? [], null);
        $this->setIfExists('producer_product_id', $data ?? [], null);
        $this->setIfExists('product_documentation_id', $data ?? [], null);
        $this->setIfExists('product_package_id', $data ?? [], null);
        $this->setIfExists('shipment_package_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets eco_participation_fee
     *
     * @return \Ebay\Inventory\Model\Amount|null
     */
    public function getEcoParticipationFee()
    {
        return $this->container['eco_participation_fee'];
    }

    /**
     * Sets eco_participation_fee
     *
     * @param \Ebay\Inventory\Model\Amount|null $eco_participation_fee eco_participation_fee
     *
     * @return self
     */
    public function setEcoParticipationFee($eco_participation_fee)
    {
        if (is_null($eco_participation_fee)) {
            throw new \InvalidArgumentException('non-nullable eco_participation_fee cannot be null');
        }
        $this->container['eco_participation_fee'] = $eco_participation_fee;

        return $this;
    }

    /**
     * Gets producer_product_id
     *
     * @return string|null
     */
    public function getProducerProductId()
    {
        return $this->container['producer_product_id'];
    }

    /**
     * Sets producer_product_id
     *
     * @param string|null $producer_product_id <span class=\"tablenote\"><b>Note:</b> <b>THIS FIELD IS DEPRECATED AND NO LONGER SUPPORTED.</b> For sellers selling on the eBay France Marketplace, Extended Producer Responsibility ID fields are no longer set at the listing level. Instead, sellers must provide these IDs for each applicable category in their My eBay accounts. The URL will be based on the seller's home/registration site, and will use this pattern: https://accountsettings./epr-fr. Sellers based in the US will use <a href=\"https://accountsettings.ebay.com/epr-fr\" target=\"_blank\">https://accountsettings.ebay.com/epr-fr</a>, sellers based in France will use <a href=\"https://accountsettings.ebay.fr/epr-fr\" target=\"_blank\">https://accountsettings.ebay.fr/epr-fr</a>, and so on.</span>
     *
     * @return self
     */
    public function setProducerProductId($producer_product_id)
    {
        if (is_null($producer_product_id)) {
            throw new \InvalidArgumentException('non-nullable producer_product_id cannot be null');
        }
        $this->container['producer_product_id'] = $producer_product_id;

        return $this;
    }

    /**
     * Gets product_documentation_id
     *
     * @return string|null
     */
    public function getProductDocumentationId()
    {
        return $this->container['product_documentation_id'];
    }

    /**
     * Sets product_documentation_id
     *
     * @param string|null $product_documentation_id <span class=\"tablenote\"><b>Note:</b> <b>THIS FIELD IS DEPRECATED AND NO LONGER SUPPORTED.</b> For sellers selling on the eBay France Marketplace, Extended Producer Responsibility ID fields are no longer set at the listing level. Instead, sellers must provide these IDs for each applicable category in their My eBay accounts. The URL will be based on the seller's home/registration site, and will use this pattern: https://accountsettings./epr-fr. Sellers based in the US will use <a href=\"https://accountsettings.ebay.com/epr-fr\" target=\"_blank\">https://accountsettings.ebay.com/epr-fr</a>, sellers based in France will use <a href=\"https://accountsettings.ebay.fr/epr-fr\" target=\"_blank\">https://accountsettings.ebay.fr/epr-fr</a>, and so on.</span>
     *
     * @return self
     */
    public function setProductDocumentationId($product_documentation_id)
    {
        if (is_null($product_documentation_id)) {
            throw new \InvalidArgumentException('non-nullable product_documentation_id cannot be null');
        }
        $this->container['product_documentation_id'] = $product_documentation_id;

        return $this;
    }

    /**
     * Gets product_package_id
     *
     * @return string|null
     */
    public function getProductPackageId()
    {
        return $this->container['product_package_id'];
    }

    /**
     * Sets product_package_id
     *
     * @param string|null $product_package_id <span class=\"tablenote\"><b>Note:</b> <b>THIS FIELD IS DEPRECATED AND NO LONGER SUPPORTED.</b> For sellers selling on the eBay France Marketplace, Extended Producer Responsibility ID fields are no longer set at the listing level. Instead, sellers must provide these IDs for each applicable category in their My eBay accounts. The URL will be based on the seller's home/registration site, and will use this pattern: https://accountsettings./epr-fr. Sellers based in the US will use <a href=\"https://accountsettings.ebay.com/epr-fr\" target=\"_blank\">https://accountsettings.ebay.com/epr-fr</a>, sellers based in France will use <a href=\"https://accountsettings.ebay.fr/epr-fr\" target=\"_blank\">https://accountsettings.ebay.fr/epr-fr</a>, and so on.</span>
     *
     * @return self
     */
    public function setProductPackageId($product_package_id)
    {
        if (is_null($product_package_id)) {
            throw new \InvalidArgumentException('non-nullable product_package_id cannot be null');
        }
        $this->container['product_package_id'] = $product_package_id;

        return $this;
    }

    /**
     * Gets shipment_package_id
     *
     * @return string|null
     */
    public function getShipmentPackageId()
    {
        return $this->container['shipment_package_id'];
    }

    /**
     * Sets shipment_package_id
     *
     * @param string|null $shipment_package_id <span class=\"tablenote\"><b>Note:</b> <b>THIS FIELD IS DEPRECATED AND NO LONGER SUPPORTED.</b> For sellers selling on the eBay France Marketplace, Extended Producer Responsibility ID fields are no longer set at the listing level. Instead, sellers must provide these IDs for each applicable category in their My eBay accounts. The URL will be based on the seller's home/registration site, and will use this pattern: https://accountsettings./epr-fr. Sellers based in the US will use <a href=\"https://accountsettings.ebay.com/epr-fr\" target=\"_blank\">https://accountsettings.ebay.com/epr-fr</a>, sellers based in France will use <a href=\"https://accountsettings.ebay.fr/epr-fr\" target=\"_blank\">https://accountsettings.ebay.fr/epr-fr</a>, and so on.</span>
     *
     * @return self
     */
    public function setShipmentPackageId($shipment_package_id)
    {
        if (is_null($shipment_package_id)) {
            throw new \InvalidArgumentException('non-nullable shipment_package_id cannot be null');
        }
        $this->container['shipment_package_id'] = $shipment_package_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


