<?php
/**
 * InventoryItemGroupApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.
 *
 * The version of the OpenAPI document: 1.17.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Inventory\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Ebay\Inventory\ApiException;
use Ebay\Inventory\Configuration;
use Ebay\Inventory\FormDataProcessor;
use Ebay\Inventory\HeaderSelector;
use Ebay\Inventory\ObjectSerializer;

/**
 * InventoryItemGroupApi Class Doc Comment
 *
 * @category Class
 * @package  Ebay\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InventoryItemGroupApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createOrReplaceInventoryItemGroup' => [
            'application/json',
        ],
        'deleteInventoryItemGroup' => [
            'application/json',
        ],
        'getInventoryItemGroup' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createOrReplaceInventoryItemGroup
     *
     * @param  string $content_language This header sets the natural language that will be used in the field values of the request payload. For example, the value passed in this header should be &lt;code&gt;en-US&lt;/code&gt; for English or &lt;code&gt;de-DE&lt;/code&gt; for German.&lt;br&gt;&lt;br&gt;For more information on the Content-Language header, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being created or updated. This identifier is defined by the seller.&lt;br&gt;&lt;br&gt;This value cannot be changed once it is set.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max Length:&lt;/b&gt; 50 (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Inventory\Model\InventoryItemGroup $inventory_item_group Details of the inventory Item Group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Inventory\Model\BaseResponse|\Ebay\Inventory\Model\BaseResponse
     */
    public function createOrReplaceInventoryItemGroup($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, string $contentType = self::contentTypes['createOrReplaceInventoryItemGroup'][0])
    {
        list($response) = $this->createOrReplaceInventoryItemGroupWithHttpInfo($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, $contentType);
        return $response;
    }

    /**
     * Operation createOrReplaceInventoryItemGroupWithHttpInfo
     *
     * @param  string $content_language This header sets the natural language that will be used in the field values of the request payload. For example, the value passed in this header should be &lt;code&gt;en-US&lt;/code&gt; for English or &lt;code&gt;de-DE&lt;/code&gt; for German.&lt;br&gt;&lt;br&gt;For more information on the Content-Language header, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being created or updated. This identifier is defined by the seller.&lt;br&gt;&lt;br&gt;This value cannot be changed once it is set.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max Length:&lt;/b&gt; 50 (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Inventory\Model\InventoryItemGroup $inventory_item_group Details of the inventory Item Group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Inventory\Model\BaseResponse|\Ebay\Inventory\Model\BaseResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrReplaceInventoryItemGroupWithHttpInfo($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, string $contentType = self::contentTypes['createOrReplaceInventoryItemGroup'][0])
    {
        $request = $this->createOrReplaceInventoryItemGroupRequest($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Inventory\Model\BaseResponse',
                        $request,
                        $response,
                    );
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Inventory\Model\BaseResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Inventory\Model\BaseResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Inventory\Model\BaseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Inventory\Model\BaseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createOrReplaceInventoryItemGroupAsync
     *
     * @param  string $content_language This header sets the natural language that will be used in the field values of the request payload. For example, the value passed in this header should be &lt;code&gt;en-US&lt;/code&gt; for English or &lt;code&gt;de-DE&lt;/code&gt; for German.&lt;br&gt;&lt;br&gt;For more information on the Content-Language header, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being created or updated. This identifier is defined by the seller.&lt;br&gt;&lt;br&gt;This value cannot be changed once it is set.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max Length:&lt;/b&gt; 50 (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Inventory\Model\InventoryItemGroup $inventory_item_group Details of the inventory Item Group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceInventoryItemGroupAsync($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, string $contentType = self::contentTypes['createOrReplaceInventoryItemGroup'][0])
    {
        return $this->createOrReplaceInventoryItemGroupAsyncWithHttpInfo($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrReplaceInventoryItemGroupAsyncWithHttpInfo
     *
     * @param  string $content_language This header sets the natural language that will be used in the field values of the request payload. For example, the value passed in this header should be &lt;code&gt;en-US&lt;/code&gt; for English or &lt;code&gt;de-DE&lt;/code&gt; for German.&lt;br&gt;&lt;br&gt;For more information on the Content-Language header, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being created or updated. This identifier is defined by the seller.&lt;br&gt;&lt;br&gt;This value cannot be changed once it is set.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max Length:&lt;/b&gt; 50 (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Inventory\Model\InventoryItemGroup $inventory_item_group Details of the inventory Item Group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceInventoryItemGroupAsyncWithHttpInfo($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, string $contentType = self::contentTypes['createOrReplaceInventoryItemGroup'][0])
    {
        $returnType = '\Ebay\Inventory\Model\BaseResponse';
        $request = $this->createOrReplaceInventoryItemGroupRequest($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrReplaceInventoryItemGroup'
     *
     * @param  string $content_language This header sets the natural language that will be used in the field values of the request payload. For example, the value passed in this header should be &lt;code&gt;en-US&lt;/code&gt; for English or &lt;code&gt;de-DE&lt;/code&gt; for German.&lt;br&gt;&lt;br&gt;For more information on the Content-Language header, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being created or updated. This identifier is defined by the seller.&lt;br&gt;&lt;br&gt;This value cannot be changed once it is set.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max Length:&lt;/b&gt; 50 (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Inventory\Model\InventoryItemGroup $inventory_item_group Details of the inventory Item Group (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrReplaceInventoryItemGroupRequest($content_language, $inventory_item_group_key, $content_type, $inventory_item_group, string $contentType = self::contentTypes['createOrReplaceInventoryItemGroup'][0])
    {

        // verify the required parameter 'content_language' is set
        if ($content_language === null || (is_array($content_language) && count($content_language) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_language when calling createOrReplaceInventoryItemGroup'
            );
        }

        // verify the required parameter 'inventory_item_group_key' is set
        if ($inventory_item_group_key === null || (is_array($inventory_item_group_key) && count($inventory_item_group_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_item_group_key when calling createOrReplaceInventoryItemGroup'
            );
        }

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling createOrReplaceInventoryItemGroup'
            );
        }

        // verify the required parameter 'inventory_item_group' is set
        if ($inventory_item_group === null || (is_array($inventory_item_group) && count($inventory_item_group) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_item_group when calling createOrReplaceInventoryItemGroup'
            );
        }


        $resourcePath = '/inventory_item_group/{inventoryItemGroupKey}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_language !== null) {
            $headerParams['Content-Language'] = ObjectSerializer::toHeaderValue($content_language);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($inventory_item_group_key !== null) {
            $resourcePath = str_replace(
                '{' . 'inventoryItemGroupKey' . '}',
                ObjectSerializer::toPathValue($inventory_item_group_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_item_group)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_item_group));
            } else {
                $httpBody = $inventory_item_group;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemGroup
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being deleted. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemGroup($inventory_item_group_key, string $contentType = self::contentTypes['deleteInventoryItemGroup'][0])
    {
        $this->deleteInventoryItemGroupWithHttpInfo($inventory_item_group_key, $contentType);
    }

    /**
     * Operation deleteInventoryItemGroupWithHttpInfo
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being deleted. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemGroupWithHttpInfo($inventory_item_group_key, string $contentType = self::contentTypes['deleteInventoryItemGroup'][0])
    {
        $request = $this->deleteInventoryItemGroupRequest($inventory_item_group_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemGroupAsync
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being deleted. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemGroupAsync($inventory_item_group_key, string $contentType = self::contentTypes['deleteInventoryItemGroup'][0])
    {
        return $this->deleteInventoryItemGroupAsyncWithHttpInfo($inventory_item_group_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemGroupAsyncWithHttpInfo
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being deleted. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemGroupAsyncWithHttpInfo($inventory_item_group_key, string $contentType = self::contentTypes['deleteInventoryItemGroup'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemGroupRequest($inventory_item_group_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemGroup'
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being deleted. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemGroupRequest($inventory_item_group_key, string $contentType = self::contentTypes['deleteInventoryItemGroup'][0])
    {

        // verify the required parameter 'inventory_item_group_key' is set
        if ($inventory_item_group_key === null || (is_array($inventory_item_group_key) && count($inventory_item_group_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_item_group_key when calling deleteInventoryItemGroup'
            );
        }


        $resourcePath = '/inventory_item_group/{inventoryItemGroupKey}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($inventory_item_group_key !== null) {
            $resourcePath = str_replace(
                '{' . 'inventoryItemGroupKey' . '}',
                ObjectSerializer::toPathValue($inventory_item_group_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemGroup
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being retrieved. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Inventory\Model\InventoryItemGroup
     */
    public function getInventoryItemGroup($inventory_item_group_key, string $contentType = self::contentTypes['getInventoryItemGroup'][0])
    {
        list($response) = $this->getInventoryItemGroupWithHttpInfo($inventory_item_group_key, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemGroupWithHttpInfo
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being retrieved. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \Ebay\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Inventory\Model\InventoryItemGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemGroupWithHttpInfo($inventory_item_group_key, string $contentType = self::contentTypes['getInventoryItemGroup'][0])
    {
        $request = $this->getInventoryItemGroupRequest($inventory_item_group_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Inventory\Model\InventoryItemGroup',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Inventory\Model\InventoryItemGroup',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Inventory\Model\InventoryItemGroup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getInventoryItemGroupAsync
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being retrieved. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemGroupAsync($inventory_item_group_key, string $contentType = self::contentTypes['getInventoryItemGroup'][0])
    {
        return $this->getInventoryItemGroupAsyncWithHttpInfo($inventory_item_group_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemGroupAsyncWithHttpInfo
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being retrieved. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemGroupAsyncWithHttpInfo($inventory_item_group_key, string $contentType = self::contentTypes['getInventoryItemGroup'][0])
    {
        $returnType = '\Ebay\Inventory\Model\InventoryItemGroup';
        $request = $this->getInventoryItemGroupRequest($inventory_item_group_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemGroup'
     *
     * @param  string $inventory_item_group_key This path parameter specifies the unique identifier of the inventory item group being retrieved. This value is assigned by the seller when an inventory item group is created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemGroupRequest($inventory_item_group_key, string $contentType = self::contentTypes['getInventoryItemGroup'][0])
    {

        // verify the required parameter 'inventory_item_group_key' is set
        if ($inventory_item_group_key === null || (is_array($inventory_item_group_key) && count($inventory_item_group_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_item_group_key when calling getInventoryItemGroup'
            );
        }


        $resourcePath = '/inventory_item_group/{inventoryItemGroupKey}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($inventory_item_group_key !== null) {
            $resourcePath = str_replace(
                '{' . 'inventoryItemGroupKey' . '}',
                ObjectSerializer::toPathValue($inventory_item_group_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
