# # Tax

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**apply_tax** | **bool** | When set to &lt;code&gt;true&lt;/code&gt;, the seller&#39;s account-level sales-tax table will be used to calculate sales tax for an order.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; Sales-tax tables are available only for the US and Canada marketplaces.&lt;/span&gt;&lt;br&gt;&lt;div class&#x3D;\&quot;msgbox_important\&quot;&gt;&lt;p class&#x3D;\&quot;msgbox_importantInDiv\&quot; data-mc-autonum&#x3D;\&quot;&amp;lt;b&amp;gt;&amp;lt;span style&#x3D;&amp;quot;color: #dd1e31;&amp;quot; class&#x3D;&amp;quot;mcFormatColor&amp;quot;&amp;gt;Important! &amp;lt;/span&amp;gt;&amp;lt;/b&amp;gt;\&quot;&gt;&lt;span class&#x3D;\&quot;autonumber\&quot;&gt;&lt;span&gt;&lt;b&gt;&lt;span style&#x3D;\&quot;color: #dd1e31;\&quot; class&#x3D;\&quot;mcFormatColor\&quot;&gt;Important!&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt; In the US, eBay now calculates, collects, and remits sales tax to the proper taxing authorities in all 50 states and Washington, DC. Sellers can no longer specify sales-tax rates for these jurisdictions using a tax table.&lt;br&gt;&lt;br&gt;However, sellers may continue to use a sales-tax table to set rates for the following US territories:&lt;ul&gt;&lt;li&gt;American Samoa (AS)&lt;/li&gt;&lt;li&gt;Guam (GU)&lt;/li&gt;&lt;li&gt;Northern Mariana Islands (MP)&lt;/li&gt;&lt;li&gt;Palau (PW)&lt;/li&gt;&lt;li&gt;US Virgin Islands (VI)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;&lt;/div&gt;&lt;br&gt;For complete information about using sales-tax tables, refer to &lt;a href&#x3D;\&quot;/api-docs/sell/static/seller-accounts/tax-tables.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Establishing sales-tax tables&lt;/a&gt;.&lt;br&gt;&lt;br&gt;Note that a seller can enable the use of a sales-tax table, but if a sales-tax rate is not specified for the buyer&#39;s tax jurisdiction, sales tax will not be applied to the order.&lt;br&gt;&lt;br&gt;When a &lt;code&gt;thirdPartyTaxCategory&lt;/code&gt; value is used, &lt;code&gt;applyTax&lt;/code&gt; must also be set to &lt;code&gt;true&lt;/code&gt;.&lt;br&gt;&lt;br&gt;This field will be returned by &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot;&gt;getOffers&lt;/a&gt; if set for the offer.&lt;br&gt;&lt;br&gt;For additional information, refer to &lt;a href&#x3D;\&quot;https://www.ebay.com/help/selling/fees-credits-invoices/taxes-import-charges?id&#x3D;4121 \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Taxes and import charges&lt;/a&gt;. | [optional]
**third_party_tax_category** | **string** | The tax exception category code. If this field is used, sales tax will also apply to a service/fee, and not just the item price. This is to be used only by sellers who have opted into sales tax being calculated by a sales tax calculation vendor. If you are interested in becoming a tax calculation vendor partner with eBay, contact &lt;a href&#x3D;\&quot;mailto:developer-relations@ebay.com \&quot;&gt;developer-relations@ebay.com&lt;/a&gt;. One supported value for this field is &lt;code&gt;WASTE_RECYCLING_FEE&lt;/code&gt;. If this field is used, the &lt;strong&gt;applyTax&lt;/strong&gt; field must also be used and set to &lt;code&gt;true&lt;/code&gt;&lt;br&gt;&lt;br&gt;This field will be returned by &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot;&gt;getOffers&lt;/a&gt; if set for the offer. | [optional]
**vat_percentage** | **float** | This value is the Value Add Tax (VAT) rate for the item, if any. When a VAT percentage is specified, the item&#39;s VAT information appears on the listing&#39;s View Item page. In addition, the seller can choose to print an invoice that includes the item&#39;s net price, VAT percent, VAT amount, and total price. Since VAT rates vary depending on the item and on the user&#39;s country of residence, a seller is responsible for entering the correct VAT rate; it is not calculated by eBay. &lt;br&gt;&lt;br&gt; To use VAT, a seller must be a business seller with a VAT-ID registered with eBay, and must be listing the item on a VAT-enabled site. Max applicable length is 6 characters, including the decimal (e.g., 12.345). The scale is 3 decimal places. (If you pass in 12.3456, eBay may round up the value to 12.346).&lt;br&gt;&lt;br&gt;This field will be returned by &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot;&gt;getOffers&lt;/a&gt; if set for the offer. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
