# # Specification

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **string** | This is the name of product variation aspect. Typically, for clothing, typical aspect names are &lt;code&gt;\&quot;Size\&quot;&lt;/code&gt; and &lt;code&gt;\&quot;Color\&quot;&lt;/code&gt;. Product variation aspects are not required immediately upon creating an inventory item group, but these aspects will be required before a multiple-variation listing containing this inventory item group is published. For each product variation aspect that is specified through the &lt;strong&gt;specifications&lt;/strong&gt; container, one &lt;strong&gt;name&lt;/strong&gt; value is required and two or more variations of this aspect are required through the &lt;strong&gt;values&lt;/strong&gt; array.&lt;br&gt;&lt;br&gt; &lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; Each member of the inventory item group should have these same aspect names specified through the &lt;strong&gt;product.aspects&lt;/strong&gt; container when the inventory item is created with the &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; or &lt;strong&gt;bulkCreateOrReplaceInventoryItem&lt;/strong&gt; call. &lt;/span&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 40 | [optional]
**values** | **string[]** | This is an array of values pertaining to the corresponding product variation aspect (specified in the &lt;strong&gt;name&lt;/strong&gt; field). Below is a sample of how these values will appear under a &lt;strong&gt;specifications&lt;/strong&gt; container: &lt;br&gt; &lt;pre&gt;&lt;code&gt;\&quot;specifications\&quot;: [{&lt;br&gt; \&quot;name\&quot;: \&quot;Size\&quot;,&lt;br&gt; \&quot;values\&quot;: [\&quot;Small\&quot;,&lt;br&gt; \&quot;Medium\&quot;,&lt;br&gt; \&quot;Large\&quot;]&lt;br&gt; },&lt;br&gt; { &lt;br&gt; \&quot;name\&quot;: \&quot;Color\&quot;,&lt;br&gt; \&quot;values\&quot;: [\&quot;Blue\&quot;,&lt;br&gt; \&quot;White\&quot;,&lt;br&gt; \&quot;Red\&quot;] &lt;br&gt; }] &lt;/pre&gt;&lt;/code&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; Each member of the inventory item group should have these same aspect names, and each individual inventory item should have each variation of the product aspect values specified through the &lt;strong&gt;product.aspects&lt;/strong&gt; container when the inventory item is created with the &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; or &lt;strong&gt;bulkCreateOrReplaceInventoryItem&lt;/strong&gt; call. &lt;/span&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 50 | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
