# # Product

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**aspects** | **array<string,string[]>** | This is a collection of item specifics (aka product aspects) name-value pairs that provide more information about the product and might make it easier for buyers to find. To view required/recommended product aspects/item specifics names (and corresponding values) for a specific eBay category, sellers can use the &lt;a href&#x3D;\&quot;/api-docs/commerce/taxonomy/resources/category_tree/methods/getItemAspectsForCategory\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getItemAspectsForCategory&lt;/a&gt; method of the Taxonomy API. Alternatively, sellers can view similar items on eBay.com in the same category to get an idea of what other sellers are using for product aspects/item specifics.&lt;br&gt;&lt;br&gt;Sellers also have the option of specifying an eBay Product ID (ePID) or optionally, a Global Trade Item Number (GTIN) through the corresponding fields in the &lt;strong&gt;product&lt;/strong&gt; container in an attempt to find a product match in the eBay Catalog. If a match is found based on the ePID or GTIN value, the product aspects that are defined for the eBay Catalog product will automatically get picked up by the newly created/updated inventory item. &lt;br&gt;&lt;br&gt;Below is an example of the proper JSON syntax to use when manually inputting item specifics. Note that one item specific name, such as &#39;Features&#39;, can have more than one value. If an item specific name has more than one value, each value is delimited with a comma.&lt;br&gt;&lt;br&gt; &lt;pre&gt;&lt;code&gt;\&quot;aspects\&quot;: {&lt;br&gt; \&quot;Brand\&quot;: [\&quot;GoPro\&quot;],&lt;br&gt; \&quot;Storage Type\&quot;: [\&quot;Removable\&quot;]&lt;br&gt; }&lt;/code&gt;&lt;/pre&gt;&lt;br&gt;Note that inventory items that will become part of an inventory item group and multiple-variation listing should have the same attributes that are defined for the inventory item group.&lt;br&gt;&lt;br&gt;This container will be returned if one or more item specific pairs are defined for the inventory item.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length for Aspect Name&lt;/strong&gt;: 40&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length for Aspect Value&lt;/strong&gt;: 50 | [optional]
**brand** | **string** | The brand of the product. This field is often paired with the &lt;strong&gt;mpn&lt;/strong&gt; field to identify a specific product by Manufacture Part Number. This field is conditionally required if the eBay category requires a Manufacturer Part Number (MPN) value. If eBay is able to find a product match in the eBay Catalog when an eBay Product ID (ePID) or GTIN value (UPC, ISBN, or EAN) is supplied, all product details of that eBay Catalog product is picked up by the inventory item record (including brand) if the &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call is successful. &lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If a brand was passed in as an item specific name-value pair through the &lt;strong&gt;aspects&lt;/strong&gt; array in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call, this value is also picked up by the &lt;strong&gt;brand&lt;/strong&gt; field.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 65 | [optional]
**description** | **string** | The description of the product. The description of an existing inventory item can be added or modified with a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call. The description of an inventory item is automatically populated if the seller specifies an eBay Product ID (ePID) or a Global Trade Item Number (GTIN) and eBay is able to find a matching product in the eBay Catalog.&lt;br&gt;&lt;br&gt;Note that this field is optional but recommended. If a &lt;strong&gt;listingDescription&lt;/strong&gt; field is omitted when creating and publishing a single-variation offer, the text in this field will be used instead. If neither the &lt;strong&gt;product.description&lt;/strong&gt; field for the inventory item nor the &lt;strong&gt;listingDescription&lt;/strong&gt; field for the offer exist, the &lt;strong&gt;publishOffer&lt;/strong&gt; call will fail. If the inventory item will be part of an inventory item group/multiple-variation listing, this field should definitely be used to specify how the corresponding product variation is different (e.g. &lt;em&gt;This is the green, extra-large version of the shirt&lt;/em&gt;). However, in the case of an inventory item group, the text in the &lt;strong&gt;description&lt;/strong&gt; field of the inventory item group will become the listing description of the actual eBay listing instead of the text in this field.&lt;br&gt;&lt;br&gt;Basic HTML tags are supported, including the following tags:&lt;ul&gt;&lt;li&gt;&amp;lt;b&amp;gt;&lt;/li&gt;&lt;li&gt;&amp;lt;strong&amp;gt;&lt;/li&gt;&lt;li&gt;&amp;lt;br&amp;gt;&lt;/li&gt;&lt;li&gt;&amp;lt;ol&amp;gt;&lt;/li&gt;&lt;li&gt;&amp;lt;ul&amp;gt;&lt;/li&gt;&lt;li&gt;&amp;lt;li&amp;gt;&lt;/li&gt;&lt;li&gt;Table tags including &amp;lt;table&amp;gt;, &amp;lt;tr&amp;gt;, &amp;lt;td&amp;gt;, &amp;lt;th&amp;gt;, &amp;lt;thead&amp;gt;, &amp;lt;tfoot&amp;gt;, &amp;lt;tbody&amp;gt;, &amp;lt;caption&amp;gt;, &amp;lt;colgroup&amp;gt;, and &amp;lt;col&amp;gt;&lt;/li&gt;&lt;/ul&gt;A seller can not use any active content in their listing description. Active content includes animation or video via JavaScript, Flash, plug-ins, or form actions.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If one of the GTIN types (e.g. UPC) was passed in when the inventory item was created/modified and a product match was found in the eBay catalog, product description is one of the details that gets picked up from the catalog product.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 4000 | [optional]
**ean** | **string[]** | The European Article Number/International Article Number (EAN) for the product. Although an ePID value is preferred when trying to find a product match in the eBay Catalog, this field can also be used in an attempt to find a product match in the eBay Catalog. If a product match is found in the eBay Catalog, the inventory item is automatically populated with available product details such as a title, a product description, product aspects (including the specified EAN value), and a link to any stock image that exists for the catalog product.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If an EAN was passed in as an item specific name-value pair through the &lt;strong&gt;aspects&lt;/strong&gt; array in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call, this value is also picked up by the &lt;strong&gt;ean&lt;/strong&gt; field. | [optional]
**epid** | **string** | The eBay Product Identifier (ePID) for the product. This field can be used to directly identify an eBay Catalog product. Based on its specified ePID value, eBay will search for the product in the eBay Catalog, and if a match is found, the inventory item is automatically populated with available product details such as product title, product description, product aspects, and a link to any stock image that exists for the catalog product.&lt;br&gt;&lt;br&gt;In an attempt to find a eBay Catalog product match, an ePID value is always preferred over the other product identifiers, since it is possible that one GTIN value can be associated with multiple eBay Catalog products, and if multiple products are found, product details will not be picked up by the Inventory Item object.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. | [optional]
**image_urls** | **string[]** | An array of one or more links to images for the product. URLs must use the \&quot;HTTPS\&quot; protocol. Images can be self-hosted by the seller, or sellers can use the &lt;a href&#x3D;\&quot;/Devzone/XML/docs/Reference/eBay/UploadSiteHostedPictures.html \&quot;  target&#x3D;\&quot;_blank\&quot;&gt;UploadSiteHostedPictures&lt;/a&gt; call of the Trading API to upload images to an eBay Picture Server. If successful, the response of the &lt;a href&#x3D;\&quot;/Devzone/XML/docs/Reference/eBay/UploadSiteHostedPictures.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;UploadSiteHostedPictures&lt;/a&gt; call will contain a full URL to the image on an eBay Picture Server. This is the URL that will be passed in through the &lt;strong&gt;imageUrls&lt;/strong&gt; array. Before an offer can be published, at least one image must exist for the inventory item. In almost any category at no cost, sellers can include up to 24 pictures in one listing. For inventory items that are a part of an inventory item group/multiple-variation listings, a maximum of 12 pictures may be used per inventory item in the group. Motor vehicle listings are an exception. The number of included pictures in motor vehicle listings depend on the selected vehicle package (see &lt;a href&#x3D;\&quot;https://www.ebay.com/help/selling/fees-credits-invoices/motors-fees?id&#x3D;4127 \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Fees for selling vehicles on eBay Motors&lt;/a&gt;).&lt;br&gt;&lt;br&gt;A link to a stock image for a product may automatically be populated for an inventory item if the seller specifies an eBay Product ID (ePID) or a Global Trade Item Number (GTIN) and eBay is able to find a matching product in the eBay Catalog.&lt;br&gt;&lt;br&gt;This container will always be returned for an inventory item that is part of a published offer since a published offer will always have at least one picture, but this container will only be returned if defined for inventory items that are not a part of a published offer. | [optional]
**isbn** | **string[]** | The International Standard Book Number (ISBN) value for the product. Although an ePID value is preferred when trying to find a product match in the eBay Catalog, this field can also be used in an attempt to find a product match in the eBay Catalog. If a product match is found in the eBay Catalog, the inventory item is automatically populated with available product details such as a title, a product description, product aspects (including the specified ISBN value), and a link to any stock image that exists for the catalog product.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If an ISBN was passed in as an item specific name-value pair through the &lt;strong&gt;aspects&lt;/strong&gt; array in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call, this value is also picked up by the &lt;strong&gt;isbn&lt;/strong&gt; field. | [optional]
**mpn** | **string** | The Manufacturer Part Number (MPN) of a product. This field is paired with the &lt;strong&gt;brand&lt;/strong&gt; field to identify a product. Some eBay categories require MPN values. The &lt;a href&#x3D;\&quot;/api-docs/commerce/taxonomy/resources/category_tree/methods/getItemAspectsForCategory\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getItemAspectsForCategory&lt;/a&gt; method in the Taxonomy API can be used to see if a category requires an MPN. The MPN value for a product may automatically be populated for an inventory item if the seller specifies an eBay Product ID (ePID) or a Global Trade Item Number (GTIN) and eBay is able to find a matching product in the eBay Catalog. &lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If an MPN was passed in as an item specific name-value pair through the &lt;strong&gt;aspects&lt;/strong&gt; array in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call, this value is also picked up by the &lt;strong&gt;mpn&lt;/strong&gt; field.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 65 | [optional]
**subtitle** | **string** | A subtitle is an optional listing feature that allows the seller to provide more information about the product, possibly including keywords that may assist with search results. An additional listing fee will be charged to the seller if a subtitle is used. For more information on using listing subtitles on the US site, see the &lt;a href&#x3D;\&quot;https://pages.ebay.com/help/sell/itemsubtitle.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Adding a subtitle to your listings&lt;/a&gt; help page. The subtitle of an existing inventory item can added, modified, or removed with a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call.&lt;br&gt;&lt;br&gt;Note that the same &lt;strong&gt;subtitle&lt;/strong&gt; text should be used for each inventory item that will be part of an inventory item group, and ultimately become one product variation within a multiple-variation listing.&lt;br&gt;&lt;br&gt;This field will only be returned if set for an inventory item.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 55 | [optional]
**title** | **string** | The title of an inventory item can be added or modified with a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call. Although not immediately required, a title will be needed before an offer with the inventory item is published. The title of an inventory item is automatically populated if the seller specifies an eBay Product ID (ePID) or a Global Trade Item Number (GTIN) and eBay is able to find a matching product in the eBay Catalog. If the inventory item will become part of a single-variation offer, and the listing is not a product-based listing, the text in this field will become the actual listing title for the published offer. However, if the inventory item will become part of a multiple-variation offer, the text in &lt;strong&gt;title&lt;/strong&gt; field of the inventory item group entity will actually become the listing title for the published offer instead, although a title can still be provided for the inventory item, and it will actually become the title of the variation.&lt;br&gt;&lt;br&gt;This field will always be returned for an inventory item that is part of a published offer since a published offer will always have a listing title, but this field will only be returned if defined for inventory items that are not a part of a published offer.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 80 | [optional]
**upc** | **string[]** | The Universal Product Code (UPC) value for the product. Although an ePID value is preferred when trying to find a product match in the eBay Catalog, this field can also be used in an attempt to find a product match in the eBay Catalog. If a product match is found in the eBay Catalog, the inventory item is automatically populated with available product details such as a title, a product description, product aspects (including the specified UPC value), and a link to any stock image that exists for the catalog product.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory item. If a UPC was passed in as an item specific name-value pair through the &lt;strong&gt;aspects&lt;/strong&gt; array in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; call, this value is also picked up by the &lt;strong&gt;upc&lt;/strong&gt; field. | [optional]
**video_ids** | **string[]** | An array of one or more &lt;b&gt;videoId&lt;/b&gt; values for the product. A video ID is a unique identifier that is automatically created by eBay when a seller successfully uploads a video to eBay using the  &lt;a href&#x3D;\&quot;/api-docs/commerce/media/resources/video/methods/uploadVideo \&quot; target&#x3D;\&quot;_blank\&quot;&gt;uploadVideo&lt;/a&gt; method of the &lt;a href&#x3D;\&quot;/api-docs/commerce/media/overview.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Media API&lt;/a&gt;.&lt;br&gt;&lt;br&gt;For information on supported marketplaces and platforms, as well as other requirements and limitations of video support, please refer to &lt;a href&#x3D;\&quot;/api-docs/sell/static/inventory/managing-video-media.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Managing videos&lt;/a&gt;.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; Only one video per listing is supported.&lt;/span&gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
