# # PriceQuantity

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**offers** | [**\Ebay\Inventory\Model\OfferPriceQuantity[]**](OfferPriceQuantity.md) | This container is needed if the seller is updating the price and/or quantity of one or more published offers, and a successful call will actually update the active eBay listing with the revised price and/or available quantity.&lt;br&gt;&lt;br&gt;This call is not designed to work with unpublished offers. For unpublished offers, the seller should use the &lt;strong&gt;updateOffer&lt;/strong&gt; call to update the available quantity and/or price.&lt;br&gt;&lt;br&gt; If the seller is also using the &lt;strong&gt;shipToLocationAvailability&lt;/strong&gt; container and &lt;strong&gt;sku&lt;/strong&gt; field to update the total &#39;ship-to-home&#39; quantity of the inventory item, the SKU value associated with the corresponding &lt;strong&gt;offerId&lt;/strong&gt; value(s) must be the same as the corresponding &lt;strong&gt;sku&lt;/strong&gt; value that is passed in, or an error will occur.&lt;br&gt;&lt;br&gt;A separate (&lt;strong&gt;OfferPriceQuantity&lt;/strong&gt;) node is required for each offer being updated. | [optional]
**ship_to_location_availability** | [**\Ebay\Inventory\Model\ShipToLocationAvailability**](ShipToLocationAvailability.md) |  | [optional]
**sku** | **string** | This is the seller-defined SKU value of the inventory item whose total &#39;ship-to-home&#39; quantity will be updated. This field is only required when the seller is updating the total quantity of an inventory item using the &lt;strong&gt;shipToLocationAvailability&lt;/strong&gt; container. If the seller is updating the price and/or quantity of one or more specific offers, one or more &lt;strong&gt;offerId&lt;/strong&gt; values are used instead, and the &lt;strong&gt;sku&lt;/strong&gt; value is not needed.&lt;br&gt;&lt;br&gt;If the seller wants to update the price and/or quantity of one or more offers, and also wants to update the total &#39;ship-to-home&#39; quantity of the corresponding inventory item, the SKU value associated with the &lt;strong&gt;offerId&lt;/strong&gt; value(s) must be the same as the corresponding &lt;strong&gt;sku&lt;/strong&gt; value that is passed in, or an error will occur.&lt;br&gt;&lt;br&gt;Use the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/inventory_item/methods/getInventoryItems\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getInventoryItems&lt;/a&gt; method to retrieve SKU values.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 50&lt;br&gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
