# # ListingPolicies

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**best_offer_terms** | [**\Ebay\Inventory\Model\BestOffer**](BestOffer.md) |  | [optional]
**e_bay_plus_if_eligible** | **bool** | This field is included in an offer and set to &lt;code&gt;true&lt;/code&gt; if a Top-Rated seller is opted in to the eBay Plus program. With the eBay Plus program, qualified sellers must commit to next-day delivery of the item, and the buyers must have an eBay Plus subscription to be eligible to receive the benefits of this program, which are free, next-day delivery, as well as free returns.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; Currently, this program is only available on the Germany and Australian sites.&lt;/span&gt;&lt;br&gt;This field will be returned in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffers&lt;/a&gt; methods if set for the offer. | [optional]
**fulfillment_policy_id** | **string** | This unique identifier indicates the fulfillment business policy that will be used once an offer is published and converted to an eBay listing. This fulfillment business policy will set all fulfillment-related settings for the eBay listing.&lt;br&gt;&lt;br&gt;Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the fulfillment business policy before assigning it to the offer to make sure it is compatible with the inventory item and the offer settings. The seller may also want to review the shipping service costs in the fulfillment policy, and that seller might decide to override the shipping costs for one or more shipping service options by using the &lt;strong&gt;shippingCostOverrides&lt;/strong&gt; container.&lt;br&gt;&lt;br&gt;Business policies can be created and managed in My eBay or with the &lt;a href&#x3D;\&quot;/api-docs/sell/account/overview.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Account API&lt;/a&gt;. To get a list of all return policies associated with a seller&#39;s account on a specific eBay Marketplace, use the Account API&#39;s &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. There are also calls in the &lt;strong&gt;Account API&lt;/strong&gt; to retrieve a fulfillment policy by policy ID or policy name.&lt;br&gt;&lt;br&gt;This field will be returned in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffers&lt;/a&gt; methods if set for the offer. | [optional]
**payment_policy_id** | **string** | This unique identifier indicates the payment business policy that will be used once an offer is published and converted to an eBay listing. This payment business policy will set all payment-related settings for the eBay listing.&lt;br&gt;&lt;br&gt;Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the payment business policy to make sure that it is compatible with the marketplace and listing category before assigning it to the offer.&lt;br&gt;&lt;br&gt;Business policies can be created and managed in My eBay or with the &lt;a href&#x3D;\&quot;/api-docs/sell/account/overview.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Account API&lt;/a&gt;. To get a list of all payment policies associated with a seller&#39;s account on a specific eBay Marketplace, use the Account API&#39;s &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getPaymentPolicies&lt;/a&gt; method. There are also calls in the &lt;strong&gt;Account API&lt;/strong&gt; to retrieve a payment policy by policy ID or policy name.&lt;br&gt;&lt;br&gt;This field will be returned in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffers&lt;/a&gt; methods if set for the offer. | [optional]
**product_compliance_policy_ids** | **string[]** | This field contains the array of unique identifiers indicating the seller-created &lt;i&gt;global&lt;/i&gt; product compliance policies that will be used once an offer is published and converted to a listing.&lt;br&gt;&lt;br&gt;Product compliance policies provide buyers with important information and disclosures about products. For example, if you sell batteries and specific disclosures are required to be shared with all potential buyers, your global product compliance policy could contain the required disclosures.&lt;br&gt;&lt;br&gt;A maximum of six (6) global product compliance policies may apply to &lt;i&gt;each offer&lt;/i&gt;.&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; For countries that support country-specific policies, use &lt;a href&#x3D;\&quot;#request.listingPolicies.regionalProductCompliancePolicies\&quot;&gt;regionalProductCompliancePolicies&lt;/a&gt; to apply them to an offer.&lt;/span&gt; | [optional]
**regional_product_compliance_policies** | [**\Ebay\Inventory\Model\RegionalProductCompliancePolicies**](RegionalProductCompliancePolicies.md) |  | [optional]
**regional_take_back_policies** | [**\Ebay\Inventory\Model\RegionalTakeBackPolicies**](RegionalTakeBackPolicies.md) |  | [optional]
**return_policy_id** | **string** | This unique identifier indicates the return business policy that will be used once an offer is published and converted to an eBay listing. This return business policy will set all return policy settings for the eBay listing.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; As a part of Digital Services Act (DSA) requirements, as of April 3, 2023, buyers in the EU must be allowed to return an item within 14 days or more, unless the item is exempt. Where applicable, sellers should update their return policies to reflect this requirement of accepting returns from EU buyers.&lt;/span&gt;&lt;br&gt;Business policies are not immediately required for offers, but are required before an offer can be published. The seller should review the return business policy before assigning it to the offer to make sure it is compatible with the inventory item and the offer settings.&lt;br&gt;&lt;br&gt;Business policies can be created and managed in My eBay or with the &lt;a href&#x3D;\&quot;/developer.ebay.com/api-docs/sell/account/overview.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Account API&lt;/a&gt;. To get a list of all return policies associated with a seller&#39;s account on a specific eBay Marketplace, use the Account API&#39;s &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getReturnPolicies&lt;/a&gt; call. There are also calls in the &lt;strong&gt;Account API&lt;/strong&gt; to retrieve a return policy by policy ID or policy name.&lt;br&gt;&lt;br&gt;This field will be returned in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffers&lt;/a&gt; methods if set for the offer. | [optional]
**shipping_cost_overrides** | [**\Ebay\Inventory\Model\ShippingCostOverride[]**](ShippingCostOverride.md) | This container is used if the seller wishes to override the shipping costs or surcharge for one or more domestic or international shipping service options defined in the fulfillment listing policy. To override the costs of a specific domestic or international shipping service option, the seller must know the priority/order of that shipping service in the fulfillment listing policy. The name of a shipping service option can be found in the &lt;strong&gt;shippingOptions.shippingServices.shippingServiceCode&lt;/strong&gt; field of the fulfillment policy, and the priority/order of that shipping service option is found in the &lt;strong&gt;shippingOptions.shippingServices.sortOrderId&lt;/strong&gt; field. Both of these values can be retrieved by searching for that fulfillment policy with the &lt;strong&gt;getFulfillmentPolicies&lt;/strong&gt; or &lt;strong&gt;getFulfillmentPolicyByName&lt;/strong&gt; calls of the &lt;strong&gt;Account API&lt;/strong&gt;. The &lt;strong&gt;shippingCostOverrides.priority&lt;/strong&gt; value should match the &lt;strong&gt;shippingOptions.shippingServices.sortOrderId&lt;/strong&gt; in order to override the shipping costs for that shipping service option. The seller must also ensure that the &lt;strong&gt;shippingServiceType&lt;/strong&gt; value is set to &lt;code&gt;DOMESTIC&lt;/code&gt; to override a domestic shipping service option, or to &lt;code&gt;INTERNATIONAL&lt;/code&gt; to override an international shipping service option.&lt;br&gt;&lt;br&gt;A separate &lt;strong&gt;ShippingCostOverrides&lt;/strong&gt; node is needed for each shipping service option whose costs are being overridden. All defined fields of the &lt;strong&gt;shippingCostOverrides&lt;/strong&gt; container should be included, even if the shipping costs and surcharge values are not changing.&lt;br&gt;&lt;br&gt;The &lt;strong&gt;shippingCostOverrides&lt;/strong&gt; container is returned in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffer\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffer&lt;/a&gt; and &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/offer/methods/getOffers\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOffers&lt;/a&gt; calls if one or more shipping cost overrides are being applied to the fulfillment policy. | [optional]
**take_back_policy_id** | **string** | This unique identifier indicates the seller-created &lt;i&gt;global&lt;/i&gt; take-back policy that will be used once an offer is published and converted to a listing.&lt;br&gt;&lt;br&gt;One (1) global take-back policy may be specified &lt;i&gt;per offer&lt;/i&gt;.&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; For countries that support country-specific policies, use &lt;a href&#x3D;\&quot;#request.listingPolicies.regionalTakeBackPolicies\&quot;&gt;regionalTakeBackPolicies&lt;/a&gt; to apply them to an offer.&lt;/span&gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
