# # InventoryLocationResponse

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**location** | [**\Ebay\Inventory\Model\Location**](Location.md) |  | [optional]
**location_additional_information** | **string** | This text field provides additional information about an inventory location. This field is returned if it is set for the inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 256 | [optional]
**location_instructions** | **string** | This text field is used by the merchant to provide special pickup instructions for the store location. This field can help create a pleasant and easy pickup experience for In-Store Pickup and Click and Collect orders. If this field was not set up through a &lt;strong&gt;createInventoryLocation&lt;/strong&gt; or a &lt;strong&gt;updateInventoryLocation&lt;/strong&gt; call, eBay will use the default pickup instructions contained in the merchant&#39;s profile.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 1000 | [optional]
**location_types** | **string[]** | This container defines the function of the inventory location. Typically, an inventory location will serve as a store or a warehouse, but in some cases, an inventory location may be both.&lt;br&gt;&lt;br&gt;For In-Store Pickup inventory set &lt;b&gt;StoreTypeEnum&lt;/b&gt; to &lt;code&gt;STORE&lt;/code&gt;.&lt;br&gt;&lt;br&gt;The location type of an inventory location defaults to &lt;code&gt;WAREHOUSE&lt;/code&gt; if a location type is not specified when a merchant creates an inventory location. | [optional]
**location_web_url** | **string** | This text field shows the  Website address (URL) associated with the inventory location. This field is returned if defined for the inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 512 | [optional]
**merchant_location_key** | **string** | The unique identifier of the inventory location. This identifier is set up by the merchant when the inventory location is first created with the &lt;strong&gt;createInventoryLocation&lt;/strong&gt; call. Once this value is set for an inventory location, it cannot be modified.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 36 | [optional]
**merchant_location_status** | **string** | This field indicates whether the inventory location is enabled (inventory can be loaded to location) or disabled (inventory can not be loaded to location). The merchant can use the &lt;strong&gt;enableInventoryLocation&lt;/strong&gt; call to enable an inventory location in disabled status, or the &lt;strong&gt;disableInventoryLocation&lt;/strong&gt; call to disable an inventory location in enabled status. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/api:StatusEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**name** | **string** | The name of the inventory location. This name should be a human-friendly name as it will be displayed in In-Store Pickup and Click and Collect listings. For store inventory locations, this field is not required for the &lt;strong&gt;createInventoryLocation&lt;/strong&gt; call, but a store inventory location must have a defined &lt;strong&gt;name&lt;/strong&gt; value before an In-Store Pickup and Click and Collect enabled offer is published. So, if the seller omits this field in the &lt;strong&gt;createInventoryLocation&lt;/strong&gt; call, it will have to be added later through a &lt;strong&gt;updateInventoryLocation&lt;/strong&gt; call.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 1000 | [optional]
**operating_hours** | [**\Ebay\Inventory\Model\OperatingHours[]**](OperatingHours.md) | This container shows the regular operating hours for a store location during the days of the week. A &lt;strong&gt;dayOfWeekEnum&lt;/strong&gt; field and an &lt;strong&gt;intervals&lt;/strong&gt; container is shown for each day of the week that the store location is open. | [optional]
**phone** | **string** | The phone number for an inventory location. This field will typically only be set and returned for store locations.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 36 | [optional]
**special_hours** | [**\Ebay\Inventory\Model\SpecialHours[]**](SpecialHours.md) | This container shows the special operating hours for a store location on a specific date or dates. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
