# # InventoryItemWithSkuLocaleGroupid

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**availability** | [**\Ebay\Inventory\Model\AvailabilityWithAll**](AvailabilityWithAll.md) |  | [optional]
**condition** | **string** | This enumeration value indicates the condition of the item. Supported item condition values will vary by eBay site and category. &lt;br&gt;&lt;br&gt; Since the condition of an inventory item must be specified before being published in an offer, this field is always returned in the &#39;Get&#39; calls for SKUs that are part of a published offer. If a SKU is not part of a published offer, this field will only be returned if set for the inventory item.&lt;br&gt;&lt;br&gt; &lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; The &#39;Manufacturer Refurbished&#39; item condition is no longer a valid item condition on any eBay marketplace, and to reflect this change, the &lt;code&gt;MANUFACTURER_REFURBISHED&lt;/code&gt; value has essentially been replaced with the &lt;code&gt;CERTIFIED_REFURBISHED&lt;/code&gt; enumeration value with Version 1.13.0. For any existing inventory items that have &lt;code&gt;MANUFACTURER_REFURBISHED&lt;/code&gt; set as their &lt;strong&gt;condition&lt;/strong&gt; value, eBay will automatically convert the condition of these inventory items to &lt;code&gt;CERTIFIED_REFURBISHED&lt;/code&gt;, so it is not necessary for the developer to update these inventory items with a &#39;create or replace&#39; call. &lt;br&gt;&lt;br&gt;  To list an item as &#39;Certified Refurbished&#39;, a seller must be pre-qualified by eBay for this feature. Any seller who is not eligible for this feature will be blocked if they try to create a new listing or revise an existing listing with this item condition. &lt;br&gt;&lt;br&gt; Any seller that is interested in eligibility requirements to list with &#39;Certified Refurbished&#39; should see the &lt;a href&#x3D;\&quot;https://pages.ebay.com/seller-center/listing-and-marketing/certified-refurbished-program.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Certified refurbished program&lt;/a&gt; page in Seller Center. &lt;/span&gt;&lt;div class&#x3D;\&quot;msgbox_important\&quot;&gt;&lt;p class&#x3D;\&quot;msgbox_importantInDiv\&quot; data-mc-autonum&#x3D;\&quot;&amp;lt;b&amp;gt;&amp;lt;span style&#x3D;&amp;quot;color: #dd1e31;&amp;quot; class&#x3D;&amp;quot;mcFormatColor&amp;quot;&amp;gt;Important! &amp;lt;/span&amp;gt;&amp;lt;/b&amp;gt;\&quot;&gt;&lt;span class&#x3D;\&quot;autonumber\&quot;&gt;&lt;span&gt;&lt;b&gt;&lt;span style&#x3D;\&quot;color: #dd1e31;\&quot; class&#x3D;\&quot;mcFormatColor\&quot;&gt;Important!&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;For trading card listings in Non-Sport Trading Card Singles (183050), CCG Individual Cards (183454), and Sports Trading Card Singles (261328) categories, LIKE_NEW (2750) can be used to specify the card as a Graded card and USED_VERY_GOOD (4000) can be used to specify the card as an Ungraded card. If either of these item conditions are used for the affected categories, the seller is then required to use the conditionDescriptors array to provide one or more applicable Condition Descriptor name-value pairs. See the conditionDescriptors field description for more information.&lt;/p&gt;&lt;p&gt;Beginning October 23, 2023, trading card listings in the affected categories must use either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition, and no other item conditions will be accepted. These item conditions and the  conditionDescriptors array will be required for all new listings. If not provided after this date, the publishOffer, bulkPublishOffer, and publishOfferByInventoryItemGroup methods will fail when trying to create new listings.&lt;/p&gt;&lt;p&gt;By January 22 2024, all existing listings must be modified with either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition and applicable conditionDescriptors name-value pairs. The updateOffer method will fail if the inventory item object does not have one of these two item conditions along with applicable conditionDescriptors name-value pairs.&lt;/p&gt;&lt;/span&gt;&lt;/div&gt; For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:ConditionEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**condition_description** | **string** | This string field is used by the seller to more clearly describe the condition of used items, or items that are not &#39;Brand New&#39;, &#39;New with tags&#39;, or &#39;New in box&#39;. The ConditionDescription field is available for all categories. If the ConditionDescription field is used with an item in a new condition (Condition IDs 1000-1499), eBay will simply ignore this field if included, and eBay will return a warning message to the user. This field should only be used to further clarify the condition of the used item. It should not be used for branding, promotions, shipping, returns, payment or other information unrelated to the condition of the item. Make sure that the condition value, condition description, listing description, and the item&#39;s pictures do not contradict one another.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max length&lt;/strong&gt;/: 1000. | [optional]
**condition_descriptors** | [**\Ebay\Inventory\Model\ConditionDescriptor[]**](ConditionDescriptor.md) | &lt;div class&#x3D;\&quot;msgbox_important\&quot;&gt;&lt;p class&#x3D;\&quot;msgbox_importantInDiv\&quot; data-mc-autonum&#x3D;\&quot;&amp;lt;b&amp;gt;&amp;lt;span style&#x3D;&amp;quot;color: #dd1e31;&amp;quot; class&#x3D;&amp;quot;mcFormatColor&amp;quot;&amp;gt;Important! &amp;lt;/span&amp;gt;&amp;lt;/b&amp;gt;\&quot;&gt;&lt;span class&#x3D;\&quot;autonumber\&quot;&gt;&lt;span&gt;&lt;b&gt;&lt;span style&#x3D;\&quot;color: #dd1e31;\&quot; class&#x3D;\&quot;mcFormatColor\&quot;&gt;Important!&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;For trading card listings in Non-Sport Trading Card Singles (183050), CCG Individual Cards (183454), and Sports Trading Card Singles (261328) categories, LIKE_NEW (2750) can be used to specify the card as a Graded card and USED_VERY_GOOD (4000) can be used to specify the card as an Ungraded card. If either of these item conditions are used for the affected categories, the seller is then required to use the conditionDescriptors array to provide one or more applicable Condition Descriptor name-value pairs.&lt;/p&gt;&lt;p&gt;Beginning October 23, 2023, trading card listings in the affected categories must use either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition, and no other item conditions will be accepted. These item conditions and the  conditionDescriptors array will be required for all new listings. If not provided after this date, the publishOffer, bulkPublishOffer, and publishOfferByInventoryItemGroup methods will fail when trying to create new listings.&lt;/p&gt;&lt;p&gt;By January 22 2024, all existing listings must be modified with either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition and applicable conditionDescriptors name-value pairs. The updateOffer method will fail if the inventory item object does not have one of these two item conditions along with applicable conditionDescriptors name-value pairs.&lt;/p&gt;&lt;/span&gt;&lt;/div&gt;&lt;br&gt;&lt;br&gt;This container is used by the seller to provide additional information about the condition of an item in a structured format. Descriptors are name-value attributes that can be either closed set or open text. &lt;br&gt;&lt;br&gt; For more information on the numeric IDs and their text equivalents, use the &lt;a href&#x3D;\&quot;/api-docs/sell/metadata/resources/marketplace/methods/getItemConditionPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getItemConditionPolicies&lt;/a&gt; method of the Metadata API. &lt;br&gt;&lt;br&gt; | [optional]
**group_ids** | **string[]** | This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item group(s). This array is not returned if the inventory item is not associated with any inventory item groups. | [optional]
**inventory_item_group_keys** | **string[]** | This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item&#39;s variation in a multiple-variation listing. This array is not returned if the inventory item is not associated with any inventory item groups. | [optional]
**locale** | **string** | This field returns the natural language that was provided in the field values of the request payload (i.e., en_AU, en_GB or de_DE). For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:LocaleEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**package_weight_and_size** | [**\Ebay\Inventory\Model\PackageWeightAndSize**](PackageWeightAndSize.md) |  | [optional]
**product** | [**\Ebay\Inventory\Model\Product**](Product.md) |  | [optional]
**sku** | **string** | The seller-defined Stock-Keeping Unit (SKU) of the inventory item. The seller should have a unique SKU value for every product that they sell. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
