# # InventoryItemGroup

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**aspects** | **string** | This is a collection of item specifics (aka product aspects) name-value pairs that are shared by all product variations within the inventory item group. Common aspects for the inventory item group are not immediately required upon creating an inventory item group, but these aspects will be required before the first offer of the group is published. Common aspects for a men&#39;s t-shirt might be pattern and sleeve length. Below is an example of the proper JSON syntax to use when manually inputting item specifics. Note that one item specific name, such as &#39;Features&#39;, can have more than one value. If an item specific name has more than one value, each value is delimited with a comma.&lt;br&gt; &lt;pre&gt;&lt;code&gt;\&quot;aspects\&quot;: {&lt;br&gt; \&quot;pattern\&quot;: [\&quot;solid\&quot;],&lt;br&gt; \&quot;sleeves\&quot;: [\&quot;short\&quot;]&lt;br&gt; }&lt;/code&gt;&lt;/pre&gt;This container is always returned if one or more offers associated with the inventory item group have been published, and is only returned if set for an inventory item group if that group has yet to have any offers published.&lt;br&gt; | [optional]
**description** | **string** | The description of the inventory item group. This description should fully describe the product and the variations of the product that are available in the inventory item group, since this description will ultimately become the listing description once the first offer of the group is published. This field is not initially required when first creating an inventory item group, but will be required before the first offer of the group is published. &lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; Since this description will ultimately  become the listing description in a multiple-variation listing, the seller should omit the &lt;strong&gt;listingDescription&lt;/strong&gt; field when creating the offers for each variation. If they include the &lt;strong&gt;listingDescription&lt;/strong&gt; field for the individual offer(s) in an item group, the text in that field for a published offer will overwrite the text provided in this &lt;strong&gt;description&lt;/strong&gt; field for the inventory item group.&lt;/span&gt;&lt;br&gt;&lt;br&gt;HTML tags and markup can be used in this field, but each character counts toward the max length limit.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; To ensure that their short listing description is optimized when viewed on mobile devices, sellers should strongly consider using eBay&#39;s &lt;a href&#x3D;\&quot;https://pages.ebay.com/sell/itemdescription/customizeyoursummary.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;View Item description summary feature&lt;/a&gt; when listing their items. Keep in mind that the &#39;short&#39; listing description is what prospective buyers first see when they view the listing on a mobile device. The &#39;full&#39; listing description is also available to mobile users when they click on the short listing description, but the full description is not automatically optimized for viewing in mobile devices, and many users won&#39;t even drill down to the full description.&lt;br&gt;&lt;br&gt; Using HTML div and span tag attributes, this feature allows sellers to customize and fully control the short listing description that is displayed to prospective buyers when viewing the listing on a mobile device. The short listing description on mobile devices is limited to 800 characters, and whenever the full listing description (provided in this field, in UI, or seller tool) exceeds this limit, eBay uses a special algorithm to derive the best possible short listing description within the 800-character limit. However, due to some short listing description content being removed, it is definitely not ideal for the seller, and could lead to a bad buyer experience and possibly to a Significantly not as described (SNAD) case, since the buyer may not get complete details on the item when viewing the short listing description. See the eBay help page for more details on using the HTML div and span tags.&lt;/span&gt;&lt;br&gt;&lt;br&gt;This field is always returned if one or more offers associated with the inventory item group have been published, and is only returned if set for an inventory item group if that group has yet to have any offers published.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 500000 (which includes HTML markup/tags)&lt;br&gt; | [optional]
**image_urls** | **string[]** | An array of one or more links to images for the inventory item group. URLs must use the \&quot;HTTPS\&quot; protocol. Images can be self-hosted by the seller, or sellers can use the &lt;a href&#x3D;\&quot;/Devzone/XML/docs/Reference/eBay/UploadSiteHostedPictures.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;UploadSiteHostedPictures&lt;/a&gt; call of the Trading API to upload images to an eBay Picture Server. If successful, the response of the &lt;a href&#x3D;\&quot;/Devzone/XML/docs/Reference/eBay/UploadSiteHostedPictures.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;UploadSiteHostedPictures&lt;/a&gt; call will contain a full URL to the image on an eBay Picture Server. This is the URL that will be passed in through the &lt;strong&gt;imageUrls&lt;/strong&gt; array. &lt;br&gt;&lt;br&gt; Before any offer can be published, at least one image must exist for the offer. Links to images can either be passed in through this &lt;strong&gt;imageUrls&lt;/strong&gt; container, or they can be passed in through the &lt;strong&gt;product.imageUrls&lt;/strong&gt; container when creating each inventory item in the group. If the &lt;strong&gt;variesBy.aspectsImageVariesBy&lt;/strong&gt; field is used to specify the main product aspect where the variations vary, the links to the images must be passed in through this &lt;strong&gt;imageUrls&lt;/strong&gt; container, and there should be a picture for each variation. So, if the &lt;strong&gt;variesBy.aspectsImageVariesBy&lt;/strong&gt; field is set to &lt;code&gt;Color&lt;/code&gt;, a link should be included to an image demonstrating each available color in the group.&lt;br&gt;&lt;br&gt;In almost any category at no cost, sellers can include up to 24 pictures in one listing. For inventory items that are a part of an inventory item group/multiple-variation listings, a maximum of 12 pictures may be used per inventory item in the group. Motor vehicle listings are an exception. The number of included pictures in motor vehicle listings depend on the selected vehicle package (see &lt;a href&#x3D;\&quot;https://www.ebay.com/help/selling/fees-credits-invoices/motors-fees?id&#x3D;4127 \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Fees for selling vehicles on eBay Motors&lt;/a&gt;).&lt;br&gt;&lt;br&gt; This container will always be returned for an inventory item group that has at least one published offer since a published offer will always have at least one picture, but this container will only be returned if defined for inventory item groups that have yet to have any published offers. | [optional]
**inventory_item_group_key** | **string** | This is the unique identifier of the inventory item group. This identifier is created by the seller when an inventory item group is created. &lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; This field is only applicable to the &lt;strong&gt;getInventoryItemGroup&lt;/strong&gt; call and not to the &lt;strong&gt;createOrReplaceInventoryItemGroup&lt;/strong&gt; call. In the &lt;strong&gt;createOrReplaceInventoryItemGroup&lt;/strong&gt; call, the &lt;strong&gt;inventoryItemGroupKey&lt;/strong&gt; value is passed into the end of the call URI instead. &lt;/span&gt; | [optional]
**subtitle** | **string** | A subtitle is an optional listing feature that allows the seller to provide more information about the product, possibly including keywords that may assist with search results. An additional listing fee will be charged to the seller if a subtitle is used. For more information on using listing subtitles on the US site, see the &lt;a href&#x3D;\&quot;https://pages.ebay.com/help/sell/itemsubtitle.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Adding a subtitle to your listings&lt;/a&gt; help page. &lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; Since this subtitle will ultimately  become the subtitle in a multiple-variation listing, the seller should not include the &lt;strong&gt;subtitle&lt;/strong&gt; field when creating the inventory items that are members of the group. If they do include the &lt;strong&gt;subtitle&lt;/strong&gt; field in an inventory item record, the text in that field will overwrite the text provided in this &lt;strong&gt;subtitle&lt;/strong&gt; field for each inventory item in the group that is published.&lt;/span&gt;&lt;br&gt;&lt;br&gt;This field will only be returned if set for an inventory item.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 55&lt;br&gt; | [optional]
**title** | **string** | The title of the inventory item group. This title will ultimately become the listing title once the first offer of the group is published. This field is not initially required when first creating an inventory item group, but will be required before the first offer of the group is published.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; Since this title will ultimately  become the listing title in a multiple-variation listing, the seller should omit the &lt;strong&gt;title&lt;/strong&gt; field when creating the inventory items that are members of the group. If they do include the &lt;strong&gt;title&lt;/strong&gt; field in an inventory item record, the text in that field will overwrite the text provided in this &lt;strong&gt;title&lt;/strong&gt; field for each inventory item in the group that is published.&lt;/span&gt;&lt;br&gt;&lt;br&gt; This field is always returned if one or more offers associated with the inventory item group have been published, and is only returned if set for an inventory item group if that group has yet to have any offers published.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 80 &lt;br&gt; | [optional]
**variant_skus** | **string[]** | This required container is used to assign individual inventory items to the inventory item group. Multiple SKU values are passed in to this container. If updating an existing inventory item group, the seller should make sure that all member SKU values are passed in, as long as the seller wants that SKU to remain in the group.&lt;br&gt;&lt;br&gt; It is also possible to add or remove SKUs with a &lt;strong&gt;createOrReplaceInventoryItemGroup&lt;/strong&gt; call. If the seller wants to remove a SKU from the group, that seller will just omit that SKU value from this container to remove that inventory item/SKU from the inventory item group and any published, multiple-variation listing. However, a variation cannot be removed from the group if that variation has one or more sales for that listing. A workaround for this is to set that variation&#39;s quantity to &lt;code&gt;0&lt;/code&gt; and it will be &#39;grayed out&#39; in the View Item page.&lt;br&gt;&lt;br&gt;This container is always returned. | [optional]
**varies_by** | [**\Ebay\Inventory\Model\VariesBy**](VariesBy.md) |  | [optional]
**video_ids** | **string[]** | An array of one or more &lt;b&gt;videoId&lt;/b&gt; values for the inventory item group. A video ID is a unique identifier that is automatically created by eBay when a seller successfully uploads a video to eBay using the  &lt;a href&#x3D;\&quot;/api-docs/commerce/media/resources/video/methods/uploadVideo \&quot; target&#x3D;\&quot;_blank\&quot;&gt;uploadVideo&lt;/a&gt; method of the &lt;a href&#x3D;\&quot;/api-docs/commerce/media/overview.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Media API&lt;/a&gt;.&lt;br&gt;&lt;br&gt;For information on supported marketplaces and platforms, as well as other requirements and limitations of video support, please refer to &lt;a href&#x3D;\&quot;/api-docs/sell/static/inventory/managing-video-media.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Managing videos&lt;/a&gt;.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; Only one video per listing is supported.&lt;/span&gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
