# # InventoryItem

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**availability** | [**\Ebay\Inventory\Model\Availability**](Availability.md) |  | [optional]
**condition** | **string** | This enumeration value indicates the condition of the item. Supported item condition values will vary by eBay site and category. To see which item condition values that a particular eBay category supports, use the &lt;a href&#x3D;\&quot;/api-docs/sell/metadata/resources/marketplace/methods/getItemConditionPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getItemConditionPolicies&lt;/a&gt; method of the &lt;strong&gt;Metadata API&lt;/strong&gt;. This method returns condition ID values that map to the enumeration values defined in the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/types/slr:ConditionEnum\&quot; target&#x3D;\&quot;_blank\&quot;&gt;ConditionEnum&lt;/a&gt; type. The &lt;a href&#x3D;\&quot;/api-docs/sell/static/metadata/condition-id-values.html\&quot; target&#x3D;\&quot;_blank\&quot;&gt;Item condition ID and name values&lt;/a&gt; topic in the &lt;strong&gt;Selling Integration Guide&lt;/strong&gt; has a table that maps condition ID values to &lt;strong&gt;ConditionEnum&lt;/strong&gt; values. The &lt;strong&gt;getItemConditionPolicies&lt;/strong&gt; call reference page has more information.&lt;br&gt;&lt;br&gt; A &lt;strong&gt;condition&lt;/strong&gt; value is optional up until the seller is ready to publish an offer with the SKU, at which time it becomes required for most eBay categories.&lt;br&gt;&lt;br&gt; &lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; The &#39;Manufacturer Refurbished&#39; item condition is no longer a valid item condition on any eBay marketplace, and to reflect this change, the &lt;code&gt;MANUFACTURER_REFURBISHED&lt;/code&gt; value is no longer applicable, and should not be used. With Version 1.13.0, the &lt;code&gt;CERTIFIED_REFURBISHED&lt;/code&gt; enumeration value has been introduced, and CR-eligible sellers should make a note to start using &lt;code&gt;CERTIFIED_REFURBISHED&lt;/code&gt; from this point forward. For the time being, if the &lt;code&gt;MANUFACTURER_REFURBISHED&lt;/code&gt; enum is used in a &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt; method, it will be accepted but automatically converted by eBay to &lt;code&gt;CERTIFIED_REFURBISHED&lt;/code&gt;. In the future, the &lt;code&gt;MANUFACTURER_REFURBISHED&lt;/code&gt; may start triggering an error if used.&lt;br&gt;&lt;br&gt;As of September 1, 2021, condition ID &lt;code&gt;2500&lt;/code&gt; (&#39;Seller Refurbished&#39;) can no longer be used in the Cell Phones &amp; Smartphones category (category ID &lt;code&gt;9355&lt;/code&gt;) for the following marketplaces: US, Canada, UK, Germany, and Australia. The &#39;Seller Refurbished&#39; item condition will be replaced by one of three new refurbished values:&lt;ul&gt;&lt;li&gt;condition ID &lt;code&gt;2010&lt;/code&gt; (&#39;Excellent - Refurbished&#39;)&lt;/li&gt;&lt;li&gt;condition ID &lt;code&gt;2020&lt;/code&gt; (&#39;Very Good - Refurbished&#39;)&lt;/li&gt;&lt;li&gt;condition ID &lt;code&gt;2030&lt;/code&gt; (&#39;Good - Refurbished&#39;)&lt;/li&gt;&lt;/ul&gt; To use any of these new refurbished item conditions in category &lt;code&gt;9355&lt;/code&gt;, sellers must go through an application and qualification process. Any seller who is not eligible to use these new refurbished item conditions in category &lt;code&gt;9355&lt;/code&gt; will be blocked if they try to create a new listing or revise an existing listing with any of these three new item conditions. Any active listings in category &lt;code&gt;9355&lt;/code&gt; that had condition ID &lt;code&gt;2500&lt;/code&gt; (&#39;Seller Refurbished&#39;) as the item condition should have been administratively ended by eBay. Sellers will have to relist these items, and until they are eligible to list with the new refurbished item conditions, they will need to use another item condition supported in category &lt;code&gt;9355&lt;/code&gt;, such as condition ID &lt;code&gt;3000&lt;/code&gt; (&#39;Used&#39;).&lt;br&gt;&lt;br&gt;To list an item as &#39;Certified Refurbished&#39;, a seller must be pre-qualified by eBay for this feature. Any seller who is not eligible for this feature will be blocked if they try to create a new listing or revise an existing listing with this item condition. &lt;br&gt;&lt;br&gt; Any seller that is interested in eligibility requirements to list with &#39;Certified Refurbished&#39; should see the &lt;a href&#x3D;\&quot;https://pages.ebay.com/seller-center/listing-and-marketing/certified-refurbished-program.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;Certified refurbished program&lt;/a&gt; page in Seller Center. &lt;/span&gt;&lt;div class&#x3D;\&quot;msgbox_important\&quot;&gt;&lt;p class&#x3D;\&quot;msgbox_importantInDiv\&quot; data-mc-autonum&#x3D;\&quot;&amp;lt;b&amp;gt;&amp;lt;span style&#x3D;&amp;quot;color: #dd1e31;&amp;quot; class&#x3D;&amp;quot;mcFormatColor&amp;quot;&amp;gt;Important! &amp;lt;/span&amp;gt;&amp;lt;/b&amp;gt;\&quot;&gt;&lt;span class&#x3D;\&quot;autonumber\&quot;&gt;&lt;span&gt;&lt;b&gt;&lt;span style&#x3D;\&quot;color: #dd1e31;\&quot; class&#x3D;\&quot;mcFormatColor\&quot;&gt;Important!&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;For trading card listings in Non-Sport Trading Card Singles (183050), CCG Individual Cards (183454), and Sports Trading Card Singles (261328) categories, LIKE_NEW (2750) can be used to specify the card as a Graded card and USED_VERY_GOOD (4000) can be used to specify the card as an Ungraded card. If either of these item conditions are used for the affected categories, the seller is then required to use the conditionDescriptors array to provide one or more applicable Condition Descriptor name-value pairs. See the conditionDescriptors field description for more information.&lt;/p&gt;&lt;p&gt;Beginning October 23, 2023, trading card listings in the affected categories must use either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition, and no other item conditions will be accepted. These item conditions and the  conditionDescriptors array will be required for all new listings. If not provided after this date, the publishOffer, bulkPublishOffer, and publishOfferByInventoryItemGroup methods will fail when trying to create new listings.&lt;/p&gt;&lt;p&gt;By January 22 2024, all existing listings must be modified with either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition and applicable conditionDescriptors name-value pairs. The updateOffer method will fail if the inventory item object does not have one of these two item conditions along with applicable conditionDescriptors name-value pairs.&lt;/p&gt;&lt;/span&gt;&lt;/div&gt; For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:ConditionEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**condition_description** | **string** | This string field is used by the seller to more clearly describe the condition of a used inventory item, or an inventory item whose &lt;strong&gt;condition&lt;/strong&gt; value is not &lt;code&gt;NEW&lt;/code&gt;, &lt;code&gt;LIKE_NEW&lt;/code&gt;, &lt;code&gt;NEW_OTHER&lt;/code&gt;, or &lt;code&gt;NEW_WITH_DEFECTS&lt;/code&gt;.&lt;br&gt;&lt;br&gt; The &lt;strong&gt;conditionDescription&lt;/strong&gt; field is available for all eBay categories. If the &lt;strong&gt;conditionDescription&lt;/strong&gt; field is used with an item in one of the new conditions (mentioned in previous paragraph), eBay will simply ignore this field if included, and eBay will return a warning message to the user. &lt;br&gt;&lt;br&gt; This field should only be used to further clarify the condition of the used item. It should not be used for branding, promotions, shipping, returns, payment or other information unrelated to the condition of the used item. Make sure that the &lt;strong&gt;condition&lt;/strong&gt; value, condition description, listing description, and the item&#39;s pictures do not contradict one another. &lt;br&gt;&lt;br&gt; This field is not always required, but is required if an inventory item is being updated and a condition description already exists for that inventory item. &lt;br&gt;&lt;br&gt; This field is returned in the &lt;strong&gt;getInventoryItem&lt;/strong&gt; and &lt;strong&gt;getInventoryItems&lt;/strong&gt; calls if a condition description was provided for a used inventory item.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 1000. | [optional]
**condition_descriptors** | [**\Ebay\Inventory\Model\ConditionDescriptor[]**](ConditionDescriptor.md) | &lt;div class&#x3D;\&quot;msgbox_important\&quot;&gt;&lt;p class&#x3D;\&quot;msgbox_importantInDiv\&quot; data-mc-autonum&#x3D;\&quot;&amp;lt;b&amp;gt;&amp;lt;span style&#x3D;&amp;quot;color: #dd1e31;&amp;quot; class&#x3D;&amp;quot;mcFormatColor&amp;quot;&amp;gt;Important! &amp;lt;/span&amp;gt;&amp;lt;/b&amp;gt;\&quot;&gt;&lt;span class&#x3D;\&quot;autonumber\&quot;&gt;&lt;span&gt;&lt;b&gt;&lt;span style&#x3D;\&quot;color: #dd1e31;\&quot; class&#x3D;\&quot;mcFormatColor\&quot;&gt;Important!&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;For trading card listings in Non-Sport Trading Card Singles (183050), CCG Individual Cards (183454), and Sports Trading Card Singles (261328) categories, LIKE_NEW (2750) can be used to specify the card as a Graded card and USED_VERY_GOOD (4000) can be used to specify the card as an Ungraded card. If either of these item conditions are used for the affected categories, the seller is then required to use the conditionDescriptors array to provide one or more applicable Condition Descriptor name-value pairs.&lt;/p&gt;&lt;p&gt;Beginning October 23, 2023, trading card listings in the affected categories must use either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition, and no other item conditions will be accepted. These item conditions and the  conditionDescriptors array will be required for all new listings. If not provided after this date, the publishOffer, bulkPublishOffer, and publishOfferByInventoryItemGroup methods will fail when trying to create new listings.&lt;/p&gt;&lt;p&gt;By January 22 2024, all existing listings must be modified with either LIKE_NEW (2750) or USED_VERY_GOOD (4000) item condition and applicable conditionDescriptors name-value pairs. The updateOffer method will fail if the inventory item object does not have one of these two item conditions along with applicable conditionDescriptors name-value pairs.&lt;/p&gt;&lt;/span&gt;&lt;/div&gt;&lt;br&gt;&lt;br&gt;This container is used by the seller to provide additional information about the condition of an item in a structured format. Condition descriptors are name-value attributes that can be either close set or open text inputs.&lt;br&gt;&lt;br&gt; To retrieve all condition descriptor numeric IDs for a category, use the &lt;a href&#x3D;\&quot;/api-docs/sell/metadata/resources/marketplace/methods/getItemConditionPolicies\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getItemConditionPolicies&lt;/a&gt; method of the Metadata API. &lt;br&gt;&lt;br&gt; | [optional]
**package_weight_and_size** | [**\Ebay\Inventory\Model\PackageWeightAndSize**](PackageWeightAndSize.md) |  | [optional]
**product** | [**\Ebay\Inventory\Model\Product**](Product.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
