# # EbayOfferDetailsWithId

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**available_quantity** | **int** | This integer value sets the quantity of the inventory item that will be available through the offer. Quantity must be set to &lt;code&gt;1&lt;/code&gt; or more in order for the inventory item to be purchasable. This value should not be more than the quantity that is specified for the inventory item record. For auction listings, this value must be &lt;code&gt;1&lt;/code&gt;. &lt;br&gt;&lt;br&gt;If this field exists for the current unpublished or published offer, it should be provided again in the &lt;strong&gt;updateOffer&lt;/strong&gt; call, even if the value is not changing. If this particular field is omitted in an &lt;strong&gt;updateOffer&lt;/strong&gt; call, the general available quantity set for the inventory item record may be used instead, and this may not be accurate if the inventory item is being sold across multiple marketplaces. | [optional]
**category_id** | **string** | The unique identifier of the eBay category that the inventory item is/will be listed under. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Sellers can use the &lt;a href&#x3D;\&quot;/api-docs/commerce/taxonomy/resources/category_tree/methods/getCategorySuggestions \&quot; target&#x3D;\&quot;_blank\&quot;&gt;getCategorySuggestions&lt;/a&gt; method of the Taxonomy API to retrieve suggested category ID values. The seller passes in a query string like \&quot;&lt;em&gt;iPhone 6&lt;/em&gt;\&quot;, and category ID values for suggested categories are returned in the response.&lt;br&gt;&lt;br&gt;If this field exists for the current unpublished offer, it should be provided again in the &lt;strong&gt;updateOffer&lt;/strong&gt; call, even if the eBay category is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur. The eBay category of an active eBay listing cannot be changed once the listing has one or more sales, or if the listing is scheduled to end in less than 12 hours. | [optional]
**charity** | [**\Ebay\Inventory\Model\Charity**](Charity.md) |  | [optional]
**extended_producer_responsibility** | [**\Ebay\Inventory\Model\ExtendedProducerResponsibility**](ExtendedProducerResponsibility.md) |  | [optional]
**hide_buyer_details** | **bool** | This field is included and set to &lt;code&gt;true&lt;/code&gt; if the seller wishes to update a published or unpublished offer with the private listing feature. Alternatively, the seller could also remove the private listing feature (if already set for a published or unpublished offer) by including this field and setting it to &lt;code&gt;false&lt;/code&gt;. &lt;br&gt;&lt;br&gt; Sellers may want to use this option when they believe that a listing&#39;s potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users. | [optional]
**include_catalog_product_details** | **bool** | This field indicates whether or not eBay product catalog details are applied to a listing. A value of &lt;code&gt;true&lt;/code&gt; indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt;.&lt;p&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;strong&gt;Note:&lt;/strong&gt; Though the &lt;strong&gt;includeCatalogProductDetails&lt;/strong&gt; parameter is not required to be submitted in the request, the parameter defaults to &#39;true&#39; if omitted.&lt;/span&gt;&lt;/p&gt; | [optional]
**listing_description** | **string** | The text in this field is (published offers), or will become (unpublished offers) the description of the eBay listing. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Note that if the &lt;strong&gt;listingDescription&lt;/strong&gt; field was omitted in the &lt;strong&gt;createOffer&lt;/strong&gt; call for the offer, the offer entity should have picked up the text provided in the &lt;strong&gt;product.description&lt;/strong&gt; field of the inventory item record, or if the inventory item is part of a group, the offer entity should have picked up the text provided in the &lt;strong&gt;description&lt;/strong&gt; field of the inventory item group record.&lt;br&gt;&lt;br&gt;HTML tags and markup can be used in listing descriptions, but each character counts toward the max length limit.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; To ensure that their short listing description is optimized when viewed on mobile devices, sellers should strongly consider using eBay&#39;s &lt;a href&#x3D;\&quot;https://pages.ebay.com/sell/itemdescription/customizeyoursummary.html \&quot; target&#x3D;\&quot;_blank\&quot;&gt;View Item description summary feature&lt;/a&gt; when listing their items. Keep in mind that the &#39;short&#39; listing description is what prospective buyers first see when they view the listing on a mobile device. The &#39;full&#39; listing description is also available to mobile users when they click on the short listing description, but the full description is not automatically optimized for viewing in mobile devices, and many users won&#39;t even drill down to the full description.&lt;br&gt;&lt;br&gt; Using HTML div and span tag attributes, this feature allows sellers to customize and fully control the short listing description that is displayed to prospective buyers when viewing the listing on a mobile device. The short listing description on mobile devices is limited to 800 characters, and whenever the full listing description (provided in this field, in UI, or seller tool) exceeds this limit, eBay uses a special algorithm to derive the best possible short listing description within the 800-character limit. However, due to some short listing description content being removed, it is definitely not ideal for the seller, and could lead to a bad buyer experience and possibly to a Significantly not as described (SNAD) case, since the buyer may not get complete details on the item when viewing the short listing description. See the eBay help page for more details on using the HTML div and span tags.&lt;/span&gt;&lt;br&gt;&lt;br&gt;If this field exists for the current unpublished offer, it should be provided again in the &lt;strong&gt;updateOffer&lt;/strong&gt; call, even if the text is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max length&lt;/strong&gt;: 500000 (which includes HTML markup/tags) | [optional]
**listing_duration** | **string** | This field indicates the number of days that the listing will be active. For fixed-price listings, this value must be set to &lt;code&gt;GTC&lt;/code&gt;, but auction listings support different listing durations.&lt;br&gt;&lt;br&gt; The GTC (Good &#39;Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; If the listing duration expires for an auction offer without a winning bidder, the listing then becomes available as a fixed-price offer and listing duration will be &lt;code&gt;GTC&lt;/code&gt;.&lt;/span&gt; For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**listing_policies** | [**\Ebay\Inventory\Model\ListingPolicies**](ListingPolicies.md) |  | [optional]
**listing_start_date** | **string** | This field can be used with an unpublished offer if the seller wants to specify a time in the future that the listing will become active on eBay. The timestamp supplied in this field should be in UTC format, and it should be far enough in the future so that the seller will have enough time to publish the listing with the &lt;strong&gt;publishOffer&lt;/strong&gt; method.&lt;br&gt;&lt;br&gt; For example: 2023-05-30T19:08:00Z.&lt;br&gt;&lt;br&gt; This field is optional, and it doesn&#39;t apply to offers where the corresponding listing is already active. If this field is not provided, the listing starts immediately after a successful &lt;strong&gt;publishOffer&lt;/strong&gt; method. | [optional]
**lot_size** | **int** | This field is only applicable if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same item, such as four identical tires being sold as a single offer, or it can be a mixed lot of similar items, such as used clothing items or an assortment of baseball cards. Whether the lot listing involved identical items or a mixed lot, the integer value passed into this field is the total number of items in the lot. Lots can be used for auction and fixed-price listings. | [optional]
**merchant_location_key** | **string** | The unique identifier of a merchant&#39;s inventory location (where the inventory item in the offer is located).&lt;br&gt;&lt;br&gt; To get more information about inventory locations, the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/location/methods/getInventoryLocations\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getInventoryLocations&lt;/a&gt; method can be used.br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; This field is not initially required upon first creating an offer, but will become required before an offer can be published.&lt;/span&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 36 | [optional]
**pricing_summary** | [**\Ebay\Inventory\Model\PricingSummary**](PricingSummary.md) |  | [optional]
**quantity_limit_per_buyer** | **int** | This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceeding the quantity specified for this field. So, if this field&#39;s value is &lt;code&gt;5&lt;/code&gt;, each buyer may purchase between one to five of these products, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase.&lt;br&gt;&lt;br&gt;If this field currently exists for an unpublished or published offer, it should be provided again in an &lt;strong&gt;updateOffer&lt;/strong&gt; call, even if the value is not changing.&lt;br&gt; | [optional]
**regulatory** | [**\Ebay\Inventory\Model\Regulatory**](Regulatory.md) |  | [optional]
**secondary_category_id** | **string** | The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the &lt;a href&#x3D;\&quot;/api-docs/commerce/taxonomy/resources/category_tree/methods/getCategorySuggestions\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getCategorySuggestions&lt;/a&gt; method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. &lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;strong&gt;Note:&lt;/strong&gt; You cannot list &lt;strong&gt;US eBay Motors&lt;/strong&gt; vehicles in two categories. However, you can list &lt;strong&gt;Parts &amp; Accessories&lt;/strong&gt; in two categories.&lt;/span&gt; | [optional]
**store_category_names** | **string[]** | This container is used if the seller would like to place the inventory item into one or two store categories that the seller has set up for their eBay store. The string value(s) passed in to this container will be the full path(s) to the store categories, as shown below:&lt;br&gt; &lt;pre&gt;&lt;code&gt;\&quot;storeCategoryNames\&quot;: [&lt;br&gt; \&quot;/Fashion/Men/Shirts\&quot;, &lt;br&gt; \&quot;/Fashion/Men/Accessories\&quot; ], &lt;/pre&gt;&lt;/code&gt;If this field currently exists for an unpublished or published offer, it should be provided again in an &lt;strong&gt;updateOffer&lt;/strong&gt; call, even if the eBay categories are not changing. | [optional]
**tax** | [**\Ebay\Inventory\Model\Tax**](Tax.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
