# # EbayOfferDetailsWithAll

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**available_quantity** | **int** | This integer value indicates the quantity of the inventory item (specified by the &lt;strong&gt;sku&lt;/strong&gt; value) that will be available for purchase by buyers shopping on the eBay site specified in the &lt;strong&gt;marketplaceId&lt;/strong&gt; field. | [optional]
**category_id** | **string** | The unique identifier of the primary eBay category that the inventory item is listed under. This field is always returned for published offers, but is only returned if set for unpublished offers. | [optional]
**charity** | [**\Ebay\Inventory\Model\Charity**](Charity.md) |  | [optional]
**extended_producer_responsibility** | [**\Ebay\Inventory\Model\ExtendedProducerResponsibility**](ExtendedProducerResponsibility.md) |  | [optional]
**format** | **string** | This enumerated value indicates the listing format of the offer. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:FormatTypeEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**hide_buyer_details** | **bool** | This field is returned as &lt;code&gt;true&lt;/code&gt; if the private listing feature has been enabled for the offer. Sellers may want to use this feature when they believe that a listing&#39;s potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users. &lt;br&gt;&lt;br&gt; This field is always returned even if not explicitly set in the offer. It defaults to &lt;code&gt;false&lt;/code&gt;, so will get returned as &lt;code&gt;false&lt;/code&gt; if seller does not set this feature with a &#39;Create&#39; or &#39;Update&#39; offer method. | [optional]
**include_catalog_product_details** | **bool** | This field indicates whether or not eBay product catalog details are applied to a listing. A value of &lt;code&gt;true&lt;/code&gt; indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in &lt;strong&gt;createOrReplaceInventoryItem&lt;/strong&gt;.&lt;p&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;strong&gt;Note:&lt;/strong&gt; Though the &lt;strong&gt;includeCatalogProductDetails&lt;/strong&gt; parameter is not required to be submitted in the request, the parameter defaults to &#39;true&#39; if omitted.&lt;/span&gt;&lt;/p&gt; | [optional]
**listing** | [**\Ebay\Inventory\Model\ListingDetails**](ListingDetails.md) |  | [optional]
**listing_description** | **string** | The description of the eBay listing that is part of the unpublished or published offer. This field is always returned for published offers, but is only returned if set for unpublished offers.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 500000 (which includes HTML markup/tags) | [optional]
**listing_duration** | **string** | This field indicates the number of days that the listing will be active.&lt;br&gt;&lt;br&gt;This field is returned for both auction and fixed-price listings; however, the value returned for fixed-price listings will always be &lt;code&gt;GTC&lt;/code&gt;. The GTC (Good &#39;Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt; &lt;strong&gt;Note:&lt;/strong&gt; If the listing duration expires for an auction offer, the listing then becomes available as a fixed-price offer and will be GTC.&lt;/span&gt; For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**listing_policies** | [**\Ebay\Inventory\Model\ListingPolicies**](ListingPolicies.md) |  | [optional]
**listing_start_date** | **string** | This timestamp is the date/time (in UTC format) that the seller set for the scheduled listing. With the scheduled listing feature, the seller can set a time in the future that the listing will become active, instead of the listing becoming active immediately after a &lt;strong&gt;publishOffer&lt;/strong&gt; call.&lt;br&gt;&lt;br&gt; For example: 2023-05-30T19:08:00Z.&lt;br&gt;&lt;br&gt; Scheduled listings do not always start at the exact date/time specified by the seller, but the date/time of the timestamp returned in &lt;strong&gt;getOffer&lt;/strong&gt;/&lt;strong&gt;getOffers&lt;/strong&gt; will be the same as the timestamp passed into a &#39;Create&#39; or &#39;Update&#39; offer call. &lt;br&gt;&lt;br&gt; This field is returned if set for an offer. | [optional]
**lot_size** | **int** | This field is only applicable and returned if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same product. An example would be a set of four identical car tires. The integer value in this field is the number of identical items being sold through the lot listing. | [optional]
**marketplace_id** | **string** | This enumeration value is the unique identifier of the eBay site on which the offer is available, or will be made available. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:MarketplaceEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**merchant_location_key** | **string** | The unique identifier of the inventory location. This identifier is set up by the merchant when the inventory location is first created with the &lt;strong&gt;createInventoryLocation&lt;/strong&gt; call. Once this value is set for an inventory location, it can not be modified. To get more information about this inventory location, the &lt;a href&#x3D;\&quot;/api-docs/sell/inventory/resources/location/methods/getInventoryLocation\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getInventoryLocation&lt;/a&gt; method can be used, passing in this value at the end of the call URI.&lt;br&gt;&lt;br&gt;This field is always returned for published offers, but is only returned if set for unpublished offers.&lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 36 | [optional]
**offer_id** | **string** | The unique identifier of the offer. This identifier is used in many offer-related calls, and it is also used in the &lt;strong&gt;bulkUpdatePriceQuantity&lt;/strong&gt; call. | [optional]
**pricing_summary** | [**\Ebay\Inventory\Model\PricingSummary**](PricingSummary.md) |  | [optional]
**quantity_limit_per_buyer** | **int** | This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity of an inventory item per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceed the quantity in this field. So, if this field&#39;s value is &lt;code&gt;5&lt;/code&gt;, each buyer may purchase a quantity of the inventory item between one and five, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase.&lt;br&gt; | [optional]
**regulatory** | [**\Ebay\Inventory\Model\Regulatory**](Regulatory.md) |  | [optional]
**secondary_category_id** | **string** | The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the &lt;a href&#x3D;\&quot;/api-docs/commerce/taxonomy/resources/category_tree/methods/getCategorySuggestions\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getCategorySuggestions&lt;/a&gt; method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. &lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;strong&gt;Note:&lt;/strong&gt; You cannot list &lt;strong&gt;US eBay Motors&lt;/strong&gt; vehicles in two categories. However, you can list &lt;strong&gt;Parts &amp; Accessories&lt;/strong&gt; in two categories.&lt;/span&gt; | [optional]
**sku** | **string** | This is the seller-defined SKU value of the product in the offer.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Max Length&lt;/strong&gt;: 50 &lt;br&gt; | [optional]
**status** | **string** | The enumeration value in this field specifies the status of the offer - either &lt;code&gt;PUBLISHED&lt;/code&gt; or &lt;code&gt;UNPUBLISHED&lt;/code&gt;. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/slr:OfferStatusEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**store_category_names** | **string[]** | This container is returned if the seller chose to place the inventory item into one or two eBay store categories that the seller has set up for their eBay store. The string value(s) in this container will be the full path(s) to the eBay store categories, as shown below:&lt;br&gt; &lt;pre&gt;&lt;code&gt;\&quot;storeCategoryNames\&quot;: [&lt;br&gt; \&quot;/Fashion/Men/Shirts\&quot;, &lt;br&gt; \&quot;/Fashion/Men/Accessories\&quot; ], &lt;/pre&gt;&lt;/code&gt; | [optional]
**tax** | [**\Ebay\Inventory\Model\Tax**](Tax.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
