# # Address

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**address_line1** | **string** | The first line of a street address. This field is required for store inventory locations that will be holding In-Store Pickup inventory. A street address is not required if the inventory location is not holding In-Store Pickup Inventory.&lt;br&gt;&lt;br&gt;This field will be returned if defined for an inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 128 | [optional]
**address_line2** | **string** | The second line of a street address. This field can be used for additional address information, such as a suite or apartment number. A street address is not required if the inventory location is not holding In-Store Pickup Inventory.&lt;br&gt;&lt;br&gt;This field will be returned if defined for an inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 128 | [optional]
**city** | **string** | The city in which the inventory location resides. This field is required for store inventory locations that will be holding In-Store Pickup inventory. For warehouse locations, this field is technically optional, as a &lt;strong&gt;postalCode&lt;/strong&gt; can be used instead of  &lt;strong&gt;city&lt;/strong&gt;/&lt;strong&gt;stateOrProvince&lt;/strong&gt; pair, and then the city is just derived from this postal/zip code.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 128 | [optional]
**country** | **string** | The country in which the address resides, represented as two-letter &lt;a href&#x3D;\&quot;https://www.iso.org/iso-3166-country-codes.html \&quot; title&#x3D;\&quot;https://www.iso.org \&quot; target&#x3D;\&quot;_blank\&quot;&gt;ISO 3166&lt;/a&gt; country code. For example, &lt;code&gt;US&lt;/code&gt; represents the United States, and &lt;code&gt;DE&lt;/code&gt; represents Germany. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/inventory/types/ba:CountryCodeEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**county** | **string** | The county in which the address resides.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory location. | [optional]
**postal_code** | **string** | The postal/zip code of the address. eBay uses postal codes to surface In-Store Pickup items within the vicinity of a buyer&#39;s location, and it also user postal codes (origin and destination) to estimate shipping costs when the seller uses calculated shipping. A &lt;strong&gt;city&lt;/strong&gt;/&lt;strong&gt;stateOrProvince&lt;/strong&gt; pair can be used instead of a &lt;strong&gt;postalCode&lt;/strong&gt; value, and then the postal code is just derived from the city and state/province.&lt;br&gt;&lt;br&gt;This field is returned if defined for an inventory location. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 16 | [optional]
**state_or_province** | **string** | The state/province in which the inventory location resides. This field is required for store inventory locations that will be holding In-Store Pickup inventory. For warehouse locations, this field is technically optional, as a &lt;strong&gt;postalCode&lt;/strong&gt; can be used instead of &lt;strong&gt;city&lt;/strong&gt;/&lt;strong&gt;stateOrProvince&lt;/strong&gt; pair, and then the state or province is just derived from this postal/zip code. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 128 | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
