# OpenAPIClient-php

<span class=\"tablenote\"><b>Note:</b> Not all the account related fields are returned for an authenticated user. The fields returned in the response are controlled by the scopes and are available only to select developers approved by business units.</span><br /><br />Retrieves the authenticated user's account profile information. It can be used to let users log into your app or site using eBay, which frees you from needing to store and protect user's PII (Personal Identifiable Information) data.


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/ebay.git"
    }
  ],
  "require": {
    "talisman/ebay": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: api_auth
$config = Ebay\Identity\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Ebay\Identity\Api\UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getUser();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->getUser: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://apiz.ebay.com/commerce/identity/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UserApi* | [**getUser**](docs/Api/UserApi.md#getuser) | **GET** /user/ | 

## Models

- [Address](docs/Model/Address.md)
- [BusinessAccount](docs/Model/BusinessAccount.md)
- [Contact](docs/Model/Contact.md)
- [Error](docs/Model/Error.md)
- [ErrorParameter](docs/Model/ErrorParameter.md)
- [IndividualAccount](docs/Model/IndividualAccount.md)
- [Phone](docs/Model/Phone.md)
- [UserResponse](docs/Model/UserResponse.md)

## Authorization

Authentication schemes defined for the API:
### api_auth

- **Type**: `OAuth`
- **Flow**: `accessCode`
- **Authorization URL**: `https://auth.ebay.com/oauth2/authorize`
- **Scopes**: 
    - **https://api.ebay.com/oauth/api_scope/commerce.identity.email.readonly**: View a user's personal email information from their eBay member account
    - **https://api.ebay.com/oauth/api_scope/commerce.identity.address.readonly**: View a user's personal address information from their eBay member account
    - **https://api.ebay.com/oauth/api_scope/commerce.identity.readonly**: View a user's basic information, such as username or business account details, from their eBay member account
    - **https://api.ebay.com/oauth/api_scope/commerce.identity.name.readonly**: View a user's first and last name from their eBay member account
    - **https://api.ebay.com/oauth/api_scope/commerce.identity.phone.readonly**: View a user's personal telephone information from their eBay member account

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v2.0.0`
    - Package version: `1.3.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
