<?php
/**
 * Program
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * Program Class Doc Comment
 *
 * @category Class
 * @description This type is returned for order line items eligible for the Authenticity Guarantee service and/or for order line items fulfilled by the eBay Fulfillment program or eBay shipping.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Program implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Program';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'authenticity_verification' => '\Ebay\Fulfilment\Model\PostSaleAuthenticationProgram',
        'ebay_shipping' => '\Ebay\Fulfilment\Model\EbayShipping',
        'ebay_vault' => '\Ebay\Fulfilment\Model\EbayVaultProgram',
        'ebay_international_shipping' => '\Ebay\Fulfilment\Model\EbayInternationalShipping',
        'fulfillment_program' => '\Ebay\Fulfilment\Model\EbayFulfillmentProgram'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'authenticity_verification' => null,
        'ebay_shipping' => null,
        'ebay_vault' => null,
        'ebay_international_shipping' => null,
        'fulfillment_program' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'authenticity_verification' => false,
        'ebay_shipping' => false,
        'ebay_vault' => false,
        'ebay_international_shipping' => false,
        'fulfillment_program' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'authenticity_verification' => 'authenticityVerification',
        'ebay_shipping' => 'ebayShipping',
        'ebay_vault' => 'ebayVault',
        'ebay_international_shipping' => 'ebayInternationalShipping',
        'fulfillment_program' => 'fulfillmentProgram'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'authenticity_verification' => 'setAuthenticityVerification',
        'ebay_shipping' => 'setEbayShipping',
        'ebay_vault' => 'setEbayVault',
        'ebay_international_shipping' => 'setEbayInternationalShipping',
        'fulfillment_program' => 'setFulfillmentProgram'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'authenticity_verification' => 'getAuthenticityVerification',
        'ebay_shipping' => 'getEbayShipping',
        'ebay_vault' => 'getEbayVault',
        'ebay_international_shipping' => 'getEbayInternationalShipping',
        'fulfillment_program' => 'getFulfillmentProgram'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('authenticity_verification', $data ?? [], null);
        $this->setIfExists('ebay_shipping', $data ?? [], null);
        $this->setIfExists('ebay_vault', $data ?? [], null);
        $this->setIfExists('ebay_international_shipping', $data ?? [], null);
        $this->setIfExists('fulfillment_program', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets authenticity_verification
     *
     * @return \Ebay\Fulfilment\Model\PostSaleAuthenticationProgram|null
     */
    public function getAuthenticityVerification()
    {
        return $this->container['authenticity_verification'];
    }

    /**
     * Sets authenticity_verification
     *
     * @param \Ebay\Fulfilment\Model\PostSaleAuthenticationProgram|null $authenticity_verification authenticity_verification
     *
     * @return self
     */
    public function setAuthenticityVerification($authenticity_verification)
    {
        if (is_null($authenticity_verification)) {
            throw new \InvalidArgumentException('non-nullable authenticity_verification cannot be null');
        }
        $this->container['authenticity_verification'] = $authenticity_verification;

        return $this;
    }

    /**
     * Gets ebay_shipping
     *
     * @return \Ebay\Fulfilment\Model\EbayShipping|null
     */
    public function getEbayShipping()
    {
        return $this->container['ebay_shipping'];
    }

    /**
     * Sets ebay_shipping
     *
     * @param \Ebay\Fulfilment\Model\EbayShipping|null $ebay_shipping ebay_shipping
     *
     * @return self
     */
    public function setEbayShipping($ebay_shipping)
    {
        if (is_null($ebay_shipping)) {
            throw new \InvalidArgumentException('non-nullable ebay_shipping cannot be null');
        }
        $this->container['ebay_shipping'] = $ebay_shipping;

        return $this;
    }

    /**
     * Gets ebay_vault
     *
     * @return \Ebay\Fulfilment\Model\EbayVaultProgram|null
     */
    public function getEbayVault()
    {
        return $this->container['ebay_vault'];
    }

    /**
     * Sets ebay_vault
     *
     * @param \Ebay\Fulfilment\Model\EbayVaultProgram|null $ebay_vault ebay_vault
     *
     * @return self
     */
    public function setEbayVault($ebay_vault)
    {
        if (is_null($ebay_vault)) {
            throw new \InvalidArgumentException('non-nullable ebay_vault cannot be null');
        }
        $this->container['ebay_vault'] = $ebay_vault;

        return $this;
    }

    /**
     * Gets ebay_international_shipping
     *
     * @return \Ebay\Fulfilment\Model\EbayInternationalShipping|null
     */
    public function getEbayInternationalShipping()
    {
        return $this->container['ebay_international_shipping'];
    }

    /**
     * Sets ebay_international_shipping
     *
     * @param \Ebay\Fulfilment\Model\EbayInternationalShipping|null $ebay_international_shipping ebay_international_shipping
     *
     * @return self
     */
    public function setEbayInternationalShipping($ebay_international_shipping)
    {
        if (is_null($ebay_international_shipping)) {
            throw new \InvalidArgumentException('non-nullable ebay_international_shipping cannot be null');
        }
        $this->container['ebay_international_shipping'] = $ebay_international_shipping;

        return $this;
    }

    /**
     * Gets fulfillment_program
     *
     * @return \Ebay\Fulfilment\Model\EbayFulfillmentProgram|null
     */
    public function getFulfillmentProgram()
    {
        return $this->container['fulfillment_program'];
    }

    /**
     * Sets fulfillment_program
     *
     * @param \Ebay\Fulfilment\Model\EbayFulfillmentProgram|null $fulfillment_program fulfillment_program
     *
     * @return self
     */
    public function setFulfillmentProgram($fulfillment_program)
    {
        if (is_null($fulfillment_program)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_program cannot be null');
        }
        $this->container['fulfillment_program'] = $fulfillment_program;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


