<?php
/**
 * PricingSummary
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * PricingSummary Class Doc Comment
 *
 * @category Class
 * @description This type contains a summary of cumulative costs and charges for all line items of an order, including item price, price adjustments, sales taxes, delivery costs, and order discounts.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PricingSummary implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PricingSummary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'adjustment' => '\Ebay\Fulfilment\Model\Amount',
        'delivery_cost' => '\Ebay\Fulfilment\Model\Amount',
        'delivery_discount' => '\Ebay\Fulfilment\Model\Amount',
        'fee' => '\Ebay\Fulfilment\Model\Amount',
        'price_discount' => '\Ebay\Fulfilment\Model\Amount',
        'price_subtotal' => '\Ebay\Fulfilment\Model\Amount',
        'tax' => '\Ebay\Fulfilment\Model\Amount',
        'total' => '\Ebay\Fulfilment\Model\Amount'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'adjustment' => null,
        'delivery_cost' => null,
        'delivery_discount' => null,
        'fee' => null,
        'price_discount' => null,
        'price_subtotal' => null,
        'tax' => null,
        'total' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'adjustment' => false,
        'delivery_cost' => false,
        'delivery_discount' => false,
        'fee' => false,
        'price_discount' => false,
        'price_subtotal' => false,
        'tax' => false,
        'total' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'adjustment' => 'adjustment',
        'delivery_cost' => 'deliveryCost',
        'delivery_discount' => 'deliveryDiscount',
        'fee' => 'fee',
        'price_discount' => 'priceDiscount',
        'price_subtotal' => 'priceSubtotal',
        'tax' => 'tax',
        'total' => 'total'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'adjustment' => 'setAdjustment',
        'delivery_cost' => 'setDeliveryCost',
        'delivery_discount' => 'setDeliveryDiscount',
        'fee' => 'setFee',
        'price_discount' => 'setPriceDiscount',
        'price_subtotal' => 'setPriceSubtotal',
        'tax' => 'setTax',
        'total' => 'setTotal'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'adjustment' => 'getAdjustment',
        'delivery_cost' => 'getDeliveryCost',
        'delivery_discount' => 'getDeliveryDiscount',
        'fee' => 'getFee',
        'price_discount' => 'getPriceDiscount',
        'price_subtotal' => 'getPriceSubtotal',
        'tax' => 'getTax',
        'total' => 'getTotal'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('adjustment', $data ?? [], null);
        $this->setIfExists('delivery_cost', $data ?? [], null);
        $this->setIfExists('delivery_discount', $data ?? [], null);
        $this->setIfExists('fee', $data ?? [], null);
        $this->setIfExists('price_discount', $data ?? [], null);
        $this->setIfExists('price_subtotal', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets adjustment
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getAdjustment()
    {
        return $this->container['adjustment'];
    }

    /**
     * Sets adjustment
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $adjustment adjustment
     *
     * @return self
     */
    public function setAdjustment($adjustment)
    {
        if (is_null($adjustment)) {
            throw new \InvalidArgumentException('non-nullable adjustment cannot be null');
        }
        $this->container['adjustment'] = $adjustment;

        return $this;
    }

    /**
     * Gets delivery_cost
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getDeliveryCost()
    {
        return $this->container['delivery_cost'];
    }

    /**
     * Sets delivery_cost
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $delivery_cost delivery_cost
     *
     * @return self
     */
    public function setDeliveryCost($delivery_cost)
    {
        if (is_null($delivery_cost)) {
            throw new \InvalidArgumentException('non-nullable delivery_cost cannot be null');
        }
        $this->container['delivery_cost'] = $delivery_cost;

        return $this;
    }

    /**
     * Gets delivery_discount
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getDeliveryDiscount()
    {
        return $this->container['delivery_discount'];
    }

    /**
     * Sets delivery_discount
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $delivery_discount delivery_discount
     *
     * @return self
     */
    public function setDeliveryDiscount($delivery_discount)
    {
        if (is_null($delivery_discount)) {
            throw new \InvalidArgumentException('non-nullable delivery_discount cannot be null');
        }
        $this->container['delivery_discount'] = $delivery_discount;

        return $this;
    }

    /**
     * Gets fee
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getFee()
    {
        return $this->container['fee'];
    }

    /**
     * Sets fee
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $fee fee
     *
     * @return self
     */
    public function setFee($fee)
    {
        if (is_null($fee)) {
            throw new \InvalidArgumentException('non-nullable fee cannot be null');
        }
        $this->container['fee'] = $fee;

        return $this;
    }

    /**
     * Gets price_discount
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getPriceDiscount()
    {
        return $this->container['price_discount'];
    }

    /**
     * Sets price_discount
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $price_discount price_discount
     *
     * @return self
     */
    public function setPriceDiscount($price_discount)
    {
        if (is_null($price_discount)) {
            throw new \InvalidArgumentException('non-nullable price_discount cannot be null');
        }
        $this->container['price_discount'] = $price_discount;

        return $this;
    }

    /**
     * Gets price_subtotal
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getPriceSubtotal()
    {
        return $this->container['price_subtotal'];
    }

    /**
     * Sets price_subtotal
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $price_subtotal price_subtotal
     *
     * @return self
     */
    public function setPriceSubtotal($price_subtotal)
    {
        if (is_null($price_subtotal)) {
            throw new \InvalidArgumentException('non-nullable price_subtotal cannot be null');
        }
        $this->container['price_subtotal'] = $price_subtotal;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


