<?php
/**
 * PaymentHold
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * PaymentHold Class Doc Comment
 *
 * @category Class
 * @description This type contains information about a hold placed on a payment to a seller for an order, including the reason why the buyer&#39;s payment for the order is being held, the expected release date of the funds into the seller&#39;s account, the current state of the hold, and the actual release date if the payment has been released, and possible actions the seller can take to expedite the payout of funds into their account.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentHold implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentHold';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'expected_release_date' => 'string',
        'hold_amount' => '\Ebay\Fulfilment\Model\Amount',
        'hold_reason' => 'string',
        'hold_state' => 'string',
        'release_date' => 'string',
        'seller_actions_to_release' => '\Ebay\Fulfilment\Model\SellerActionsToRelease[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'expected_release_date' => null,
        'hold_amount' => null,
        'hold_reason' => null,
        'hold_state' => null,
        'release_date' => null,
        'seller_actions_to_release' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'expected_release_date' => false,
        'hold_amount' => false,
        'hold_reason' => false,
        'hold_state' => false,
        'release_date' => false,
        'seller_actions_to_release' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'expected_release_date' => 'expectedReleaseDate',
        'hold_amount' => 'holdAmount',
        'hold_reason' => 'holdReason',
        'hold_state' => 'holdState',
        'release_date' => 'releaseDate',
        'seller_actions_to_release' => 'sellerActionsToRelease'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'expected_release_date' => 'setExpectedReleaseDate',
        'hold_amount' => 'setHoldAmount',
        'hold_reason' => 'setHoldReason',
        'hold_state' => 'setHoldState',
        'release_date' => 'setReleaseDate',
        'seller_actions_to_release' => 'setSellerActionsToRelease'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'expected_release_date' => 'getExpectedReleaseDate',
        'hold_amount' => 'getHoldAmount',
        'hold_reason' => 'getHoldReason',
        'hold_state' => 'getHoldState',
        'release_date' => 'getReleaseDate',
        'seller_actions_to_release' => 'getSellerActionsToRelease'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('expected_release_date', $data ?? [], null);
        $this->setIfExists('hold_amount', $data ?? [], null);
        $this->setIfExists('hold_reason', $data ?? [], null);
        $this->setIfExists('hold_state', $data ?? [], null);
        $this->setIfExists('release_date', $data ?? [], null);
        $this->setIfExists('seller_actions_to_release', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets expected_release_date
     *
     * @return string|null
     */
    public function getExpectedReleaseDate()
    {
        return $this->container['expected_release_date'];
    }

    /**
     * Sets expected_release_date
     *
     * @param string|null $expected_release_date The date and time that the payment being held is expected to be released to the seller. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. This field will be returned if known by eBay. <br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2015-08-04T19:09:02.768Z</code>
     *
     * @return self
     */
    public function setExpectedReleaseDate($expected_release_date)
    {
        if (is_null($expected_release_date)) {
            throw new \InvalidArgumentException('non-nullable expected_release_date cannot be null');
        }
        $this->container['expected_release_date'] = $expected_release_date;

        return $this;
    }

    /**
     * Gets hold_amount
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getHoldAmount()
    {
        return $this->container['hold_amount'];
    }

    /**
     * Sets hold_amount
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $hold_amount hold_amount
     *
     * @return self
     */
    public function setHoldAmount($hold_amount)
    {
        if (is_null($hold_amount)) {
            throw new \InvalidArgumentException('non-nullable hold_amount cannot be null');
        }
        $this->container['hold_amount'] = $hold_amount;

        return $this;
    }

    /**
     * Gets hold_reason
     *
     * @return string|null
     */
    public function getHoldReason()
    {
        return $this->container['hold_reason'];
    }

    /**
     * Sets hold_reason
     *
     * @param string|null $hold_reason The reason that the payment is being held. A seller's payment may be held for a number of reasons, including when the seller is new, the seller's level is below standard, or if a return case or 'Significantly not as described' case is pending against the seller. This field is always returned with the <strong>paymentHolds</strong> array.
     *
     * @return self
     */
    public function setHoldReason($hold_reason)
    {
        if (is_null($hold_reason)) {
            throw new \InvalidArgumentException('non-nullable hold_reason cannot be null');
        }
        $this->container['hold_reason'] = $hold_reason;

        return $this;
    }

    /**
     * Gets hold_state
     *
     * @return string|null
     */
    public function getHoldState()
    {
        return $this->container['hold_state'];
    }

    /**
     * Sets hold_state
     *
     * @param string|null $hold_state The current stage or condition of the hold. This field is always returned with the <strong>paymentHolds</strong> array.<br><br><b>Applicable values:</b><ul><li><code>HELD</code></li><li><code>HELD_PENDING</code></li><li><code>NOT_HELD</code></li><li><code>RELEASE_CONFIRMED</code></li><li><code>RELEASE_FAILED</code></li><li><code>RELEASE_PENDING</code></li><li><code>RELEASED</code></li></ul>
     *
     * @return self
     */
    public function setHoldState($hold_state)
    {
        if (is_null($hold_state)) {
            throw new \InvalidArgumentException('non-nullable hold_state cannot be null');
        }
        $this->container['hold_state'] = $hold_state;

        return $this;
    }

    /**
     * Gets release_date
     *
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->container['release_date'];
    }

    /**
     * Sets release_date
     *
     * @param string|null $release_date The date and time that the payment being held was actually released to the seller. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. This field is not returned until the seller's payment is actually released into the seller's account.<br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2015-08-04T19:09:02.768Z</code>
     *
     * @return self
     */
    public function setReleaseDate($release_date)
    {
        if (is_null($release_date)) {
            throw new \InvalidArgumentException('non-nullable release_date cannot be null');
        }
        $this->container['release_date'] = $release_date;

        return $this;
    }

    /**
     * Gets seller_actions_to_release
     *
     * @return \Ebay\Fulfilment\Model\SellerActionsToRelease[]|null
     */
    public function getSellerActionsToRelease()
    {
        return $this->container['seller_actions_to_release'];
    }

    /**
     * Sets seller_actions_to_release
     *
     * @param \Ebay\Fulfilment\Model\SellerActionsToRelease[]|null $seller_actions_to_release A list of one or more possible actions that the seller can take to expedite the release of the payment hold.
     *
     * @return self
     */
    public function setSellerActionsToRelease($seller_actions_to_release)
    {
        if (is_null($seller_actions_to_release)) {
            throw new \InvalidArgumentException('non-nullable seller_actions_to_release cannot be null');
        }
        $this->container['seller_actions_to_release'] = $seller_actions_to_release;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


