<?php
/**
 * PaymentDisputeOutcomeDetail
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * PaymentDisputeOutcomeDetail Class Doc Comment
 *
 * @category Class
 * @description This type is used by the &lt;strong&gt;resolution&lt;/strong&gt; container that is returned for payment disputes that have been resolved.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentDisputeOutcomeDetail implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentDisputeOutcomeDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fees' => '\Ebay\Fulfilment\Model\SimpleAmount',
        'protected_amount' => '\Ebay\Fulfilment\Model\SimpleAmount',
        'protection_status' => 'string',
        'reason_for_closure' => 'string',
        'recoup_amount' => '\Ebay\Fulfilment\Model\SimpleAmount',
        'total_fee_credit' => '\Ebay\Fulfilment\Model\SimpleAmount'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fees' => null,
        'protected_amount' => null,
        'protection_status' => null,
        'reason_for_closure' => null,
        'recoup_amount' => null,
        'total_fee_credit' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fees' => false,
        'protected_amount' => false,
        'protection_status' => false,
        'reason_for_closure' => false,
        'recoup_amount' => false,
        'total_fee_credit' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fees' => 'fees',
        'protected_amount' => 'protectedAmount',
        'protection_status' => 'protectionStatus',
        'reason_for_closure' => 'reasonForClosure',
        'recoup_amount' => 'recoupAmount',
        'total_fee_credit' => 'totalFeeCredit'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fees' => 'setFees',
        'protected_amount' => 'setProtectedAmount',
        'protection_status' => 'setProtectionStatus',
        'reason_for_closure' => 'setReasonForClosure',
        'recoup_amount' => 'setRecoupAmount',
        'total_fee_credit' => 'setTotalFeeCredit'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fees' => 'getFees',
        'protected_amount' => 'getProtectedAmount',
        'protection_status' => 'getProtectionStatus',
        'reason_for_closure' => 'getReasonForClosure',
        'recoup_amount' => 'getRecoupAmount',
        'total_fee_credit' => 'getTotalFeeCredit'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fees', $data ?? [], null);
        $this->setIfExists('protected_amount', $data ?? [], null);
        $this->setIfExists('protection_status', $data ?? [], null);
        $this->setIfExists('reason_for_closure', $data ?? [], null);
        $this->setIfExists('recoup_amount', $data ?? [], null);
        $this->setIfExists('total_fee_credit', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fees
     *
     * @return \Ebay\Fulfilment\Model\SimpleAmount|null
     */
    public function getFees()
    {
        return $this->container['fees'];
    }

    /**
     * Sets fees
     *
     * @param \Ebay\Fulfilment\Model\SimpleAmount|null $fees fees
     *
     * @return self
     */
    public function setFees($fees)
    {
        if (is_null($fees)) {
            throw new \InvalidArgumentException('non-nullable fees cannot be null');
        }
        $this->container['fees'] = $fees;

        return $this;
    }

    /**
     * Gets protected_amount
     *
     * @return \Ebay\Fulfilment\Model\SimpleAmount|null
     */
    public function getProtectedAmount()
    {
        return $this->container['protected_amount'];
    }

    /**
     * Sets protected_amount
     *
     * @param \Ebay\Fulfilment\Model\SimpleAmount|null $protected_amount protected_amount
     *
     * @return self
     */
    public function setProtectedAmount($protected_amount)
    {
        if (is_null($protected_amount)) {
            throw new \InvalidArgumentException('non-nullable protected_amount cannot be null');
        }
        $this->container['protected_amount'] = $protected_amount;

        return $this;
    }

    /**
     * Gets protection_status
     *
     * @return string|null
     */
    public function getProtectionStatus()
    {
        return $this->container['protection_status'];
    }

    /**
     * Sets protection_status
     *
     * @param string|null $protection_status This enumeration value indicates if the seller is fully protected, partially protected, or not protected by eBay for the payment dispute. This field is always returned once the payment dispute is resolved. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:ProtectionStatusEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setProtectionStatus($protection_status)
    {
        if (is_null($protection_status)) {
            throw new \InvalidArgumentException('non-nullable protection_status cannot be null');
        }
        $this->container['protection_status'] = $protection_status;

        return $this;
    }

    /**
     * Gets reason_for_closure
     *
     * @return string|null
     */
    public function getReasonForClosure()
    {
        return $this->container['reason_for_closure'];
    }

    /**
     * Sets reason_for_closure
     *
     * @param string|null $reason_for_closure The enumeration value returned in this field indicates the outcome of the payment dispute for the seller. This field is always returned once the payment dispute is resolved. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:OutcomeEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setReasonForClosure($reason_for_closure)
    {
        if (is_null($reason_for_closure)) {
            throw new \InvalidArgumentException('non-nullable reason_for_closure cannot be null');
        }
        $this->container['reason_for_closure'] = $reason_for_closure;

        return $this;
    }

    /**
     * Gets recoup_amount
     *
     * @return \Ebay\Fulfilment\Model\SimpleAmount|null
     */
    public function getRecoupAmount()
    {
        return $this->container['recoup_amount'];
    }

    /**
     * Sets recoup_amount
     *
     * @param \Ebay\Fulfilment\Model\SimpleAmount|null $recoup_amount recoup_amount
     *
     * @return self
     */
    public function setRecoupAmount($recoup_amount)
    {
        if (is_null($recoup_amount)) {
            throw new \InvalidArgumentException('non-nullable recoup_amount cannot be null');
        }
        $this->container['recoup_amount'] = $recoup_amount;

        return $this;
    }

    /**
     * Gets total_fee_credit
     *
     * @return \Ebay\Fulfilment\Model\SimpleAmount|null
     */
    public function getTotalFeeCredit()
    {
        return $this->container['total_fee_credit'];
    }

    /**
     * Sets total_fee_credit
     *
     * @param \Ebay\Fulfilment\Model\SimpleAmount|null $total_fee_credit total_fee_credit
     *
     * @return self
     */
    public function setTotalFeeCredit($total_fee_credit)
    {
        if (is_null($total_fee_credit)) {
            throw new \InvalidArgumentException('non-nullable total_fee_credit cannot be null');
        }
        $this->container['total_fee_credit'] = $total_fee_credit;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


