<?php
/**
 * PaymentDispute
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * PaymentDispute Class Doc Comment
 *
 * @category Class
 * @description This type is used by the base response of the &lt;strong&gt;getPaymentDispute&lt;/strong&gt; method. The &lt;strong&gt;getPaymentDispute&lt;/strong&gt; method retrieves detailed information on a specific payment dispute.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentDispute implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentDispute';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amount' => '\Ebay\Fulfilment\Model\SimpleAmount',
        'available_choices' => 'string[]',
        'buyer_provided' => '\Ebay\Fulfilment\Model\InfoFromBuyer',
        'buyer_username' => 'string',
        'closed_date' => 'string',
        'evidence' => '\Ebay\Fulfilment\Model\DisputeEvidence[]',
        'evidence_requests' => '\Ebay\Fulfilment\Model\EvidenceRequest[]',
        'line_items' => '\Ebay\Fulfilment\Model\OrderLineItems[]',
        'monetary_transactions' => '\Ebay\Fulfilment\Model\MonetaryTransaction[]',
        'note' => 'string',
        'open_date' => 'string',
        'order_id' => 'string',
        'payment_dispute_id' => 'string',
        'payment_dispute_status' => 'string',
        'reason' => 'string',
        'resolution' => '\Ebay\Fulfilment\Model\PaymentDisputeOutcomeDetail',
        'respond_by_date' => 'string',
        'return_address' => '\Ebay\Fulfilment\Model\ReturnAddress',
        'revision' => 'int',
        'seller_response' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amount' => null,
        'available_choices' => null,
        'buyer_provided' => null,
        'buyer_username' => null,
        'closed_date' => null,
        'evidence' => null,
        'evidence_requests' => null,
        'line_items' => null,
        'monetary_transactions' => null,
        'note' => null,
        'open_date' => null,
        'order_id' => null,
        'payment_dispute_id' => null,
        'payment_dispute_status' => null,
        'reason' => null,
        'resolution' => null,
        'respond_by_date' => null,
        'return_address' => null,
        'revision' => 'int32',
        'seller_response' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'amount' => false,
        'available_choices' => false,
        'buyer_provided' => false,
        'buyer_username' => false,
        'closed_date' => false,
        'evidence' => false,
        'evidence_requests' => false,
        'line_items' => false,
        'monetary_transactions' => false,
        'note' => false,
        'open_date' => false,
        'order_id' => false,
        'payment_dispute_id' => false,
        'payment_dispute_status' => false,
        'reason' => false,
        'resolution' => false,
        'respond_by_date' => false,
        'return_address' => false,
        'revision' => false,
        'seller_response' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amount' => 'amount',
        'available_choices' => 'availableChoices',
        'buyer_provided' => 'buyerProvided',
        'buyer_username' => 'buyerUsername',
        'closed_date' => 'closedDate',
        'evidence' => 'evidence',
        'evidence_requests' => 'evidenceRequests',
        'line_items' => 'lineItems',
        'monetary_transactions' => 'monetaryTransactions',
        'note' => 'note',
        'open_date' => 'openDate',
        'order_id' => 'orderId',
        'payment_dispute_id' => 'paymentDisputeId',
        'payment_dispute_status' => 'paymentDisputeStatus',
        'reason' => 'reason',
        'resolution' => 'resolution',
        'respond_by_date' => 'respondByDate',
        'return_address' => 'returnAddress',
        'revision' => 'revision',
        'seller_response' => 'sellerResponse'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amount' => 'setAmount',
        'available_choices' => 'setAvailableChoices',
        'buyer_provided' => 'setBuyerProvided',
        'buyer_username' => 'setBuyerUsername',
        'closed_date' => 'setClosedDate',
        'evidence' => 'setEvidence',
        'evidence_requests' => 'setEvidenceRequests',
        'line_items' => 'setLineItems',
        'monetary_transactions' => 'setMonetaryTransactions',
        'note' => 'setNote',
        'open_date' => 'setOpenDate',
        'order_id' => 'setOrderId',
        'payment_dispute_id' => 'setPaymentDisputeId',
        'payment_dispute_status' => 'setPaymentDisputeStatus',
        'reason' => 'setReason',
        'resolution' => 'setResolution',
        'respond_by_date' => 'setRespondByDate',
        'return_address' => 'setReturnAddress',
        'revision' => 'setRevision',
        'seller_response' => 'setSellerResponse'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amount' => 'getAmount',
        'available_choices' => 'getAvailableChoices',
        'buyer_provided' => 'getBuyerProvided',
        'buyer_username' => 'getBuyerUsername',
        'closed_date' => 'getClosedDate',
        'evidence' => 'getEvidence',
        'evidence_requests' => 'getEvidenceRequests',
        'line_items' => 'getLineItems',
        'monetary_transactions' => 'getMonetaryTransactions',
        'note' => 'getNote',
        'open_date' => 'getOpenDate',
        'order_id' => 'getOrderId',
        'payment_dispute_id' => 'getPaymentDisputeId',
        'payment_dispute_status' => 'getPaymentDisputeStatus',
        'reason' => 'getReason',
        'resolution' => 'getResolution',
        'respond_by_date' => 'getRespondByDate',
        'return_address' => 'getReturnAddress',
        'revision' => 'getRevision',
        'seller_response' => 'getSellerResponse'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('available_choices', $data ?? [], null);
        $this->setIfExists('buyer_provided', $data ?? [], null);
        $this->setIfExists('buyer_username', $data ?? [], null);
        $this->setIfExists('closed_date', $data ?? [], null);
        $this->setIfExists('evidence', $data ?? [], null);
        $this->setIfExists('evidence_requests', $data ?? [], null);
        $this->setIfExists('line_items', $data ?? [], null);
        $this->setIfExists('monetary_transactions', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('open_date', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('payment_dispute_id', $data ?? [], null);
        $this->setIfExists('payment_dispute_status', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('resolution', $data ?? [], null);
        $this->setIfExists('respond_by_date', $data ?? [], null);
        $this->setIfExists('return_address', $data ?? [], null);
        $this->setIfExists('revision', $data ?? [], null);
        $this->setIfExists('seller_response', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets amount
     *
     * @return \Ebay\Fulfilment\Model\SimpleAmount|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param \Ebay\Fulfilment\Model\SimpleAmount|null $amount amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets available_choices
     *
     * @return string[]|null
     */
    public function getAvailableChoices()
    {
        return $this->container['available_choices'];
    }

    /**
     * Sets available_choices
     *
     * @param string[]|null $available_choices The value(s) returned in this array indicate the choices that the seller has when responding to the payment dispute. Once the seller has responded to the payment dispute, this field will no longer be shown, and instead, the <strong>sellerResponse</strong> field will show the decision that the seller made.
     *
     * @return self
     */
    public function setAvailableChoices($available_choices)
    {
        if (is_null($available_choices)) {
            throw new \InvalidArgumentException('non-nullable available_choices cannot be null');
        }
        $this->container['available_choices'] = $available_choices;

        return $this;
    }

    /**
     * Gets buyer_provided
     *
     * @return \Ebay\Fulfilment\Model\InfoFromBuyer|null
     */
    public function getBuyerProvided()
    {
        return $this->container['buyer_provided'];
    }

    /**
     * Sets buyer_provided
     *
     * @param \Ebay\Fulfilment\Model\InfoFromBuyer|null $buyer_provided buyer_provided
     *
     * @return self
     */
    public function setBuyerProvided($buyer_provided)
    {
        if (is_null($buyer_provided)) {
            throw new \InvalidArgumentException('non-nullable buyer_provided cannot be null');
        }
        $this->container['buyer_provided'] = $buyer_provided;

        return $this;
    }

    /**
     * Gets buyer_username
     *
     * @return string|null
     */
    public function getBuyerUsername()
    {
        return $this->container['buyer_username'];
    }

    /**
     * Sets buyer_username
     *
     * @param string|null $buyer_username This is the eBay user ID of the buyer that initiated the payment dispute.
     *
     * @return self
     */
    public function setBuyerUsername($buyer_username)
    {
        if (is_null($buyer_username)) {
            throw new \InvalidArgumentException('non-nullable buyer_username cannot be null');
        }
        $this->container['buyer_username'] = $buyer_username;

        return $this;
    }

    /**
     * Gets closed_date
     *
     * @return string|null
     */
    public function getClosedDate()
    {
        return $this->container['closed_date'];
    }

    /**
     * Sets closed_date
     *
     * @param string|null $closed_date The timestamp in this field shows the date/time when the payment dispute was closed, so this field is only returned for payment disputes in the <code>CLOSED</code> state.<br><br>The timestamps returned here use the ISO-8601 24-hour date and time format, and the time zone used is Universal Coordinated Time (UTC), also known as Greenwich Mean Time (GMT), or Zulu. The ISO-8601 format looks like this: <em>yyyy-MM-ddThh:mm.ss.sssZ</em>. An example would be <code>2019-08-04T19:09:02.768Z</code>.
     *
     * @return self
     */
    public function setClosedDate($closed_date)
    {
        if (is_null($closed_date)) {
            throw new \InvalidArgumentException('non-nullable closed_date cannot be null');
        }
        $this->container['closed_date'] = $closed_date;

        return $this;
    }

    /**
     * Gets evidence
     *
     * @return \Ebay\Fulfilment\Model\DisputeEvidence[]|null
     */
    public function getEvidence()
    {
        return $this->container['evidence'];
    }

    /**
     * Sets evidence
     *
     * @param \Ebay\Fulfilment\Model\DisputeEvidence[]|null $evidence This container shows any evidence that has been provided by the seller to contest the payment dispute. Evidence may include shipment tracking information, proof of authentication documentation, image(s) to proof that an item is as described, or financial documentation/invoice.<br><br>This container is only returned if the seller has provided at least one document used as evidence against the payment dispute.
     *
     * @return self
     */
    public function setEvidence($evidence)
    {
        if (is_null($evidence)) {
            throw new \InvalidArgumentException('non-nullable evidence cannot be null');
        }
        $this->container['evidence'] = $evidence;

        return $this;
    }

    /**
     * Gets evidence_requests
     *
     * @return \Ebay\Fulfilment\Model\EvidenceRequest[]|null
     */
    public function getEvidenceRequests()
    {
        return $this->container['evidence_requests'];
    }

    /**
     * Sets evidence_requests
     *
     * @param \Ebay\Fulfilment\Model\EvidenceRequest[]|null $evidence_requests This container is returned if one or more evidence documents are being requested from the seller.
     *
     * @return self
     */
    public function setEvidenceRequests($evidence_requests)
    {
        if (is_null($evidence_requests)) {
            throw new \InvalidArgumentException('non-nullable evidence_requests cannot be null');
        }
        $this->container['evidence_requests'] = $evidence_requests;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Ebay\Fulfilment\Model\OrderLineItems[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Ebay\Fulfilment\Model\OrderLineItems[]|null $line_items This array is used to identify one or more order line items associated with the payment dispute. There will always be at least one <b>itemId</b>/<b>lineItemId</b> pair returned in this array.
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        if (is_null($line_items)) {
            throw new \InvalidArgumentException('non-nullable line_items cannot be null');
        }
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets monetary_transactions
     *
     * @return \Ebay\Fulfilment\Model\MonetaryTransaction[]|null
     */
    public function getMonetaryTransactions()
    {
        return $this->container['monetary_transactions'];
    }

    /**
     * Sets monetary_transactions
     *
     * @param \Ebay\Fulfilment\Model\MonetaryTransaction[]|null $monetary_transactions This array provide details about one or more monetary transactions that occur as part of a payment dispute. This array is only returned once one or more monetary transacations occur with a payment dispute.
     *
     * @return self
     */
    public function setMonetaryTransactions($monetary_transactions)
    {
        if (is_null($monetary_transactions)) {
            throw new \InvalidArgumentException('non-nullable monetary_transactions cannot be null');
        }
        $this->container['monetary_transactions'] = $monetary_transactions;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note This field shows information that the seller provides about the dispute, such as the basis for the dispute, any relevant evidence, tracking numbers, and so forth.<br><br>This field is limited to 1000 characters.
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets open_date
     *
     * @return string|null
     */
    public function getOpenDate()
    {
        return $this->container['open_date'];
    }

    /**
     * Sets open_date
     *
     * @param string|null $open_date The timestamp in this field shows the date/time when the payment dispute was opened. This field is returned for payment disputes in all states.<br><br>The timestamps returned here use the ISO-8601 24-hour date and time format, and the time zone used is Universal Coordinated Time (UTC), also known as Greenwich Mean Time (GMT), or Zulu. The ISO-8601 format looks like this: <em>yyyy-MM-ddThh:mm.ss.sssZ</em>. An example would be <code>2019-08-04T19:09:02.768Z</code>.
     *
     * @return self
     */
    public function setOpenDate($open_date)
    {
        if (is_null($open_date)) {
            throw new \InvalidArgumentException('non-nullable open_date cannot be null');
        }
        $this->container['open_date'] = $open_date;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id This is the unique identifier of the order involved in the payment dispute.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets payment_dispute_id
     *
     * @return string|null
     */
    public function getPaymentDisputeId()
    {
        return $this->container['payment_dispute_id'];
    }

    /**
     * Sets payment_dispute_id
     *
     * @param string|null $payment_dispute_id This is the unique identifier of the payment dispute. This is the same identifier that is passed in to the call URI. This identifier is automatically created by eBay once the payment dispute comes into the eBay system.
     *
     * @return self
     */
    public function setPaymentDisputeId($payment_dispute_id)
    {
        if (is_null($payment_dispute_id)) {
            throw new \InvalidArgumentException('non-nullable payment_dispute_id cannot be null');
        }
        $this->container['payment_dispute_id'] = $payment_dispute_id;

        return $this;
    }

    /**
     * Gets payment_dispute_status
     *
     * @return string|null
     */
    public function getPaymentDisputeStatus()
    {
        return $this->container['payment_dispute_status'];
    }

    /**
     * Sets payment_dispute_status
     *
     * @param string|null $payment_dispute_status The enumeration value in this field gives the current status of the payment dispute. The status of a payment dispute partially determines other fields that are returned in the response. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:DisputeStateEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setPaymentDisputeStatus($payment_dispute_status)
    {
        if (is_null($payment_dispute_status)) {
            throw new \InvalidArgumentException('non-nullable payment_dispute_status cannot be null');
        }
        $this->container['payment_dispute_status'] = $payment_dispute_status;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason The enumeration value in this field gives the reason why the buyer initiated the payment dispute. See <strong>DisputeReasonEnum</strong> type for a description of the supported reasons that buyers can give for initiating a payment dispute. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:DisputeReasonEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets resolution
     *
     * @return \Ebay\Fulfilment\Model\PaymentDisputeOutcomeDetail|null
     */
    public function getResolution()
    {
        return $this->container['resolution'];
    }

    /**
     * Sets resolution
     *
     * @param \Ebay\Fulfilment\Model\PaymentDisputeOutcomeDetail|null $resolution resolution
     *
     * @return self
     */
    public function setResolution($resolution)
    {
        if (is_null($resolution)) {
            throw new \InvalidArgumentException('non-nullable resolution cannot be null');
        }
        $this->container['resolution'] = $resolution;

        return $this;
    }

    /**
     * Gets respond_by_date
     *
     * @return string|null
     */
    public function getRespondByDate()
    {
        return $this->container['respond_by_date'];
    }

    /**
     * Sets respond_by_date
     *
     * @param string|null $respond_by_date The timestamp in this field shows the date/time when the seller must response to a payment dispute, so this field is only returned for payment disputes in the <code>ACTION_NEEDED</code> state. For payment disputes that currently require action by the seller, that same seller should look at the <strong>availableChoices</strong> array to see the available actions.<br><br>The timestamps returned here use the ISO-8601 24-hour date and time format, and the time zone used is Universal Coordinated Time (UTC), also known as Greenwich Mean Time (GMT), or Zulu. The ISO-8601 format looks like this: <em>yyyy-MM-ddThh:mm.ss.sssZ</em>. An example would be <code>2019-08-04T19:09:02.768Z</code>.
     *
     * @return self
     */
    public function setRespondByDate($respond_by_date)
    {
        if (is_null($respond_by_date)) {
            throw new \InvalidArgumentException('non-nullable respond_by_date cannot be null');
        }
        $this->container['respond_by_date'] = $respond_by_date;

        return $this;
    }

    /**
     * Gets return_address
     *
     * @return \Ebay\Fulfilment\Model\ReturnAddress|null
     */
    public function getReturnAddress()
    {
        return $this->container['return_address'];
    }

    /**
     * Sets return_address
     *
     * @param \Ebay\Fulfilment\Model\ReturnAddress|null $return_address return_address
     *
     * @return self
     */
    public function setReturnAddress($return_address)
    {
        if (is_null($return_address)) {
            throw new \InvalidArgumentException('non-nullable return_address cannot be null');
        }
        $this->container['return_address'] = $return_address;

        return $this;
    }

    /**
     * Gets revision
     *
     * @return int|null
     */
    public function getRevision()
    {
        return $this->container['revision'];
    }

    /**
     * Sets revision
     *
     * @param int|null $revision This integer value indicates the revision number of the payment dispute. Each time an action is taken against a payment dispute, this integer value increases by 1.
     *
     * @return self
     */
    public function setRevision($revision)
    {
        if (is_null($revision)) {
            throw new \InvalidArgumentException('non-nullable revision cannot be null');
        }
        $this->container['revision'] = $revision;

        return $this;
    }

    /**
     * Gets seller_response
     *
     * @return string|null
     */
    public function getSellerResponse()
    {
        return $this->container['seller_response'];
    }

    /**
     * Sets seller_response
     *
     * @param string|null $seller_response The enumeration value returned in this field indicates how the seller has responded to the payment dispute. The seller has the option of accepting the payment dispute and agreeing to issue a refund, accepting the payment dispute and agreeing to issue a refund as long as the buyer returns the item, or contesting the payment dispute. This field is returned as soon as the seller makes an initial decision on the payment dispute. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:SellerResponseEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setSellerResponse($seller_response)
    {
        if (is_null($seller_response)) {
            throw new \InvalidArgumentException('non-nullable seller_response cannot be null');
        }
        $this->container['seller_response'] = $seller_response;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


