<?php
/**
 * Order
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @description This type contains the details of an order, including information about the buyer, order history, shipping fulfillments, line items, costs, payments, and order fulfillment status.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer' => '\Ebay\Fulfilment\Model\Buyer',
        'buyer_checkout_notes' => 'string',
        'cancel_status' => '\Ebay\Fulfilment\Model\CancelStatus',
        'creation_date' => 'string',
        'ebay_collect_and_remit_tax' => 'bool',
        'fulfillment_hrefs' => 'string[]',
        'fulfillment_start_instructions' => '\Ebay\Fulfilment\Model\FulfillmentStartInstruction[]',
        'last_modified_date' => 'string',
        'legacy_order_id' => 'string',
        'line_items' => '\Ebay\Fulfilment\Model\LineItem[]',
        'order_fulfillment_status' => 'string',
        'order_id' => 'string',
        'order_payment_status' => 'string',
        'payment_summary' => '\Ebay\Fulfilment\Model\PaymentSummary',
        'pricing_summary' => '\Ebay\Fulfilment\Model\PricingSummary',
        'program' => '\Ebay\Fulfilment\Model\Program',
        'sales_record_reference' => 'string',
        'seller_id' => 'string',
        'total_fee_basis_amount' => '\Ebay\Fulfilment\Model\Amount',
        'total_marketplace_fee' => '\Ebay\Fulfilment\Model\Amount'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer' => null,
        'buyer_checkout_notes' => null,
        'cancel_status' => null,
        'creation_date' => null,
        'ebay_collect_and_remit_tax' => null,
        'fulfillment_hrefs' => null,
        'fulfillment_start_instructions' => null,
        'last_modified_date' => null,
        'legacy_order_id' => null,
        'line_items' => null,
        'order_fulfillment_status' => null,
        'order_id' => null,
        'order_payment_status' => null,
        'payment_summary' => null,
        'pricing_summary' => null,
        'program' => null,
        'sales_record_reference' => null,
        'seller_id' => null,
        'total_fee_basis_amount' => null,
        'total_marketplace_fee' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer' => false,
        'buyer_checkout_notes' => false,
        'cancel_status' => false,
        'creation_date' => false,
        'ebay_collect_and_remit_tax' => false,
        'fulfillment_hrefs' => false,
        'fulfillment_start_instructions' => false,
        'last_modified_date' => false,
        'legacy_order_id' => false,
        'line_items' => false,
        'order_fulfillment_status' => false,
        'order_id' => false,
        'order_payment_status' => false,
        'payment_summary' => false,
        'pricing_summary' => false,
        'program' => false,
        'sales_record_reference' => false,
        'seller_id' => false,
        'total_fee_basis_amount' => false,
        'total_marketplace_fee' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer' => 'buyer',
        'buyer_checkout_notes' => 'buyerCheckoutNotes',
        'cancel_status' => 'cancelStatus',
        'creation_date' => 'creationDate',
        'ebay_collect_and_remit_tax' => 'ebayCollectAndRemitTax',
        'fulfillment_hrefs' => 'fulfillmentHrefs',
        'fulfillment_start_instructions' => 'fulfillmentStartInstructions',
        'last_modified_date' => 'lastModifiedDate',
        'legacy_order_id' => 'legacyOrderId',
        'line_items' => 'lineItems',
        'order_fulfillment_status' => 'orderFulfillmentStatus',
        'order_id' => 'orderId',
        'order_payment_status' => 'orderPaymentStatus',
        'payment_summary' => 'paymentSummary',
        'pricing_summary' => 'pricingSummary',
        'program' => 'program',
        'sales_record_reference' => 'salesRecordReference',
        'seller_id' => 'sellerId',
        'total_fee_basis_amount' => 'totalFeeBasisAmount',
        'total_marketplace_fee' => 'totalMarketplaceFee'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer' => 'setBuyer',
        'buyer_checkout_notes' => 'setBuyerCheckoutNotes',
        'cancel_status' => 'setCancelStatus',
        'creation_date' => 'setCreationDate',
        'ebay_collect_and_remit_tax' => 'setEbayCollectAndRemitTax',
        'fulfillment_hrefs' => 'setFulfillmentHrefs',
        'fulfillment_start_instructions' => 'setFulfillmentStartInstructions',
        'last_modified_date' => 'setLastModifiedDate',
        'legacy_order_id' => 'setLegacyOrderId',
        'line_items' => 'setLineItems',
        'order_fulfillment_status' => 'setOrderFulfillmentStatus',
        'order_id' => 'setOrderId',
        'order_payment_status' => 'setOrderPaymentStatus',
        'payment_summary' => 'setPaymentSummary',
        'pricing_summary' => 'setPricingSummary',
        'program' => 'setProgram',
        'sales_record_reference' => 'setSalesRecordReference',
        'seller_id' => 'setSellerId',
        'total_fee_basis_amount' => 'setTotalFeeBasisAmount',
        'total_marketplace_fee' => 'setTotalMarketplaceFee'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer' => 'getBuyer',
        'buyer_checkout_notes' => 'getBuyerCheckoutNotes',
        'cancel_status' => 'getCancelStatus',
        'creation_date' => 'getCreationDate',
        'ebay_collect_and_remit_tax' => 'getEbayCollectAndRemitTax',
        'fulfillment_hrefs' => 'getFulfillmentHrefs',
        'fulfillment_start_instructions' => 'getFulfillmentStartInstructions',
        'last_modified_date' => 'getLastModifiedDate',
        'legacy_order_id' => 'getLegacyOrderId',
        'line_items' => 'getLineItems',
        'order_fulfillment_status' => 'getOrderFulfillmentStatus',
        'order_id' => 'getOrderId',
        'order_payment_status' => 'getOrderPaymentStatus',
        'payment_summary' => 'getPaymentSummary',
        'pricing_summary' => 'getPricingSummary',
        'program' => 'getProgram',
        'sales_record_reference' => 'getSalesRecordReference',
        'seller_id' => 'getSellerId',
        'total_fee_basis_amount' => 'getTotalFeeBasisAmount',
        'total_marketplace_fee' => 'getTotalMarketplaceFee'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('buyer', $data ?? [], null);
        $this->setIfExists('buyer_checkout_notes', $data ?? [], null);
        $this->setIfExists('cancel_status', $data ?? [], null);
        $this->setIfExists('creation_date', $data ?? [], null);
        $this->setIfExists('ebay_collect_and_remit_tax', $data ?? [], null);
        $this->setIfExists('fulfillment_hrefs', $data ?? [], null);
        $this->setIfExists('fulfillment_start_instructions', $data ?? [], null);
        $this->setIfExists('last_modified_date', $data ?? [], null);
        $this->setIfExists('legacy_order_id', $data ?? [], null);
        $this->setIfExists('line_items', $data ?? [], null);
        $this->setIfExists('order_fulfillment_status', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('order_payment_status', $data ?? [], null);
        $this->setIfExists('payment_summary', $data ?? [], null);
        $this->setIfExists('pricing_summary', $data ?? [], null);
        $this->setIfExists('program', $data ?? [], null);
        $this->setIfExists('sales_record_reference', $data ?? [], null);
        $this->setIfExists('seller_id', $data ?? [], null);
        $this->setIfExists('total_fee_basis_amount', $data ?? [], null);
        $this->setIfExists('total_marketplace_fee', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer
     *
     * @return \Ebay\Fulfilment\Model\Buyer|null
     */
    public function getBuyer()
    {
        return $this->container['buyer'];
    }

    /**
     * Sets buyer
     *
     * @param \Ebay\Fulfilment\Model\Buyer|null $buyer buyer
     *
     * @return self
     */
    public function setBuyer($buyer)
    {
        if (is_null($buyer)) {
            throw new \InvalidArgumentException('non-nullable buyer cannot be null');
        }
        $this->container['buyer'] = $buyer;

        return $this;
    }

    /**
     * Gets buyer_checkout_notes
     *
     * @return string|null
     */
    public function getBuyerCheckoutNotes()
    {
        return $this->container['buyer_checkout_notes'];
    }

    /**
     * Sets buyer_checkout_notes
     *
     * @param string|null $buyer_checkout_notes This field contains any comments that the buyer left for the seller about the order during checkout process. This field is only returned if a buyer left comments at checkout time.
     *
     * @return self
     */
    public function setBuyerCheckoutNotes($buyer_checkout_notes)
    {
        if (is_null($buyer_checkout_notes)) {
            throw new \InvalidArgumentException('non-nullable buyer_checkout_notes cannot be null');
        }
        $this->container['buyer_checkout_notes'] = $buyer_checkout_notes;

        return $this;
    }

    /**
     * Gets cancel_status
     *
     * @return \Ebay\Fulfilment\Model\CancelStatus|null
     */
    public function getCancelStatus()
    {
        return $this->container['cancel_status'];
    }

    /**
     * Sets cancel_status
     *
     * @param \Ebay\Fulfilment\Model\CancelStatus|null $cancel_status cancel_status
     *
     * @return self
     */
    public function setCancelStatus($cancel_status)
    {
        if (is_null($cancel_status)) {
            throw new \InvalidArgumentException('non-nullable cancel_status cannot be null');
        }
        $this->container['cancel_status'] = $cancel_status;

        return $this;
    }

    /**
     * Gets creation_date
     *
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->container['creation_date'];
    }

    /**
     * Sets creation_date
     *
     * @param string|null $creation_date The date and time that the order was created. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. <br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2015-08-04T19:09:02.768Z</code>
     *
     * @return self
     */
    public function setCreationDate($creation_date)
    {
        if (is_null($creation_date)) {
            throw new \InvalidArgumentException('non-nullable creation_date cannot be null');
        }
        $this->container['creation_date'] = $creation_date;

        return $this;
    }

    /**
     * Gets ebay_collect_and_remit_tax
     *
     * @return bool|null
     */
    public function getEbayCollectAndRemitTax()
    {
        return $this->container['ebay_collect_and_remit_tax'];
    }

    /**
     * Sets ebay_collect_and_remit_tax
     *
     * @param bool|null $ebay_collect_and_remit_tax This field is only returned if <code>true</code>, and indicates that eBay will collect tax (US state-mandated sales tax, Federal and Provincial Sales Tax in Canada, 'Goods and Services' tax in Canada, Australia, and New Zealand, and VAT collected for UK and EU countries,) for at least one line item in the order, and remit the tax to the taxing authority of the buyer's residence. If this field is returned, the seller should search for one or more <strong>ebayCollectAndRemitTaxes</strong> containers at the line item level to get more information about the type of tax and the amount.
     *
     * @return self
     */
    public function setEbayCollectAndRemitTax($ebay_collect_and_remit_tax)
    {
        if (is_null($ebay_collect_and_remit_tax)) {
            throw new \InvalidArgumentException('non-nullable ebay_collect_and_remit_tax cannot be null');
        }
        $this->container['ebay_collect_and_remit_tax'] = $ebay_collect_and_remit_tax;

        return $this;
    }

    /**
     * Gets fulfillment_hrefs
     *
     * @return string[]|null
     */
    public function getFulfillmentHrefs()
    {
        return $this->container['fulfillment_hrefs'];
    }

    /**
     * Sets fulfillment_hrefs
     *
     * @param string[]|null $fulfillment_hrefs This array contains a list of one or more <strong>getShippingFulfillment</strong> call URIs that can be used to retrieve shipping fulfillments that have been set up for the order.
     *
     * @return self
     */
    public function setFulfillmentHrefs($fulfillment_hrefs)
    {
        if (is_null($fulfillment_hrefs)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_hrefs cannot be null');
        }
        $this->container['fulfillment_hrefs'] = $fulfillment_hrefs;

        return $this;
    }

    /**
     * Gets fulfillment_start_instructions
     *
     * @return \Ebay\Fulfilment\Model\FulfillmentStartInstruction[]|null
     */
    public function getFulfillmentStartInstructions()
    {
        return $this->container['fulfillment_start_instructions'];
    }

    /**
     * Sets fulfillment_start_instructions
     *
     * @param \Ebay\Fulfilment\Model\FulfillmentStartInstruction[]|null $fulfillment_start_instructions This container consists of a set of specifications for fulfilling the order, including the type of fulfillment, shipping carrier and service, shipping address, and estimated delivery window. These instructions are derived from the buyer's and seller's eBay account preferences, the listing parameters, and the buyer's checkout selections. The seller can use them as a starting point for packaging, addressing, and shipping the order.<br><br><span class=\"tablenote\"><strong>Note:</strong> Although this container is presented as an array, it currently returns only one set of fulfillment specifications. Additional array members will be supported in future functionality.</span>
     *
     * @return self
     */
    public function setFulfillmentStartInstructions($fulfillment_start_instructions)
    {
        if (is_null($fulfillment_start_instructions)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_start_instructions cannot be null');
        }
        $this->container['fulfillment_start_instructions'] = $fulfillment_start_instructions;

        return $this;
    }

    /**
     * Gets last_modified_date
     *
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->container['last_modified_date'];
    }

    /**
     * Sets last_modified_date
     *
     * @param string|null $last_modified_date The date and time that the order was last modified. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. <br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2015-08-04T19:09:02.768Z</code>
     *
     * @return self
     */
    public function setLastModifiedDate($last_modified_date)
    {
        if (is_null($last_modified_date)) {
            throw new \InvalidArgumentException('non-nullable last_modified_date cannot be null');
        }
        $this->container['last_modified_date'] = $last_modified_date;

        return $this;
    }

    /**
     * Gets legacy_order_id
     *
     * @return string|null
     */
    public function getLegacyOrderId()
    {
        return $this->container['legacy_order_id'];
    }

    /**
     * Sets legacy_order_id
     *
     * @param string|null $legacy_order_id The unique identifier of the order in legacy format, as traditionally used by the Trading API (and other legacy APIs). Both the <b>orderId</b> field and this field are always returned.
     *
     * @return self
     */
    public function setLegacyOrderId($legacy_order_id)
    {
        if (is_null($legacy_order_id)) {
            throw new \InvalidArgumentException('non-nullable legacy_order_id cannot be null');
        }
        $this->container['legacy_order_id'] = $legacy_order_id;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Ebay\Fulfilment\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Ebay\Fulfilment\Model\LineItem[]|null $line_items This array contains the details for all line items that comprise the order.
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        if (is_null($line_items)) {
            throw new \InvalidArgumentException('non-nullable line_items cannot be null');
        }
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets order_fulfillment_status
     *
     * @return string|null
     */
    public function getOrderFulfillmentStatus()
    {
        return $this->container['order_fulfillment_status'];
    }

    /**
     * Sets order_fulfillment_status
     *
     * @param string|null $order_fulfillment_status The degree to which fulfillment of the order is complete. See the <strong>OrderFulfillmentStatus</strong> type definition for more information about each possible fulfillment state. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:OrderFulfillmentStatus'>eBay API documentation</a>
     *
     * @return self
     */
    public function setOrderFulfillmentStatus($order_fulfillment_status)
    {
        if (is_null($order_fulfillment_status)) {
            throw new \InvalidArgumentException('non-nullable order_fulfillment_status cannot be null');
        }
        $this->container['order_fulfillment_status'] = $order_fulfillment_status;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id The unique identifier of the order. Both the <b>legacyOrderId</b> field (traditionally used by Trading and other legacy APIS) and this field are always returned.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets order_payment_status
     *
     * @return string|null
     */
    public function getOrderPaymentStatus()
    {
        return $this->container['order_payment_status'];
    }

    /**
     * Sets order_payment_status
     *
     * @param string|null $order_payment_status The enumeration value returned in this field indicates the current payment status of an order, or in case of a refund request, the current status of the refund. See the <strong>OrderPaymentStatusEnum</strong> type definition for more information about each possible payment/refund state. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:OrderPaymentStatusEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setOrderPaymentStatus($order_payment_status)
    {
        if (is_null($order_payment_status)) {
            throw new \InvalidArgumentException('non-nullable order_payment_status cannot be null');
        }
        $this->container['order_payment_status'] = $order_payment_status;

        return $this;
    }

    /**
     * Gets payment_summary
     *
     * @return \Ebay\Fulfilment\Model\PaymentSummary|null
     */
    public function getPaymentSummary()
    {
        return $this->container['payment_summary'];
    }

    /**
     * Sets payment_summary
     *
     * @param \Ebay\Fulfilment\Model\PaymentSummary|null $payment_summary payment_summary
     *
     * @return self
     */
    public function setPaymentSummary($payment_summary)
    {
        if (is_null($payment_summary)) {
            throw new \InvalidArgumentException('non-nullable payment_summary cannot be null');
        }
        $this->container['payment_summary'] = $payment_summary;

        return $this;
    }

    /**
     * Gets pricing_summary
     *
     * @return \Ebay\Fulfilment\Model\PricingSummary|null
     */
    public function getPricingSummary()
    {
        return $this->container['pricing_summary'];
    }

    /**
     * Sets pricing_summary
     *
     * @param \Ebay\Fulfilment\Model\PricingSummary|null $pricing_summary pricing_summary
     *
     * @return self
     */
    public function setPricingSummary($pricing_summary)
    {
        if (is_null($pricing_summary)) {
            throw new \InvalidArgumentException('non-nullable pricing_summary cannot be null');
        }
        $this->container['pricing_summary'] = $pricing_summary;

        return $this;
    }

    /**
     * Gets program
     *
     * @return \Ebay\Fulfilment\Model\Program|null
     */
    public function getProgram()
    {
        return $this->container['program'];
    }

    /**
     * Sets program
     *
     * @param \Ebay\Fulfilment\Model\Program|null $program program
     *
     * @return self
     */
    public function setProgram($program)
    {
        if (is_null($program)) {
            throw new \InvalidArgumentException('non-nullable program cannot be null');
        }
        $this->container['program'] = $program;

        return $this;
    }

    /**
     * Gets sales_record_reference
     *
     * @return string|null
     */
    public function getSalesRecordReference()
    {
        return $this->container['sales_record_reference'];
    }

    /**
     * Sets sales_record_reference
     *
     * @param string|null $sales_record_reference An eBay-generated identifier that is used to identify and manage orders through the Selling Manager and Selling Manager Pro tools. This order identifier can also be found on the Orders grid page and in the Sales Record pages in Seller Hub. A <strong>salesRecordReference</strong> number is only generated and returned at the order level, and not at the order line item level.<br><br> In cases where the seller does not have a Selling Manager or Selling Manager Pro subscription nor access to Seller Hub, this field may not be returned.
     *
     * @return self
     */
    public function setSalesRecordReference($sales_record_reference)
    {
        if (is_null($sales_record_reference)) {
            throw new \InvalidArgumentException('non-nullable sales_record_reference cannot be null');
        }
        $this->container['sales_record_reference'] = $sales_record_reference;

        return $this;
    }

    /**
     * Gets seller_id
     *
     * @return string|null
     */
    public function getSellerId()
    {
        return $this->container['seller_id'];
    }

    /**
     * Sets seller_id
     *
     * @param string|null $seller_id The unique eBay user ID of the seller who sold the order.
     *
     * @return self
     */
    public function setSellerId($seller_id)
    {
        if (is_null($seller_id)) {
            throw new \InvalidArgumentException('non-nullable seller_id cannot be null');
        }
        $this->container['seller_id'] = $seller_id;

        return $this;
    }

    /**
     * Gets total_fee_basis_amount
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getTotalFeeBasisAmount()
    {
        return $this->container['total_fee_basis_amount'];
    }

    /**
     * Sets total_fee_basis_amount
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $total_fee_basis_amount total_fee_basis_amount
     *
     * @return self
     */
    public function setTotalFeeBasisAmount($total_fee_basis_amount)
    {
        if (is_null($total_fee_basis_amount)) {
            throw new \InvalidArgumentException('non-nullable total_fee_basis_amount cannot be null');
        }
        $this->container['total_fee_basis_amount'] = $total_fee_basis_amount;

        return $this;
    }

    /**
     * Gets total_marketplace_fee
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getTotalMarketplaceFee()
    {
        return $this->container['total_marketplace_fee'];
    }

    /**
     * Sets total_marketplace_fee
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $total_marketplace_fee total_marketplace_fee
     *
     * @return self
     */
    public function setTotalMarketplaceFee($total_marketplace_fee)
    {
        if (is_null($total_marketplace_fee)) {
            throw new \InvalidArgumentException('non-nullable total_marketplace_fee cannot be null');
        }
        $this->container['total_marketplace_fee'] = $total_marketplace_fee;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


