<?php
/**
 * LineItem
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * LineItem Class Doc Comment
 *
 * @category Class
 * @description This type contains the details of each line item in an order.
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class LineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'LineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'applied_promotions' => '\Ebay\Fulfilment\Model\AppliedPromotion[]',
        'delivery_cost' => '\Ebay\Fulfilment\Model\DeliveryCost',
        'discounted_line_item_cost' => '\Ebay\Fulfilment\Model\Amount',
        'ebay_collect_and_remit_taxes' => '\Ebay\Fulfilment\Model\EbayCollectAndRemitTax[]',
        'ebay_collected_charges' => '\Ebay\Fulfilment\Model\EbayCollectedCharges',
        'gift_details' => '\Ebay\Fulfilment\Model\GiftDetails',
        'item_location' => '\Ebay\Fulfilment\Model\ItemLocation',
        'legacy_item_id' => 'string',
        'legacy_variation_id' => 'string',
        'line_item_cost' => '\Ebay\Fulfilment\Model\Amount',
        'line_item_fulfillment_instructions' => '\Ebay\Fulfilment\Model\LineItemFulfillmentInstructions',
        'line_item_fulfillment_status' => 'string',
        'line_item_id' => 'string',
        'linked_order_line_items' => '\Ebay\Fulfilment\Model\LinkedOrderLineItem[]',
        'listing_marketplace_id' => 'string',
        'properties' => '\Ebay\Fulfilment\Model\LineItemProperties',
        'purchase_marketplace_id' => 'string',
        'quantity' => 'int',
        'refunds' => '\Ebay\Fulfilment\Model\LineItemRefund[]',
        'sku' => 'string',
        'sold_format' => 'string',
        'taxes' => '\Ebay\Fulfilment\Model\Tax[]',
        'title' => 'string',
        'total' => '\Ebay\Fulfilment\Model\Amount',
        'variation_aspects' => '\Ebay\Fulfilment\Model\NameValuePair[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'applied_promotions' => null,
        'delivery_cost' => null,
        'discounted_line_item_cost' => null,
        'ebay_collect_and_remit_taxes' => null,
        'ebay_collected_charges' => null,
        'gift_details' => null,
        'item_location' => null,
        'legacy_item_id' => null,
        'legacy_variation_id' => null,
        'line_item_cost' => null,
        'line_item_fulfillment_instructions' => null,
        'line_item_fulfillment_status' => null,
        'line_item_id' => null,
        'linked_order_line_items' => null,
        'listing_marketplace_id' => null,
        'properties' => null,
        'purchase_marketplace_id' => null,
        'quantity' => 'int32',
        'refunds' => null,
        'sku' => null,
        'sold_format' => null,
        'taxes' => null,
        'title' => null,
        'total' => null,
        'variation_aspects' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'applied_promotions' => false,
        'delivery_cost' => false,
        'discounted_line_item_cost' => false,
        'ebay_collect_and_remit_taxes' => false,
        'ebay_collected_charges' => false,
        'gift_details' => false,
        'item_location' => false,
        'legacy_item_id' => false,
        'legacy_variation_id' => false,
        'line_item_cost' => false,
        'line_item_fulfillment_instructions' => false,
        'line_item_fulfillment_status' => false,
        'line_item_id' => false,
        'linked_order_line_items' => false,
        'listing_marketplace_id' => false,
        'properties' => false,
        'purchase_marketplace_id' => false,
        'quantity' => false,
        'refunds' => false,
        'sku' => false,
        'sold_format' => false,
        'taxes' => false,
        'title' => false,
        'total' => false,
        'variation_aspects' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'applied_promotions' => 'appliedPromotions',
        'delivery_cost' => 'deliveryCost',
        'discounted_line_item_cost' => 'discountedLineItemCost',
        'ebay_collect_and_remit_taxes' => 'ebayCollectAndRemitTaxes',
        'ebay_collected_charges' => 'ebayCollectedCharges',
        'gift_details' => 'giftDetails',
        'item_location' => 'itemLocation',
        'legacy_item_id' => 'legacyItemId',
        'legacy_variation_id' => 'legacyVariationId',
        'line_item_cost' => 'lineItemCost',
        'line_item_fulfillment_instructions' => 'lineItemFulfillmentInstructions',
        'line_item_fulfillment_status' => 'lineItemFulfillmentStatus',
        'line_item_id' => 'lineItemId',
        'linked_order_line_items' => 'linkedOrderLineItems',
        'listing_marketplace_id' => 'listingMarketplaceId',
        'properties' => 'properties',
        'purchase_marketplace_id' => 'purchaseMarketplaceId',
        'quantity' => 'quantity',
        'refunds' => 'refunds',
        'sku' => 'sku',
        'sold_format' => 'soldFormat',
        'taxes' => 'taxes',
        'title' => 'title',
        'total' => 'total',
        'variation_aspects' => 'variationAspects'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'applied_promotions' => 'setAppliedPromotions',
        'delivery_cost' => 'setDeliveryCost',
        'discounted_line_item_cost' => 'setDiscountedLineItemCost',
        'ebay_collect_and_remit_taxes' => 'setEbayCollectAndRemitTaxes',
        'ebay_collected_charges' => 'setEbayCollectedCharges',
        'gift_details' => 'setGiftDetails',
        'item_location' => 'setItemLocation',
        'legacy_item_id' => 'setLegacyItemId',
        'legacy_variation_id' => 'setLegacyVariationId',
        'line_item_cost' => 'setLineItemCost',
        'line_item_fulfillment_instructions' => 'setLineItemFulfillmentInstructions',
        'line_item_fulfillment_status' => 'setLineItemFulfillmentStatus',
        'line_item_id' => 'setLineItemId',
        'linked_order_line_items' => 'setLinkedOrderLineItems',
        'listing_marketplace_id' => 'setListingMarketplaceId',
        'properties' => 'setProperties',
        'purchase_marketplace_id' => 'setPurchaseMarketplaceId',
        'quantity' => 'setQuantity',
        'refunds' => 'setRefunds',
        'sku' => 'setSku',
        'sold_format' => 'setSoldFormat',
        'taxes' => 'setTaxes',
        'title' => 'setTitle',
        'total' => 'setTotal',
        'variation_aspects' => 'setVariationAspects'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'applied_promotions' => 'getAppliedPromotions',
        'delivery_cost' => 'getDeliveryCost',
        'discounted_line_item_cost' => 'getDiscountedLineItemCost',
        'ebay_collect_and_remit_taxes' => 'getEbayCollectAndRemitTaxes',
        'ebay_collected_charges' => 'getEbayCollectedCharges',
        'gift_details' => 'getGiftDetails',
        'item_location' => 'getItemLocation',
        'legacy_item_id' => 'getLegacyItemId',
        'legacy_variation_id' => 'getLegacyVariationId',
        'line_item_cost' => 'getLineItemCost',
        'line_item_fulfillment_instructions' => 'getLineItemFulfillmentInstructions',
        'line_item_fulfillment_status' => 'getLineItemFulfillmentStatus',
        'line_item_id' => 'getLineItemId',
        'linked_order_line_items' => 'getLinkedOrderLineItems',
        'listing_marketplace_id' => 'getListingMarketplaceId',
        'properties' => 'getProperties',
        'purchase_marketplace_id' => 'getPurchaseMarketplaceId',
        'quantity' => 'getQuantity',
        'refunds' => 'getRefunds',
        'sku' => 'getSku',
        'sold_format' => 'getSoldFormat',
        'taxes' => 'getTaxes',
        'title' => 'getTitle',
        'total' => 'getTotal',
        'variation_aspects' => 'getVariationAspects'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('applied_promotions', $data ?? [], null);
        $this->setIfExists('delivery_cost', $data ?? [], null);
        $this->setIfExists('discounted_line_item_cost', $data ?? [], null);
        $this->setIfExists('ebay_collect_and_remit_taxes', $data ?? [], null);
        $this->setIfExists('ebay_collected_charges', $data ?? [], null);
        $this->setIfExists('gift_details', $data ?? [], null);
        $this->setIfExists('item_location', $data ?? [], null);
        $this->setIfExists('legacy_item_id', $data ?? [], null);
        $this->setIfExists('legacy_variation_id', $data ?? [], null);
        $this->setIfExists('line_item_cost', $data ?? [], null);
        $this->setIfExists('line_item_fulfillment_instructions', $data ?? [], null);
        $this->setIfExists('line_item_fulfillment_status', $data ?? [], null);
        $this->setIfExists('line_item_id', $data ?? [], null);
        $this->setIfExists('linked_order_line_items', $data ?? [], null);
        $this->setIfExists('listing_marketplace_id', $data ?? [], null);
        $this->setIfExists('properties', $data ?? [], null);
        $this->setIfExists('purchase_marketplace_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('refunds', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('sold_format', $data ?? [], null);
        $this->setIfExists('taxes', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('variation_aspects', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets applied_promotions
     *
     * @return \Ebay\Fulfilment\Model\AppliedPromotion[]|null
     */
    public function getAppliedPromotions()
    {
        return $this->container['applied_promotions'];
    }

    /**
     * Sets applied_promotions
     *
     * @param \Ebay\Fulfilment\Model\AppliedPromotion[]|null $applied_promotions This array contains information about one or more sales promotions or discounts applied to the line item. It is always returned, but will be returned as an empty array if no special sales promotions or discounts apply to the order line item.
     *
     * @return self
     */
    public function setAppliedPromotions($applied_promotions)
    {
        if (is_null($applied_promotions)) {
            throw new \InvalidArgumentException('non-nullable applied_promotions cannot be null');
        }
        $this->container['applied_promotions'] = $applied_promotions;

        return $this;
    }

    /**
     * Gets delivery_cost
     *
     * @return \Ebay\Fulfilment\Model\DeliveryCost|null
     */
    public function getDeliveryCost()
    {
        return $this->container['delivery_cost'];
    }

    /**
     * Sets delivery_cost
     *
     * @param \Ebay\Fulfilment\Model\DeliveryCost|null $delivery_cost delivery_cost
     *
     * @return self
     */
    public function setDeliveryCost($delivery_cost)
    {
        if (is_null($delivery_cost)) {
            throw new \InvalidArgumentException('non-nullable delivery_cost cannot be null');
        }
        $this->container['delivery_cost'] = $delivery_cost;

        return $this;
    }

    /**
     * Gets discounted_line_item_cost
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getDiscountedLineItemCost()
    {
        return $this->container['discounted_line_item_cost'];
    }

    /**
     * Sets discounted_line_item_cost
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $discounted_line_item_cost discounted_line_item_cost
     *
     * @return self
     */
    public function setDiscountedLineItemCost($discounted_line_item_cost)
    {
        if (is_null($discounted_line_item_cost)) {
            throw new \InvalidArgumentException('non-nullable discounted_line_item_cost cannot be null');
        }
        $this->container['discounted_line_item_cost'] = $discounted_line_item_cost;

        return $this;
    }

    /**
     * Gets ebay_collect_and_remit_taxes
     *
     * @return \Ebay\Fulfilment\Model\EbayCollectAndRemitTax[]|null
     */
    public function getEbayCollectAndRemitTaxes()
    {
        return $this->container['ebay_collect_and_remit_taxes'];
    }

    /**
     * Sets ebay_collect_and_remit_taxes
     *
     * @param \Ebay\Fulfilment\Model\EbayCollectAndRemitTax[]|null $ebay_collect_and_remit_taxes This container will be returned if the order line item is subject to a 'Collect and Remit' tax that eBay will collect and remit to the proper taxing authority on the buyer's behalf.<br><br>'Collect and Remit' tax includes:<ul><li>US state-mandated sales tax</li><li>Federal and Provincial Sales Tax in Canada</li><li>'Goods and Services' tax in Canada, Australia, New Zealand, and Jersey</li><li>VAT collected for the UK, EU countries, Kazakhstan, and Belarus</li><li>Sales & Service Tax (SST) in Malaysia</li></ul>The amount of this tax is shown in the <strong>amount</strong> field, and the type of tax is shown in the <strong>taxType</strong> field.<br><br>eBay will display the tax type and amount during checkout in accordance with the buyer's address, and handle collection and remittance of the tax without requiring the seller to take any action.
     *
     * @return self
     */
    public function setEbayCollectAndRemitTaxes($ebay_collect_and_remit_taxes)
    {
        if (is_null($ebay_collect_and_remit_taxes)) {
            throw new \InvalidArgumentException('non-nullable ebay_collect_and_remit_taxes cannot be null');
        }
        $this->container['ebay_collect_and_remit_taxes'] = $ebay_collect_and_remit_taxes;

        return $this;
    }

    /**
     * Gets ebay_collected_charges
     *
     * @return \Ebay\Fulfilment\Model\EbayCollectedCharges|null
     */
    public function getEbayCollectedCharges()
    {
        return $this->container['ebay_collected_charges'];
    }

    /**
     * Sets ebay_collected_charges
     *
     * @param \Ebay\Fulfilment\Model\EbayCollectedCharges|null $ebay_collected_charges ebay_collected_charges
     *
     * @return self
     */
    public function setEbayCollectedCharges($ebay_collected_charges)
    {
        if (is_null($ebay_collected_charges)) {
            throw new \InvalidArgumentException('non-nullable ebay_collected_charges cannot be null');
        }
        $this->container['ebay_collected_charges'] = $ebay_collected_charges;

        return $this;
    }

    /**
     * Gets gift_details
     *
     * @return \Ebay\Fulfilment\Model\GiftDetails|null
     */
    public function getGiftDetails()
    {
        return $this->container['gift_details'];
    }

    /**
     * Sets gift_details
     *
     * @param \Ebay\Fulfilment\Model\GiftDetails|null $gift_details gift_details
     *
     * @return self
     */
    public function setGiftDetails($gift_details)
    {
        if (is_null($gift_details)) {
            throw new \InvalidArgumentException('non-nullable gift_details cannot be null');
        }
        $this->container['gift_details'] = $gift_details;

        return $this;
    }

    /**
     * Gets item_location
     *
     * @return \Ebay\Fulfilment\Model\ItemLocation|null
     */
    public function getItemLocation()
    {
        return $this->container['item_location'];
    }

    /**
     * Sets item_location
     *
     * @param \Ebay\Fulfilment\Model\ItemLocation|null $item_location item_location
     *
     * @return self
     */
    public function setItemLocation($item_location)
    {
        if (is_null($item_location)) {
            throw new \InvalidArgumentException('non-nullable item_location cannot be null');
        }
        $this->container['item_location'] = $item_location;

        return $this;
    }

    /**
     * Gets legacy_item_id
     *
     * @return string|null
     */
    public function getLegacyItemId()
    {
        return $this->container['legacy_item_id'];
    }

    /**
     * Sets legacy_item_id
     *
     * @param string|null $legacy_item_id The eBay-generated legacy listing item ID of the listing. Note that the unique identifier of a listing in REST-based APIs is called the <strong>listingId</strong> instead.
     *
     * @return self
     */
    public function setLegacyItemId($legacy_item_id)
    {
        if (is_null($legacy_item_id)) {
            throw new \InvalidArgumentException('non-nullable legacy_item_id cannot be null');
        }
        $this->container['legacy_item_id'] = $legacy_item_id;

        return $this;
    }

    /**
     * Gets legacy_variation_id
     *
     * @return string|null
     */
    public function getLegacyVariationId()
    {
        return $this->container['legacy_variation_id'];
    }

    /**
     * Sets legacy_variation_id
     *
     * @param string|null $legacy_variation_id The unique identifier of a single variation within a multiple-variation listing. This field is only returned if the line item purchased was from a multiple-variation listing.
     *
     * @return self
     */
    public function setLegacyVariationId($legacy_variation_id)
    {
        if (is_null($legacy_variation_id)) {
            throw new \InvalidArgumentException('non-nullable legacy_variation_id cannot be null');
        }
        $this->container['legacy_variation_id'] = $legacy_variation_id;

        return $this;
    }

    /**
     * Gets line_item_cost
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getLineItemCost()
    {
        return $this->container['line_item_cost'];
    }

    /**
     * Sets line_item_cost
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $line_item_cost line_item_cost
     *
     * @return self
     */
    public function setLineItemCost($line_item_cost)
    {
        if (is_null($line_item_cost)) {
            throw new \InvalidArgumentException('non-nullable line_item_cost cannot be null');
        }
        $this->container['line_item_cost'] = $line_item_cost;

        return $this;
    }

    /**
     * Gets line_item_fulfillment_instructions
     *
     * @return \Ebay\Fulfilment\Model\LineItemFulfillmentInstructions|null
     */
    public function getLineItemFulfillmentInstructions()
    {
        return $this->container['line_item_fulfillment_instructions'];
    }

    /**
     * Sets line_item_fulfillment_instructions
     *
     * @param \Ebay\Fulfilment\Model\LineItemFulfillmentInstructions|null $line_item_fulfillment_instructions line_item_fulfillment_instructions
     *
     * @return self
     */
    public function setLineItemFulfillmentInstructions($line_item_fulfillment_instructions)
    {
        if (is_null($line_item_fulfillment_instructions)) {
            throw new \InvalidArgumentException('non-nullable line_item_fulfillment_instructions cannot be null');
        }
        $this->container['line_item_fulfillment_instructions'] = $line_item_fulfillment_instructions;

        return $this;
    }

    /**
     * Gets line_item_fulfillment_status
     *
     * @return string|null
     */
    public function getLineItemFulfillmentStatus()
    {
        return $this->container['line_item_fulfillment_status'];
    }

    /**
     * Sets line_item_fulfillment_status
     *
     * @param string|null $line_item_fulfillment_status This enumeration value indicates the current fulfillment status of the line item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:LineItemFulfillmentStatusEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setLineItemFulfillmentStatus($line_item_fulfillment_status)
    {
        if (is_null($line_item_fulfillment_status)) {
            throw new \InvalidArgumentException('non-nullable line_item_fulfillment_status cannot be null');
        }
        $this->container['line_item_fulfillment_status'] = $line_item_fulfillment_status;

        return $this;
    }

    /**
     * Gets line_item_id
     *
     * @return string|null
     */
    public function getLineItemId()
    {
        return $this->container['line_item_id'];
    }

    /**
     * Sets line_item_id
     *
     * @param string|null $line_item_id This is the unique identifier of an eBay order line item. This field is created as soon as there is a commitment to buy from the seller.
     *
     * @return self
     */
    public function setLineItemId($line_item_id)
    {
        if (is_null($line_item_id)) {
            throw new \InvalidArgumentException('non-nullable line_item_id cannot be null');
        }
        $this->container['line_item_id'] = $line_item_id;

        return $this;
    }

    /**
     * Gets linked_order_line_items
     *
     * @return \Ebay\Fulfilment\Model\LinkedOrderLineItem[]|null
     */
    public function getLinkedOrderLineItems()
    {
        return $this->container['linked_order_line_items'];
    }

    /**
     * Sets linked_order_line_items
     *
     * @param \Ebay\Fulfilment\Model\LinkedOrderLineItem[]|null $linked_order_line_items An array of one or more line items related to the corresponding order, but not a part of that order. Details include the order ID, line item ID, and title of the linked line item, the seller of that item, item specifics, estimated delivery times, and shipment tracking (if available).
     *
     * @return self
     */
    public function setLinkedOrderLineItems($linked_order_line_items)
    {
        if (is_null($linked_order_line_items)) {
            throw new \InvalidArgumentException('non-nullable linked_order_line_items cannot be null');
        }
        $this->container['linked_order_line_items'] = $linked_order_line_items;

        return $this;
    }

    /**
     * Gets listing_marketplace_id
     *
     * @return string|null
     */
    public function getListingMarketplaceId()
    {
        return $this->container['listing_marketplace_id'];
    }

    /**
     * Sets listing_marketplace_id
     *
     * @param string|null $listing_marketplace_id The unique identifier of the eBay marketplace where the line item was listed. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/ba:MarketplaceIdEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setListingMarketplaceId($listing_marketplace_id)
    {
        if (is_null($listing_marketplace_id)) {
            throw new \InvalidArgumentException('non-nullable listing_marketplace_id cannot be null');
        }
        $this->container['listing_marketplace_id'] = $listing_marketplace_id;

        return $this;
    }

    /**
     * Gets properties
     *
     * @return \Ebay\Fulfilment\Model\LineItemProperties|null
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     *
     * @param \Ebay\Fulfilment\Model\LineItemProperties|null $properties properties
     *
     * @return self
     */
    public function setProperties($properties)
    {
        if (is_null($properties)) {
            throw new \InvalidArgumentException('non-nullable properties cannot be null');
        }
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets purchase_marketplace_id
     *
     * @return string|null
     */
    public function getPurchaseMarketplaceId()
    {
        return $this->container['purchase_marketplace_id'];
    }

    /**
     * Sets purchase_marketplace_id
     *
     * @param string|null $purchase_marketplace_id The unique identifier of the eBay marketplace where the line item was listed. Often, the <strong>listingMarketplaceId</strong> and the <strong>purchaseMarketplaceId</strong> identifier are the same, but there are occasions when an item will surface on multiple eBay marketplaces. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/ba:MarketplaceIdEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setPurchaseMarketplaceId($purchase_marketplace_id)
    {
        if (is_null($purchase_marketplace_id)) {
            throw new \InvalidArgumentException('non-nullable purchase_marketplace_id cannot be null');
        }
        $this->container['purchase_marketplace_id'] = $purchase_marketplace_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity The number of units of the line item in the order. These are represented as a group by a single <b>lineItemId</b>.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets refunds
     *
     * @return \Ebay\Fulfilment\Model\LineItemRefund[]|null
     */
    public function getRefunds()
    {
        return $this->container['refunds'];
    }

    /**
     * Sets refunds
     *
     * @param \Ebay\Fulfilment\Model\LineItemRefund[]|null $refunds This array is always returned, but is returned as an empty array unless the seller has submitted a partial or full refund to the buyer for the order. If a refund has occurred, the refund amount and refund date will be shown for each refund.
     *
     * @return self
     */
    public function setRefunds($refunds)
    {
        if (is_null($refunds)) {
            throw new \InvalidArgumentException('non-nullable refunds cannot be null');
        }
        $this->container['refunds'] = $refunds;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Seller-defined Stock-Keeping Unit (SKU). This inventory identifier must be unique within the seller's eBay inventory. SKUs are optional when listing in the legacy/Trading API system, but SKUs are required when listing items through the Inventory API model.
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets sold_format
     *
     * @return string|null
     */
    public function getSoldFormat()
    {
        return $this->container['sold_format'];
    }

    /**
     * Sets sold_format
     *
     * @param string|null $sold_format The eBay listing type of the line item. The most common listing types are <code>AUCTION</code> and <code>FIXED_PRICE</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:SoldFormatEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setSoldFormat($sold_format)
    {
        if (is_null($sold_format)) {
            throw new \InvalidArgumentException('non-nullable sold_format cannot be null');
        }
        $this->container['sold_format'] = $sold_format;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Ebay\Fulfilment\Model\Tax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Ebay\Fulfilment\Model\Tax[]|null $taxes Contains a list of taxes applied to the line item, if any. This array is always returned, but will be returned as empty if no taxes are applicable to the line item.
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        if (is_null($taxes)) {
            throw new \InvalidArgumentException('non-nullable taxes cannot be null');
        }
        $this->container['taxes'] = $taxes;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The title of the listing.<br><br><span class=\"tablenote\"><b>Note:</b> The Item ID value for the listing will be returned in this field instead of the actual title if this particular listing is on-hold due to an eBay policy violation.</span>
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets total
     *
     * @return \Ebay\Fulfilment\Model\Amount|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param \Ebay\Fulfilment\Model\Amount|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets variation_aspects
     *
     * @return \Ebay\Fulfilment\Model\NameValuePair[]|null
     */
    public function getVariationAspects()
    {
        return $this->container['variation_aspects'];
    }

    /**
     * Sets variation_aspects
     *
     * @param \Ebay\Fulfilment\Model\NameValuePair[]|null $variation_aspects An array of aspect name-value pairs that identifies the specific variation of a multi-variation listing. This array can contain multiple name-value pairs, such as <code>color:blue</code> and <code>size:large</code>, and will only be returned for orders created from a multiple-variation listing.
     *
     * @return self
     */
    public function setVariationAspects($variation_aspects)
    {
        if (is_null($variation_aspects)) {
            throw new \InvalidArgumentException('non-nullable variation_aspects cannot be null');
        }
        $this->container['variation_aspects'] = $variation_aspects;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


