<?php
/**
 * AppointmentDetails
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Fulfillment API
 *
 * Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.
 *
 * The version of the OpenAPI document: v1.20.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Fulfilment\Model;

use \ArrayAccess;
use \Ebay\Fulfilment\ObjectSerializer;

/**
 * AppointmentDetails Class Doc Comment
 *
 * @category Class
 * @description This type contains information used by the installation provider concerning appointment details selected by the buyer
 * @package  Ebay\Fulfilment
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AppointmentDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AppointmentDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'appointment_end_time' => 'string',
        'appointment_start_time' => 'string',
        'appointment_status' => 'string',
        'appointment_type' => 'string',
        'appointment_window' => 'string',
        'service_provider_appointment_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'appointment_end_time' => null,
        'appointment_start_time' => null,
        'appointment_status' => null,
        'appointment_type' => null,
        'appointment_window' => null,
        'service_provider_appointment_date' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'appointment_end_time' => false,
        'appointment_start_time' => false,
        'appointment_status' => false,
        'appointment_type' => false,
        'appointment_window' => false,
        'service_provider_appointment_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'appointment_end_time' => 'appointmentEndTime',
        'appointment_start_time' => 'appointmentStartTime',
        'appointment_status' => 'appointmentStatus',
        'appointment_type' => 'appointmentType',
        'appointment_window' => 'appointmentWindow',
        'service_provider_appointment_date' => 'serviceProviderAppointmentDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'appointment_end_time' => 'setAppointmentEndTime',
        'appointment_start_time' => 'setAppointmentStartTime',
        'appointment_status' => 'setAppointmentStatus',
        'appointment_type' => 'setAppointmentType',
        'appointment_window' => 'setAppointmentWindow',
        'service_provider_appointment_date' => 'setServiceProviderAppointmentDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'appointment_end_time' => 'getAppointmentEndTime',
        'appointment_start_time' => 'getAppointmentStartTime',
        'appointment_status' => 'getAppointmentStatus',
        'appointment_type' => 'getAppointmentType',
        'appointment_window' => 'getAppointmentWindow',
        'service_provider_appointment_date' => 'getServiceProviderAppointmentDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('appointment_end_time', $data ?? [], null);
        $this->setIfExists('appointment_start_time', $data ?? [], null);
        $this->setIfExists('appointment_status', $data ?? [], null);
        $this->setIfExists('appointment_type', $data ?? [], null);
        $this->setIfExists('appointment_window', $data ?? [], null);
        $this->setIfExists('service_provider_appointment_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets appointment_end_time
     *
     * @return string|null
     */
    public function getAppointmentEndTime()
    {
        return $this->container['appointment_end_time'];
    }

    /**
     * Sets appointment_end_time
     *
     * @param string|null $appointment_end_time The date and time the appointment ends, formatted as an <a href=\"https://www.iso.org/iso-8601-date-and-time-format.html \" title=\"https://www.iso.org \" target=\"_blank\">ISO 8601</a> string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Required for tire installation. <br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2022-10-28T00:00:00.000Z</code>
     *
     * @return self
     */
    public function setAppointmentEndTime($appointment_end_time)
    {
        if (is_null($appointment_end_time)) {
            throw new \InvalidArgumentException('non-nullable appointment_end_time cannot be null');
        }
        $this->container['appointment_end_time'] = $appointment_end_time;

        return $this;
    }

    /**
     * Gets appointment_start_time
     *
     * @return string|null
     */
    public function getAppointmentStartTime()
    {
        return $this->container['appointment_start_time'];
    }

    /**
     * Sets appointment_start_time
     *
     * @param string|null $appointment_start_time The date and time the appointment begins, formatted as an <a href=\"https://www.iso.org/iso-8601-date-and-time-format.html \" title=\"https://www.iso.org \" target=\"_blank\">ISO 8601</a> string, which is based on the 24-hour Coordinated Universal Time (UTC) clock.  <br><br><b>Format:</b> <code>[YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z</code> <br><b>Example:</b> <code>2022-10-28T00:10:00.000Z</code>
     *
     * @return self
     */
    public function setAppointmentStartTime($appointment_start_time)
    {
        if (is_null($appointment_start_time)) {
            throw new \InvalidArgumentException('non-nullable appointment_start_time cannot be null');
        }
        $this->container['appointment_start_time'] = $appointment_start_time;

        return $this;
    }

    /**
     * Gets appointment_status
     *
     * @return string|null
     */
    public function getAppointmentStatus()
    {
        return $this->container['appointment_status'];
    }

    /**
     * Sets appointment_status
     *
     * @param string|null $appointment_status The status of the appointment. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:AppointmentStatusEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setAppointmentStatus($appointment_status)
    {
        if (is_null($appointment_status)) {
            throw new \InvalidArgumentException('non-nullable appointment_status cannot be null');
        }
        $this->container['appointment_status'] = $appointment_status;

        return $this;
    }

    /**
     * Gets appointment_type
     *
     * @return string|null
     */
    public function getAppointmentType()
    {
        return $this->container['appointment_type'];
    }

    /**
     * Sets appointment_type
     *
     * @param string|null $appointment_type The type of appointment. MACRO appointments only have a start time (not bounded with end time). TIME_SLOT appointments have a period (both start time and end time). Required for tire installation. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:AppointmentTypeEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setAppointmentType($appointment_type)
    {
        if (is_null($appointment_type)) {
            throw new \InvalidArgumentException('non-nullable appointment_type cannot be null');
        }
        $this->container['appointment_type'] = $appointment_type;

        return $this;
    }

    /**
     * Gets appointment_window
     *
     * @return string|null
     */
    public function getAppointmentWindow()
    {
        return $this->container['appointment_window'];
    }

    /**
     * Sets appointment_window
     *
     * @param string|null $appointment_window Appointment window for MACRO appointments. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:AppointmentWindowEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setAppointmentWindow($appointment_window)
    {
        if (is_null($appointment_window)) {
            throw new \InvalidArgumentException('non-nullable appointment_window cannot be null');
        }
        $this->container['appointment_window'] = $appointment_window;

        return $this;
    }

    /**
     * Gets service_provider_appointment_date
     *
     * @return string|null
     */
    public function getServiceProviderAppointmentDate()
    {
        return $this->container['service_provider_appointment_date'];
    }

    /**
     * Sets service_provider_appointment_date
     *
     * @param string|null $service_provider_appointment_date Service provider date of the appointment (no time stamp). Returned only for MACRO appointment types.
     *
     * @return self
     */
    public function setServiceProviderAppointmentDate($service_provider_appointment_date)
    {
        if (is_null($service_provider_appointment_date)) {
            throw new \InvalidArgumentException('non-nullable service_provider_appointment_date cannot be null');
        }
        $this->container['service_provider_appointment_date'] = $service_provider_appointment_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


