# # Refund

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**refund_id** | **string** | The unique identifier of the order refund. This value is returned unless the refund operation fails (&lt;b&gt;refundStatus&lt;/b&gt; value shows &lt;code&gt;FAILED&lt;/code&gt;). This identifier can be used to track the status of the refund through a &lt;b&gt;getOrder&lt;/b&gt; or &lt;b&gt;getOrders&lt;/b&gt; call. For order-level refunds, check the &lt;b&gt;paymentSummary.refunds.refundId&lt;/b&gt; field in the &lt;b&gt;getOrder&lt;/b&gt;/&lt;b&gt;getOrders&lt;/b&gt; response, and for line item level refunds, check the &lt;b&gt;lineItems.refunds.refundId&lt;/b&gt; field(s) in the &lt;b&gt;getOrder&lt;/b&gt;/&lt;b&gt;getOrders&lt;/b&gt; response. | [optional]
**refund_status** | **string** | The value returned in this field indicates the success or failure of the refund operation. A successful &lt;b&gt;issueRefund&lt;/b&gt; operation should result in a value of &lt;code&gt;PENDING&lt;/code&gt;. A failed &lt;b&gt;issueRefund&lt;/b&gt; operation should result in a value of &lt;code&gt;FAILED&lt;/code&gt;, and an HTTP status code and/or and API error code may also get returned to possibly indicate the issue.&lt;br&gt;&lt;br&gt;The refunds issued through this method are processed asynchronously, so the refund will not show as &#39;Refunded&#39; right away. A seller will have to make a subsequent &lt;a href&#x3D;\&quot;https://developer.ebay.com/api-docs/sell/fulfillment/resources/order/methods/getOrder\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOrder&lt;/a&gt; call to check the status of the refund.  The status of an order refund can be found in the &lt;a href&#x3D;\&quot;https://developer.ebay.com/api-docs/sell/fulfillment/resources/order/methods/getOrder#response.paymentSummary.refunds.refundStatus\&quot; target&#x3D;\&quot;_blank\&quot;&gt;paymentSummary.refunds.refundStatus&lt;/a&gt; field of the &lt;a href&#x3D;\&quot;https://developer.ebay.com/api-docs/sell/fulfillment/resources/order/methods/getOrder\&quot; target&#x3D;\&quot;_blank\&quot;&gt;getOrder&lt;/a&gt; response. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/fulfillment/types/sel:RefundStatusEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
