<?php
/**
 * ShippingOption
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account API
 *
 * The <b>Account API</b> gives sellers the ability to configure their eBay seller accounts, including the seller's policies (eBay business policies and seller-defined custom policies), opt in and out of eBay seller programs, configure sales tax tables, and get account information.  <br><br>For details on the availability of the methods in this API, see <a href=\"/api-docs/sell/account/overview.html#requirements\">Account API requirements and restrictions</a>.
 *
 * The version of the OpenAPI document: v1.9.2
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Account\Model;

use \ArrayAccess;
use \Ebay\Account\ObjectSerializer;

/**
 * ShippingOption Class Doc Comment
 *
 * @category Class
 * @description This type is used by the &lt;b&gt;shippingOptions&lt;/b&gt; array, which is used to provide detailed information on the domestic and international shipping options available for the policy. A separate &lt;b&gt;ShippingOption&lt;/b&gt; object covers domestic shipping service options and international shipping service options (if the seller ships to international locations).
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShippingOption implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShippingOption';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cost_type' => 'string',
        'insurance_fee' => '\Ebay\Account\Model\Amount',
        'insurance_offered' => 'bool',
        'option_type' => 'string',
        'package_handling_cost' => '\Ebay\Account\Model\Amount',
        'rate_table_id' => 'string',
        'shipping_discount_profile_id' => 'string',
        'shipping_promotion_offered' => 'bool',
        'shipping_services' => '\Ebay\Account\Model\ShippingService[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cost_type' => null,
        'insurance_fee' => null,
        'insurance_offered' => null,
        'option_type' => null,
        'package_handling_cost' => null,
        'rate_table_id' => null,
        'shipping_discount_profile_id' => null,
        'shipping_promotion_offered' => null,
        'shipping_services' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'cost_type' => false,
        'insurance_fee' => false,
        'insurance_offered' => false,
        'option_type' => false,
        'package_handling_cost' => false,
        'rate_table_id' => false,
        'shipping_discount_profile_id' => false,
        'shipping_promotion_offered' => false,
        'shipping_services' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cost_type' => 'costType',
        'insurance_fee' => 'insuranceFee',
        'insurance_offered' => 'insuranceOffered',
        'option_type' => 'optionType',
        'package_handling_cost' => 'packageHandlingCost',
        'rate_table_id' => 'rateTableId',
        'shipping_discount_profile_id' => 'shippingDiscountProfileId',
        'shipping_promotion_offered' => 'shippingPromotionOffered',
        'shipping_services' => 'shippingServices'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cost_type' => 'setCostType',
        'insurance_fee' => 'setInsuranceFee',
        'insurance_offered' => 'setInsuranceOffered',
        'option_type' => 'setOptionType',
        'package_handling_cost' => 'setPackageHandlingCost',
        'rate_table_id' => 'setRateTableId',
        'shipping_discount_profile_id' => 'setShippingDiscountProfileId',
        'shipping_promotion_offered' => 'setShippingPromotionOffered',
        'shipping_services' => 'setShippingServices'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cost_type' => 'getCostType',
        'insurance_fee' => 'getInsuranceFee',
        'insurance_offered' => 'getInsuranceOffered',
        'option_type' => 'getOptionType',
        'package_handling_cost' => 'getPackageHandlingCost',
        'rate_table_id' => 'getRateTableId',
        'shipping_discount_profile_id' => 'getShippingDiscountProfileId',
        'shipping_promotion_offered' => 'getShippingPromotionOffered',
        'shipping_services' => 'getShippingServices'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('cost_type', $data ?? [], null);
        $this->setIfExists('insurance_fee', $data ?? [], null);
        $this->setIfExists('insurance_offered', $data ?? [], null);
        $this->setIfExists('option_type', $data ?? [], null);
        $this->setIfExists('package_handling_cost', $data ?? [], null);
        $this->setIfExists('rate_table_id', $data ?? [], null);
        $this->setIfExists('shipping_discount_profile_id', $data ?? [], null);
        $this->setIfExists('shipping_promotion_offered', $data ?? [], null);
        $this->setIfExists('shipping_services', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cost_type
     *
     * @return string|null
     */
    public function getCostType()
    {
        return $this->container['cost_type'];
    }

    /**
     * Sets cost_type
     *
     * @param string|null $cost_type This field defines whether the shipping cost model is <code>FLAT_RATE</code> (the same rate for all buyers, or buyers within a region if shipping rate tables are used) or <code>CALCULATED</code> (the shipping rate varies by the ship-to location and size and weight of the package). <br><br>This field is conditionally required if any shipping service options are specified (domestic and/or international). For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/account/types/api:ShippingCostTypeEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setCostType($cost_type)
    {
        if (is_null($cost_type)) {
            throw new \InvalidArgumentException('non-nullable cost_type cannot be null');
        }
        $this->container['cost_type'] = $cost_type;

        return $this;
    }

    /**
     * Gets insurance_fee
     *
     * @return \Ebay\Account\Model\Amount|null
     */
    public function getInsuranceFee()
    {
        return $this->container['insurance_fee'];
    }

    /**
     * Sets insurance_fee
     *
     * @param \Ebay\Account\Model\Amount|null $insurance_fee insurance_fee
     *
     * @return self
     */
    public function setInsuranceFee($insurance_fee)
    {
        if (is_null($insurance_fee)) {
            throw new \InvalidArgumentException('non-nullable insurance_fee cannot be null');
        }
        $this->container['insurance_fee'] = $insurance_fee;

        return $this;
    }

    /**
     * Gets insurance_offered
     *
     * @return bool|null
     */
    public function getInsuranceOffered()
    {
        return $this->container['insurance_offered'];
    }

    /**
     * Sets insurance_offered
     *
     * @param bool|null $insurance_offered This field has been deprecated. <br><br>Shipping insurance is offered only via a shipping carrier's shipping services and is no longer available via eBay shipping policies.
     *
     * @return self
     */
    public function setInsuranceOffered($insurance_offered)
    {
        if (is_null($insurance_offered)) {
            throw new \InvalidArgumentException('non-nullable insurance_offered cannot be null');
        }
        $this->container['insurance_offered'] = $insurance_offered;

        return $this;
    }

    /**
     * Gets option_type
     *
     * @return string|null
     */
    public function getOptionType()
    {
        return $this->container['option_type'];
    }

    /**
     * Sets option_type
     *
     * @param string|null $option_type This field is used to indicate if the corresponding shipping service options (under <b>shippingServices</b> array) are domestic or international shipping service options. This field is conditionally required if any shipping service options are specified (domestic and/or international). For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/account/types/api:ShippingOptionTypeEnum'>eBay API documentation</a>
     *
     * @return self
     */
    public function setOptionType($option_type)
    {
        if (is_null($option_type)) {
            throw new \InvalidArgumentException('non-nullable option_type cannot be null');
        }
        $this->container['option_type'] = $option_type;

        return $this;
    }

    /**
     * Gets package_handling_cost
     *
     * @return \Ebay\Account\Model\Amount|null
     */
    public function getPackageHandlingCost()
    {
        return $this->container['package_handling_cost'];
    }

    /**
     * Sets package_handling_cost
     *
     * @param \Ebay\Account\Model\Amount|null $package_handling_cost package_handling_cost
     *
     * @return self
     */
    public function setPackageHandlingCost($package_handling_cost)
    {
        if (is_null($package_handling_cost)) {
            throw new \InvalidArgumentException('non-nullable package_handling_cost cannot be null');
        }
        $this->container['package_handling_cost'] = $package_handling_cost;

        return $this;
    }

    /**
     * Gets rate_table_id
     *
     * @return string|null
     */
    public function getRateTableId()
    {
        return $this->container['rate_table_id'];
    }

    /**
     * Sets rate_table_id
     *
     * @param string|null $rate_table_id This field is used if the seller wants to associate a domestic or international shipping rate table to the fulfillment business policy. The <a href=\"/api-docs/sell/account/resources/rate_table/methods/getRateTables\">getRateTables</a> method can be used to retrieve shipping rate table IDs.<br><br>With domestic and international shipping rate tables, the seller can set different shipping costs based on shipping regions and shipping speed/level of service (one-day, expedited, standard, economy). There are also options to additional per-weight and handling charges.<br><br>Sellers need to be careful that shipping rate tables match the corresponding shipping service options. In other words, a domestic shipping rate table must not be specified in the same container where international shipping service options are being specified, and vice versa, and the shipping speed/level of service of the provided shipping service options should match the shipping speed/level of service options that are defined in the shipping rate tables. <br><br>For example, if the corresponding shipping rate table defines costs for one-day shipping services, there should be at least one one-day shipping service option specified under the <b>shippingServices</b> array.<br><br>This field is returned if set.
     *
     * @return self
     */
    public function setRateTableId($rate_table_id)
    {
        if (is_null($rate_table_id)) {
            throw new \InvalidArgumentException('non-nullable rate_table_id cannot be null');
        }
        $this->container['rate_table_id'] = $rate_table_id;

        return $this;
    }

    /**
     * Gets shipping_discount_profile_id
     *
     * @return string|null
     */
    public function getShippingDiscountProfileId()
    {
        return $this->container['shipping_discount_profile_id'];
    }

    /**
     * Sets shipping_discount_profile_id
     *
     * @param string|null $shipping_discount_profile_id This field is the unique identifier of a seller's domestic or international shipping discount profile. If a buyer satisfies the requirements of the discount rule, this buyer will receive a shipping discount for the order. <br><br>The seller can create and manage shipping discount profiles using (Get/Set) <b>ShippingDiscountProfiles</b> calls in the <b>Trading API</b> or through the <b>Shipping Preferences</b> in <b>My eBay</b>. <br><br><span class=\"tablenote\"><b>Note: </b>Initially, shipping discount profiles in the <b>Account API</b> will <i>not</i> be available to all sellers.</span>
     *
     * @return self
     */
    public function setShippingDiscountProfileId($shipping_discount_profile_id)
    {
        if (is_null($shipping_discount_profile_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_discount_profile_id cannot be null');
        }
        $this->container['shipping_discount_profile_id'] = $shipping_discount_profile_id;

        return $this;
    }

    /**
     * Gets shipping_promotion_offered
     *
     * @return bool|null
     */
    public function getShippingPromotionOffered()
    {
        return $this->container['shipping_promotion_offered'];
    }

    /**
     * Sets shipping_promotion_offered
     *
     * @param bool|null $shipping_promotion_offered This boolean indicates whether or not the seller has set up a promotional shipping discount that will be available to buyers who satisfy the requirements of the shipping discount rule. <br><br>The seller can create and manage shipping promotional discounts using (Get/Set) <b>ShippingDiscountProfiles</b> calls in the <b>Trading API</b> or through the <b>Shipping Preferences</b> in <b>My eBay</b>. <br><br><span class=\"tablenote\"><b>Note: </b>Initially, shipping discount profiles in the <b>Account API</b> will <i>not</i> be available to all sellers.</span>
     *
     * @return self
     */
    public function setShippingPromotionOffered($shipping_promotion_offered)
    {
        if (is_null($shipping_promotion_offered)) {
            throw new \InvalidArgumentException('non-nullable shipping_promotion_offered cannot be null');
        }
        $this->container['shipping_promotion_offered'] = $shipping_promotion_offered;

        return $this;
    }

    /**
     * Gets shipping_services
     *
     * @return \Ebay\Account\Model\ShippingService[]|null
     */
    public function getShippingServices()
    {
        return $this->container['shipping_services'];
    }

    /**
     * Sets shipping_services
     *
     * @param \Ebay\Account\Model\ShippingService[]|null $shipping_services This array consists of the domestic or international shipping services options that are defined for the policy. The shipping service options defined under this array should match what is set in the corresponding <b>shippingOptions.optionType</b> field (which controls whether domestic or international shipping service options are being defined). If a shipping rate table is being used, the specified shipping service options should also match the shipping rate table settings (domestic or international, shipping speed/level of service, etc.) <br><br>Sellers can specify up to four domestic shipping services and up to five international shipping service options by using separate <b>shippingService</b> containers for each. If the seller is using the Global Shipping Program as an international option, only a total of four international shipping service options (including GSP) can be offered. <br><br> See <a href=\"/api-docs/sell/static/seller-accounts/ht_shipping-setting-shipping-carrier-and-service-values.html\" target=\"_blank\">How to set up shipping carrier and shipping service values</a>. <br><br>To use the eBay standard envelope service (eSE), see <a href=\"/api-docs/sell/static/seller-accounts/using-the-ebay-standard-envelope-service.html\" target=\"_blank\">Using eBay standard envelope (eSE) service</a>.<br><br>This array is conditionally required if the seller is offering one or more domestic and/or international shipping service options.
     *
     * @return self
     */
    public function setShippingServices($shipping_services)
    {
        if (is_null($shipping_services)) {
            throw new \InvalidArgumentException('non-nullable shipping_services cannot be null');
        }
        $this->container['shipping_services'] = $shipping_services;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


