<?php
/**
 * ReturnPolicyApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account API
 *
 * The <b>Account API</b> gives sellers the ability to configure their eBay seller accounts, including the seller's policies (eBay business policies and seller-defined custom policies), opt in and out of eBay seller programs, configure sales tax tables, and get account information.  <br><br>For details on the availability of the methods in this API, see <a href=\"/api-docs/sell/account/overview.html#requirements\">Account API requirements and restrictions</a>.
 *
 * The version of the OpenAPI document: v1.9.2
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Account\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Ebay\Account\ApiException;
use Ebay\Account\Configuration;
use Ebay\Account\FormDataProcessor;
use Ebay\Account\HeaderSelector;
use Ebay\Account\ObjectSerializer;

/**
 * ReturnPolicyApi Class Doc Comment
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReturnPolicyApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createReturnPolicy' => [
            'application/json',
        ],
        'deleteReturnPolicy' => [
            'application/json',
        ],
        'getReturnPolicies' => [
            'application/json',
        ],
        'getReturnPolicy' => [
            'application/json',
        ],
        'getReturnPolicyByName' => [
            'application/json',
        ],
        'updateReturnPolicy' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createReturnPolicy
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Return policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetReturnPolicyResponse
     */
    public function createReturnPolicy($content_type, $return_policy_request, string $contentType = self::contentTypes['createReturnPolicy'][0])
    {
        list($response) = $this->createReturnPolicyWithHttpInfo($content_type, $return_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation createReturnPolicyWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Return policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetReturnPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReturnPolicyWithHttpInfo($content_type, $return_policy_request, string $contentType = self::contentTypes['createReturnPolicy'][0])
    {
        $request = $this->createReturnPolicyRequest($content_type, $return_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetReturnPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetReturnPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetReturnPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createReturnPolicyAsync
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Return policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnPolicyAsync($content_type, $return_policy_request, string $contentType = self::contentTypes['createReturnPolicy'][0])
    {
        return $this->createReturnPolicyAsyncWithHttpInfo($content_type, $return_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReturnPolicyAsyncWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Return policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnPolicyAsyncWithHttpInfo($content_type, $return_policy_request, string $contentType = self::contentTypes['createReturnPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetReturnPolicyResponse';
        $request = $this->createReturnPolicyRequest($content_type, $return_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReturnPolicy'
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Return policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReturnPolicyRequest($content_type, $return_policy_request, string $contentType = self::contentTypes['createReturnPolicy'][0])
    {

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling createReturnPolicy'
            );
        }

        // verify the required parameter 'return_policy_request' is set
        if ($return_policy_request === null || (is_array($return_policy_request) && count($return_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_request when calling createReturnPolicy'
            );
        }


        $resourcePath = '/return_policy';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($return_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($return_policy_request));
            } else {
                $httpBody = $return_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteReturnPolicy
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteReturnPolicy($return_policy_id, string $contentType = self::contentTypes['deleteReturnPolicy'][0])
    {
        $this->deleteReturnPolicyWithHttpInfo($return_policy_id, $contentType);
    }

    /**
     * Operation deleteReturnPolicyWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteReturnPolicyWithHttpInfo($return_policy_id, string $contentType = self::contentTypes['deleteReturnPolicy'][0])
    {
        $request = $this->deleteReturnPolicyRequest($return_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteReturnPolicyAsync
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnPolicyAsync($return_policy_id, string $contentType = self::contentTypes['deleteReturnPolicy'][0])
    {
        return $this->deleteReturnPolicyAsyncWithHttpInfo($return_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteReturnPolicyAsyncWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnPolicyAsyncWithHttpInfo($return_policy_id, string $contentType = self::contentTypes['deleteReturnPolicy'][0])
    {
        $returnType = '';
        $request = $this->deleteReturnPolicyRequest($return_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteReturnPolicy'
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteReturnPolicyRequest($return_policy_id, string $contentType = self::contentTypes['deleteReturnPolicy'][0])
    {

        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling deleteReturnPolicy'
            );
        }


        $resourcePath = '/return_policy/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnPolicies
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\ReturnPolicyResponse
     */
    public function getReturnPolicies($marketplace_id, string $contentType = self::contentTypes['getReturnPolicies'][0])
    {
        list($response) = $this->getReturnPoliciesWithHttpInfo($marketplace_id, $contentType);
        return $response;
    }

    /**
     * Operation getReturnPoliciesWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\ReturnPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnPoliciesWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getReturnPolicies'][0])
    {
        $request = $this->getReturnPoliciesRequest($marketplace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\ReturnPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\ReturnPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\ReturnPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getReturnPoliciesAsync
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPoliciesAsync($marketplace_id, string $contentType = self::contentTypes['getReturnPolicies'][0])
    {
        return $this->getReturnPoliciesAsyncWithHttpInfo($marketplace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnPoliciesAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPoliciesAsyncWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getReturnPolicies'][0])
    {
        $returnType = '\Ebay\Account\Model\ReturnPolicyResponse';
        $request = $this->getReturnPoliciesRequest($marketplace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnPolicies'
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnPoliciesRequest($marketplace_id, string $contentType = self::contentTypes['getReturnPolicies'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getReturnPolicies'
            );
        }


        $resourcePath = '/return_policy';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnPolicy
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\ReturnPolicy
     */
    public function getReturnPolicy($return_policy_id, string $contentType = self::contentTypes['getReturnPolicy'][0])
    {
        list($response) = $this->getReturnPolicyWithHttpInfo($return_policy_id, $contentType);
        return $response;
    }

    /**
     * Operation getReturnPolicyWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\ReturnPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnPolicyWithHttpInfo($return_policy_id, string $contentType = self::contentTypes['getReturnPolicy'][0])
    {
        $request = $this->getReturnPolicyRequest($return_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\ReturnPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\ReturnPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\ReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getReturnPolicyAsync
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPolicyAsync($return_policy_id, string $contentType = self::contentTypes['getReturnPolicy'][0])
    {
        return $this->getReturnPolicyAsyncWithHttpInfo($return_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnPolicyAsyncWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPolicyAsyncWithHttpInfo($return_policy_id, string $contentType = self::contentTypes['getReturnPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\ReturnPolicy';
        $request = $this->getReturnPolicyRequest($return_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnPolicy'
     *
     * @param  string $return_policy_id This path parameter specifies the unique identifier of the return policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnPolicyRequest($return_policy_id, string $contentType = self::contentTypes['getReturnPolicy'][0])
    {

        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling getReturnPolicy'
            );
        }


        $resourcePath = '/return_policy/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnPolicyByName
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the return policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\ReturnPolicy
     */
    public function getReturnPolicyByName($marketplace_id, $name, string $contentType = self::contentTypes['getReturnPolicyByName'][0])
    {
        list($response) = $this->getReturnPolicyByNameWithHttpInfo($marketplace_id, $name, $contentType);
        return $response;
    }

    /**
     * Operation getReturnPolicyByNameWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the return policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\ReturnPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnPolicyByNameWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getReturnPolicyByName'][0])
    {
        $request = $this->getReturnPolicyByNameRequest($marketplace_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\ReturnPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\ReturnPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\ReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getReturnPolicyByNameAsync
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the return policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPolicyByNameAsync($marketplace_id, $name, string $contentType = self::contentTypes['getReturnPolicyByName'][0])
    {
        return $this->getReturnPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnPolicyByNameAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the return policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getReturnPolicyByName'][0])
    {
        $returnType = '\Ebay\Account\Model\ReturnPolicy';
        $request = $this->getReturnPolicyByNameRequest($marketplace_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnPolicyByName'
     *
     * @param  string $marketplace_id This query parameter specifies the ID of the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the return policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnPolicyByNameRequest($marketplace_id, $name, string $contentType = self::contentTypes['getReturnPolicyByName'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getReturnPolicyByName'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getReturnPolicyByName'
            );
        }


        $resourcePath = '/return_policy/get_by_policy_name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateReturnPolicy
     *
     * @param  string $return_policy_id This path parameter specifies the ID of the return policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Container for a return policy request. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetReturnPolicyResponse
     */
    public function updateReturnPolicy($return_policy_id, $content_type, $return_policy_request, string $contentType = self::contentTypes['updateReturnPolicy'][0])
    {
        list($response) = $this->updateReturnPolicyWithHttpInfo($return_policy_id, $content_type, $return_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation updateReturnPolicyWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the ID of the return policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Container for a return policy request. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetReturnPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateReturnPolicyWithHttpInfo($return_policy_id, $content_type, $return_policy_request, string $contentType = self::contentTypes['updateReturnPolicy'][0])
    {
        $request = $this->updateReturnPolicyRequest($return_policy_id, $content_type, $return_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetReturnPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetReturnPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetReturnPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateReturnPolicyAsync
     *
     * @param  string $return_policy_id This path parameter specifies the ID of the return policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Container for a return policy request. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReturnPolicyAsync($return_policy_id, $content_type, $return_policy_request, string $contentType = self::contentTypes['updateReturnPolicy'][0])
    {
        return $this->updateReturnPolicyAsyncWithHttpInfo($return_policy_id, $content_type, $return_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateReturnPolicyAsyncWithHttpInfo
     *
     * @param  string $return_policy_id This path parameter specifies the ID of the return policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Container for a return policy request. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReturnPolicyAsyncWithHttpInfo($return_policy_id, $content_type, $return_policy_request, string $contentType = self::contentTypes['updateReturnPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetReturnPolicyResponse';
        $request = $this->updateReturnPolicyRequest($return_policy_id, $content_type, $return_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateReturnPolicy'
     *
     * @param  string $return_policy_id This path parameter specifies the ID of the return policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a return policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/return_policy/methods/getReturnPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getReturnPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\ReturnPolicyRequest $return_policy_request Container for a return policy request. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateReturnPolicyRequest($return_policy_id, $content_type, $return_policy_request, string $contentType = self::contentTypes['updateReturnPolicy'][0])
    {

        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling updateReturnPolicy'
            );
        }

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling updateReturnPolicy'
            );
        }

        // verify the required parameter 'return_policy_request' is set
        if ($return_policy_request === null || (is_array($return_policy_request) && count($return_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_request when calling updateReturnPolicy'
            );
        }


        $resourcePath = '/return_policy/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($return_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($return_policy_request));
            } else {
                $httpBody = $return_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
