<?php
/**
 * PaymentPolicyApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account API
 *
 * The <b>Account API</b> gives sellers the ability to configure their eBay seller accounts, including the seller's policies (eBay business policies and seller-defined custom policies), opt in and out of eBay seller programs, configure sales tax tables, and get account information.  <br><br>For details on the availability of the methods in this API, see <a href=\"/api-docs/sell/account/overview.html#requirements\">Account API requirements and restrictions</a>.
 *
 * The version of the OpenAPI document: v1.9.2
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Account\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Ebay\Account\ApiException;
use Ebay\Account\Configuration;
use Ebay\Account\FormDataProcessor;
use Ebay\Account\HeaderSelector;
use Ebay\Account\ObjectSerializer;

/**
 * PaymentPolicyApi Class Doc Comment
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PaymentPolicyApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createPaymentPolicy' => [
            'application/json',
        ],
        'deletePaymentPolicy' => [
            'application/json',
        ],
        'getPaymentPolicies' => [
            'application/json',
        ],
        'getPaymentPolicy' => [
            'application/json',
        ],
        'getPaymentPolicyByName' => [
            'application/json',
        ],
        'updatePaymentPolicy' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createPaymentPolicy
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetPaymentPolicyResponse
     */
    public function createPaymentPolicy($content_type, $payment_policy_request, string $contentType = self::contentTypes['createPaymentPolicy'][0])
    {
        list($response) = $this->createPaymentPolicyWithHttpInfo($content_type, $payment_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation createPaymentPolicyWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetPaymentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentPolicyWithHttpInfo($content_type, $payment_policy_request, string $contentType = self::contentTypes['createPaymentPolicy'][0])
    {
        $request = $this->createPaymentPolicyRequest($content_type, $payment_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetPaymentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetPaymentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetPaymentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createPaymentPolicyAsync
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentPolicyAsync($content_type, $payment_policy_request, string $contentType = self::contentTypes['createPaymentPolicy'][0])
    {
        return $this->createPaymentPolicyAsyncWithHttpInfo($content_type, $payment_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentPolicyAsyncWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentPolicyAsyncWithHttpInfo($content_type, $payment_policy_request, string $contentType = self::contentTypes['createPaymentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetPaymentPolicyResponse';
        $request = $this->createPaymentPolicyRequest($content_type, $payment_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPaymentPolicy'
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPaymentPolicyRequest($content_type, $payment_policy_request, string $contentType = self::contentTypes['createPaymentPolicy'][0])
    {

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling createPaymentPolicy'
            );
        }

        // verify the required parameter 'payment_policy_request' is set
        if ($payment_policy_request === null || (is_array($payment_policy_request) && count($payment_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_policy_request when calling createPaymentPolicy'
            );
        }


        $resourcePath = '/payment_policy';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($payment_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($payment_policy_request));
            } else {
                $httpBody = $payment_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePaymentPolicy
     *
     * @param  string $payment_policy_id This path parameter specifies the unique identifier of the payment policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePaymentPolicy($payment_policy_id, string $contentType = self::contentTypes['deletePaymentPolicy'][0])
    {
        $this->deletePaymentPolicyWithHttpInfo($payment_policy_id, $contentType);
    }

    /**
     * Operation deletePaymentPolicyWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the unique identifier of the payment policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePaymentPolicyWithHttpInfo($payment_policy_id, string $contentType = self::contentTypes['deletePaymentPolicy'][0])
    {
        $request = $this->deletePaymentPolicyRequest($payment_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deletePaymentPolicyAsync
     *
     * @param  string $payment_policy_id This path parameter specifies the unique identifier of the payment policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentPolicyAsync($payment_policy_id, string $contentType = self::contentTypes['deletePaymentPolicy'][0])
    {
        return $this->deletePaymentPolicyAsyncWithHttpInfo($payment_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePaymentPolicyAsyncWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the unique identifier of the payment policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentPolicyAsyncWithHttpInfo($payment_policy_id, string $contentType = self::contentTypes['deletePaymentPolicy'][0])
    {
        $returnType = '';
        $request = $this->deletePaymentPolicyRequest($payment_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePaymentPolicy'
     *
     * @param  string $payment_policy_id This path parameter specifies the unique identifier of the payment policy you want to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePaymentPolicyRequest($payment_policy_id, string $contentType = self::contentTypes['deletePaymentPolicy'][0])
    {

        // verify the required parameter 'payment_policy_id' is set
        if ($payment_policy_id === null || (is_array($payment_policy_id) && count($payment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_policy_id when calling deletePaymentPolicy'
            );
        }


        $resourcePath = '/payment_policy/{payment_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($payment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_policy_id' . '}',
                ObjectSerializer::toPathValue($payment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaymentPolicies
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\PaymentPolicyResponse
     */
    public function getPaymentPolicies($marketplace_id, string $contentType = self::contentTypes['getPaymentPolicies'][0])
    {
        list($response) = $this->getPaymentPoliciesWithHttpInfo($marketplace_id, $contentType);
        return $response;
    }

    /**
     * Operation getPaymentPoliciesWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\PaymentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentPoliciesWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getPaymentPolicies'][0])
    {
        $request = $this->getPaymentPoliciesRequest($marketplace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\PaymentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\PaymentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\PaymentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPaymentPoliciesAsync
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPoliciesAsync($marketplace_id, string $contentType = self::contentTypes['getPaymentPolicies'][0])
    {
        return $this->getPaymentPoliciesAsyncWithHttpInfo($marketplace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPaymentPoliciesAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPoliciesAsyncWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getPaymentPolicies'][0])
    {
        $returnType = '\Ebay\Account\Model\PaymentPolicyResponse';
        $request = $this->getPaymentPoliciesRequest($marketplace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaymentPolicies'
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPaymentPoliciesRequest($marketplace_id, string $contentType = self::contentTypes['getPaymentPolicies'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getPaymentPolicies'
            );
        }


        $resourcePath = '/payment_policy';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaymentPolicy
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\PaymentPolicy
     */
    public function getPaymentPolicy($payment_policy_id, string $contentType = self::contentTypes['getPaymentPolicy'][0])
    {
        list($response) = $this->getPaymentPolicyWithHttpInfo($payment_policy_id, $contentType);
        return $response;
    }

    /**
     * Operation getPaymentPolicyWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\PaymentPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentPolicyWithHttpInfo($payment_policy_id, string $contentType = self::contentTypes['getPaymentPolicy'][0])
    {
        $request = $this->getPaymentPolicyRequest($payment_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\PaymentPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\PaymentPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\PaymentPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPaymentPolicyAsync
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPolicyAsync($payment_policy_id, string $contentType = self::contentTypes['getPaymentPolicy'][0])
    {
        return $this->getPaymentPolicyAsyncWithHttpInfo($payment_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPaymentPolicyAsyncWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPolicyAsyncWithHttpInfo($payment_policy_id, string $contentType = self::contentTypes['getPaymentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\PaymentPolicy';
        $request = $this->getPaymentPolicyRequest($payment_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaymentPolicy'
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to retrieve. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPaymentPolicyRequest($payment_policy_id, string $contentType = self::contentTypes['getPaymentPolicy'][0])
    {

        // verify the required parameter 'payment_policy_id' is set
        if ($payment_policy_id === null || (is_array($payment_policy_id) && count($payment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_policy_id when calling getPaymentPolicy'
            );
        }


        $resourcePath = '/payment_policy/{payment_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($payment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_policy_id' . '}',
                ObjectSerializer::toPathValue($payment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaymentPolicyByName
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the payment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\PaymentPolicy
     */
    public function getPaymentPolicyByName($marketplace_id, $name, string $contentType = self::contentTypes['getPaymentPolicyByName'][0])
    {
        list($response) = $this->getPaymentPolicyByNameWithHttpInfo($marketplace_id, $name, $contentType);
        return $response;
    }

    /**
     * Operation getPaymentPolicyByNameWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the payment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\PaymentPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentPolicyByNameWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getPaymentPolicyByName'][0])
    {
        $request = $this->getPaymentPolicyByNameRequest($marketplace_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\PaymentPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\PaymentPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\PaymentPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPaymentPolicyByNameAsync
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the payment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPolicyByNameAsync($marketplace_id, $name, string $contentType = self::contentTypes['getPaymentPolicyByName'][0])
    {
        return $this->getPaymentPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPaymentPolicyByNameAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the payment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaymentPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getPaymentPolicyByName'][0])
    {
        $returnType = '\Ebay\Account\Model\PaymentPolicy';
        $request = $this->getPaymentPolicyByNameRequest($marketplace_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaymentPolicyByName'
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the payment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This value can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPaymentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPaymentPolicyByNameRequest($marketplace_id, $name, string $contentType = self::contentTypes['getPaymentPolicyByName'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getPaymentPolicyByName'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getPaymentPolicyByName'
            );
        }


        $resourcePath = '/payment_policy/get_by_policy_name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePaymentPolicy
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetPaymentPolicyResponse
     */
    public function updatePaymentPolicy($payment_policy_id, $content_type, $payment_policy_request, string $contentType = self::contentTypes['updatePaymentPolicy'][0])
    {
        list($response) = $this->updatePaymentPolicyWithHttpInfo($payment_policy_id, $content_type, $payment_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation updatePaymentPolicyWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetPaymentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePaymentPolicyWithHttpInfo($payment_policy_id, $content_type, $payment_policy_request, string $contentType = self::contentTypes['updatePaymentPolicy'][0])
    {
        $request = $this->updatePaymentPolicyRequest($payment_policy_id, $content_type, $payment_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetPaymentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetPaymentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetPaymentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePaymentPolicyAsync
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePaymentPolicyAsync($payment_policy_id, $content_type, $payment_policy_request, string $contentType = self::contentTypes['updatePaymentPolicy'][0])
    {
        return $this->updatePaymentPolicyAsyncWithHttpInfo($payment_policy_id, $content_type, $payment_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePaymentPolicyAsyncWithHttpInfo
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePaymentPolicyAsyncWithHttpInfo($payment_policy_id, $content_type, $payment_policy_request, string $contentType = self::contentTypes['updatePaymentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetPaymentPolicyResponse';
        $request = $this->updatePaymentPolicyRequest($payment_policy_id, $content_type, $payment_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePaymentPolicy'
     *
     * @param  string $payment_policy_id This path parameter specifies the ID of the payment policy you want to update. &lt;br&gt;&lt;br&gt; This ID can be retrieved for a payment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/payment_policy/methods/getPaymentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getPaymentPolices&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\PaymentPolicyRequest $payment_policy_request Payment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePaymentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePaymentPolicyRequest($payment_policy_id, $content_type, $payment_policy_request, string $contentType = self::contentTypes['updatePaymentPolicy'][0])
    {

        // verify the required parameter 'payment_policy_id' is set
        if ($payment_policy_id === null || (is_array($payment_policy_id) && count($payment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_policy_id when calling updatePaymentPolicy'
            );
        }

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling updatePaymentPolicy'
            );
        }

        // verify the required parameter 'payment_policy_request' is set
        if ($payment_policy_request === null || (is_array($payment_policy_request) && count($payment_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_policy_request when calling updatePaymentPolicy'
            );
        }


        $resourcePath = '/payment_policy/{payment_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($payment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_policy_id' . '}',
                ObjectSerializer::toPathValue($payment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($payment_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($payment_policy_request));
            } else {
                $httpBody = $payment_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
