<?php
/**
 * FulfillmentPolicyApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account API
 *
 * The <b>Account API</b> gives sellers the ability to configure their eBay seller accounts, including the seller's policies (eBay business policies and seller-defined custom policies), opt in and out of eBay seller programs, configure sales tax tables, and get account information.  <br><br>For details on the availability of the methods in this API, see <a href=\"/api-docs/sell/account/overview.html#requirements\">Account API requirements and restrictions</a>.
 *
 * The version of the OpenAPI document: v1.9.2
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Ebay\Account\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Ebay\Account\ApiException;
use Ebay\Account\Configuration;
use Ebay\Account\FormDataProcessor;
use Ebay\Account\HeaderSelector;
use Ebay\Account\ObjectSerializer;

/**
 * FulfillmentPolicyApi Class Doc Comment
 *
 * @category Class
 * @package  Ebay\Account
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FulfillmentPolicyApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createFulfillmentPolicy' => [
            'application/json',
        ],
        'deleteFulfillmentPolicy' => [
            'application/json',
        ],
        'getFulfillmentPolicies' => [
            'application/json',
        ],
        'getFulfillmentPolicy' => [
            'application/json',
        ],
        'getFulfillmentPolicyByName' => [
            'application/json',
        ],
        'updateFulfillmentPolicy' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createFulfillmentPolicy
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Request to create a seller account fulfillment policy. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetFulfillmentPolicyResponse
     */
    public function createFulfillmentPolicy($content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['createFulfillmentPolicy'][0])
    {
        list($response) = $this->createFulfillmentPolicyWithHttpInfo($content_type, $fulfillment_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation createFulfillmentPolicyWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Request to create a seller account fulfillment policy. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetFulfillmentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createFulfillmentPolicyWithHttpInfo($content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['createFulfillmentPolicy'][0])
    {
        $request = $this->createFulfillmentPolicyRequest($content_type, $fulfillment_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createFulfillmentPolicyAsync
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Request to create a seller account fulfillment policy. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFulfillmentPolicyAsync($content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['createFulfillmentPolicy'][0])
    {
        return $this->createFulfillmentPolicyAsyncWithHttpInfo($content_type, $fulfillment_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createFulfillmentPolicyAsyncWithHttpInfo
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Request to create a seller account fulfillment policy. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFulfillmentPolicyAsyncWithHttpInfo($content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['createFulfillmentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetFulfillmentPolicyResponse';
        $request = $this->createFulfillmentPolicyRequest($content_type, $fulfillment_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createFulfillmentPolicy'
     *
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Request to create a seller account fulfillment policy. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createFulfillmentPolicyRequest($content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['createFulfillmentPolicy'][0])
    {

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling createFulfillmentPolicy'
            );
        }

        // verify the required parameter 'fulfillment_policy_request' is set
        if ($fulfillment_policy_request === null || (is_array($fulfillment_policy_request) && count($fulfillment_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfillment_policy_request when calling createFulfillmentPolicy'
            );
        }


        $resourcePath = '/fulfillment_policy/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($fulfillment_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($fulfillment_policy_request));
            } else {
                $httpBody = $fulfillment_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteFulfillmentPolicy
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteFulfillmentPolicy($fulfillment_policy_id, string $contentType = self::contentTypes['deleteFulfillmentPolicy'][0])
    {
        $this->deleteFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, $contentType);
    }

    /**
     * Operation deleteFulfillmentPolicyWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, string $contentType = self::contentTypes['deleteFulfillmentPolicy'][0])
    {
        $request = $this->deleteFulfillmentPolicyRequest($fulfillment_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteFulfillmentPolicyAsync
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteFulfillmentPolicyAsync($fulfillment_policy_id, string $contentType = self::contentTypes['deleteFulfillmentPolicy'][0])
    {
        return $this->deleteFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteFulfillmentPolicyAsyncWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, string $contentType = self::contentTypes['deleteFulfillmentPolicy'][0])
    {
        $returnType = '';
        $request = $this->deleteFulfillmentPolicyRequest($fulfillment_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteFulfillmentPolicy'
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy to delete.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteFulfillmentPolicyRequest($fulfillment_policy_id, string $contentType = self::contentTypes['deleteFulfillmentPolicy'][0])
    {

        // verify the required parameter 'fulfillment_policy_id' is set
        if ($fulfillment_policy_id === null || (is_array($fulfillment_policy_id) && count($fulfillment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfillment_policy_id when calling deleteFulfillmentPolicy'
            );
        }


        $resourcePath = '/fulfillment_policy/{fulfillmentPolicyId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($fulfillment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fulfillmentPolicyId' . '}',
                ObjectSerializer::toPathValue($fulfillment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFulfillmentPolicies
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\FulfillmentPolicyResponse
     */
    public function getFulfillmentPolicies($marketplace_id, string $contentType = self::contentTypes['getFulfillmentPolicies'][0])
    {
        list($response) = $this->getFulfillmentPoliciesWithHttpInfo($marketplace_id, $contentType);
        return $response;
    }

    /**
     * Operation getFulfillmentPoliciesWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicies'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\FulfillmentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFulfillmentPoliciesWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getFulfillmentPolicies'][0])
    {
        $request = $this->getFulfillmentPoliciesRequest($marketplace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\FulfillmentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\FulfillmentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\FulfillmentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getFulfillmentPoliciesAsync
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPoliciesAsync($marketplace_id, string $contentType = self::contentTypes['getFulfillmentPolicies'][0])
    {
        return $this->getFulfillmentPoliciesAsyncWithHttpInfo($marketplace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFulfillmentPoliciesAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPoliciesAsyncWithHttpInfo($marketplace_id, string $contentType = self::contentTypes['getFulfillmentPolicies'][0])
    {
        $returnType = '\Ebay\Account\Model\FulfillmentPolicyResponse';
        $request = $this->getFulfillmentPoliciesRequest($marketplace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFulfillmentPolicies'
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policies you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFulfillmentPoliciesRequest($marketplace_id, string $contentType = self::contentTypes['getFulfillmentPolicies'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getFulfillmentPolicies'
            );
        }


        $resourcePath = '/fulfillment_policy';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFulfillmentPolicy
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\FulfillmentPolicy
     */
    public function getFulfillmentPolicy($fulfillment_policy_id, string $contentType = self::contentTypes['getFulfillmentPolicy'][0])
    {
        list($response) = $this->getFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, $contentType);
        return $response;
    }

    /**
     * Operation getFulfillmentPolicyWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\FulfillmentPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, string $contentType = self::contentTypes['getFulfillmentPolicy'][0])
    {
        $request = $this->getFulfillmentPolicyRequest($fulfillment_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\FulfillmentPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\FulfillmentPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\FulfillmentPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getFulfillmentPolicyAsync
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPolicyAsync($fulfillment_policy_id, string $contentType = self::contentTypes['getFulfillmentPolicy'][0])
    {
        return $this->getFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFulfillmentPolicyAsyncWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, string $contentType = self::contentTypes['getFulfillmentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\FulfillmentPolicy';
        $request = $this->getFulfillmentPolicyRequest($fulfillment_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFulfillmentPolicy'
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt; This ID can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFulfillmentPolicyRequest($fulfillment_policy_id, string $contentType = self::contentTypes['getFulfillmentPolicy'][0])
    {

        // verify the required parameter 'fulfillment_policy_id' is set
        if ($fulfillment_policy_id === null || (is_array($fulfillment_policy_id) && count($fulfillment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfillment_policy_id when calling getFulfillmentPolicy'
            );
        }


        $resourcePath = '/fulfillment_policy/{fulfillmentPolicyId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($fulfillment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fulfillmentPolicyId' . '}',
                ObjectSerializer::toPathValue($fulfillment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFulfillmentPolicyByName
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt;This value can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\FulfillmentPolicy
     */
    public function getFulfillmentPolicyByName($marketplace_id, $name, string $contentType = self::contentTypes['getFulfillmentPolicyByName'][0])
    {
        list($response) = $this->getFulfillmentPolicyByNameWithHttpInfo($marketplace_id, $name, $contentType);
        return $response;
    }

    /**
     * Operation getFulfillmentPolicyByNameWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt;This value can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicyByName'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\FulfillmentPolicy, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFulfillmentPolicyByNameWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getFulfillmentPolicyByName'][0])
    {
        $request = $this->getFulfillmentPolicyByNameRequest($marketplace_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\FulfillmentPolicy',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\FulfillmentPolicy',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\FulfillmentPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getFulfillmentPolicyByNameAsync
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt;This value can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPolicyByNameAsync($marketplace_id, $name, string $contentType = self::contentTypes['getFulfillmentPolicyByName'][0])
    {
        return $this->getFulfillmentPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFulfillmentPolicyByNameAsyncWithHttpInfo
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt;This value can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentPolicyByNameAsyncWithHttpInfo($marketplace_id, $name, string $contentType = self::contentTypes['getFulfillmentPolicyByName'][0])
    {
        $returnType = '\Ebay\Account\Model\FulfillmentPolicy';
        $request = $this->getFulfillmentPolicyByNameRequest($marketplace_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFulfillmentPolicyByName'
     *
     * @param  string $marketplace_id This query parameter specifies the eBay marketplace of the policy you want to retrieve. For implementation help, refer to eBay API documentation at https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum (required)
     * @param  string $name This query parameter specifies the seller-defined name of the fulfillment policy you want to retrieve.&lt;br&gt;&lt;br&gt;This value can be retrieved for a fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFulfillmentPolicyByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFulfillmentPolicyByNameRequest($marketplace_id, $name, string $contentType = self::contentTypes['getFulfillmentPolicyByName'][0])
    {

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (is_array($marketplace_id) && count($marketplace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling getFulfillmentPolicyByName'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getFulfillmentPolicyByName'
            );
        }


        $resourcePath = '/fulfillment_policy/get_by_policy_name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $marketplace_id,
            'marketplace_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateFulfillmentPolicy
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to update.&lt;br&gt;&lt;br&gt;This ID can be retrieved for a specific fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Fulfillment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Ebay\Account\Model\SetFulfillmentPolicyResponse
     */
    public function updateFulfillmentPolicy($fulfillment_policy_id, $content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['updateFulfillmentPolicy'][0])
    {
        list($response) = $this->updateFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, $content_type, $fulfillment_policy_request, $contentType);
        return $response;
    }

    /**
     * Operation updateFulfillmentPolicyWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to update.&lt;br&gt;&lt;br&gt;This ID can be retrieved for a specific fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Fulfillment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \Ebay\Account\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Ebay\Account\Model\SetFulfillmentPolicyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateFulfillmentPolicyWithHttpInfo($fulfillment_policy_id, $content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['updateFulfillmentPolicy'][0])
    {
        $request = $this->updateFulfillmentPolicyRequest($fulfillment_policy_id, $content_type, $fulfillment_policy_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Ebay\Account\Model\SetFulfillmentPolicyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateFulfillmentPolicyAsync
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to update.&lt;br&gt;&lt;br&gt;This ID can be retrieved for a specific fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Fulfillment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFulfillmentPolicyAsync($fulfillment_policy_id, $content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['updateFulfillmentPolicy'][0])
    {
        return $this->updateFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, $content_type, $fulfillment_policy_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateFulfillmentPolicyAsyncWithHttpInfo
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to update.&lt;br&gt;&lt;br&gt;This ID can be retrieved for a specific fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Fulfillment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFulfillmentPolicyAsyncWithHttpInfo($fulfillment_policy_id, $content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['updateFulfillmentPolicy'][0])
    {
        $returnType = '\Ebay\Account\Model\SetFulfillmentPolicyResponse';
        $request = $this->updateFulfillmentPolicyRequest($fulfillment_policy_id, $content_type, $fulfillment_policy_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateFulfillmentPolicy'
     *
     * @param  string $fulfillment_policy_id This path parameter specifies the ID of the fulfillment policy you want to update.&lt;br&gt;&lt;br&gt;This ID can be retrieved for a specific fulfillment policy by using the &lt;a href&#x3D;\&quot;/api-docs/sell/account/resources/fulfillment_policy/methods/getFulfillmentPolicies\&quot; target&#x3D;\&quot;_blank \&quot;&gt;getFulfillmentPolicies&lt;/a&gt; method. (required)
     * @param  string $content_type This header indicates the format of the request body provided by the client. Its value should be set to &lt;b&gt;application/json&lt;/b&gt;. &lt;br&gt;&lt;br&gt; For more information, refer to &lt;a href&#x3D;\&quot;/api-docs/static/rest-request-components.html#HTTP\&quot; target&#x3D;\&quot;_blank \&quot;&gt;HTTP request headers&lt;/a&gt;. (required)
     * @param  \Ebay\Account\Model\FulfillmentPolicyRequest $fulfillment_policy_request Fulfillment policy request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFulfillmentPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateFulfillmentPolicyRequest($fulfillment_policy_id, $content_type, $fulfillment_policy_request, string $contentType = self::contentTypes['updateFulfillmentPolicy'][0])
    {

        // verify the required parameter 'fulfillment_policy_id' is set
        if ($fulfillment_policy_id === null || (is_array($fulfillment_policy_id) && count($fulfillment_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfillment_policy_id when calling updateFulfillmentPolicy'
            );
        }

        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling updateFulfillmentPolicy'
            );
        }

        // verify the required parameter 'fulfillment_policy_request' is set
        if ($fulfillment_policy_request === null || (is_array($fulfillment_policy_request) && count($fulfillment_policy_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfillment_policy_request when calling updateFulfillmentPolicy'
            );
        }


        $resourcePath = '/fulfillment_policy/{fulfillmentPolicyId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($fulfillment_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fulfillmentPolicyId' . '}',
                ObjectSerializer::toPathValue($fulfillment_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($fulfillment_policy_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($fulfillment_policy_request));
            } else {
                $httpBody = $fulfillment_policy_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
