# # FulfillmentPolicyRequest

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**category_types** | [**\Ebay\Account\Model\CategoryType[]**](CategoryType.md) | This container is used to specify whether the fulfillment business policy applies to motor vehicle listings, or if it applies to non-motor vehicle listings. | [optional]
**description** | **string** | A seller-defined description of the fulfillment policy. This description is only for the seller&#39;s use, and is not exposed on any eBay pages.  &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 250 | [optional]
**freight_shipping** | **bool** | This field is included and set to &lt;code&gt;true&lt;/code&gt; if freight shipping is available for the item. Freight shipping can be used for large items over 150 lbs.&lt;br&gt;&lt;br&gt;&lt;b&gt;Default&lt;/b&gt;: false | [optional]
**global_shipping** | **bool** | This field is included and set to &lt;code&gt;true&lt;/code&gt; if the seller wants to use the Global Shipping Program for international shipments. See the &lt;a href&#x3D;\&quot;https://pages.ebay.com/help/sell/shipping-globally.html \&quot;&gt;Global Shipping Program&lt;/a&gt; help topic for more details and requirements on the Global Shipping Program.&lt;br&gt;&lt;br&gt;It is possible for a seller to use a combination of the Global Shipping Program and other international shipping services. &lt;br&gt;&lt;br&gt;If this value is set to &lt;code&gt;false&lt;/code&gt; or if the field is omitted, the seller is responsible for manually specifying individual international shipping services (if the seller ships internationally)., as described in &lt;a href&#x3D;\&quot;https://developer.ebay.com/api-docs/sell/static/seller-accounts/ht_shipping-worldwide.html \&quot;&gt;Setting up worldwide shipping&lt;/a&gt;. &lt;br&gt;&lt;br&gt;Sellers can opt in or out of the Global Shipping Program through the Shipping preferences in My eBay.&lt;br&gt;&lt;br&gt;&lt;span class&#x3D;\&quot;tablenote\&quot;&gt;&lt;b&gt;Note&lt;/b&gt;: On the US marketplace, the &lt;em&gt;&lt;b&gt;Global Shipping Program&lt;/b&gt;&lt;/em&gt; is scheduled to be replaced by a new intermediated international shipping program called &lt;em&gt;&lt;b&gt;eBay International Shipping&lt;/b&gt;&lt;/em&gt;. US sellers who are opted in to the Global Shipping Program will be automatically opted in to eBay International Shipping when it becomes available to them. All US sellers will be migrated by March 31, 2023. &lt;br&gt;&lt;br&gt;eBay International Shipping is an account level setting, and no field needs to be set in a Fulfillment business policy to enable it. As long as the US seller&#39;s account is opted in to eBay International Shipping, this shipping option will be enabled automatically for all listings where international shipping is available. &lt;br&gt;&lt;br&gt;A US seller who is opted in to eBay International Shipping can also specify individual international shipping service options for a Fulfillment business policy.&lt;/span&gt;&lt;p&gt;&lt;b&gt;Default&lt;/b&gt;: false&lt;/p&gt; | [optional]
**handling_time** | [**\Ebay\Account\Model\TimeDuration**](TimeDuration.md) |  | [optional]
**local_pickup** | **bool** | This field should be included and set to &lt;code&gt;true&lt;/code&gt; if local pickup is one of the fulfillment options available to the buyer. It is possible for the seller to make local pickup and some shipping service options available to the buyer.&lt;br&gt;&lt;br&gt;With local pickup, the buyer and seller make arrangements for pickup time and location.&lt;br&gt;&lt;br&gt;&lt;b&gt;Default&lt;/b&gt;: &lt;code&gt;false&lt;/code&gt; | [optional]
**marketplace_id** | **string** | The ID of the eBay marketplace to which this fulfillment policy applies. For implementation help, refer to &lt;a href&#x3D;&#39;https://developer.ebay.com/api-docs/sell/account/types/ba:MarketplaceIdEnum&#39;&gt;eBay API documentation&lt;/a&gt; | [optional]
**name** | **string** | A seller-defined name for this fulfillment policy. Names must be unique for policies assigned to the same marketplace. &lt;br&gt;&lt;br&gt;&lt;b&gt;Max length&lt;/b&gt;: 64 | [optional]
**pickup_drop_off** | **bool** | This field should be included and set to &lt;code&gt;true&lt;/code&gt; if the seller offers the \&quot;Click and Collect\&quot; feature for an item. &lt;p&gt;To enable \&quot;Click and Collect\&quot; on a listing, a seller must be eligible for Click and Collect. Currently, Click and Collect is available to only large retail merchants selling in the eBay AU and UK marketplaces.&lt;/p&gt;  &lt;p&gt;In addition to setting this field to &lt;code&gt;true&lt;/code&gt;, the merchant must also do the following to enable the \&quot;Click and Collect\&quot; option on a listing: &lt;ul&gt;&lt;li&gt;Have inventory for the product at one or more physical stores tied to the merchant&#39;s account. &lt;p&gt;Sellers can use the &lt;b&gt;createInventoryLocation&lt;/b&gt; method in the Inventory API to associate physical stores to their account and they can then can add inventory to specific store locations.&lt;/p&gt;&lt;/li&gt;&lt;li&gt;Set an immediate payment requirement on the item. The immediate payment feature requires the seller to: &lt;ul&gt;&lt;li&gt;Set the &lt;b&gt;immediatePay&lt;/b&gt; flag in the payment policy to &#39;true&#39;.&lt;/li&gt;&lt;li&gt;Have a valid store location with a complete street address.&lt;/li&gt;&lt;/ul&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;When a merchant successfully lists an item with Click and Collect, prospective buyers within a reasonable distance from one of the merchant&#39;s stores (that has stock available) will see the \&quot;Available for Click and Collect\&quot; option on the listing, along with information on the closest store that has the item.&lt;/p&gt;&lt;b&gt;Default&lt;/b&gt;: false | [optional]
**shipping_options** | [**\Ebay\Account\Model\ShippingOption[]**](ShippingOption.md) | This array is used to provide detailed information on the domestic and international shipping options available for the policy. &lt;br&gt;&lt;br&gt;A separate &lt;b&gt;ShippingOption&lt;/b&gt; object is required for domestic shipping service options and for international shipping service options (if the seller ships to international locations). &lt;ul&gt;&lt;li&gt;The &lt;b&gt;optionType&lt;/b&gt; field is used to indicate whether the &lt;b&gt;ShippingOption&lt;/b&gt; object applies to domestic or international shipping, and the &lt;b&gt;costType&lt;/b&gt; field is used to indicate whether flat-rate shipping or calculated shipping will be used.&lt;/li&gt; &lt;li&gt;The &lt;b&gt;rateTableId&lt;/b&gt; field can be used to associate a defined shipping rate table to the policy, and the &lt;b&gt;packageHandlingCost&lt;/b&gt; container can be used to set a handling charge for the policy.&lt;/li&gt;&lt;/ul&gt; &lt;p&gt;A separate &lt;b&gt;ShippingServices&lt;/b&gt; object will be used to specify cost and other details for every available domestic and international shipping service option. &lt;/p&gt; | [optional]
**ship_to_locations** | [**\Ebay\Account\Model\RegionSet**](RegionSet.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
