<?php
/**
 * Supplier
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * Supplier Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Supplier implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Supplier';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'currency' => 'string',
        'payment_term' => 'string',
        'tax_rule' => 'string',
        'discount' => 'int',
        'comments' => 'mixed',
        'account_payable' => 'string',
        'tax_number' => 'mixed',
        'additional_attribute1' => 'mixed',
        'additional_attribute2' => 'mixed',
        'additional_attribute3' => 'mixed',
        'additional_attribute4' => 'mixed',
        'additional_attribute5' => 'mixed',
        'additional_attribute6' => 'mixed',
        'additional_attribute7' => 'mixed',
        'additional_attribute8' => 'mixed',
        'additional_attribute9' => 'mixed',
        'additional_attribute10' => 'mixed',
        'attribute_set' => 'mixed',
        'status' => 'string',
        'last_modified_on' => 'string',
        'addresses' => '\Cin7\Model\BillingAddress',
        'contacts' => '\Cin7\Model\Contact[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'currency' => null,
        'payment_term' => null,
        'tax_rule' => null,
        'discount' => null,
        'comments' => null,
        'account_payable' => null,
        'tax_number' => null,
        'additional_attribute1' => null,
        'additional_attribute2' => null,
        'additional_attribute3' => null,
        'additional_attribute4' => null,
        'additional_attribute5' => null,
        'additional_attribute6' => null,
        'additional_attribute7' => null,
        'additional_attribute8' => null,
        'additional_attribute9' => null,
        'additional_attribute10' => null,
        'attribute_set' => null,
        'status' => null,
        'last_modified_on' => null,
        'addresses' => null,
        'contacts' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'name' => false,
        'currency' => false,
        'payment_term' => false,
        'tax_rule' => false,
        'discount' => false,
        'comments' => true,
        'account_payable' => false,
        'tax_number' => true,
        'additional_attribute1' => true,
        'additional_attribute2' => true,
        'additional_attribute3' => true,
        'additional_attribute4' => true,
        'additional_attribute5' => true,
        'additional_attribute6' => true,
        'additional_attribute7' => true,
        'additional_attribute8' => true,
        'additional_attribute9' => true,
        'additional_attribute10' => true,
        'attribute_set' => true,
        'status' => false,
        'last_modified_on' => false,
        'addresses' => false,
        'contacts' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'ID',
        'name' => 'Name',
        'currency' => 'Currency',
        'payment_term' => 'PaymentTerm',
        'tax_rule' => 'TaxRule',
        'discount' => 'Discount',
        'comments' => 'Comments',
        'account_payable' => 'AccountPayable',
        'tax_number' => 'TaxNumber',
        'additional_attribute1' => 'AdditionalAttribute1',
        'additional_attribute2' => 'AdditionalAttribute2',
        'additional_attribute3' => 'AdditionalAttribute3',
        'additional_attribute4' => 'AdditionalAttribute4',
        'additional_attribute5' => 'AdditionalAttribute5',
        'additional_attribute6' => 'AdditionalAttribute6',
        'additional_attribute7' => 'AdditionalAttribute7',
        'additional_attribute8' => 'AdditionalAttribute8',
        'additional_attribute9' => 'AdditionalAttribute9',
        'additional_attribute10' => 'AdditionalAttribute10',
        'attribute_set' => 'AttributeSet',
        'status' => 'Status',
        'last_modified_on' => 'LastModifiedOn',
        'addresses' => 'Addresses',
        'contacts' => 'Contacts'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'currency' => 'setCurrency',
        'payment_term' => 'setPaymentTerm',
        'tax_rule' => 'setTaxRule',
        'discount' => 'setDiscount',
        'comments' => 'setComments',
        'account_payable' => 'setAccountPayable',
        'tax_number' => 'setTaxNumber',
        'additional_attribute1' => 'setAdditionalAttribute1',
        'additional_attribute2' => 'setAdditionalAttribute2',
        'additional_attribute3' => 'setAdditionalAttribute3',
        'additional_attribute4' => 'setAdditionalAttribute4',
        'additional_attribute5' => 'setAdditionalAttribute5',
        'additional_attribute6' => 'setAdditionalAttribute6',
        'additional_attribute7' => 'setAdditionalAttribute7',
        'additional_attribute8' => 'setAdditionalAttribute8',
        'additional_attribute9' => 'setAdditionalAttribute9',
        'additional_attribute10' => 'setAdditionalAttribute10',
        'attribute_set' => 'setAttributeSet',
        'status' => 'setStatus',
        'last_modified_on' => 'setLastModifiedOn',
        'addresses' => 'setAddresses',
        'contacts' => 'setContacts'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'currency' => 'getCurrency',
        'payment_term' => 'getPaymentTerm',
        'tax_rule' => 'getTaxRule',
        'discount' => 'getDiscount',
        'comments' => 'getComments',
        'account_payable' => 'getAccountPayable',
        'tax_number' => 'getTaxNumber',
        'additional_attribute1' => 'getAdditionalAttribute1',
        'additional_attribute2' => 'getAdditionalAttribute2',
        'additional_attribute3' => 'getAdditionalAttribute3',
        'additional_attribute4' => 'getAdditionalAttribute4',
        'additional_attribute5' => 'getAdditionalAttribute5',
        'additional_attribute6' => 'getAdditionalAttribute6',
        'additional_attribute7' => 'getAdditionalAttribute7',
        'additional_attribute8' => 'getAdditionalAttribute8',
        'additional_attribute9' => 'getAdditionalAttribute9',
        'additional_attribute10' => 'getAdditionalAttribute10',
        'attribute_set' => 'getAttributeSet',
        'status' => 'getStatus',
        'last_modified_on' => 'getLastModifiedOn',
        'addresses' => 'getAddresses',
        'contacts' => 'getContacts'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('payment_term', $data ?? [], null);
        $this->setIfExists('tax_rule', $data ?? [], null);
        $this->setIfExists('discount', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('account_payable', $data ?? [], null);
        $this->setIfExists('tax_number', $data ?? [], null);
        $this->setIfExists('additional_attribute1', $data ?? [], null);
        $this->setIfExists('additional_attribute2', $data ?? [], null);
        $this->setIfExists('additional_attribute3', $data ?? [], null);
        $this->setIfExists('additional_attribute4', $data ?? [], null);
        $this->setIfExists('additional_attribute5', $data ?? [], null);
        $this->setIfExists('additional_attribute6', $data ?? [], null);
        $this->setIfExists('additional_attribute7', $data ?? [], null);
        $this->setIfExists('additional_attribute8', $data ?? [], null);
        $this->setIfExists('additional_attribute9', $data ?? [], null);
        $this->setIfExists('additional_attribute10', $data ?? [], null);
        $this->setIfExists('attribute_set', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('addresses', $data ?? [], null);
        $this->setIfExists('contacts', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets payment_term
     *
     * @return string|null
     */
    public function getPaymentTerm()
    {
        return $this->container['payment_term'];
    }

    /**
     * Sets payment_term
     *
     * @param string|null $payment_term payment_term
     *
     * @return self
     */
    public function setPaymentTerm($payment_term)
    {
        if (is_null($payment_term)) {
            throw new \InvalidArgumentException('non-nullable payment_term cannot be null');
        }
        $this->container['payment_term'] = $payment_term;

        return $this;
    }

    /**
     * Gets tax_rule
     *
     * @return string|null
     */
    public function getTaxRule()
    {
        return $this->container['tax_rule'];
    }

    /**
     * Sets tax_rule
     *
     * @param string|null $tax_rule tax_rule
     *
     * @return self
     */
    public function setTaxRule($tax_rule)
    {
        if (is_null($tax_rule)) {
            throw new \InvalidArgumentException('non-nullable tax_rule cannot be null');
        }
        $this->container['tax_rule'] = $tax_rule;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param int|null $discount discount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        if (is_null($discount)) {
            throw new \InvalidArgumentException('non-nullable discount cannot be null');
        }
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return mixed|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param mixed|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            array_push($this->openAPINullablesSetToNull, 'comments');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comments', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets account_payable
     *
     * @return string|null
     */
    public function getAccountPayable()
    {
        return $this->container['account_payable'];
    }

    /**
     * Sets account_payable
     *
     * @param string|null $account_payable account_payable
     *
     * @return self
     */
    public function setAccountPayable($account_payable)
    {
        if (is_null($account_payable)) {
            throw new \InvalidArgumentException('non-nullable account_payable cannot be null');
        }
        $this->container['account_payable'] = $account_payable;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return mixed|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param mixed|null $tax_number tax_number
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        if (is_null($tax_number)) {
            array_push($this->openAPINullablesSetToNull, 'tax_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets additional_attribute1
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute1()
    {
        return $this->container['additional_attribute1'];
    }

    /**
     * Sets additional_attribute1
     *
     * @param mixed|null $additional_attribute1 additional_attribute1
     *
     * @return self
     */
    public function setAdditionalAttribute1($additional_attribute1)
    {
        if (is_null($additional_attribute1)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute1'] = $additional_attribute1;

        return $this;
    }

    /**
     * Gets additional_attribute2
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute2()
    {
        return $this->container['additional_attribute2'];
    }

    /**
     * Sets additional_attribute2
     *
     * @param mixed|null $additional_attribute2 additional_attribute2
     *
     * @return self
     */
    public function setAdditionalAttribute2($additional_attribute2)
    {
        if (is_null($additional_attribute2)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute2'] = $additional_attribute2;

        return $this;
    }

    /**
     * Gets additional_attribute3
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute3()
    {
        return $this->container['additional_attribute3'];
    }

    /**
     * Sets additional_attribute3
     *
     * @param mixed|null $additional_attribute3 additional_attribute3
     *
     * @return self
     */
    public function setAdditionalAttribute3($additional_attribute3)
    {
        if (is_null($additional_attribute3)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute3'] = $additional_attribute3;

        return $this;
    }

    /**
     * Gets additional_attribute4
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute4()
    {
        return $this->container['additional_attribute4'];
    }

    /**
     * Sets additional_attribute4
     *
     * @param mixed|null $additional_attribute4 additional_attribute4
     *
     * @return self
     */
    public function setAdditionalAttribute4($additional_attribute4)
    {
        if (is_null($additional_attribute4)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute4'] = $additional_attribute4;

        return $this;
    }

    /**
     * Gets additional_attribute5
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute5()
    {
        return $this->container['additional_attribute5'];
    }

    /**
     * Sets additional_attribute5
     *
     * @param mixed|null $additional_attribute5 additional_attribute5
     *
     * @return self
     */
    public function setAdditionalAttribute5($additional_attribute5)
    {
        if (is_null($additional_attribute5)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute5');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute5', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute5'] = $additional_attribute5;

        return $this;
    }

    /**
     * Gets additional_attribute6
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute6()
    {
        return $this->container['additional_attribute6'];
    }

    /**
     * Sets additional_attribute6
     *
     * @param mixed|null $additional_attribute6 additional_attribute6
     *
     * @return self
     */
    public function setAdditionalAttribute6($additional_attribute6)
    {
        if (is_null($additional_attribute6)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute6');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute6', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute6'] = $additional_attribute6;

        return $this;
    }

    /**
     * Gets additional_attribute7
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute7()
    {
        return $this->container['additional_attribute7'];
    }

    /**
     * Sets additional_attribute7
     *
     * @param mixed|null $additional_attribute7 additional_attribute7
     *
     * @return self
     */
    public function setAdditionalAttribute7($additional_attribute7)
    {
        if (is_null($additional_attribute7)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute7');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute7', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute7'] = $additional_attribute7;

        return $this;
    }

    /**
     * Gets additional_attribute8
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute8()
    {
        return $this->container['additional_attribute8'];
    }

    /**
     * Sets additional_attribute8
     *
     * @param mixed|null $additional_attribute8 additional_attribute8
     *
     * @return self
     */
    public function setAdditionalAttribute8($additional_attribute8)
    {
        if (is_null($additional_attribute8)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute8');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute8', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute8'] = $additional_attribute8;

        return $this;
    }

    /**
     * Gets additional_attribute9
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute9()
    {
        return $this->container['additional_attribute9'];
    }

    /**
     * Sets additional_attribute9
     *
     * @param mixed|null $additional_attribute9 additional_attribute9
     *
     * @return self
     */
    public function setAdditionalAttribute9($additional_attribute9)
    {
        if (is_null($additional_attribute9)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute9');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute9', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute9'] = $additional_attribute9;

        return $this;
    }

    /**
     * Gets additional_attribute10
     *
     * @return mixed|null
     */
    public function getAdditionalAttribute10()
    {
        return $this->container['additional_attribute10'];
    }

    /**
     * Sets additional_attribute10
     *
     * @param mixed|null $additional_attribute10 additional_attribute10
     *
     * @return self
     */
    public function setAdditionalAttribute10($additional_attribute10)
    {
        if (is_null($additional_attribute10)) {
            array_push($this->openAPINullablesSetToNull, 'additional_attribute10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('additional_attribute10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['additional_attribute10'] = $additional_attribute10;

        return $this;
    }

    /**
     * Gets attribute_set
     *
     * @return mixed|null
     */
    public function getAttributeSet()
    {
        return $this->container['attribute_set'];
    }

    /**
     * Sets attribute_set
     *
     * @param mixed|null $attribute_set attribute_set
     *
     * @return self
     */
    public function setAttributeSet($attribute_set)
    {
        if (is_null($attribute_set)) {
            array_push($this->openAPINullablesSetToNull, 'attribute_set');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attribute_set', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attribute_set'] = $attribute_set;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets addresses
     *
     * @return \Cin7\Model\BillingAddress|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Cin7\Model\BillingAddress|null $addresses addresses
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        if (is_null($addresses)) {
            throw new \InvalidArgumentException('non-nullable addresses cannot be null');
        }
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets contacts
     *
     * @return \Cin7\Model\Contact[]|null
     */
    public function getContacts()
    {
        return $this->container['contacts'];
    }

    /**
     * Sets contacts
     *
     * @param \Cin7\Model\Contact[]|null $contacts contacts
     *
     * @return self
     */
    public function setContacts($contacts)
    {
        if (is_null($contacts)) {
            throw new \InvalidArgumentException('non-nullable contacts cannot be null');
        }
        $this->container['contacts'] = $contacts;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


