<?php
/**
 * SaleSummary
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * SaleSummary Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SaleSummary implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SaleSummary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sale_id' => 'string',
        'order_number' => 'string',
        'status' => 'string',
        'order_date' => 'string',
        'invoice_date' => 'string',
        'customer' => 'string',
        'customer_id' => 'string',
        'invoice_number' => 'string',
        'customer_reference' => 'string',
        'invoice_amount' => 'int',
        'paid_amount' => 'int',
        'invoice_due_date' => 'string',
        'ship_by' => 'string',
        'base_currency' => 'string',
        'customer_currency' => 'string',
        'credit_note_number' => 'string',
        'updated' => 'string',
        'quote_status' => 'string',
        'order_status' => 'string',
        'combined_picking_status' => 'string',
        'combined_payment_status' => 'string',
        'combined_tracking_numbers' => 'string',
        'combined_packing_status' => 'string',
        'combined_shipping_status' => 'string',
        'combined_invoice_status' => 'string',
        'credit_note_status' => 'string',
        'ful_filment_status' => 'string',
        'type' => 'string',
        'source_channel' => 'string',
        'external_id' => 'mixed',
        'order_location_id' => 'string',
        'restock_status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sale_id' => null,
        'order_number' => null,
        'status' => null,
        'order_date' => null,
        'invoice_date' => null,
        'customer' => null,
        'customer_id' => null,
        'invoice_number' => null,
        'customer_reference' => null,
        'invoice_amount' => null,
        'paid_amount' => null,
        'invoice_due_date' => null,
        'ship_by' => null,
        'base_currency' => null,
        'customer_currency' => null,
        'credit_note_number' => null,
        'updated' => null,
        'quote_status' => null,
        'order_status' => null,
        'combined_picking_status' => null,
        'combined_payment_status' => null,
        'combined_tracking_numbers' => null,
        'combined_packing_status' => null,
        'combined_shipping_status' => null,
        'combined_invoice_status' => null,
        'credit_note_status' => null,
        'ful_filment_status' => null,
        'type' => null,
        'source_channel' => null,
        'external_id' => null,
        'order_location_id' => null,
        'restock_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sale_id' => false,
        'order_number' => false,
        'status' => false,
        'order_date' => false,
        'invoice_date' => false,
        'customer' => false,
        'customer_id' => false,
        'invoice_number' => false,
        'customer_reference' => false,
        'invoice_amount' => false,
        'paid_amount' => false,
        'invoice_due_date' => false,
        'ship_by' => false,
        'base_currency' => false,
        'customer_currency' => false,
        'credit_note_number' => false,
        'updated' => false,
        'quote_status' => false,
        'order_status' => false,
        'combined_picking_status' => false,
        'combined_payment_status' => false,
        'combined_tracking_numbers' => false,
        'combined_packing_status' => false,
        'combined_shipping_status' => false,
        'combined_invoice_status' => false,
        'credit_note_status' => false,
        'ful_filment_status' => false,
        'type' => false,
        'source_channel' => false,
        'external_id' => true,
        'order_location_id' => false,
        'restock_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sale_id' => 'SaleID',
        'order_number' => 'OrderNumber',
        'status' => 'Status',
        'order_date' => 'OrderDate',
        'invoice_date' => 'InvoiceDate',
        'customer' => 'Customer',
        'customer_id' => 'CustomerID',
        'invoice_number' => 'InvoiceNumber',
        'customer_reference' => 'CustomerReference',
        'invoice_amount' => 'InvoiceAmount',
        'paid_amount' => 'PaidAmount',
        'invoice_due_date' => 'InvoiceDueDate',
        'ship_by' => 'ShipBy',
        'base_currency' => 'BaseCurrency',
        'customer_currency' => 'CustomerCurrency',
        'credit_note_number' => 'CreditNoteNumber',
        'updated' => 'Updated',
        'quote_status' => 'QuoteStatus',
        'order_status' => 'OrderStatus',
        'combined_picking_status' => 'CombinedPickingStatus',
        'combined_payment_status' => 'CombinedPaymentStatus',
        'combined_tracking_numbers' => 'CombinedTrackingNumbers',
        'combined_packing_status' => 'CombinedPackingStatus',
        'combined_shipping_status' => 'CombinedShippingStatus',
        'combined_invoice_status' => 'CombinedInvoiceStatus',
        'credit_note_status' => 'CreditNoteStatus',
        'ful_filment_status' => 'FulFilmentStatus',
        'type' => 'Type',
        'source_channel' => 'SourceChannel',
        'external_id' => 'ExternalID',
        'order_location_id' => 'OrderLocationID',
        'restock_status' => 'RestockStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sale_id' => 'setSaleId',
        'order_number' => 'setOrderNumber',
        'status' => 'setStatus',
        'order_date' => 'setOrderDate',
        'invoice_date' => 'setInvoiceDate',
        'customer' => 'setCustomer',
        'customer_id' => 'setCustomerId',
        'invoice_number' => 'setInvoiceNumber',
        'customer_reference' => 'setCustomerReference',
        'invoice_amount' => 'setInvoiceAmount',
        'paid_amount' => 'setPaidAmount',
        'invoice_due_date' => 'setInvoiceDueDate',
        'ship_by' => 'setShipBy',
        'base_currency' => 'setBaseCurrency',
        'customer_currency' => 'setCustomerCurrency',
        'credit_note_number' => 'setCreditNoteNumber',
        'updated' => 'setUpdated',
        'quote_status' => 'setQuoteStatus',
        'order_status' => 'setOrderStatus',
        'combined_picking_status' => 'setCombinedPickingStatus',
        'combined_payment_status' => 'setCombinedPaymentStatus',
        'combined_tracking_numbers' => 'setCombinedTrackingNumbers',
        'combined_packing_status' => 'setCombinedPackingStatus',
        'combined_shipping_status' => 'setCombinedShippingStatus',
        'combined_invoice_status' => 'setCombinedInvoiceStatus',
        'credit_note_status' => 'setCreditNoteStatus',
        'ful_filment_status' => 'setFulFilmentStatus',
        'type' => 'setType',
        'source_channel' => 'setSourceChannel',
        'external_id' => 'setExternalId',
        'order_location_id' => 'setOrderLocationId',
        'restock_status' => 'setRestockStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sale_id' => 'getSaleId',
        'order_number' => 'getOrderNumber',
        'status' => 'getStatus',
        'order_date' => 'getOrderDate',
        'invoice_date' => 'getInvoiceDate',
        'customer' => 'getCustomer',
        'customer_id' => 'getCustomerId',
        'invoice_number' => 'getInvoiceNumber',
        'customer_reference' => 'getCustomerReference',
        'invoice_amount' => 'getInvoiceAmount',
        'paid_amount' => 'getPaidAmount',
        'invoice_due_date' => 'getInvoiceDueDate',
        'ship_by' => 'getShipBy',
        'base_currency' => 'getBaseCurrency',
        'customer_currency' => 'getCustomerCurrency',
        'credit_note_number' => 'getCreditNoteNumber',
        'updated' => 'getUpdated',
        'quote_status' => 'getQuoteStatus',
        'order_status' => 'getOrderStatus',
        'combined_picking_status' => 'getCombinedPickingStatus',
        'combined_payment_status' => 'getCombinedPaymentStatus',
        'combined_tracking_numbers' => 'getCombinedTrackingNumbers',
        'combined_packing_status' => 'getCombinedPackingStatus',
        'combined_shipping_status' => 'getCombinedShippingStatus',
        'combined_invoice_status' => 'getCombinedInvoiceStatus',
        'credit_note_status' => 'getCreditNoteStatus',
        'ful_filment_status' => 'getFulFilmentStatus',
        'type' => 'getType',
        'source_channel' => 'getSourceChannel',
        'external_id' => 'getExternalId',
        'order_location_id' => 'getOrderLocationId',
        'restock_status' => 'getRestockStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sale_id', $data ?? [], null);
        $this->setIfExists('order_number', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('order_date', $data ?? [], null);
        $this->setIfExists('invoice_date', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('invoice_number', $data ?? [], null);
        $this->setIfExists('customer_reference', $data ?? [], null);
        $this->setIfExists('invoice_amount', $data ?? [], null);
        $this->setIfExists('paid_amount', $data ?? [], null);
        $this->setIfExists('invoice_due_date', $data ?? [], null);
        $this->setIfExists('ship_by', $data ?? [], null);
        $this->setIfExists('base_currency', $data ?? [], null);
        $this->setIfExists('customer_currency', $data ?? [], null);
        $this->setIfExists('credit_note_number', $data ?? [], null);
        $this->setIfExists('updated', $data ?? [], null);
        $this->setIfExists('quote_status', $data ?? [], null);
        $this->setIfExists('order_status', $data ?? [], null);
        $this->setIfExists('combined_picking_status', $data ?? [], null);
        $this->setIfExists('combined_payment_status', $data ?? [], null);
        $this->setIfExists('combined_tracking_numbers', $data ?? [], null);
        $this->setIfExists('combined_packing_status', $data ?? [], null);
        $this->setIfExists('combined_shipping_status', $data ?? [], null);
        $this->setIfExists('combined_invoice_status', $data ?? [], null);
        $this->setIfExists('credit_note_status', $data ?? [], null);
        $this->setIfExists('ful_filment_status', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('source_channel', $data ?? [], null);
        $this->setIfExists('external_id', $data ?? [], null);
        $this->setIfExists('order_location_id', $data ?? [], null);
        $this->setIfExists('restock_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sale_id
     *
     * @return string|null
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param string|null $sale_id sale_id
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }

    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number order_number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        if (is_null($order_number)) {
            throw new \InvalidArgumentException('non-nullable order_number cannot be null');
        }
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets order_date
     *
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->container['order_date'];
    }

    /**
     * Sets order_date
     *
     * @param string|null $order_date order_date
     *
     * @return self
     */
    public function setOrderDate($order_date)
    {
        if (is_null($order_date)) {
            throw new \InvalidArgumentException('non-nullable order_date cannot be null');
        }
        $this->container['order_date'] = $order_date;

        return $this;
    }

    /**
     * Gets invoice_date
     *
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoice_date'];
    }

    /**
     * Sets invoice_date
     *
     * @param string|null $invoice_date invoice_date
     *
     * @return self
     */
    public function setInvoiceDate($invoice_date)
    {
        if (is_null($invoice_date)) {
            throw new \InvalidArgumentException('non-nullable invoice_date cannot be null');
        }
        $this->container['invoice_date'] = $invoice_date;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param string|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number invoice_number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (is_null($invoice_number)) {
            throw new \InvalidArgumentException('non-nullable invoice_number cannot be null');
        }
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets customer_reference
     *
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->container['customer_reference'];
    }

    /**
     * Sets customer_reference
     *
     * @param string|null $customer_reference customer_reference
     *
     * @return self
     */
    public function setCustomerReference($customer_reference)
    {
        if (is_null($customer_reference)) {
            throw new \InvalidArgumentException('non-nullable customer_reference cannot be null');
        }
        $this->container['customer_reference'] = $customer_reference;

        return $this;
    }

    /**
     * Gets invoice_amount
     *
     * @return int|null
     */
    public function getInvoiceAmount()
    {
        return $this->container['invoice_amount'];
    }

    /**
     * Sets invoice_amount
     *
     * @param int|null $invoice_amount invoice_amount
     *
     * @return self
     */
    public function setInvoiceAmount($invoice_amount)
    {
        if (is_null($invoice_amount)) {
            throw new \InvalidArgumentException('non-nullable invoice_amount cannot be null');
        }
        $this->container['invoice_amount'] = $invoice_amount;

        return $this;
    }

    /**
     * Gets paid_amount
     *
     * @return int|null
     */
    public function getPaidAmount()
    {
        return $this->container['paid_amount'];
    }

    /**
     * Sets paid_amount
     *
     * @param int|null $paid_amount paid_amount
     *
     * @return self
     */
    public function setPaidAmount($paid_amount)
    {
        if (is_null($paid_amount)) {
            throw new \InvalidArgumentException('non-nullable paid_amount cannot be null');
        }
        $this->container['paid_amount'] = $paid_amount;

        return $this;
    }

    /**
     * Gets invoice_due_date
     *
     * @return string|null
     */
    public function getInvoiceDueDate()
    {
        return $this->container['invoice_due_date'];
    }

    /**
     * Sets invoice_due_date
     *
     * @param string|null $invoice_due_date invoice_due_date
     *
     * @return self
     */
    public function setInvoiceDueDate($invoice_due_date)
    {
        if (is_null($invoice_due_date)) {
            throw new \InvalidArgumentException('non-nullable invoice_due_date cannot be null');
        }
        $this->container['invoice_due_date'] = $invoice_due_date;

        return $this;
    }

    /**
     * Gets ship_by
     *
     * @return string|null
     */
    public function getShipBy()
    {
        return $this->container['ship_by'];
    }

    /**
     * Sets ship_by
     *
     * @param string|null $ship_by ship_by
     *
     * @return self
     */
    public function setShipBy($ship_by)
    {
        if (is_null($ship_by)) {
            throw new \InvalidArgumentException('non-nullable ship_by cannot be null');
        }
        $this->container['ship_by'] = $ship_by;

        return $this;
    }

    /**
     * Gets base_currency
     *
     * @return string|null
     */
    public function getBaseCurrency()
    {
        return $this->container['base_currency'];
    }

    /**
     * Sets base_currency
     *
     * @param string|null $base_currency base_currency
     *
     * @return self
     */
    public function setBaseCurrency($base_currency)
    {
        if (is_null($base_currency)) {
            throw new \InvalidArgumentException('non-nullable base_currency cannot be null');
        }
        $this->container['base_currency'] = $base_currency;

        return $this;
    }

    /**
     * Gets customer_currency
     *
     * @return string|null
     */
    public function getCustomerCurrency()
    {
        return $this->container['customer_currency'];
    }

    /**
     * Sets customer_currency
     *
     * @param string|null $customer_currency customer_currency
     *
     * @return self
     */
    public function setCustomerCurrency($customer_currency)
    {
        if (is_null($customer_currency)) {
            throw new \InvalidArgumentException('non-nullable customer_currency cannot be null');
        }
        $this->container['customer_currency'] = $customer_currency;

        return $this;
    }

    /**
     * Gets credit_note_number
     *
     * @return string|null
     */
    public function getCreditNoteNumber()
    {
        return $this->container['credit_note_number'];
    }

    /**
     * Sets credit_note_number
     *
     * @param string|null $credit_note_number credit_note_number
     *
     * @return self
     */
    public function setCreditNoteNumber($credit_note_number)
    {
        if (is_null($credit_note_number)) {
            throw new \InvalidArgumentException('non-nullable credit_note_number cannot be null');
        }
        $this->container['credit_note_number'] = $credit_note_number;

        return $this;
    }

    /**
     * Gets updated
     *
     * @return string|null
     */
    public function getUpdated()
    {
        return $this->container['updated'];
    }

    /**
     * Sets updated
     *
     * @param string|null $updated updated
     *
     * @return self
     */
    public function setUpdated($updated)
    {
        if (is_null($updated)) {
            throw new \InvalidArgumentException('non-nullable updated cannot be null');
        }
        $this->container['updated'] = $updated;

        return $this;
    }

    /**
     * Gets quote_status
     *
     * @return string|null
     */
    public function getQuoteStatus()
    {
        return $this->container['quote_status'];
    }

    /**
     * Sets quote_status
     *
     * @param string|null $quote_status quote_status
     *
     * @return self
     */
    public function setQuoteStatus($quote_status)
    {
        if (is_null($quote_status)) {
            throw new \InvalidArgumentException('non-nullable quote_status cannot be null');
        }
        $this->container['quote_status'] = $quote_status;

        return $this;
    }

    /**
     * Gets order_status
     *
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status
     *
     * @param string|null $order_status order_status
     *
     * @return self
     */
    public function setOrderStatus($order_status)
    {
        if (is_null($order_status)) {
            throw new \InvalidArgumentException('non-nullable order_status cannot be null');
        }
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets combined_picking_status
     *
     * @return string|null
     */
    public function getCombinedPickingStatus()
    {
        return $this->container['combined_picking_status'];
    }

    /**
     * Sets combined_picking_status
     *
     * @param string|null $combined_picking_status combined_picking_status
     *
     * @return self
     */
    public function setCombinedPickingStatus($combined_picking_status)
    {
        if (is_null($combined_picking_status)) {
            throw new \InvalidArgumentException('non-nullable combined_picking_status cannot be null');
        }
        $this->container['combined_picking_status'] = $combined_picking_status;

        return $this;
    }

    /**
     * Gets combined_payment_status
     *
     * @return string|null
     */
    public function getCombinedPaymentStatus()
    {
        return $this->container['combined_payment_status'];
    }

    /**
     * Sets combined_payment_status
     *
     * @param string|null $combined_payment_status combined_payment_status
     *
     * @return self
     */
    public function setCombinedPaymentStatus($combined_payment_status)
    {
        if (is_null($combined_payment_status)) {
            throw new \InvalidArgumentException('non-nullable combined_payment_status cannot be null');
        }
        $this->container['combined_payment_status'] = $combined_payment_status;

        return $this;
    }

    /**
     * Gets combined_tracking_numbers
     *
     * @return string|null
     */
    public function getCombinedTrackingNumbers()
    {
        return $this->container['combined_tracking_numbers'];
    }

    /**
     * Sets combined_tracking_numbers
     *
     * @param string|null $combined_tracking_numbers combined_tracking_numbers
     *
     * @return self
     */
    public function setCombinedTrackingNumbers($combined_tracking_numbers)
    {
        if (is_null($combined_tracking_numbers)) {
            throw new \InvalidArgumentException('non-nullable combined_tracking_numbers cannot be null');
        }
        $this->container['combined_tracking_numbers'] = $combined_tracking_numbers;

        return $this;
    }

    /**
     * Gets combined_packing_status
     *
     * @return string|null
     */
    public function getCombinedPackingStatus()
    {
        return $this->container['combined_packing_status'];
    }

    /**
     * Sets combined_packing_status
     *
     * @param string|null $combined_packing_status combined_packing_status
     *
     * @return self
     */
    public function setCombinedPackingStatus($combined_packing_status)
    {
        if (is_null($combined_packing_status)) {
            throw new \InvalidArgumentException('non-nullable combined_packing_status cannot be null');
        }
        $this->container['combined_packing_status'] = $combined_packing_status;

        return $this;
    }

    /**
     * Gets combined_shipping_status
     *
     * @return string|null
     */
    public function getCombinedShippingStatus()
    {
        return $this->container['combined_shipping_status'];
    }

    /**
     * Sets combined_shipping_status
     *
     * @param string|null $combined_shipping_status combined_shipping_status
     *
     * @return self
     */
    public function setCombinedShippingStatus($combined_shipping_status)
    {
        if (is_null($combined_shipping_status)) {
            throw new \InvalidArgumentException('non-nullable combined_shipping_status cannot be null');
        }
        $this->container['combined_shipping_status'] = $combined_shipping_status;

        return $this;
    }

    /**
     * Gets combined_invoice_status
     *
     * @return string|null
     */
    public function getCombinedInvoiceStatus()
    {
        return $this->container['combined_invoice_status'];
    }

    /**
     * Sets combined_invoice_status
     *
     * @param string|null $combined_invoice_status combined_invoice_status
     *
     * @return self
     */
    public function setCombinedInvoiceStatus($combined_invoice_status)
    {
        if (is_null($combined_invoice_status)) {
            throw new \InvalidArgumentException('non-nullable combined_invoice_status cannot be null');
        }
        $this->container['combined_invoice_status'] = $combined_invoice_status;

        return $this;
    }

    /**
     * Gets credit_note_status
     *
     * @return string|null
     */
    public function getCreditNoteStatus()
    {
        return $this->container['credit_note_status'];
    }

    /**
     * Sets credit_note_status
     *
     * @param string|null $credit_note_status credit_note_status
     *
     * @return self
     */
    public function setCreditNoteStatus($credit_note_status)
    {
        if (is_null($credit_note_status)) {
            throw new \InvalidArgumentException('non-nullable credit_note_status cannot be null');
        }
        $this->container['credit_note_status'] = $credit_note_status;

        return $this;
    }

    /**
     * Gets ful_filment_status
     *
     * @return string|null
     */
    public function getFulFilmentStatus()
    {
        return $this->container['ful_filment_status'];
    }

    /**
     * Sets ful_filment_status
     *
     * @param string|null $ful_filment_status ful_filment_status
     *
     * @return self
     */
    public function setFulFilmentStatus($ful_filment_status)
    {
        if (is_null($ful_filment_status)) {
            throw new \InvalidArgumentException('non-nullable ful_filment_status cannot be null');
        }
        $this->container['ful_filment_status'] = $ful_filment_status;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets source_channel
     *
     * @return string|null
     */
    public function getSourceChannel()
    {
        return $this->container['source_channel'];
    }

    /**
     * Sets source_channel
     *
     * @param string|null $source_channel source_channel
     *
     * @return self
     */
    public function setSourceChannel($source_channel)
    {
        if (is_null($source_channel)) {
            throw new \InvalidArgumentException('non-nullable source_channel cannot be null');
        }
        $this->container['source_channel'] = $source_channel;

        return $this;
    }

    /**
     * Gets external_id
     *
     * @return mixed|null
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     *
     * @param mixed|null $external_id external_id
     *
     * @return self
     */
    public function setExternalId($external_id)
    {
        if (is_null($external_id)) {
            array_push($this->openAPINullablesSetToNull, 'external_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('external_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets order_location_id
     *
     * @return string|null
     */
    public function getOrderLocationId()
    {
        return $this->container['order_location_id'];
    }

    /**
     * Sets order_location_id
     *
     * @param string|null $order_location_id order_location_id
     *
     * @return self
     */
    public function setOrderLocationId($order_location_id)
    {
        if (is_null($order_location_id)) {
            throw new \InvalidArgumentException('non-nullable order_location_id cannot be null');
        }
        $this->container['order_location_id'] = $order_location_id;

        return $this;
    }

    /**
     * Gets restock_status
     *
     * @return string|null
     */
    public function getRestockStatus()
    {
        return $this->container['restock_status'];
    }

    /**
     * Sets restock_status
     *
     * @param string|null $restock_status restock_status
     *
     * @return self
     */
    public function setRestockStatus($restock_status)
    {
        if (is_null($restock_status)) {
            throw new \InvalidArgumentException('non-nullable restock_status cannot be null');
        }
        $this->container['restock_status'] = $restock_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


