<?php
/**
 * SaleFull
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * SaleFull Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SaleFull implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SaleFull';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'customer' => 'string',
        'customer_id' => 'string',
        'contact' => 'string',
        'phone' => 'string',
        'email' => 'string',
        'default_account' => 'string',
        'skip_quote' => 'bool',
        'billing_address' => '\Cin7\Model\BillingAddress',
        'shipping_address' => '\Cin7\Model\ShippingAddress',
        'shipping_notes' => 'string',
        'base_currency' => 'string',
        'customer_currency' => 'string',
        'tax_rule' => 'string',
        'tax_calculation' => 'string',
        'terms' => 'string',
        'price_tier' => 'string',
        'ship_by' => 'string',
        'location' => 'string',
        'sale_order_date' => 'string',
        'last_modified_on' => 'string',
        'note' => 'string',
        'customer_reference' => 'string',
        'cogs_amount' => 'int',
        'status' => 'string',
        'combined_picking_status' => 'string',
        'combined_packing_status' => 'string',
        'combined_shipping_status' => 'string',
        'ful_filment_status' => 'string',
        'combined_invoice_status' => 'string',
        'combined_payment_status' => 'string',
        'combined_tracking_numbers' => 'string',
        'carrier' => 'string',
        'currency_rate' => 'int',
        'sales_representative' => 'string',
        'service_only' => 'bool',
        'type' => 'string',
        'source_channel' => 'string',
        'quote' => '\Cin7\Model\Quote',
        'order' => '\Cin7\Model\Order',
        'fulfilments' => '\Cin7\Model\Fulfilment[]',
        'invoices' => '\Cin7\Model\Invoice[]',
        'credit_notes' => '\Cin7\Model\CreditNote[]',
        'manual_journals' => '\Cin7\Model\ManualJournal',
        'external_id' => 'string',
        'additional_attributes' => '\Cin7\Model\AdditionalAttributes',
        'attachments' => '\Cin7\Model\Attachment[]',
        'inventory_movements' => '\Cin7\Model\InventoryMovement[]',
        'transactions' => '\Cin7\Model\Transaction[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'customer' => null,
        'customer_id' => null,
        'contact' => null,
        'phone' => null,
        'email' => null,
        'default_account' => null,
        'skip_quote' => null,
        'billing_address' => null,
        'shipping_address' => null,
        'shipping_notes' => null,
        'base_currency' => null,
        'customer_currency' => null,
        'tax_rule' => null,
        'tax_calculation' => null,
        'terms' => null,
        'price_tier' => null,
        'ship_by' => null,
        'location' => null,
        'sale_order_date' => null,
        'last_modified_on' => null,
        'note' => null,
        'customer_reference' => null,
        'cogs_amount' => null,
        'status' => null,
        'combined_picking_status' => null,
        'combined_packing_status' => null,
        'combined_shipping_status' => null,
        'ful_filment_status' => null,
        'combined_invoice_status' => null,
        'combined_payment_status' => null,
        'combined_tracking_numbers' => null,
        'carrier' => null,
        'currency_rate' => null,
        'sales_representative' => null,
        'service_only' => null,
        'type' => null,
        'source_channel' => null,
        'quote' => null,
        'order' => null,
        'fulfilments' => null,
        'invoices' => null,
        'credit_notes' => null,
        'manual_journals' => null,
        'external_id' => null,
        'additional_attributes' => null,
        'attachments' => null,
        'inventory_movements' => null,
        'transactions' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'customer' => false,
        'customer_id' => false,
        'contact' => false,
        'phone' => false,
        'email' => false,
        'default_account' => false,
        'skip_quote' => false,
        'billing_address' => false,
        'shipping_address' => false,
        'shipping_notes' => false,
        'base_currency' => false,
        'customer_currency' => false,
        'tax_rule' => false,
        'tax_calculation' => false,
        'terms' => false,
        'price_tier' => false,
        'ship_by' => false,
        'location' => false,
        'sale_order_date' => false,
        'last_modified_on' => false,
        'note' => false,
        'customer_reference' => false,
        'cogs_amount' => false,
        'status' => false,
        'combined_picking_status' => false,
        'combined_packing_status' => false,
        'combined_shipping_status' => false,
        'ful_filment_status' => false,
        'combined_invoice_status' => false,
        'combined_payment_status' => false,
        'combined_tracking_numbers' => false,
        'carrier' => false,
        'currency_rate' => false,
        'sales_representative' => false,
        'service_only' => false,
        'type' => false,
        'source_channel' => false,
        'quote' => false,
        'order' => false,
        'fulfilments' => false,
        'invoices' => false,
        'credit_notes' => false,
        'manual_journals' => false,
        'external_id' => false,
        'additional_attributes' => false,
        'attachments' => false,
        'inventory_movements' => false,
        'transactions' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'ID',
        'customer' => 'Customer',
        'customer_id' => 'CustomerID',
        'contact' => 'Contact',
        'phone' => 'Phone',
        'email' => 'Email',
        'default_account' => 'DefaultAccount',
        'skip_quote' => 'SkipQuote',
        'billing_address' => 'BillingAddress',
        'shipping_address' => 'ShippingAddress',
        'shipping_notes' => 'ShippingNotes',
        'base_currency' => 'BaseCurrency',
        'customer_currency' => 'CustomerCurrency',
        'tax_rule' => 'TaxRule',
        'tax_calculation' => 'TaxCalculation',
        'terms' => 'Terms',
        'price_tier' => 'PriceTier',
        'ship_by' => 'ShipBy',
        'location' => 'Location',
        'sale_order_date' => 'SaleOrderDate',
        'last_modified_on' => 'LastModifiedOn',
        'note' => 'Note',
        'customer_reference' => 'CustomerReference',
        'cogs_amount' => 'COGSAmount',
        'status' => 'Status',
        'combined_picking_status' => 'CombinedPickingStatus',
        'combined_packing_status' => 'CombinedPackingStatus',
        'combined_shipping_status' => 'CombinedShippingStatus',
        'ful_filment_status' => 'FulFilmentStatus',
        'combined_invoice_status' => 'CombinedInvoiceStatus',
        'combined_payment_status' => 'CombinedPaymentStatus',
        'combined_tracking_numbers' => 'CombinedTrackingNumbers',
        'carrier' => 'Carrier',
        'currency_rate' => 'CurrencyRate',
        'sales_representative' => 'SalesRepresentative',
        'service_only' => 'ServiceOnly',
        'type' => 'Type',
        'source_channel' => 'SourceChannel',
        'quote' => 'Quote',
        'order' => 'Order',
        'fulfilments' => 'Fulfilments',
        'invoices' => 'Invoices',
        'credit_notes' => 'CreditNotes',
        'manual_journals' => 'ManualJournals',
        'external_id' => 'ExternalID',
        'additional_attributes' => 'AdditionalAttributes',
        'attachments' => 'Attachments',
        'inventory_movements' => 'InventoryMovements',
        'transactions' => 'Transactions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'customer' => 'setCustomer',
        'customer_id' => 'setCustomerId',
        'contact' => 'setContact',
        'phone' => 'setPhone',
        'email' => 'setEmail',
        'default_account' => 'setDefaultAccount',
        'skip_quote' => 'setSkipQuote',
        'billing_address' => 'setBillingAddress',
        'shipping_address' => 'setShippingAddress',
        'shipping_notes' => 'setShippingNotes',
        'base_currency' => 'setBaseCurrency',
        'customer_currency' => 'setCustomerCurrency',
        'tax_rule' => 'setTaxRule',
        'tax_calculation' => 'setTaxCalculation',
        'terms' => 'setTerms',
        'price_tier' => 'setPriceTier',
        'ship_by' => 'setShipBy',
        'location' => 'setLocation',
        'sale_order_date' => 'setSaleOrderDate',
        'last_modified_on' => 'setLastModifiedOn',
        'note' => 'setNote',
        'customer_reference' => 'setCustomerReference',
        'cogs_amount' => 'setCogsAmount',
        'status' => 'setStatus',
        'combined_picking_status' => 'setCombinedPickingStatus',
        'combined_packing_status' => 'setCombinedPackingStatus',
        'combined_shipping_status' => 'setCombinedShippingStatus',
        'ful_filment_status' => 'setFulFilmentStatus',
        'combined_invoice_status' => 'setCombinedInvoiceStatus',
        'combined_payment_status' => 'setCombinedPaymentStatus',
        'combined_tracking_numbers' => 'setCombinedTrackingNumbers',
        'carrier' => 'setCarrier',
        'currency_rate' => 'setCurrencyRate',
        'sales_representative' => 'setSalesRepresentative',
        'service_only' => 'setServiceOnly',
        'type' => 'setType',
        'source_channel' => 'setSourceChannel',
        'quote' => 'setQuote',
        'order' => 'setOrder',
        'fulfilments' => 'setFulfilments',
        'invoices' => 'setInvoices',
        'credit_notes' => 'setCreditNotes',
        'manual_journals' => 'setManualJournals',
        'external_id' => 'setExternalId',
        'additional_attributes' => 'setAdditionalAttributes',
        'attachments' => 'setAttachments',
        'inventory_movements' => 'setInventoryMovements',
        'transactions' => 'setTransactions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'customer' => 'getCustomer',
        'customer_id' => 'getCustomerId',
        'contact' => 'getContact',
        'phone' => 'getPhone',
        'email' => 'getEmail',
        'default_account' => 'getDefaultAccount',
        'skip_quote' => 'getSkipQuote',
        'billing_address' => 'getBillingAddress',
        'shipping_address' => 'getShippingAddress',
        'shipping_notes' => 'getShippingNotes',
        'base_currency' => 'getBaseCurrency',
        'customer_currency' => 'getCustomerCurrency',
        'tax_rule' => 'getTaxRule',
        'tax_calculation' => 'getTaxCalculation',
        'terms' => 'getTerms',
        'price_tier' => 'getPriceTier',
        'ship_by' => 'getShipBy',
        'location' => 'getLocation',
        'sale_order_date' => 'getSaleOrderDate',
        'last_modified_on' => 'getLastModifiedOn',
        'note' => 'getNote',
        'customer_reference' => 'getCustomerReference',
        'cogs_amount' => 'getCogsAmount',
        'status' => 'getStatus',
        'combined_picking_status' => 'getCombinedPickingStatus',
        'combined_packing_status' => 'getCombinedPackingStatus',
        'combined_shipping_status' => 'getCombinedShippingStatus',
        'ful_filment_status' => 'getFulFilmentStatus',
        'combined_invoice_status' => 'getCombinedInvoiceStatus',
        'combined_payment_status' => 'getCombinedPaymentStatus',
        'combined_tracking_numbers' => 'getCombinedTrackingNumbers',
        'carrier' => 'getCarrier',
        'currency_rate' => 'getCurrencyRate',
        'sales_representative' => 'getSalesRepresentative',
        'service_only' => 'getServiceOnly',
        'type' => 'getType',
        'source_channel' => 'getSourceChannel',
        'quote' => 'getQuote',
        'order' => 'getOrder',
        'fulfilments' => 'getFulfilments',
        'invoices' => 'getInvoices',
        'credit_notes' => 'getCreditNotes',
        'manual_journals' => 'getManualJournals',
        'external_id' => 'getExternalId',
        'additional_attributes' => 'getAdditionalAttributes',
        'attachments' => 'getAttachments',
        'inventory_movements' => 'getInventoryMovements',
        'transactions' => 'getTransactions'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('contact', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('default_account', $data ?? [], null);
        $this->setIfExists('skip_quote', $data ?? [], null);
        $this->setIfExists('billing_address', $data ?? [], null);
        $this->setIfExists('shipping_address', $data ?? [], null);
        $this->setIfExists('shipping_notes', $data ?? [], null);
        $this->setIfExists('base_currency', $data ?? [], null);
        $this->setIfExists('customer_currency', $data ?? [], null);
        $this->setIfExists('tax_rule', $data ?? [], null);
        $this->setIfExists('tax_calculation', $data ?? [], null);
        $this->setIfExists('terms', $data ?? [], null);
        $this->setIfExists('price_tier', $data ?? [], null);
        $this->setIfExists('ship_by', $data ?? [], null);
        $this->setIfExists('location', $data ?? [], null);
        $this->setIfExists('sale_order_date', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('customer_reference', $data ?? [], null);
        $this->setIfExists('cogs_amount', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('combined_picking_status', $data ?? [], null);
        $this->setIfExists('combined_packing_status', $data ?? [], null);
        $this->setIfExists('combined_shipping_status', $data ?? [], null);
        $this->setIfExists('ful_filment_status', $data ?? [], null);
        $this->setIfExists('combined_invoice_status', $data ?? [], null);
        $this->setIfExists('combined_payment_status', $data ?? [], null);
        $this->setIfExists('combined_tracking_numbers', $data ?? [], null);
        $this->setIfExists('carrier', $data ?? [], null);
        $this->setIfExists('currency_rate', $data ?? [], null);
        $this->setIfExists('sales_representative', $data ?? [], null);
        $this->setIfExists('service_only', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('source_channel', $data ?? [], null);
        $this->setIfExists('quote', $data ?? [], null);
        $this->setIfExists('order', $data ?? [], null);
        $this->setIfExists('fulfilments', $data ?? [], null);
        $this->setIfExists('invoices', $data ?? [], null);
        $this->setIfExists('credit_notes', $data ?? [], null);
        $this->setIfExists('manual_journals', $data ?? [], null);
        $this->setIfExists('external_id', $data ?? [], null);
        $this->setIfExists('additional_attributes', $data ?? [], null);
        $this->setIfExists('attachments', $data ?? [], null);
        $this->setIfExists('inventory_movements', $data ?? [], null);
        $this->setIfExists('transactions', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param string|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return string|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param string|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        if (is_null($contact)) {
            throw new \InvalidArgumentException('non-nullable contact cannot be null');
        }
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets default_account
     *
     * @return string|null
     */
    public function getDefaultAccount()
    {
        return $this->container['default_account'];
    }

    /**
     * Sets default_account
     *
     * @param string|null $default_account default_account
     *
     * @return self
     */
    public function setDefaultAccount($default_account)
    {
        if (is_null($default_account)) {
            throw new \InvalidArgumentException('non-nullable default_account cannot be null');
        }
        $this->container['default_account'] = $default_account;

        return $this;
    }

    /**
     * Gets skip_quote
     *
     * @return bool|null
     */
    public function getSkipQuote()
    {
        return $this->container['skip_quote'];
    }

    /**
     * Sets skip_quote
     *
     * @param bool|null $skip_quote skip_quote
     *
     * @return self
     */
    public function setSkipQuote($skip_quote)
    {
        if (is_null($skip_quote)) {
            throw new \InvalidArgumentException('non-nullable skip_quote cannot be null');
        }
        $this->container['skip_quote'] = $skip_quote;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \Cin7\Model\BillingAddress|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Cin7\Model\BillingAddress|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        if (is_null($billing_address)) {
            throw new \InvalidArgumentException('non-nullable billing_address cannot be null');
        }
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets shipping_address
     *
     * @return \Cin7\Model\ShippingAddress|null
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     *
     * @param \Cin7\Model\ShippingAddress|null $shipping_address shipping_address
     *
     * @return self
     */
    public function setShippingAddress($shipping_address)
    {
        if (is_null($shipping_address)) {
            throw new \InvalidArgumentException('non-nullable shipping_address cannot be null');
        }
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets shipping_notes
     *
     * @return string|null
     */
    public function getShippingNotes()
    {
        return $this->container['shipping_notes'];
    }

    /**
     * Sets shipping_notes
     *
     * @param string|null $shipping_notes shipping_notes
     *
     * @return self
     */
    public function setShippingNotes($shipping_notes)
    {
        if (is_null($shipping_notes)) {
            throw new \InvalidArgumentException('non-nullable shipping_notes cannot be null');
        }
        $this->container['shipping_notes'] = $shipping_notes;

        return $this;
    }

    /**
     * Gets base_currency
     *
     * @return string|null
     */
    public function getBaseCurrency()
    {
        return $this->container['base_currency'];
    }

    /**
     * Sets base_currency
     *
     * @param string|null $base_currency base_currency
     *
     * @return self
     */
    public function setBaseCurrency($base_currency)
    {
        if (is_null($base_currency)) {
            throw new \InvalidArgumentException('non-nullable base_currency cannot be null');
        }
        $this->container['base_currency'] = $base_currency;

        return $this;
    }

    /**
     * Gets customer_currency
     *
     * @return string|null
     */
    public function getCustomerCurrency()
    {
        return $this->container['customer_currency'];
    }

    /**
     * Sets customer_currency
     *
     * @param string|null $customer_currency customer_currency
     *
     * @return self
     */
    public function setCustomerCurrency($customer_currency)
    {
        if (is_null($customer_currency)) {
            throw new \InvalidArgumentException('non-nullable customer_currency cannot be null');
        }
        $this->container['customer_currency'] = $customer_currency;

        return $this;
    }

    /**
     * Gets tax_rule
     *
     * @return string|null
     */
    public function getTaxRule()
    {
        return $this->container['tax_rule'];
    }

    /**
     * Sets tax_rule
     *
     * @param string|null $tax_rule tax_rule
     *
     * @return self
     */
    public function setTaxRule($tax_rule)
    {
        if (is_null($tax_rule)) {
            throw new \InvalidArgumentException('non-nullable tax_rule cannot be null');
        }
        $this->container['tax_rule'] = $tax_rule;

        return $this;
    }

    /**
     * Gets tax_calculation
     *
     * @return string|null
     */
    public function getTaxCalculation()
    {
        return $this->container['tax_calculation'];
    }

    /**
     * Sets tax_calculation
     *
     * @param string|null $tax_calculation tax_calculation
     *
     * @return self
     */
    public function setTaxCalculation($tax_calculation)
    {
        if (is_null($tax_calculation)) {
            throw new \InvalidArgumentException('non-nullable tax_calculation cannot be null');
        }
        $this->container['tax_calculation'] = $tax_calculation;

        return $this;
    }

    /**
     * Gets terms
     *
     * @return string|null
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     *
     * @param string|null $terms terms
     *
     * @return self
     */
    public function setTerms($terms)
    {
        if (is_null($terms)) {
            throw new \InvalidArgumentException('non-nullable terms cannot be null');
        }
        $this->container['terms'] = $terms;

        return $this;
    }

    /**
     * Gets price_tier
     *
     * @return string|null
     */
    public function getPriceTier()
    {
        return $this->container['price_tier'];
    }

    /**
     * Sets price_tier
     *
     * @param string|null $price_tier price_tier
     *
     * @return self
     */
    public function setPriceTier($price_tier)
    {
        if (is_null($price_tier)) {
            throw new \InvalidArgumentException('non-nullable price_tier cannot be null');
        }
        $this->container['price_tier'] = $price_tier;

        return $this;
    }

    /**
     * Gets ship_by
     *
     * @return string|null
     */
    public function getShipBy()
    {
        return $this->container['ship_by'];
    }

    /**
     * Sets ship_by
     *
     * @param string|null $ship_by ship_by
     *
     * @return self
     */
    public function setShipBy($ship_by)
    {
        if (is_null($ship_by)) {
            throw new \InvalidArgumentException('non-nullable ship_by cannot be null');
        }
        $this->container['ship_by'] = $ship_by;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location location
     *
     * @return self
     */
    public function setLocation($location)
    {
        if (is_null($location)) {
            throw new \InvalidArgumentException('non-nullable location cannot be null');
        }
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets sale_order_date
     *
     * @return string|null
     */
    public function getSaleOrderDate()
    {
        return $this->container['sale_order_date'];
    }

    /**
     * Sets sale_order_date
     *
     * @param string|null $sale_order_date sale_order_date
     *
     * @return self
     */
    public function setSaleOrderDate($sale_order_date)
    {
        if (is_null($sale_order_date)) {
            throw new \InvalidArgumentException('non-nullable sale_order_date cannot be null');
        }
        $this->container['sale_order_date'] = $sale_order_date;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note note
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets customer_reference
     *
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->container['customer_reference'];
    }

    /**
     * Sets customer_reference
     *
     * @param string|null $customer_reference customer_reference
     *
     * @return self
     */
    public function setCustomerReference($customer_reference)
    {
        if (is_null($customer_reference)) {
            throw new \InvalidArgumentException('non-nullable customer_reference cannot be null');
        }
        $this->container['customer_reference'] = $customer_reference;

        return $this;
    }

    /**
     * Gets cogs_amount
     *
     * @return int|null
     */
    public function getCogsAmount()
    {
        return $this->container['cogs_amount'];
    }

    /**
     * Sets cogs_amount
     *
     * @param int|null $cogs_amount cogs_amount
     *
     * @return self
     */
    public function setCogsAmount($cogs_amount)
    {
        if (is_null($cogs_amount)) {
            throw new \InvalidArgumentException('non-nullable cogs_amount cannot be null');
        }
        $this->container['cogs_amount'] = $cogs_amount;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets combined_picking_status
     *
     * @return string|null
     */
    public function getCombinedPickingStatus()
    {
        return $this->container['combined_picking_status'];
    }

    /**
     * Sets combined_picking_status
     *
     * @param string|null $combined_picking_status combined_picking_status
     *
     * @return self
     */
    public function setCombinedPickingStatus($combined_picking_status)
    {
        if (is_null($combined_picking_status)) {
            throw new \InvalidArgumentException('non-nullable combined_picking_status cannot be null');
        }
        $this->container['combined_picking_status'] = $combined_picking_status;

        return $this;
    }

    /**
     * Gets combined_packing_status
     *
     * @return string|null
     */
    public function getCombinedPackingStatus()
    {
        return $this->container['combined_packing_status'];
    }

    /**
     * Sets combined_packing_status
     *
     * @param string|null $combined_packing_status combined_packing_status
     *
     * @return self
     */
    public function setCombinedPackingStatus($combined_packing_status)
    {
        if (is_null($combined_packing_status)) {
            throw new \InvalidArgumentException('non-nullable combined_packing_status cannot be null');
        }
        $this->container['combined_packing_status'] = $combined_packing_status;

        return $this;
    }

    /**
     * Gets combined_shipping_status
     *
     * @return string|null
     */
    public function getCombinedShippingStatus()
    {
        return $this->container['combined_shipping_status'];
    }

    /**
     * Sets combined_shipping_status
     *
     * @param string|null $combined_shipping_status combined_shipping_status
     *
     * @return self
     */
    public function setCombinedShippingStatus($combined_shipping_status)
    {
        if (is_null($combined_shipping_status)) {
            throw new \InvalidArgumentException('non-nullable combined_shipping_status cannot be null');
        }
        $this->container['combined_shipping_status'] = $combined_shipping_status;

        return $this;
    }

    /**
     * Gets ful_filment_status
     *
     * @return string|null
     */
    public function getFulFilmentStatus()
    {
        return $this->container['ful_filment_status'];
    }

    /**
     * Sets ful_filment_status
     *
     * @param string|null $ful_filment_status ful_filment_status
     *
     * @return self
     */
    public function setFulFilmentStatus($ful_filment_status)
    {
        if (is_null($ful_filment_status)) {
            throw new \InvalidArgumentException('non-nullable ful_filment_status cannot be null');
        }
        $this->container['ful_filment_status'] = $ful_filment_status;

        return $this;
    }

    /**
     * Gets combined_invoice_status
     *
     * @return string|null
     */
    public function getCombinedInvoiceStatus()
    {
        return $this->container['combined_invoice_status'];
    }

    /**
     * Sets combined_invoice_status
     *
     * @param string|null $combined_invoice_status combined_invoice_status
     *
     * @return self
     */
    public function setCombinedInvoiceStatus($combined_invoice_status)
    {
        if (is_null($combined_invoice_status)) {
            throw new \InvalidArgumentException('non-nullable combined_invoice_status cannot be null');
        }
        $this->container['combined_invoice_status'] = $combined_invoice_status;

        return $this;
    }

    /**
     * Gets combined_payment_status
     *
     * @return string|null
     */
    public function getCombinedPaymentStatus()
    {
        return $this->container['combined_payment_status'];
    }

    /**
     * Sets combined_payment_status
     *
     * @param string|null $combined_payment_status combined_payment_status
     *
     * @return self
     */
    public function setCombinedPaymentStatus($combined_payment_status)
    {
        if (is_null($combined_payment_status)) {
            throw new \InvalidArgumentException('non-nullable combined_payment_status cannot be null');
        }
        $this->container['combined_payment_status'] = $combined_payment_status;

        return $this;
    }

    /**
     * Gets combined_tracking_numbers
     *
     * @return string|null
     */
    public function getCombinedTrackingNumbers()
    {
        return $this->container['combined_tracking_numbers'];
    }

    /**
     * Sets combined_tracking_numbers
     *
     * @param string|null $combined_tracking_numbers combined_tracking_numbers
     *
     * @return self
     */
    public function setCombinedTrackingNumbers($combined_tracking_numbers)
    {
        if (is_null($combined_tracking_numbers)) {
            throw new \InvalidArgumentException('non-nullable combined_tracking_numbers cannot be null');
        }
        $this->container['combined_tracking_numbers'] = $combined_tracking_numbers;

        return $this;
    }

    /**
     * Gets carrier
     *
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->container['carrier'];
    }

    /**
     * Sets carrier
     *
     * @param string|null $carrier carrier
     *
     * @return self
     */
    public function setCarrier($carrier)
    {
        if (is_null($carrier)) {
            throw new \InvalidArgumentException('non-nullable carrier cannot be null');
        }
        $this->container['carrier'] = $carrier;

        return $this;
    }

    /**
     * Gets currency_rate
     *
     * @return int|null
     */
    public function getCurrencyRate()
    {
        return $this->container['currency_rate'];
    }

    /**
     * Sets currency_rate
     *
     * @param int|null $currency_rate currency_rate
     *
     * @return self
     */
    public function setCurrencyRate($currency_rate)
    {
        if (is_null($currency_rate)) {
            throw new \InvalidArgumentException('non-nullable currency_rate cannot be null');
        }
        $this->container['currency_rate'] = $currency_rate;

        return $this;
    }

    /**
     * Gets sales_representative
     *
     * @return string|null
     */
    public function getSalesRepresentative()
    {
        return $this->container['sales_representative'];
    }

    /**
     * Sets sales_representative
     *
     * @param string|null $sales_representative sales_representative
     *
     * @return self
     */
    public function setSalesRepresentative($sales_representative)
    {
        if (is_null($sales_representative)) {
            throw new \InvalidArgumentException('non-nullable sales_representative cannot be null');
        }
        $this->container['sales_representative'] = $sales_representative;

        return $this;
    }

    /**
     * Gets service_only
     *
     * @return bool|null
     */
    public function getServiceOnly()
    {
        return $this->container['service_only'];
    }

    /**
     * Sets service_only
     *
     * @param bool|null $service_only service_only
     *
     * @return self
     */
    public function setServiceOnly($service_only)
    {
        if (is_null($service_only)) {
            throw new \InvalidArgumentException('non-nullable service_only cannot be null');
        }
        $this->container['service_only'] = $service_only;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets source_channel
     *
     * @return string|null
     */
    public function getSourceChannel()
    {
        return $this->container['source_channel'];
    }

    /**
     * Sets source_channel
     *
     * @param string|null $source_channel source_channel
     *
     * @return self
     */
    public function setSourceChannel($source_channel)
    {
        if (is_null($source_channel)) {
            throw new \InvalidArgumentException('non-nullable source_channel cannot be null');
        }
        $this->container['source_channel'] = $source_channel;

        return $this;
    }

    /**
     * Gets quote
     *
     * @return \Cin7\Model\Quote|null
     */
    public function getQuote()
    {
        return $this->container['quote'];
    }

    /**
     * Sets quote
     *
     * @param \Cin7\Model\Quote|null $quote quote
     *
     * @return self
     */
    public function setQuote($quote)
    {
        if (is_null($quote)) {
            throw new \InvalidArgumentException('non-nullable quote cannot be null');
        }
        $this->container['quote'] = $quote;

        return $this;
    }

    /**
     * Gets order
     *
     * @return \Cin7\Model\Order|null
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     *
     * @param \Cin7\Model\Order|null $order order
     *
     * @return self
     */
    public function setOrder($order)
    {
        if (is_null($order)) {
            throw new \InvalidArgumentException('non-nullable order cannot be null');
        }
        $this->container['order'] = $order;

        return $this;
    }

    /**
     * Gets fulfilments
     *
     * @return \Cin7\Model\Fulfilment[]|null
     */
    public function getFulfilments()
    {
        return $this->container['fulfilments'];
    }

    /**
     * Sets fulfilments
     *
     * @param \Cin7\Model\Fulfilment[]|null $fulfilments fulfilments
     *
     * @return self
     */
    public function setFulfilments($fulfilments)
    {
        if (is_null($fulfilments)) {
            throw new \InvalidArgumentException('non-nullable fulfilments cannot be null');
        }
        $this->container['fulfilments'] = $fulfilments;

        return $this;
    }

    /**
     * Gets invoices
     *
     * @return \Cin7\Model\Invoice[]|null
     */
    public function getInvoices()
    {
        return $this->container['invoices'];
    }

    /**
     * Sets invoices
     *
     * @param \Cin7\Model\Invoice[]|null $invoices invoices
     *
     * @return self
     */
    public function setInvoices($invoices)
    {
        if (is_null($invoices)) {
            throw new \InvalidArgumentException('non-nullable invoices cannot be null');
        }
        $this->container['invoices'] = $invoices;

        return $this;
    }

    /**
     * Gets credit_notes
     *
     * @return \Cin7\Model\CreditNote[]|null
     */
    public function getCreditNotes()
    {
        return $this->container['credit_notes'];
    }

    /**
     * Sets credit_notes
     *
     * @param \Cin7\Model\CreditNote[]|null $credit_notes credit_notes
     *
     * @return self
     */
    public function setCreditNotes($credit_notes)
    {
        if (is_null($credit_notes)) {
            throw new \InvalidArgumentException('non-nullable credit_notes cannot be null');
        }
        $this->container['credit_notes'] = $credit_notes;

        return $this;
    }

    /**
     * Gets manual_journals
     *
     * @return \Cin7\Model\ManualJournal|null
     */
    public function getManualJournals()
    {
        return $this->container['manual_journals'];
    }

    /**
     * Sets manual_journals
     *
     * @param \Cin7\Model\ManualJournal|null $manual_journals manual_journals
     *
     * @return self
     */
    public function setManualJournals($manual_journals)
    {
        if (is_null($manual_journals)) {
            throw new \InvalidArgumentException('non-nullable manual_journals cannot be null');
        }
        $this->container['manual_journals'] = $manual_journals;

        return $this;
    }

    /**
     * Gets external_id
     *
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     *
     * @param string|null $external_id external_id
     *
     * @return self
     */
    public function setExternalId($external_id)
    {
        if (is_null($external_id)) {
            throw new \InvalidArgumentException('non-nullable external_id cannot be null');
        }
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets additional_attributes
     *
     * @return \Cin7\Model\AdditionalAttributes|null
     */
    public function getAdditionalAttributes()
    {
        return $this->container['additional_attributes'];
    }

    /**
     * Sets additional_attributes
     *
     * @param \Cin7\Model\AdditionalAttributes|null $additional_attributes additional_attributes
     *
     * @return self
     */
    public function setAdditionalAttributes($additional_attributes)
    {
        if (is_null($additional_attributes)) {
            throw new \InvalidArgumentException('non-nullable additional_attributes cannot be null');
        }
        $this->container['additional_attributes'] = $additional_attributes;

        return $this;
    }

    /**
     * Gets attachments
     *
     * @return \Cin7\Model\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \Cin7\Model\Attachment[]|null $attachments attachments
     *
     * @return self
     */
    public function setAttachments($attachments)
    {
        if (is_null($attachments)) {
            throw new \InvalidArgumentException('non-nullable attachments cannot be null');
        }
        $this->container['attachments'] = $attachments;

        return $this;
    }

    /**
     * Gets inventory_movements
     *
     * @return \Cin7\Model\InventoryMovement[]|null
     */
    public function getInventoryMovements()
    {
        return $this->container['inventory_movements'];
    }

    /**
     * Sets inventory_movements
     *
     * @param \Cin7\Model\InventoryMovement[]|null $inventory_movements inventory_movements
     *
     * @return self
     */
    public function setInventoryMovements($inventory_movements)
    {
        if (is_null($inventory_movements)) {
            throw new \InvalidArgumentException('non-nullable inventory_movements cannot be null');
        }
        $this->container['inventory_movements'] = $inventory_movements;

        return $this;
    }

    /**
     * Gets transactions
     *
     * @return \Cin7\Model\Transaction[]|null
     */
    public function getTransactions()
    {
        return $this->container['transactions'];
    }

    /**
     * Sets transactions
     *
     * @param \Cin7\Model\Transaction[]|null $transactions transactions
     *
     * @return self
     */
    public function setTransactions($transactions)
    {
        if (is_null($transactions)) {
            throw new \InvalidArgumentException('non-nullable transactions cannot be null');
        }
        $this->container['transactions'] = $transactions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


