<?php
/**
 * Sale
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * Sale Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Sale implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Sale';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'customer' => 'string',
        'customer_id' => 'string',
        'phone' => 'string',
        'email' => 'string',
        'contact' => 'string',
        'default_account' => 'string',
        'billing_address' => '\Cin7\Model\BillingAddress',
        'shipping_address' => '\Cin7\Model\ShippingAddress',
        'shipping_notes' => 'string',
        'tax_rule' => 'string',
        'tax_inclusive' => 'string',
        'terms' => 'string',
        'price_tier' => 'string',
        'location' => 'string',
        'note' => 'string',
        'customer_reference' => 'string',
        'sales_representative' => 'string',
        'carrier' => 'string',
        'currency_rate' => 'string',
        'additional_attributes' => '\Cin7\Model\AdditionalAttributes',
        'ship_by' => 'string',
        'sale_order_date' => 'string',
        'skip_quote' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'customer' => null,
        'customer_id' => null,
        'phone' => null,
        'email' => null,
        'contact' => null,
        'default_account' => null,
        'billing_address' => null,
        'shipping_address' => null,
        'shipping_notes' => null,
        'tax_rule' => null,
        'tax_inclusive' => null,
        'terms' => null,
        'price_tier' => null,
        'location' => null,
        'note' => null,
        'customer_reference' => null,
        'sales_representative' => null,
        'carrier' => null,
        'currency_rate' => null,
        'additional_attributes' => null,
        'ship_by' => null,
        'sale_order_date' => null,
        'skip_quote' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'customer' => false,
        'customer_id' => false,
        'phone' => false,
        'email' => false,
        'contact' => false,
        'default_account' => false,
        'billing_address' => false,
        'shipping_address' => false,
        'shipping_notes' => false,
        'tax_rule' => false,
        'tax_inclusive' => false,
        'terms' => false,
        'price_tier' => false,
        'location' => false,
        'note' => false,
        'customer_reference' => false,
        'sales_representative' => false,
        'carrier' => false,
        'currency_rate' => false,
        'additional_attributes' => false,
        'ship_by' => false,
        'sale_order_date' => false,
        'skip_quote' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'ID',
        'customer' => 'Customer',
        'customer_id' => 'CustomerID',
        'phone' => 'Phone',
        'email' => 'Email',
        'contact' => 'Contact',
        'default_account' => 'DefaultAccount',
        'billing_address' => 'BillingAddress',
        'shipping_address' => 'ShippingAddress',
        'shipping_notes' => 'ShippingNotes',
        'tax_rule' => 'TaxRule',
        'tax_inclusive' => 'TaxInclusive',
        'terms' => 'Terms',
        'price_tier' => 'PriceTier',
        'location' => 'Location',
        'note' => 'Note',
        'customer_reference' => 'CustomerReference',
        'sales_representative' => 'SalesRepresentative',
        'carrier' => 'Carrier',
        'currency_rate' => 'CurrencyRate',
        'additional_attributes' => 'AdditionalAttributes',
        'ship_by' => 'ShipBy',
        'sale_order_date' => 'SaleOrderDate',
        'skip_quote' => 'SkipQuote'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'customer' => 'setCustomer',
        'customer_id' => 'setCustomerId',
        'phone' => 'setPhone',
        'email' => 'setEmail',
        'contact' => 'setContact',
        'default_account' => 'setDefaultAccount',
        'billing_address' => 'setBillingAddress',
        'shipping_address' => 'setShippingAddress',
        'shipping_notes' => 'setShippingNotes',
        'tax_rule' => 'setTaxRule',
        'tax_inclusive' => 'setTaxInclusive',
        'terms' => 'setTerms',
        'price_tier' => 'setPriceTier',
        'location' => 'setLocation',
        'note' => 'setNote',
        'customer_reference' => 'setCustomerReference',
        'sales_representative' => 'setSalesRepresentative',
        'carrier' => 'setCarrier',
        'currency_rate' => 'setCurrencyRate',
        'additional_attributes' => 'setAdditionalAttributes',
        'ship_by' => 'setShipBy',
        'sale_order_date' => 'setSaleOrderDate',
        'skip_quote' => 'setSkipQuote'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'customer' => 'getCustomer',
        'customer_id' => 'getCustomerId',
        'phone' => 'getPhone',
        'email' => 'getEmail',
        'contact' => 'getContact',
        'default_account' => 'getDefaultAccount',
        'billing_address' => 'getBillingAddress',
        'shipping_address' => 'getShippingAddress',
        'shipping_notes' => 'getShippingNotes',
        'tax_rule' => 'getTaxRule',
        'tax_inclusive' => 'getTaxInclusive',
        'terms' => 'getTerms',
        'price_tier' => 'getPriceTier',
        'location' => 'getLocation',
        'note' => 'getNote',
        'customer_reference' => 'getCustomerReference',
        'sales_representative' => 'getSalesRepresentative',
        'carrier' => 'getCarrier',
        'currency_rate' => 'getCurrencyRate',
        'additional_attributes' => 'getAdditionalAttributes',
        'ship_by' => 'getShipBy',
        'sale_order_date' => 'getSaleOrderDate',
        'skip_quote' => 'getSkipQuote'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('contact', $data ?? [], null);
        $this->setIfExists('default_account', $data ?? [], null);
        $this->setIfExists('billing_address', $data ?? [], null);
        $this->setIfExists('shipping_address', $data ?? [], null);
        $this->setIfExists('shipping_notes', $data ?? [], null);
        $this->setIfExists('tax_rule', $data ?? [], null);
        $this->setIfExists('tax_inclusive', $data ?? [], null);
        $this->setIfExists('terms', $data ?? [], null);
        $this->setIfExists('price_tier', $data ?? [], null);
        $this->setIfExists('location', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('customer_reference', $data ?? [], null);
        $this->setIfExists('sales_representative', $data ?? [], null);
        $this->setIfExists('carrier', $data ?? [], null);
        $this->setIfExists('currency_rate', $data ?? [], null);
        $this->setIfExists('additional_attributes', $data ?? [], null);
        $this->setIfExists('ship_by', $data ?? [], null);
        $this->setIfExists('sale_order_date', $data ?? [], null);
        $this->setIfExists('skip_quote', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param string|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return string|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param string|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        if (is_null($contact)) {
            throw new \InvalidArgumentException('non-nullable contact cannot be null');
        }
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets default_account
     *
     * @return string|null
     */
    public function getDefaultAccount()
    {
        return $this->container['default_account'];
    }

    /**
     * Sets default_account
     *
     * @param string|null $default_account default_account
     *
     * @return self
     */
    public function setDefaultAccount($default_account)
    {
        if (is_null($default_account)) {
            throw new \InvalidArgumentException('non-nullable default_account cannot be null');
        }
        $this->container['default_account'] = $default_account;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \Cin7\Model\BillingAddress|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Cin7\Model\BillingAddress|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        if (is_null($billing_address)) {
            throw new \InvalidArgumentException('non-nullable billing_address cannot be null');
        }
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets shipping_address
     *
     * @return \Cin7\Model\ShippingAddress|null
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     *
     * @param \Cin7\Model\ShippingAddress|null $shipping_address shipping_address
     *
     * @return self
     */
    public function setShippingAddress($shipping_address)
    {
        if (is_null($shipping_address)) {
            throw new \InvalidArgumentException('non-nullable shipping_address cannot be null');
        }
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets shipping_notes
     *
     * @return string|null
     */
    public function getShippingNotes()
    {
        return $this->container['shipping_notes'];
    }

    /**
     * Sets shipping_notes
     *
     * @param string|null $shipping_notes shipping_notes
     *
     * @return self
     */
    public function setShippingNotes($shipping_notes)
    {
        if (is_null($shipping_notes)) {
            throw new \InvalidArgumentException('non-nullable shipping_notes cannot be null');
        }
        $this->container['shipping_notes'] = $shipping_notes;

        return $this;
    }

    /**
     * Gets tax_rule
     *
     * @return string|null
     */
    public function getTaxRule()
    {
        return $this->container['tax_rule'];
    }

    /**
     * Sets tax_rule
     *
     * @param string|null $tax_rule tax_rule
     *
     * @return self
     */
    public function setTaxRule($tax_rule)
    {
        if (is_null($tax_rule)) {
            throw new \InvalidArgumentException('non-nullable tax_rule cannot be null');
        }
        $this->container['tax_rule'] = $tax_rule;

        return $this;
    }

    /**
     * Gets tax_inclusive
     *
     * @return string|null
     */
    public function getTaxInclusive()
    {
        return $this->container['tax_inclusive'];
    }

    /**
     * Sets tax_inclusive
     *
     * @param string|null $tax_inclusive tax_inclusive
     *
     * @return self
     */
    public function setTaxInclusive($tax_inclusive)
    {
        if (is_null($tax_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_inclusive cannot be null');
        }
        $this->container['tax_inclusive'] = $tax_inclusive;

        return $this;
    }

    /**
     * Gets terms
     *
     * @return string|null
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     *
     * @param string|null $terms terms
     *
     * @return self
     */
    public function setTerms($terms)
    {
        if (is_null($terms)) {
            throw new \InvalidArgumentException('non-nullable terms cannot be null');
        }
        $this->container['terms'] = $terms;

        return $this;
    }

    /**
     * Gets price_tier
     *
     * @return string|null
     */
    public function getPriceTier()
    {
        return $this->container['price_tier'];
    }

    /**
     * Sets price_tier
     *
     * @param string|null $price_tier price_tier
     *
     * @return self
     */
    public function setPriceTier($price_tier)
    {
        if (is_null($price_tier)) {
            throw new \InvalidArgumentException('non-nullable price_tier cannot be null');
        }
        $this->container['price_tier'] = $price_tier;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location location
     *
     * @return self
     */
    public function setLocation($location)
    {
        if (is_null($location)) {
            throw new \InvalidArgumentException('non-nullable location cannot be null');
        }
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note note
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets customer_reference
     *
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->container['customer_reference'];
    }

    /**
     * Sets customer_reference
     *
     * @param string|null $customer_reference customer_reference
     *
     * @return self
     */
    public function setCustomerReference($customer_reference)
    {
        if (is_null($customer_reference)) {
            throw new \InvalidArgumentException('non-nullable customer_reference cannot be null');
        }
        $this->container['customer_reference'] = $customer_reference;

        return $this;
    }

    /**
     * Gets sales_representative
     *
     * @return string|null
     */
    public function getSalesRepresentative()
    {
        return $this->container['sales_representative'];
    }

    /**
     * Sets sales_representative
     *
     * @param string|null $sales_representative sales_representative
     *
     * @return self
     */
    public function setSalesRepresentative($sales_representative)
    {
        if (is_null($sales_representative)) {
            throw new \InvalidArgumentException('non-nullable sales_representative cannot be null');
        }
        $this->container['sales_representative'] = $sales_representative;

        return $this;
    }

    /**
     * Gets carrier
     *
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->container['carrier'];
    }

    /**
     * Sets carrier
     *
     * @param string|null $carrier carrier
     *
     * @return self
     */
    public function setCarrier($carrier)
    {
        if (is_null($carrier)) {
            throw new \InvalidArgumentException('non-nullable carrier cannot be null');
        }
        $this->container['carrier'] = $carrier;

        return $this;
    }

    /**
     * Gets currency_rate
     *
     * @return string|null
     */
    public function getCurrencyRate()
    {
        return $this->container['currency_rate'];
    }

    /**
     * Sets currency_rate
     *
     * @param string|null $currency_rate currency_rate
     *
     * @return self
     */
    public function setCurrencyRate($currency_rate)
    {
        if (is_null($currency_rate)) {
            throw new \InvalidArgumentException('non-nullable currency_rate cannot be null');
        }
        $this->container['currency_rate'] = $currency_rate;

        return $this;
    }

    /**
     * Gets additional_attributes
     *
     * @return \Cin7\Model\AdditionalAttributes|null
     */
    public function getAdditionalAttributes()
    {
        return $this->container['additional_attributes'];
    }

    /**
     * Sets additional_attributes
     *
     * @param \Cin7\Model\AdditionalAttributes|null $additional_attributes additional_attributes
     *
     * @return self
     */
    public function setAdditionalAttributes($additional_attributes)
    {
        if (is_null($additional_attributes)) {
            throw new \InvalidArgumentException('non-nullable additional_attributes cannot be null');
        }
        $this->container['additional_attributes'] = $additional_attributes;

        return $this;
    }

    /**
     * Gets ship_by
     *
     * @return string|null
     */
    public function getShipBy()
    {
        return $this->container['ship_by'];
    }

    /**
     * Sets ship_by
     *
     * @param string|null $ship_by ship_by
     *
     * @return self
     */
    public function setShipBy($ship_by)
    {
        if (is_null($ship_by)) {
            throw new \InvalidArgumentException('non-nullable ship_by cannot be null');
        }
        $this->container['ship_by'] = $ship_by;

        return $this;
    }

    /**
     * Gets sale_order_date
     *
     * @return string|null
     */
    public function getSaleOrderDate()
    {
        return $this->container['sale_order_date'];
    }

    /**
     * Sets sale_order_date
     *
     * @param string|null $sale_order_date sale_order_date
     *
     * @return self
     */
    public function setSaleOrderDate($sale_order_date)
    {
        if (is_null($sale_order_date)) {
            throw new \InvalidArgumentException('non-nullable sale_order_date cannot be null');
        }
        $this->container['sale_order_date'] = $sale_order_date;

        return $this;
    }

    /**
     * Gets skip_quote
     *
     * @return string|null
     */
    public function getSkipQuote()
    {
        return $this->container['skip_quote'];
    }

    /**
     * Sets skip_quote
     *
     * @param string|null $skip_quote skip_quote
     *
     * @return self
     */
    public function setSkipQuote($skip_quote)
    {
        if (is_null($skip_quote)) {
            throw new \InvalidArgumentException('non-nullable skip_quote cannot be null');
        }
        $this->container['skip_quote'] = $skip_quote;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


