<?php
/**
 * ReorderLevel
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * ReorderLevel Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReorderLevel implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReorderLevel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'location_id' => 'string',
        'location_name' => 'string',
        'minimum_before_reorder' => 'int',
        'reorder_quantity' => 'int',
        'stock_locator' => 'string',
        'pick_zones' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'location_id' => null,
        'location_name' => null,
        'minimum_before_reorder' => null,
        'reorder_quantity' => null,
        'stock_locator' => null,
        'pick_zones' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'location_id' => false,
        'location_name' => false,
        'minimum_before_reorder' => false,
        'reorder_quantity' => false,
        'stock_locator' => false,
        'pick_zones' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'location_id' => 'LocationID',
        'location_name' => 'LocationName',
        'minimum_before_reorder' => 'MinimumBeforeReorder',
        'reorder_quantity' => 'ReorderQuantity',
        'stock_locator' => 'StockLocator',
        'pick_zones' => 'PickZones'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'location_id' => 'setLocationId',
        'location_name' => 'setLocationName',
        'minimum_before_reorder' => 'setMinimumBeforeReorder',
        'reorder_quantity' => 'setReorderQuantity',
        'stock_locator' => 'setStockLocator',
        'pick_zones' => 'setPickZones'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'location_id' => 'getLocationId',
        'location_name' => 'getLocationName',
        'minimum_before_reorder' => 'getMinimumBeforeReorder',
        'reorder_quantity' => 'getReorderQuantity',
        'stock_locator' => 'getStockLocator',
        'pick_zones' => 'getPickZones'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('location_name', $data ?? [], null);
        $this->setIfExists('minimum_before_reorder', $data ?? [], null);
        $this->setIfExists('reorder_quantity', $data ?? [], null);
        $this->setIfExists('stock_locator', $data ?? [], null);
        $this->setIfExists('pick_zones', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id location_id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets location_name
     *
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->container['location_name'];
    }

    /**
     * Sets location_name
     *
     * @param string|null $location_name location_name
     *
     * @return self
     */
    public function setLocationName($location_name)
    {
        if (is_null($location_name)) {
            throw new \InvalidArgumentException('non-nullable location_name cannot be null');
        }
        $this->container['location_name'] = $location_name;

        return $this;
    }

    /**
     * Gets minimum_before_reorder
     *
     * @return int|null
     */
    public function getMinimumBeforeReorder()
    {
        return $this->container['minimum_before_reorder'];
    }

    /**
     * Sets minimum_before_reorder
     *
     * @param int|null $minimum_before_reorder minimum_before_reorder
     *
     * @return self
     */
    public function setMinimumBeforeReorder($minimum_before_reorder)
    {
        if (is_null($minimum_before_reorder)) {
            throw new \InvalidArgumentException('non-nullable minimum_before_reorder cannot be null');
        }
        $this->container['minimum_before_reorder'] = $minimum_before_reorder;

        return $this;
    }

    /**
     * Gets reorder_quantity
     *
     * @return int|null
     */
    public function getReorderQuantity()
    {
        return $this->container['reorder_quantity'];
    }

    /**
     * Sets reorder_quantity
     *
     * @param int|null $reorder_quantity reorder_quantity
     *
     * @return self
     */
    public function setReorderQuantity($reorder_quantity)
    {
        if (is_null($reorder_quantity)) {
            throw new \InvalidArgumentException('non-nullable reorder_quantity cannot be null');
        }
        $this->container['reorder_quantity'] = $reorder_quantity;

        return $this;
    }

    /**
     * Gets stock_locator
     *
     * @return string|null
     */
    public function getStockLocator()
    {
        return $this->container['stock_locator'];
    }

    /**
     * Sets stock_locator
     *
     * @param string|null $stock_locator stock_locator
     *
     * @return self
     */
    public function setStockLocator($stock_locator)
    {
        if (is_null($stock_locator)) {
            throw new \InvalidArgumentException('non-nullable stock_locator cannot be null');
        }
        $this->container['stock_locator'] = $stock_locator;

        return $this;
    }

    /**
     * Gets pick_zones
     *
     * @return string|null
     */
    public function getPickZones()
    {
        return $this->container['pick_zones'];
    }

    /**
     * Sets pick_zones
     *
     * @param string|null $pick_zones pick_zones
     *
     * @return self
     */
    public function setPickZones($pick_zones)
    {
        if (is_null($pick_zones)) {
            throw new \InvalidArgumentException('non-nullable pick_zones cannot be null');
        }
        $this->container['pick_zones'] = $pick_zones;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


