<?php
/**
 * Product
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'sku' => 'string',
        'name' => 'string',
        'category' => 'string',
        'brand' => 'string',
        'type' => 'string',
        'costing_method' => 'string',
        'drop_ship_mode' => 'string',
        'default_location' => 'string',
        'length' => 'int',
        'width' => 'int',
        'height' => 'int',
        'weight' => 'int',
        'uom' => 'string',
        'weight_units' => 'string',
        'dimensions_units' => 'string',
        'barcode' => 'string',
        'minimum_before_reorder' => 'int',
        'reorder_quantity' => 'int',
        'price_tier1' => 'int',
        'price_tier2' => 'int',
        'price_tier3' => 'int',
        'price_tier4' => 'int',
        'price_tier5' => 'int',
        'price_tier6' => 'int',
        'price_tier7' => 'int',
        'price_tier8' => 'int',
        'price_tier9' => 'int',
        'price_tier10' => 'int',
        'price_tiers' => '\Cin7\Model\PriceTiers',
        'average_cost' => 'int',
        'short_description' => 'string',
        'description' => 'string',
        'internal_note' => 'string',
        'additional_attribute1' => 'string',
        'additional_attribute2' => 'string',
        'additional_attribute3' => 'string',
        'additional_attribute4' => 'string',
        'additional_attribute5' => 'string',
        'additional_attribute6' => 'string',
        'additional_attribute7' => 'string',
        'additional_attribute8' => 'string',
        'additional_attribute9' => 'string',
        'additional_attribute10' => 'string',
        'attribute_set' => 'mixed',
        'discount_rule' => 'mixed',
        'tags' => 'string',
        'status' => 'string',
        'stock_locator' => 'string',
        'cogs_account' => 'string',
        'revenue_account' => 'string',
        'expense_account' => 'string',
        'inventory_account' => 'string',
        'purchase_tax_rule' => 'string',
        'sale_tax_rule' => 'string',
        'last_modified_on' => 'string',
        'sellable' => 'bool',
        'pick_zones' => 'string',
        'bill_of_material' => 'bool',
        'auto_assembly' => 'bool',
        'auto_disassembly' => 'bool',
        'quantity_to_produce' => 'int',
        'assembly_instruction_url' => 'string',
        'assembly_cost_estimation_method' => 'string',
        'suppliers' => '\Cin7\Model\Supplier',
        'reorder_levels' => '\Cin7\Model\ReorderLevel',
        'bill_of_materials_products' => '\Cin7\Model\BillOfMaterialsProduct[]',
        'bill_of_materials_services' => '\Cin7\Model\BillOfMaterialsService[]',
        'movements' => '\Cin7\Model\Movement[]',
        'attachments' => '\Cin7\Model\Attachment[]',
        'custom_prices' => '\Cin7\Model\CustomPrice',
        'carton_height' => 'int',
        'carton_width' => 'int',
        'carton_length' => 'int',
        'carton_quantity' => 'int',
        'carton_inner_quantity' => 'int',
        'hs_code' => 'string',
        'country_of_origin' => 'string',
        'country_of_origin_code' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'sku' => null,
        'name' => null,
        'category' => null,
        'brand' => null,
        'type' => null,
        'costing_method' => null,
        'drop_ship_mode' => null,
        'default_location' => null,
        'length' => null,
        'width' => null,
        'height' => null,
        'weight' => null,
        'uom' => null,
        'weight_units' => null,
        'dimensions_units' => null,
        'barcode' => null,
        'minimum_before_reorder' => null,
        'reorder_quantity' => null,
        'price_tier1' => null,
        'price_tier2' => null,
        'price_tier3' => null,
        'price_tier4' => null,
        'price_tier5' => null,
        'price_tier6' => null,
        'price_tier7' => null,
        'price_tier8' => null,
        'price_tier9' => null,
        'price_tier10' => null,
        'price_tiers' => null,
        'average_cost' => null,
        'short_description' => null,
        'description' => null,
        'internal_note' => null,
        'additional_attribute1' => null,
        'additional_attribute2' => null,
        'additional_attribute3' => null,
        'additional_attribute4' => null,
        'additional_attribute5' => null,
        'additional_attribute6' => null,
        'additional_attribute7' => null,
        'additional_attribute8' => null,
        'additional_attribute9' => null,
        'additional_attribute10' => null,
        'attribute_set' => null,
        'discount_rule' => null,
        'tags' => null,
        'status' => null,
        'stock_locator' => null,
        'cogs_account' => null,
        'revenue_account' => null,
        'expense_account' => null,
        'inventory_account' => null,
        'purchase_tax_rule' => null,
        'sale_tax_rule' => null,
        'last_modified_on' => null,
        'sellable' => null,
        'pick_zones' => null,
        'bill_of_material' => null,
        'auto_assembly' => null,
        'auto_disassembly' => null,
        'quantity_to_produce' => null,
        'assembly_instruction_url' => null,
        'assembly_cost_estimation_method' => null,
        'suppliers' => null,
        'reorder_levels' => null,
        'bill_of_materials_products' => null,
        'bill_of_materials_services' => null,
        'movements' => null,
        'attachments' => null,
        'custom_prices' => null,
        'carton_height' => null,
        'carton_width' => null,
        'carton_length' => null,
        'carton_quantity' => null,
        'carton_inner_quantity' => null,
        'hs_code' => null,
        'country_of_origin' => null,
        'country_of_origin_code' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'sku' => false,
        'name' => false,
        'category' => false,
        'brand' => false,
        'type' => false,
        'costing_method' => false,
        'drop_ship_mode' => false,
        'default_location' => false,
        'length' => false,
        'width' => false,
        'height' => false,
        'weight' => false,
        'uom' => false,
        'weight_units' => false,
        'dimensions_units' => false,
        'barcode' => false,
        'minimum_before_reorder' => false,
        'reorder_quantity' => false,
        'price_tier1' => false,
        'price_tier2' => false,
        'price_tier3' => false,
        'price_tier4' => false,
        'price_tier5' => false,
        'price_tier6' => false,
        'price_tier7' => false,
        'price_tier8' => false,
        'price_tier9' => false,
        'price_tier10' => false,
        'price_tiers' => false,
        'average_cost' => false,
        'short_description' => false,
        'description' => false,
        'internal_note' => false,
        'additional_attribute1' => false,
        'additional_attribute2' => false,
        'additional_attribute3' => false,
        'additional_attribute4' => false,
        'additional_attribute5' => false,
        'additional_attribute6' => false,
        'additional_attribute7' => false,
        'additional_attribute8' => false,
        'additional_attribute9' => false,
        'additional_attribute10' => false,
        'attribute_set' => true,
        'discount_rule' => true,
        'tags' => false,
        'status' => false,
        'stock_locator' => false,
        'cogs_account' => false,
        'revenue_account' => false,
        'expense_account' => false,
        'inventory_account' => false,
        'purchase_tax_rule' => false,
        'sale_tax_rule' => false,
        'last_modified_on' => false,
        'sellable' => false,
        'pick_zones' => false,
        'bill_of_material' => false,
        'auto_assembly' => false,
        'auto_disassembly' => false,
        'quantity_to_produce' => false,
        'assembly_instruction_url' => false,
        'assembly_cost_estimation_method' => false,
        'suppliers' => false,
        'reorder_levels' => false,
        'bill_of_materials_products' => false,
        'bill_of_materials_services' => false,
        'movements' => false,
        'attachments' => false,
        'custom_prices' => false,
        'carton_height' => false,
        'carton_width' => false,
        'carton_length' => false,
        'carton_quantity' => false,
        'carton_inner_quantity' => false,
        'hs_code' => false,
        'country_of_origin' => false,
        'country_of_origin_code' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'ID',
        'sku' => 'SKU',
        'name' => 'Name',
        'category' => 'Category',
        'brand' => 'Brand',
        'type' => 'Type',
        'costing_method' => 'CostingMethod',
        'drop_ship_mode' => 'DropShipMode',
        'default_location' => 'DefaultLocation',
        'length' => 'Length',
        'width' => 'Width',
        'height' => 'Height',
        'weight' => 'Weight',
        'uom' => 'UOM',
        'weight_units' => 'WeightUnits',
        'dimensions_units' => 'DimensionsUnits',
        'barcode' => 'Barcode',
        'minimum_before_reorder' => 'MinimumBeforeReorder',
        'reorder_quantity' => 'ReorderQuantity',
        'price_tier1' => 'PriceTier1',
        'price_tier2' => 'PriceTier2',
        'price_tier3' => 'PriceTier3',
        'price_tier4' => 'PriceTier4',
        'price_tier5' => 'PriceTier5',
        'price_tier6' => 'PriceTier6',
        'price_tier7' => 'PriceTier7',
        'price_tier8' => 'PriceTier8',
        'price_tier9' => 'PriceTier9',
        'price_tier10' => 'PriceTier10',
        'price_tiers' => 'PriceTiers',
        'average_cost' => 'AverageCost',
        'short_description' => 'ShortDescription',
        'description' => 'Description',
        'internal_note' => 'InternalNote',
        'additional_attribute1' => 'AdditionalAttribute1',
        'additional_attribute2' => 'AdditionalAttribute2',
        'additional_attribute3' => 'AdditionalAttribute3',
        'additional_attribute4' => 'AdditionalAttribute4',
        'additional_attribute5' => 'AdditionalAttribute5',
        'additional_attribute6' => 'AdditionalAttribute6',
        'additional_attribute7' => 'AdditionalAttribute7',
        'additional_attribute8' => 'AdditionalAttribute8',
        'additional_attribute9' => 'AdditionalAttribute9',
        'additional_attribute10' => 'AdditionalAttribute10',
        'attribute_set' => 'AttributeSet',
        'discount_rule' => 'DiscountRule',
        'tags' => 'Tags',
        'status' => 'Status',
        'stock_locator' => 'StockLocator',
        'cogs_account' => 'COGSAccount',
        'revenue_account' => 'RevenueAccount',
        'expense_account' => 'ExpenseAccount',
        'inventory_account' => 'InventoryAccount',
        'purchase_tax_rule' => 'PurchaseTaxRule',
        'sale_tax_rule' => 'SaleTaxRule',
        'last_modified_on' => 'LastModifiedOn',
        'sellable' => 'Sellable',
        'pick_zones' => 'PickZones',
        'bill_of_material' => 'BillOfMaterial',
        'auto_assembly' => 'AutoAssembly',
        'auto_disassembly' => 'AutoDisassembly',
        'quantity_to_produce' => 'QuantityToProduce',
        'assembly_instruction_url' => 'AssemblyInstructionURL',
        'assembly_cost_estimation_method' => 'AssemblyCostEstimationMethod',
        'suppliers' => 'Suppliers',
        'reorder_levels' => 'ReorderLevels',
        'bill_of_materials_products' => 'BillOfMaterialsProducts',
        'bill_of_materials_services' => 'BillOfMaterialsServices',
        'movements' => 'Movements',
        'attachments' => 'Attachments',
        'custom_prices' => 'CustomPrices',
        'carton_height' => 'CartonHeight',
        'carton_width' => 'CartonWidth',
        'carton_length' => 'CartonLength',
        'carton_quantity' => 'CartonQuantity',
        'carton_inner_quantity' => 'CartonInnerQuantity',
        'hs_code' => 'HSCode',
        'country_of_origin' => 'CountryOfOrigin',
        'country_of_origin_code' => 'CountryOfOriginCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'sku' => 'setSku',
        'name' => 'setName',
        'category' => 'setCategory',
        'brand' => 'setBrand',
        'type' => 'setType',
        'costing_method' => 'setCostingMethod',
        'drop_ship_mode' => 'setDropShipMode',
        'default_location' => 'setDefaultLocation',
        'length' => 'setLength',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'weight' => 'setWeight',
        'uom' => 'setUom',
        'weight_units' => 'setWeightUnits',
        'dimensions_units' => 'setDimensionsUnits',
        'barcode' => 'setBarcode',
        'minimum_before_reorder' => 'setMinimumBeforeReorder',
        'reorder_quantity' => 'setReorderQuantity',
        'price_tier1' => 'setPriceTier1',
        'price_tier2' => 'setPriceTier2',
        'price_tier3' => 'setPriceTier3',
        'price_tier4' => 'setPriceTier4',
        'price_tier5' => 'setPriceTier5',
        'price_tier6' => 'setPriceTier6',
        'price_tier7' => 'setPriceTier7',
        'price_tier8' => 'setPriceTier8',
        'price_tier9' => 'setPriceTier9',
        'price_tier10' => 'setPriceTier10',
        'price_tiers' => 'setPriceTiers',
        'average_cost' => 'setAverageCost',
        'short_description' => 'setShortDescription',
        'description' => 'setDescription',
        'internal_note' => 'setInternalNote',
        'additional_attribute1' => 'setAdditionalAttribute1',
        'additional_attribute2' => 'setAdditionalAttribute2',
        'additional_attribute3' => 'setAdditionalAttribute3',
        'additional_attribute4' => 'setAdditionalAttribute4',
        'additional_attribute5' => 'setAdditionalAttribute5',
        'additional_attribute6' => 'setAdditionalAttribute6',
        'additional_attribute7' => 'setAdditionalAttribute7',
        'additional_attribute8' => 'setAdditionalAttribute8',
        'additional_attribute9' => 'setAdditionalAttribute9',
        'additional_attribute10' => 'setAdditionalAttribute10',
        'attribute_set' => 'setAttributeSet',
        'discount_rule' => 'setDiscountRule',
        'tags' => 'setTags',
        'status' => 'setStatus',
        'stock_locator' => 'setStockLocator',
        'cogs_account' => 'setCogsAccount',
        'revenue_account' => 'setRevenueAccount',
        'expense_account' => 'setExpenseAccount',
        'inventory_account' => 'setInventoryAccount',
        'purchase_tax_rule' => 'setPurchaseTaxRule',
        'sale_tax_rule' => 'setSaleTaxRule',
        'last_modified_on' => 'setLastModifiedOn',
        'sellable' => 'setSellable',
        'pick_zones' => 'setPickZones',
        'bill_of_material' => 'setBillOfMaterial',
        'auto_assembly' => 'setAutoAssembly',
        'auto_disassembly' => 'setAutoDisassembly',
        'quantity_to_produce' => 'setQuantityToProduce',
        'assembly_instruction_url' => 'setAssemblyInstructionUrl',
        'assembly_cost_estimation_method' => 'setAssemblyCostEstimationMethod',
        'suppliers' => 'setSuppliers',
        'reorder_levels' => 'setReorderLevels',
        'bill_of_materials_products' => 'setBillOfMaterialsProducts',
        'bill_of_materials_services' => 'setBillOfMaterialsServices',
        'movements' => 'setMovements',
        'attachments' => 'setAttachments',
        'custom_prices' => 'setCustomPrices',
        'carton_height' => 'setCartonHeight',
        'carton_width' => 'setCartonWidth',
        'carton_length' => 'setCartonLength',
        'carton_quantity' => 'setCartonQuantity',
        'carton_inner_quantity' => 'setCartonInnerQuantity',
        'hs_code' => 'setHsCode',
        'country_of_origin' => 'setCountryOfOrigin',
        'country_of_origin_code' => 'setCountryOfOriginCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'sku' => 'getSku',
        'name' => 'getName',
        'category' => 'getCategory',
        'brand' => 'getBrand',
        'type' => 'getType',
        'costing_method' => 'getCostingMethod',
        'drop_ship_mode' => 'getDropShipMode',
        'default_location' => 'getDefaultLocation',
        'length' => 'getLength',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'weight' => 'getWeight',
        'uom' => 'getUom',
        'weight_units' => 'getWeightUnits',
        'dimensions_units' => 'getDimensionsUnits',
        'barcode' => 'getBarcode',
        'minimum_before_reorder' => 'getMinimumBeforeReorder',
        'reorder_quantity' => 'getReorderQuantity',
        'price_tier1' => 'getPriceTier1',
        'price_tier2' => 'getPriceTier2',
        'price_tier3' => 'getPriceTier3',
        'price_tier4' => 'getPriceTier4',
        'price_tier5' => 'getPriceTier5',
        'price_tier6' => 'getPriceTier6',
        'price_tier7' => 'getPriceTier7',
        'price_tier8' => 'getPriceTier8',
        'price_tier9' => 'getPriceTier9',
        'price_tier10' => 'getPriceTier10',
        'price_tiers' => 'getPriceTiers',
        'average_cost' => 'getAverageCost',
        'short_description' => 'getShortDescription',
        'description' => 'getDescription',
        'internal_note' => 'getInternalNote',
        'additional_attribute1' => 'getAdditionalAttribute1',
        'additional_attribute2' => 'getAdditionalAttribute2',
        'additional_attribute3' => 'getAdditionalAttribute3',
        'additional_attribute4' => 'getAdditionalAttribute4',
        'additional_attribute5' => 'getAdditionalAttribute5',
        'additional_attribute6' => 'getAdditionalAttribute6',
        'additional_attribute7' => 'getAdditionalAttribute7',
        'additional_attribute8' => 'getAdditionalAttribute8',
        'additional_attribute9' => 'getAdditionalAttribute9',
        'additional_attribute10' => 'getAdditionalAttribute10',
        'attribute_set' => 'getAttributeSet',
        'discount_rule' => 'getDiscountRule',
        'tags' => 'getTags',
        'status' => 'getStatus',
        'stock_locator' => 'getStockLocator',
        'cogs_account' => 'getCogsAccount',
        'revenue_account' => 'getRevenueAccount',
        'expense_account' => 'getExpenseAccount',
        'inventory_account' => 'getInventoryAccount',
        'purchase_tax_rule' => 'getPurchaseTaxRule',
        'sale_tax_rule' => 'getSaleTaxRule',
        'last_modified_on' => 'getLastModifiedOn',
        'sellable' => 'getSellable',
        'pick_zones' => 'getPickZones',
        'bill_of_material' => 'getBillOfMaterial',
        'auto_assembly' => 'getAutoAssembly',
        'auto_disassembly' => 'getAutoDisassembly',
        'quantity_to_produce' => 'getQuantityToProduce',
        'assembly_instruction_url' => 'getAssemblyInstructionUrl',
        'assembly_cost_estimation_method' => 'getAssemblyCostEstimationMethod',
        'suppliers' => 'getSuppliers',
        'reorder_levels' => 'getReorderLevels',
        'bill_of_materials_products' => 'getBillOfMaterialsProducts',
        'bill_of_materials_services' => 'getBillOfMaterialsServices',
        'movements' => 'getMovements',
        'attachments' => 'getAttachments',
        'custom_prices' => 'getCustomPrices',
        'carton_height' => 'getCartonHeight',
        'carton_width' => 'getCartonWidth',
        'carton_length' => 'getCartonLength',
        'carton_quantity' => 'getCartonQuantity',
        'carton_inner_quantity' => 'getCartonInnerQuantity',
        'hs_code' => 'getHsCode',
        'country_of_origin' => 'getCountryOfOrigin',
        'country_of_origin_code' => 'getCountryOfOriginCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('costing_method', $data ?? [], null);
        $this->setIfExists('drop_ship_mode', $data ?? [], null);
        $this->setIfExists('default_location', $data ?? [], null);
        $this->setIfExists('length', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('uom', $data ?? [], null);
        $this->setIfExists('weight_units', $data ?? [], null);
        $this->setIfExists('dimensions_units', $data ?? [], null);
        $this->setIfExists('barcode', $data ?? [], null);
        $this->setIfExists('minimum_before_reorder', $data ?? [], null);
        $this->setIfExists('reorder_quantity', $data ?? [], null);
        $this->setIfExists('price_tier1', $data ?? [], null);
        $this->setIfExists('price_tier2', $data ?? [], null);
        $this->setIfExists('price_tier3', $data ?? [], null);
        $this->setIfExists('price_tier4', $data ?? [], null);
        $this->setIfExists('price_tier5', $data ?? [], null);
        $this->setIfExists('price_tier6', $data ?? [], null);
        $this->setIfExists('price_tier7', $data ?? [], null);
        $this->setIfExists('price_tier8', $data ?? [], null);
        $this->setIfExists('price_tier9', $data ?? [], null);
        $this->setIfExists('price_tier10', $data ?? [], null);
        $this->setIfExists('price_tiers', $data ?? [], null);
        $this->setIfExists('average_cost', $data ?? [], null);
        $this->setIfExists('short_description', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('internal_note', $data ?? [], null);
        $this->setIfExists('additional_attribute1', $data ?? [], null);
        $this->setIfExists('additional_attribute2', $data ?? [], null);
        $this->setIfExists('additional_attribute3', $data ?? [], null);
        $this->setIfExists('additional_attribute4', $data ?? [], null);
        $this->setIfExists('additional_attribute5', $data ?? [], null);
        $this->setIfExists('additional_attribute6', $data ?? [], null);
        $this->setIfExists('additional_attribute7', $data ?? [], null);
        $this->setIfExists('additional_attribute8', $data ?? [], null);
        $this->setIfExists('additional_attribute9', $data ?? [], null);
        $this->setIfExists('additional_attribute10', $data ?? [], null);
        $this->setIfExists('attribute_set', $data ?? [], null);
        $this->setIfExists('discount_rule', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('stock_locator', $data ?? [], null);
        $this->setIfExists('cogs_account', $data ?? [], null);
        $this->setIfExists('revenue_account', $data ?? [], null);
        $this->setIfExists('expense_account', $data ?? [], null);
        $this->setIfExists('inventory_account', $data ?? [], null);
        $this->setIfExists('purchase_tax_rule', $data ?? [], null);
        $this->setIfExists('sale_tax_rule', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('sellable', $data ?? [], null);
        $this->setIfExists('pick_zones', $data ?? [], null);
        $this->setIfExists('bill_of_material', $data ?? [], null);
        $this->setIfExists('auto_assembly', $data ?? [], null);
        $this->setIfExists('auto_disassembly', $data ?? [], null);
        $this->setIfExists('quantity_to_produce', $data ?? [], null);
        $this->setIfExists('assembly_instruction_url', $data ?? [], null);
        $this->setIfExists('assembly_cost_estimation_method', $data ?? [], null);
        $this->setIfExists('suppliers', $data ?? [], null);
        $this->setIfExists('reorder_levels', $data ?? [], null);
        $this->setIfExists('bill_of_materials_products', $data ?? [], null);
        $this->setIfExists('bill_of_materials_services', $data ?? [], null);
        $this->setIfExists('movements', $data ?? [], null);
        $this->setIfExists('attachments', $data ?? [], null);
        $this->setIfExists('custom_prices', $data ?? [], null);
        $this->setIfExists('carton_height', $data ?? [], null);
        $this->setIfExists('carton_width', $data ?? [], null);
        $this->setIfExists('carton_length', $data ?? [], null);
        $this->setIfExists('carton_quantity', $data ?? [], null);
        $this->setIfExists('carton_inner_quantity', $data ?? [], null);
        $this->setIfExists('hs_code', $data ?? [], null);
        $this->setIfExists('country_of_origin', $data ?? [], null);
        $this->setIfExists('country_of_origin_code', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand brand
     *
     * @return self
     */
    public function setBrand($brand)
    {
        if (is_null($brand)) {
            throw new \InvalidArgumentException('non-nullable brand cannot be null');
        }
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets costing_method
     *
     * @return string|null
     */
    public function getCostingMethod()
    {
        return $this->container['costing_method'];
    }

    /**
     * Sets costing_method
     *
     * @param string|null $costing_method costing_method
     *
     * @return self
     */
    public function setCostingMethod($costing_method)
    {
        if (is_null($costing_method)) {
            throw new \InvalidArgumentException('non-nullable costing_method cannot be null');
        }
        $this->container['costing_method'] = $costing_method;

        return $this;
    }

    /**
     * Gets drop_ship_mode
     *
     * @return string|null
     */
    public function getDropShipMode()
    {
        return $this->container['drop_ship_mode'];
    }

    /**
     * Sets drop_ship_mode
     *
     * @param string|null $drop_ship_mode drop_ship_mode
     *
     * @return self
     */
    public function setDropShipMode($drop_ship_mode)
    {
        if (is_null($drop_ship_mode)) {
            throw new \InvalidArgumentException('non-nullable drop_ship_mode cannot be null');
        }
        $this->container['drop_ship_mode'] = $drop_ship_mode;

        return $this;
    }

    /**
     * Gets default_location
     *
     * @return string|null
     */
    public function getDefaultLocation()
    {
        return $this->container['default_location'];
    }

    /**
     * Sets default_location
     *
     * @param string|null $default_location default_location
     *
     * @return self
     */
    public function setDefaultLocation($default_location)
    {
        if (is_null($default_location)) {
            throw new \InvalidArgumentException('non-nullable default_location cannot be null');
        }
        $this->container['default_location'] = $default_location;

        return $this;
    }

    /**
     * Gets length
     *
     * @return int|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param int|null $length length
     *
     * @return self
     */
    public function setLength($length)
    {
        if (is_null($length)) {
            throw new \InvalidArgumentException('non-nullable length cannot be null');
        }
        $this->container['length'] = $length;

        return $this;
    }

    /**
     * Gets width
     *
     * @return int|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param int|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return int|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param int|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return int|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param int|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets uom
     *
     * @return string|null
     */
    public function getUom()
    {
        return $this->container['uom'];
    }

    /**
     * Sets uom
     *
     * @param string|null $uom uom
     *
     * @return self
     */
    public function setUom($uom)
    {
        if (is_null($uom)) {
            throw new \InvalidArgumentException('non-nullable uom cannot be null');
        }
        $this->container['uom'] = $uom;

        return $this;
    }

    /**
     * Gets weight_units
     *
     * @return string|null
     */
    public function getWeightUnits()
    {
        return $this->container['weight_units'];
    }

    /**
     * Sets weight_units
     *
     * @param string|null $weight_units weight_units
     *
     * @return self
     */
    public function setWeightUnits($weight_units)
    {
        if (is_null($weight_units)) {
            throw new \InvalidArgumentException('non-nullable weight_units cannot be null');
        }
        $this->container['weight_units'] = $weight_units;

        return $this;
    }

    /**
     * Gets dimensions_units
     *
     * @return string|null
     */
    public function getDimensionsUnits()
    {
        return $this->container['dimensions_units'];
    }

    /**
     * Sets dimensions_units
     *
     * @param string|null $dimensions_units dimensions_units
     *
     * @return self
     */
    public function setDimensionsUnits($dimensions_units)
    {
        if (is_null($dimensions_units)) {
            throw new \InvalidArgumentException('non-nullable dimensions_units cannot be null');
        }
        $this->container['dimensions_units'] = $dimensions_units;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode barcode
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        if (is_null($barcode)) {
            throw new \InvalidArgumentException('non-nullable barcode cannot be null');
        }
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets minimum_before_reorder
     *
     * @return int|null
     */
    public function getMinimumBeforeReorder()
    {
        return $this->container['minimum_before_reorder'];
    }

    /**
     * Sets minimum_before_reorder
     *
     * @param int|null $minimum_before_reorder minimum_before_reorder
     *
     * @return self
     */
    public function setMinimumBeforeReorder($minimum_before_reorder)
    {
        if (is_null($minimum_before_reorder)) {
            throw new \InvalidArgumentException('non-nullable minimum_before_reorder cannot be null');
        }
        $this->container['minimum_before_reorder'] = $minimum_before_reorder;

        return $this;
    }

    /**
     * Gets reorder_quantity
     *
     * @return int|null
     */
    public function getReorderQuantity()
    {
        return $this->container['reorder_quantity'];
    }

    /**
     * Sets reorder_quantity
     *
     * @param int|null $reorder_quantity reorder_quantity
     *
     * @return self
     */
    public function setReorderQuantity($reorder_quantity)
    {
        if (is_null($reorder_quantity)) {
            throw new \InvalidArgumentException('non-nullable reorder_quantity cannot be null');
        }
        $this->container['reorder_quantity'] = $reorder_quantity;

        return $this;
    }

    /**
     * Gets price_tier1
     *
     * @return int|null
     */
    public function getPriceTier1()
    {
        return $this->container['price_tier1'];
    }

    /**
     * Sets price_tier1
     *
     * @param int|null $price_tier1 price_tier1
     *
     * @return self
     */
    public function setPriceTier1($price_tier1)
    {
        if (is_null($price_tier1)) {
            throw new \InvalidArgumentException('non-nullable price_tier1 cannot be null');
        }
        $this->container['price_tier1'] = $price_tier1;

        return $this;
    }

    /**
     * Gets price_tier2
     *
     * @return int|null
     */
    public function getPriceTier2()
    {
        return $this->container['price_tier2'];
    }

    /**
     * Sets price_tier2
     *
     * @param int|null $price_tier2 price_tier2
     *
     * @return self
     */
    public function setPriceTier2($price_tier2)
    {
        if (is_null($price_tier2)) {
            throw new \InvalidArgumentException('non-nullable price_tier2 cannot be null');
        }
        $this->container['price_tier2'] = $price_tier2;

        return $this;
    }

    /**
     * Gets price_tier3
     *
     * @return int|null
     */
    public function getPriceTier3()
    {
        return $this->container['price_tier3'];
    }

    /**
     * Sets price_tier3
     *
     * @param int|null $price_tier3 price_tier3
     *
     * @return self
     */
    public function setPriceTier3($price_tier3)
    {
        if (is_null($price_tier3)) {
            throw new \InvalidArgumentException('non-nullable price_tier3 cannot be null');
        }
        $this->container['price_tier3'] = $price_tier3;

        return $this;
    }

    /**
     * Gets price_tier4
     *
     * @return int|null
     */
    public function getPriceTier4()
    {
        return $this->container['price_tier4'];
    }

    /**
     * Sets price_tier4
     *
     * @param int|null $price_tier4 price_tier4
     *
     * @return self
     */
    public function setPriceTier4($price_tier4)
    {
        if (is_null($price_tier4)) {
            throw new \InvalidArgumentException('non-nullable price_tier4 cannot be null');
        }
        $this->container['price_tier4'] = $price_tier4;

        return $this;
    }

    /**
     * Gets price_tier5
     *
     * @return int|null
     */
    public function getPriceTier5()
    {
        return $this->container['price_tier5'];
    }

    /**
     * Sets price_tier5
     *
     * @param int|null $price_tier5 price_tier5
     *
     * @return self
     */
    public function setPriceTier5($price_tier5)
    {
        if (is_null($price_tier5)) {
            throw new \InvalidArgumentException('non-nullable price_tier5 cannot be null');
        }
        $this->container['price_tier5'] = $price_tier5;

        return $this;
    }

    /**
     * Gets price_tier6
     *
     * @return int|null
     */
    public function getPriceTier6()
    {
        return $this->container['price_tier6'];
    }

    /**
     * Sets price_tier6
     *
     * @param int|null $price_tier6 price_tier6
     *
     * @return self
     */
    public function setPriceTier6($price_tier6)
    {
        if (is_null($price_tier6)) {
            throw new \InvalidArgumentException('non-nullable price_tier6 cannot be null');
        }
        $this->container['price_tier6'] = $price_tier6;

        return $this;
    }

    /**
     * Gets price_tier7
     *
     * @return int|null
     */
    public function getPriceTier7()
    {
        return $this->container['price_tier7'];
    }

    /**
     * Sets price_tier7
     *
     * @param int|null $price_tier7 price_tier7
     *
     * @return self
     */
    public function setPriceTier7($price_tier7)
    {
        if (is_null($price_tier7)) {
            throw new \InvalidArgumentException('non-nullable price_tier7 cannot be null');
        }
        $this->container['price_tier7'] = $price_tier7;

        return $this;
    }

    /**
     * Gets price_tier8
     *
     * @return int|null
     */
    public function getPriceTier8()
    {
        return $this->container['price_tier8'];
    }

    /**
     * Sets price_tier8
     *
     * @param int|null $price_tier8 price_tier8
     *
     * @return self
     */
    public function setPriceTier8($price_tier8)
    {
        if (is_null($price_tier8)) {
            throw new \InvalidArgumentException('non-nullable price_tier8 cannot be null');
        }
        $this->container['price_tier8'] = $price_tier8;

        return $this;
    }

    /**
     * Gets price_tier9
     *
     * @return int|null
     */
    public function getPriceTier9()
    {
        return $this->container['price_tier9'];
    }

    /**
     * Sets price_tier9
     *
     * @param int|null $price_tier9 price_tier9
     *
     * @return self
     */
    public function setPriceTier9($price_tier9)
    {
        if (is_null($price_tier9)) {
            throw new \InvalidArgumentException('non-nullable price_tier9 cannot be null');
        }
        $this->container['price_tier9'] = $price_tier9;

        return $this;
    }

    /**
     * Gets price_tier10
     *
     * @return int|null
     */
    public function getPriceTier10()
    {
        return $this->container['price_tier10'];
    }

    /**
     * Sets price_tier10
     *
     * @param int|null $price_tier10 price_tier10
     *
     * @return self
     */
    public function setPriceTier10($price_tier10)
    {
        if (is_null($price_tier10)) {
            throw new \InvalidArgumentException('non-nullable price_tier10 cannot be null');
        }
        $this->container['price_tier10'] = $price_tier10;

        return $this;
    }

    /**
     * Gets price_tiers
     *
     * @return \Cin7\Model\PriceTiers|null
     */
    public function getPriceTiers()
    {
        return $this->container['price_tiers'];
    }

    /**
     * Sets price_tiers
     *
     * @param \Cin7\Model\PriceTiers|null $price_tiers price_tiers
     *
     * @return self
     */
    public function setPriceTiers($price_tiers)
    {
        if (is_null($price_tiers)) {
            throw new \InvalidArgumentException('non-nullable price_tiers cannot be null');
        }
        $this->container['price_tiers'] = $price_tiers;

        return $this;
    }

    /**
     * Gets average_cost
     *
     * @return int|null
     */
    public function getAverageCost()
    {
        return $this->container['average_cost'];
    }

    /**
     * Sets average_cost
     *
     * @param int|null $average_cost average_cost
     *
     * @return self
     */
    public function setAverageCost($average_cost)
    {
        if (is_null($average_cost)) {
            throw new \InvalidArgumentException('non-nullable average_cost cannot be null');
        }
        $this->container['average_cost'] = $average_cost;

        return $this;
    }

    /**
     * Gets short_description
     *
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->container['short_description'];
    }

    /**
     * Sets short_description
     *
     * @param string|null $short_description short_description
     *
     * @return self
     */
    public function setShortDescription($short_description)
    {
        if (is_null($short_description)) {
            throw new \InvalidArgumentException('non-nullable short_description cannot be null');
        }
        $this->container['short_description'] = $short_description;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets internal_note
     *
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->container['internal_note'];
    }

    /**
     * Sets internal_note
     *
     * @param string|null $internal_note internal_note
     *
     * @return self
     */
    public function setInternalNote($internal_note)
    {
        if (is_null($internal_note)) {
            throw new \InvalidArgumentException('non-nullable internal_note cannot be null');
        }
        $this->container['internal_note'] = $internal_note;

        return $this;
    }

    /**
     * Gets additional_attribute1
     *
     * @return string|null
     */
    public function getAdditionalAttribute1()
    {
        return $this->container['additional_attribute1'];
    }

    /**
     * Sets additional_attribute1
     *
     * @param string|null $additional_attribute1 additional_attribute1
     *
     * @return self
     */
    public function setAdditionalAttribute1($additional_attribute1)
    {
        if (is_null($additional_attribute1)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute1 cannot be null');
        }
        $this->container['additional_attribute1'] = $additional_attribute1;

        return $this;
    }

    /**
     * Gets additional_attribute2
     *
     * @return string|null
     */
    public function getAdditionalAttribute2()
    {
        return $this->container['additional_attribute2'];
    }

    /**
     * Sets additional_attribute2
     *
     * @param string|null $additional_attribute2 additional_attribute2
     *
     * @return self
     */
    public function setAdditionalAttribute2($additional_attribute2)
    {
        if (is_null($additional_attribute2)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute2 cannot be null');
        }
        $this->container['additional_attribute2'] = $additional_attribute2;

        return $this;
    }

    /**
     * Gets additional_attribute3
     *
     * @return string|null
     */
    public function getAdditionalAttribute3()
    {
        return $this->container['additional_attribute3'];
    }

    /**
     * Sets additional_attribute3
     *
     * @param string|null $additional_attribute3 additional_attribute3
     *
     * @return self
     */
    public function setAdditionalAttribute3($additional_attribute3)
    {
        if (is_null($additional_attribute3)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute3 cannot be null');
        }
        $this->container['additional_attribute3'] = $additional_attribute3;

        return $this;
    }

    /**
     * Gets additional_attribute4
     *
     * @return string|null
     */
    public function getAdditionalAttribute4()
    {
        return $this->container['additional_attribute4'];
    }

    /**
     * Sets additional_attribute4
     *
     * @param string|null $additional_attribute4 additional_attribute4
     *
     * @return self
     */
    public function setAdditionalAttribute4($additional_attribute4)
    {
        if (is_null($additional_attribute4)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute4 cannot be null');
        }
        $this->container['additional_attribute4'] = $additional_attribute4;

        return $this;
    }

    /**
     * Gets additional_attribute5
     *
     * @return string|null
     */
    public function getAdditionalAttribute5()
    {
        return $this->container['additional_attribute5'];
    }

    /**
     * Sets additional_attribute5
     *
     * @param string|null $additional_attribute5 additional_attribute5
     *
     * @return self
     */
    public function setAdditionalAttribute5($additional_attribute5)
    {
        if (is_null($additional_attribute5)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute5 cannot be null');
        }
        $this->container['additional_attribute5'] = $additional_attribute5;

        return $this;
    }

    /**
     * Gets additional_attribute6
     *
     * @return string|null
     */
    public function getAdditionalAttribute6()
    {
        return $this->container['additional_attribute6'];
    }

    /**
     * Sets additional_attribute6
     *
     * @param string|null $additional_attribute6 additional_attribute6
     *
     * @return self
     */
    public function setAdditionalAttribute6($additional_attribute6)
    {
        if (is_null($additional_attribute6)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute6 cannot be null');
        }
        $this->container['additional_attribute6'] = $additional_attribute6;

        return $this;
    }

    /**
     * Gets additional_attribute7
     *
     * @return string|null
     */
    public function getAdditionalAttribute7()
    {
        return $this->container['additional_attribute7'];
    }

    /**
     * Sets additional_attribute7
     *
     * @param string|null $additional_attribute7 additional_attribute7
     *
     * @return self
     */
    public function setAdditionalAttribute7($additional_attribute7)
    {
        if (is_null($additional_attribute7)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute7 cannot be null');
        }
        $this->container['additional_attribute7'] = $additional_attribute7;

        return $this;
    }

    /**
     * Gets additional_attribute8
     *
     * @return string|null
     */
    public function getAdditionalAttribute8()
    {
        return $this->container['additional_attribute8'];
    }

    /**
     * Sets additional_attribute8
     *
     * @param string|null $additional_attribute8 additional_attribute8
     *
     * @return self
     */
    public function setAdditionalAttribute8($additional_attribute8)
    {
        if (is_null($additional_attribute8)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute8 cannot be null');
        }
        $this->container['additional_attribute8'] = $additional_attribute8;

        return $this;
    }

    /**
     * Gets additional_attribute9
     *
     * @return string|null
     */
    public function getAdditionalAttribute9()
    {
        return $this->container['additional_attribute9'];
    }

    /**
     * Sets additional_attribute9
     *
     * @param string|null $additional_attribute9 additional_attribute9
     *
     * @return self
     */
    public function setAdditionalAttribute9($additional_attribute9)
    {
        if (is_null($additional_attribute9)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute9 cannot be null');
        }
        $this->container['additional_attribute9'] = $additional_attribute9;

        return $this;
    }

    /**
     * Gets additional_attribute10
     *
     * @return string|null
     */
    public function getAdditionalAttribute10()
    {
        return $this->container['additional_attribute10'];
    }

    /**
     * Sets additional_attribute10
     *
     * @param string|null $additional_attribute10 additional_attribute10
     *
     * @return self
     */
    public function setAdditionalAttribute10($additional_attribute10)
    {
        if (is_null($additional_attribute10)) {
            throw new \InvalidArgumentException('non-nullable additional_attribute10 cannot be null');
        }
        $this->container['additional_attribute10'] = $additional_attribute10;

        return $this;
    }

    /**
     * Gets attribute_set
     *
     * @return mixed|null
     */
    public function getAttributeSet()
    {
        return $this->container['attribute_set'];
    }

    /**
     * Sets attribute_set
     *
     * @param mixed|null $attribute_set attribute_set
     *
     * @return self
     */
    public function setAttributeSet($attribute_set)
    {
        if (is_null($attribute_set)) {
            array_push($this->openAPINullablesSetToNull, 'attribute_set');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attribute_set', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attribute_set'] = $attribute_set;

        return $this;
    }

    /**
     * Gets discount_rule
     *
     * @return mixed|null
     */
    public function getDiscountRule()
    {
        return $this->container['discount_rule'];
    }

    /**
     * Sets discount_rule
     *
     * @param mixed|null $discount_rule discount_rule
     *
     * @return self
     */
    public function setDiscountRule($discount_rule)
    {
        if (is_null($discount_rule)) {
            array_push($this->openAPINullablesSetToNull, 'discount_rule');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_rule', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_rule'] = $discount_rule;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string|null $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets stock_locator
     *
     * @return string|null
     */
    public function getStockLocator()
    {
        return $this->container['stock_locator'];
    }

    /**
     * Sets stock_locator
     *
     * @param string|null $stock_locator stock_locator
     *
     * @return self
     */
    public function setStockLocator($stock_locator)
    {
        if (is_null($stock_locator)) {
            throw new \InvalidArgumentException('non-nullable stock_locator cannot be null');
        }
        $this->container['stock_locator'] = $stock_locator;

        return $this;
    }

    /**
     * Gets cogs_account
     *
     * @return string|null
     */
    public function getCogsAccount()
    {
        return $this->container['cogs_account'];
    }

    /**
     * Sets cogs_account
     *
     * @param string|null $cogs_account cogs_account
     *
     * @return self
     */
    public function setCogsAccount($cogs_account)
    {
        if (is_null($cogs_account)) {
            throw new \InvalidArgumentException('non-nullable cogs_account cannot be null');
        }
        $this->container['cogs_account'] = $cogs_account;

        return $this;
    }

    /**
     * Gets revenue_account
     *
     * @return string|null
     */
    public function getRevenueAccount()
    {
        return $this->container['revenue_account'];
    }

    /**
     * Sets revenue_account
     *
     * @param string|null $revenue_account revenue_account
     *
     * @return self
     */
    public function setRevenueAccount($revenue_account)
    {
        if (is_null($revenue_account)) {
            throw new \InvalidArgumentException('non-nullable revenue_account cannot be null');
        }
        $this->container['revenue_account'] = $revenue_account;

        return $this;
    }

    /**
     * Gets expense_account
     *
     * @return string|null
     */
    public function getExpenseAccount()
    {
        return $this->container['expense_account'];
    }

    /**
     * Sets expense_account
     *
     * @param string|null $expense_account expense_account
     *
     * @return self
     */
    public function setExpenseAccount($expense_account)
    {
        if (is_null($expense_account)) {
            throw new \InvalidArgumentException('non-nullable expense_account cannot be null');
        }
        $this->container['expense_account'] = $expense_account;

        return $this;
    }

    /**
     * Gets inventory_account
     *
     * @return string|null
     */
    public function getInventoryAccount()
    {
        return $this->container['inventory_account'];
    }

    /**
     * Sets inventory_account
     *
     * @param string|null $inventory_account inventory_account
     *
     * @return self
     */
    public function setInventoryAccount($inventory_account)
    {
        if (is_null($inventory_account)) {
            throw new \InvalidArgumentException('non-nullable inventory_account cannot be null');
        }
        $this->container['inventory_account'] = $inventory_account;

        return $this;
    }

    /**
     * Gets purchase_tax_rule
     *
     * @return string|null
     */
    public function getPurchaseTaxRule()
    {
        return $this->container['purchase_tax_rule'];
    }

    /**
     * Sets purchase_tax_rule
     *
     * @param string|null $purchase_tax_rule purchase_tax_rule
     *
     * @return self
     */
    public function setPurchaseTaxRule($purchase_tax_rule)
    {
        if (is_null($purchase_tax_rule)) {
            throw new \InvalidArgumentException('non-nullable purchase_tax_rule cannot be null');
        }
        $this->container['purchase_tax_rule'] = $purchase_tax_rule;

        return $this;
    }

    /**
     * Gets sale_tax_rule
     *
     * @return string|null
     */
    public function getSaleTaxRule()
    {
        return $this->container['sale_tax_rule'];
    }

    /**
     * Sets sale_tax_rule
     *
     * @param string|null $sale_tax_rule sale_tax_rule
     *
     * @return self
     */
    public function setSaleTaxRule($sale_tax_rule)
    {
        if (is_null($sale_tax_rule)) {
            throw new \InvalidArgumentException('non-nullable sale_tax_rule cannot be null');
        }
        $this->container['sale_tax_rule'] = $sale_tax_rule;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets sellable
     *
     * @return bool|null
     */
    public function getSellable()
    {
        return $this->container['sellable'];
    }

    /**
     * Sets sellable
     *
     * @param bool|null $sellable sellable
     *
     * @return self
     */
    public function setSellable($sellable)
    {
        if (is_null($sellable)) {
            throw new \InvalidArgumentException('non-nullable sellable cannot be null');
        }
        $this->container['sellable'] = $sellable;

        return $this;
    }

    /**
     * Gets pick_zones
     *
     * @return string|null
     */
    public function getPickZones()
    {
        return $this->container['pick_zones'];
    }

    /**
     * Sets pick_zones
     *
     * @param string|null $pick_zones pick_zones
     *
     * @return self
     */
    public function setPickZones($pick_zones)
    {
        if (is_null($pick_zones)) {
            throw new \InvalidArgumentException('non-nullable pick_zones cannot be null');
        }
        $this->container['pick_zones'] = $pick_zones;

        return $this;
    }

    /**
     * Gets bill_of_material
     *
     * @return bool|null
     */
    public function getBillOfMaterial()
    {
        return $this->container['bill_of_material'];
    }

    /**
     * Sets bill_of_material
     *
     * @param bool|null $bill_of_material bill_of_material
     *
     * @return self
     */
    public function setBillOfMaterial($bill_of_material)
    {
        if (is_null($bill_of_material)) {
            throw new \InvalidArgumentException('non-nullable bill_of_material cannot be null');
        }
        $this->container['bill_of_material'] = $bill_of_material;

        return $this;
    }

    /**
     * Gets auto_assembly
     *
     * @return bool|null
     */
    public function getAutoAssembly()
    {
        return $this->container['auto_assembly'];
    }

    /**
     * Sets auto_assembly
     *
     * @param bool|null $auto_assembly auto_assembly
     *
     * @return self
     */
    public function setAutoAssembly($auto_assembly)
    {
        if (is_null($auto_assembly)) {
            throw new \InvalidArgumentException('non-nullable auto_assembly cannot be null');
        }
        $this->container['auto_assembly'] = $auto_assembly;

        return $this;
    }

    /**
     * Gets auto_disassembly
     *
     * @return bool|null
     */
    public function getAutoDisassembly()
    {
        return $this->container['auto_disassembly'];
    }

    /**
     * Sets auto_disassembly
     *
     * @param bool|null $auto_disassembly auto_disassembly
     *
     * @return self
     */
    public function setAutoDisassembly($auto_disassembly)
    {
        if (is_null($auto_disassembly)) {
            throw new \InvalidArgumentException('non-nullable auto_disassembly cannot be null');
        }
        $this->container['auto_disassembly'] = $auto_disassembly;

        return $this;
    }

    /**
     * Gets quantity_to_produce
     *
     * @return int|null
     */
    public function getQuantityToProduce()
    {
        return $this->container['quantity_to_produce'];
    }

    /**
     * Sets quantity_to_produce
     *
     * @param int|null $quantity_to_produce quantity_to_produce
     *
     * @return self
     */
    public function setQuantityToProduce($quantity_to_produce)
    {
        if (is_null($quantity_to_produce)) {
            throw new \InvalidArgumentException('non-nullable quantity_to_produce cannot be null');
        }
        $this->container['quantity_to_produce'] = $quantity_to_produce;

        return $this;
    }

    /**
     * Gets assembly_instruction_url
     *
     * @return string|null
     */
    public function getAssemblyInstructionUrl()
    {
        return $this->container['assembly_instruction_url'];
    }

    /**
     * Sets assembly_instruction_url
     *
     * @param string|null $assembly_instruction_url assembly_instruction_url
     *
     * @return self
     */
    public function setAssemblyInstructionUrl($assembly_instruction_url)
    {
        if (is_null($assembly_instruction_url)) {
            throw new \InvalidArgumentException('non-nullable assembly_instruction_url cannot be null');
        }
        $this->container['assembly_instruction_url'] = $assembly_instruction_url;

        return $this;
    }

    /**
     * Gets assembly_cost_estimation_method
     *
     * @return string|null
     */
    public function getAssemblyCostEstimationMethod()
    {
        return $this->container['assembly_cost_estimation_method'];
    }

    /**
     * Sets assembly_cost_estimation_method
     *
     * @param string|null $assembly_cost_estimation_method assembly_cost_estimation_method
     *
     * @return self
     */
    public function setAssemblyCostEstimationMethod($assembly_cost_estimation_method)
    {
        if (is_null($assembly_cost_estimation_method)) {
            throw new \InvalidArgumentException('non-nullable assembly_cost_estimation_method cannot be null');
        }
        $this->container['assembly_cost_estimation_method'] = $assembly_cost_estimation_method;

        return $this;
    }

    /**
     * Gets suppliers
     *
     * @return \Cin7\Model\Supplier|null
     */
    public function getSuppliers()
    {
        return $this->container['suppliers'];
    }

    /**
     * Sets suppliers
     *
     * @param \Cin7\Model\Supplier|null $suppliers suppliers
     *
     * @return self
     */
    public function setSuppliers($suppliers)
    {
        if (is_null($suppliers)) {
            throw new \InvalidArgumentException('non-nullable suppliers cannot be null');
        }
        $this->container['suppliers'] = $suppliers;

        return $this;
    }

    /**
     * Gets reorder_levels
     *
     * @return \Cin7\Model\ReorderLevel|null
     */
    public function getReorderLevels()
    {
        return $this->container['reorder_levels'];
    }

    /**
     * Sets reorder_levels
     *
     * @param \Cin7\Model\ReorderLevel|null $reorder_levels reorder_levels
     *
     * @return self
     */
    public function setReorderLevels($reorder_levels)
    {
        if (is_null($reorder_levels)) {
            throw new \InvalidArgumentException('non-nullable reorder_levels cannot be null');
        }
        $this->container['reorder_levels'] = $reorder_levels;

        return $this;
    }

    /**
     * Gets bill_of_materials_products
     *
     * @return \Cin7\Model\BillOfMaterialsProduct[]|null
     */
    public function getBillOfMaterialsProducts()
    {
        return $this->container['bill_of_materials_products'];
    }

    /**
     * Sets bill_of_materials_products
     *
     * @param \Cin7\Model\BillOfMaterialsProduct[]|null $bill_of_materials_products bill_of_materials_products
     *
     * @return self
     */
    public function setBillOfMaterialsProducts($bill_of_materials_products)
    {
        if (is_null($bill_of_materials_products)) {
            throw new \InvalidArgumentException('non-nullable bill_of_materials_products cannot be null');
        }
        $this->container['bill_of_materials_products'] = $bill_of_materials_products;

        return $this;
    }

    /**
     * Gets bill_of_materials_services
     *
     * @return \Cin7\Model\BillOfMaterialsService[]|null
     */
    public function getBillOfMaterialsServices()
    {
        return $this->container['bill_of_materials_services'];
    }

    /**
     * Sets bill_of_materials_services
     *
     * @param \Cin7\Model\BillOfMaterialsService[]|null $bill_of_materials_services bill_of_materials_services
     *
     * @return self
     */
    public function setBillOfMaterialsServices($bill_of_materials_services)
    {
        if (is_null($bill_of_materials_services)) {
            throw new \InvalidArgumentException('non-nullable bill_of_materials_services cannot be null');
        }
        $this->container['bill_of_materials_services'] = $bill_of_materials_services;

        return $this;
    }

    /**
     * Gets movements
     *
     * @return \Cin7\Model\Movement[]|null
     */
    public function getMovements()
    {
        return $this->container['movements'];
    }

    /**
     * Sets movements
     *
     * @param \Cin7\Model\Movement[]|null $movements movements
     *
     * @return self
     */
    public function setMovements($movements)
    {
        if (is_null($movements)) {
            throw new \InvalidArgumentException('non-nullable movements cannot be null');
        }
        $this->container['movements'] = $movements;

        return $this;
    }

    /**
     * Gets attachments
     *
     * @return \Cin7\Model\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \Cin7\Model\Attachment[]|null $attachments attachments
     *
     * @return self
     */
    public function setAttachments($attachments)
    {
        if (is_null($attachments)) {
            throw new \InvalidArgumentException('non-nullable attachments cannot be null');
        }
        $this->container['attachments'] = $attachments;

        return $this;
    }

    /**
     * Gets custom_prices
     *
     * @return \Cin7\Model\CustomPrice|null
     */
    public function getCustomPrices()
    {
        return $this->container['custom_prices'];
    }

    /**
     * Sets custom_prices
     *
     * @param \Cin7\Model\CustomPrice|null $custom_prices custom_prices
     *
     * @return self
     */
    public function setCustomPrices($custom_prices)
    {
        if (is_null($custom_prices)) {
            throw new \InvalidArgumentException('non-nullable custom_prices cannot be null');
        }
        $this->container['custom_prices'] = $custom_prices;

        return $this;
    }

    /**
     * Gets carton_height
     *
     * @return int|null
     */
    public function getCartonHeight()
    {
        return $this->container['carton_height'];
    }

    /**
     * Sets carton_height
     *
     * @param int|null $carton_height carton_height
     *
     * @return self
     */
    public function setCartonHeight($carton_height)
    {
        if (is_null($carton_height)) {
            throw new \InvalidArgumentException('non-nullable carton_height cannot be null');
        }
        $this->container['carton_height'] = $carton_height;

        return $this;
    }

    /**
     * Gets carton_width
     *
     * @return int|null
     */
    public function getCartonWidth()
    {
        return $this->container['carton_width'];
    }

    /**
     * Sets carton_width
     *
     * @param int|null $carton_width carton_width
     *
     * @return self
     */
    public function setCartonWidth($carton_width)
    {
        if (is_null($carton_width)) {
            throw new \InvalidArgumentException('non-nullable carton_width cannot be null');
        }
        $this->container['carton_width'] = $carton_width;

        return $this;
    }

    /**
     * Gets carton_length
     *
     * @return int|null
     */
    public function getCartonLength()
    {
        return $this->container['carton_length'];
    }

    /**
     * Sets carton_length
     *
     * @param int|null $carton_length carton_length
     *
     * @return self
     */
    public function setCartonLength($carton_length)
    {
        if (is_null($carton_length)) {
            throw new \InvalidArgumentException('non-nullable carton_length cannot be null');
        }
        $this->container['carton_length'] = $carton_length;

        return $this;
    }

    /**
     * Gets carton_quantity
     *
     * @return int|null
     */
    public function getCartonQuantity()
    {
        return $this->container['carton_quantity'];
    }

    /**
     * Sets carton_quantity
     *
     * @param int|null $carton_quantity carton_quantity
     *
     * @return self
     */
    public function setCartonQuantity($carton_quantity)
    {
        if (is_null($carton_quantity)) {
            throw new \InvalidArgumentException('non-nullable carton_quantity cannot be null');
        }
        $this->container['carton_quantity'] = $carton_quantity;

        return $this;
    }

    /**
     * Gets carton_inner_quantity
     *
     * @return int|null
     */
    public function getCartonInnerQuantity()
    {
        return $this->container['carton_inner_quantity'];
    }

    /**
     * Sets carton_inner_quantity
     *
     * @param int|null $carton_inner_quantity carton_inner_quantity
     *
     * @return self
     */
    public function setCartonInnerQuantity($carton_inner_quantity)
    {
        if (is_null($carton_inner_quantity)) {
            throw new \InvalidArgumentException('non-nullable carton_inner_quantity cannot be null');
        }
        $this->container['carton_inner_quantity'] = $carton_inner_quantity;

        return $this;
    }

    /**
     * Gets hs_code
     *
     * @return string|null
     */
    public function getHsCode()
    {
        return $this->container['hs_code'];
    }

    /**
     * Sets hs_code
     *
     * @param string|null $hs_code hs_code
     *
     * @return self
     */
    public function setHsCode($hs_code)
    {
        if (is_null($hs_code)) {
            throw new \InvalidArgumentException('non-nullable hs_code cannot be null');
        }
        $this->container['hs_code'] = $hs_code;

        return $this;
    }

    /**
     * Gets country_of_origin
     *
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->container['country_of_origin'];
    }

    /**
     * Sets country_of_origin
     *
     * @param string|null $country_of_origin country_of_origin
     *
     * @return self
     */
    public function setCountryOfOrigin($country_of_origin)
    {
        if (is_null($country_of_origin)) {
            throw new \InvalidArgumentException('non-nullable country_of_origin cannot be null');
        }
        $this->container['country_of_origin'] = $country_of_origin;

        return $this;
    }

    /**
     * Gets country_of_origin_code
     *
     * @return string|null
     */
    public function getCountryOfOriginCode()
    {
        return $this->container['country_of_origin_code'];
    }

    /**
     * Sets country_of_origin_code
     *
     * @param string|null $country_of_origin_code country_of_origin_code
     *
     * @return self
     */
    public function setCountryOfOriginCode($country_of_origin_code)
    {
        if (is_null($country_of_origin_code)) {
            throw new \InvalidArgumentException('non-nullable country_of_origin_code cannot be null');
        }
        $this->container['country_of_origin_code'] = $country_of_origin_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


