<?php
/**
 * Me
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * Me Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Me implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Me';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'company' => 'string',
        'currency' => 'string',
        'time_zone' => 'string',
        'default_weight_units' => 'string',
        'default_dimensions_units' => 'string',
        'lock_date' => 'string',
        'opening_balance_date' => 'string',
        'tax_calculation_method' => 'string',
        'default_sale_tax_rule_id' => 'string',
        'default_sale_tax_rule_name' => 'string',
        'maximum_decimal_places_in_quantity' => 'string',
        'apply_customer_discounts_after_other_discounts' => 'bool',
        'discount_rule' => 'string',
        'automatically_apply_discounts' => 'bool',
        'rounding_table' => '\Cin7\Model\Rounding'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'company' => null,
        'currency' => null,
        'time_zone' => null,
        'default_weight_units' => null,
        'default_dimensions_units' => null,
        'lock_date' => null,
        'opening_balance_date' => null,
        'tax_calculation_method' => null,
        'default_sale_tax_rule_id' => null,
        'default_sale_tax_rule_name' => null,
        'maximum_decimal_places_in_quantity' => null,
        'apply_customer_discounts_after_other_discounts' => null,
        'discount_rule' => null,
        'automatically_apply_discounts' => null,
        'rounding_table' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'company' => false,
        'currency' => false,
        'time_zone' => false,
        'default_weight_units' => false,
        'default_dimensions_units' => false,
        'lock_date' => false,
        'opening_balance_date' => false,
        'tax_calculation_method' => false,
        'default_sale_tax_rule_id' => false,
        'default_sale_tax_rule_name' => false,
        'maximum_decimal_places_in_quantity' => false,
        'apply_customer_discounts_after_other_discounts' => false,
        'discount_rule' => false,
        'automatically_apply_discounts' => false,
        'rounding_table' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'company' => 'Company',
        'currency' => 'Currency',
        'time_zone' => 'TimeZone',
        'default_weight_units' => 'DefaultWeightUnits',
        'default_dimensions_units' => 'DefaultDimensionsUnits',
        'lock_date' => 'LockDate',
        'opening_balance_date' => 'OpeningBalanceDate',
        'tax_calculation_method' => 'TaxCalculationMethod',
        'default_sale_tax_rule_id' => 'DefaultSaleTaxRuleId',
        'default_sale_tax_rule_name' => 'DefaultSaleTaxRuleName',
        'maximum_decimal_places_in_quantity' => 'MaximumDecimalPlacesInQuantity',
        'apply_customer_discounts_after_other_discounts' => 'ApplyCustomerDiscountsAfterOtherDiscounts',
        'discount_rule' => 'DiscountRule',
        'automatically_apply_discounts' => 'AutomaticallyApplyDiscounts',
        'rounding_table' => 'RoundingTable'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'company' => 'setCompany',
        'currency' => 'setCurrency',
        'time_zone' => 'setTimeZone',
        'default_weight_units' => 'setDefaultWeightUnits',
        'default_dimensions_units' => 'setDefaultDimensionsUnits',
        'lock_date' => 'setLockDate',
        'opening_balance_date' => 'setOpeningBalanceDate',
        'tax_calculation_method' => 'setTaxCalculationMethod',
        'default_sale_tax_rule_id' => 'setDefaultSaleTaxRuleId',
        'default_sale_tax_rule_name' => 'setDefaultSaleTaxRuleName',
        'maximum_decimal_places_in_quantity' => 'setMaximumDecimalPlacesInQuantity',
        'apply_customer_discounts_after_other_discounts' => 'setApplyCustomerDiscountsAfterOtherDiscounts',
        'discount_rule' => 'setDiscountRule',
        'automatically_apply_discounts' => 'setAutomaticallyApplyDiscounts',
        'rounding_table' => 'setRoundingTable'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'company' => 'getCompany',
        'currency' => 'getCurrency',
        'time_zone' => 'getTimeZone',
        'default_weight_units' => 'getDefaultWeightUnits',
        'default_dimensions_units' => 'getDefaultDimensionsUnits',
        'lock_date' => 'getLockDate',
        'opening_balance_date' => 'getOpeningBalanceDate',
        'tax_calculation_method' => 'getTaxCalculationMethod',
        'default_sale_tax_rule_id' => 'getDefaultSaleTaxRuleId',
        'default_sale_tax_rule_name' => 'getDefaultSaleTaxRuleName',
        'maximum_decimal_places_in_quantity' => 'getMaximumDecimalPlacesInQuantity',
        'apply_customer_discounts_after_other_discounts' => 'getApplyCustomerDiscountsAfterOtherDiscounts',
        'discount_rule' => 'getDiscountRule',
        'automatically_apply_discounts' => 'getAutomaticallyApplyDiscounts',
        'rounding_table' => 'getRoundingTable'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('time_zone', $data ?? [], null);
        $this->setIfExists('default_weight_units', $data ?? [], null);
        $this->setIfExists('default_dimensions_units', $data ?? [], null);
        $this->setIfExists('lock_date', $data ?? [], null);
        $this->setIfExists('opening_balance_date', $data ?? [], null);
        $this->setIfExists('tax_calculation_method', $data ?? [], null);
        $this->setIfExists('default_sale_tax_rule_id', $data ?? [], null);
        $this->setIfExists('default_sale_tax_rule_name', $data ?? [], null);
        $this->setIfExists('maximum_decimal_places_in_quantity', $data ?? [], null);
        $this->setIfExists('apply_customer_discounts_after_other_discounts', $data ?? [], null);
        $this->setIfExists('discount_rule', $data ?? [], null);
        $this->setIfExists('automatically_apply_discounts', $data ?? [], null);
        $this->setIfExists('rounding_table', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company company
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets time_zone
     *
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     *
     * @param string|null $time_zone time_zone
     *
     * @return self
     */
    public function setTimeZone($time_zone)
    {
        if (is_null($time_zone)) {
            throw new \InvalidArgumentException('non-nullable time_zone cannot be null');
        }
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets default_weight_units
     *
     * @return string|null
     */
    public function getDefaultWeightUnits()
    {
        return $this->container['default_weight_units'];
    }

    /**
     * Sets default_weight_units
     *
     * @param string|null $default_weight_units default_weight_units
     *
     * @return self
     */
    public function setDefaultWeightUnits($default_weight_units)
    {
        if (is_null($default_weight_units)) {
            throw new \InvalidArgumentException('non-nullable default_weight_units cannot be null');
        }
        $this->container['default_weight_units'] = $default_weight_units;

        return $this;
    }

    /**
     * Gets default_dimensions_units
     *
     * @return string|null
     */
    public function getDefaultDimensionsUnits()
    {
        return $this->container['default_dimensions_units'];
    }

    /**
     * Sets default_dimensions_units
     *
     * @param string|null $default_dimensions_units default_dimensions_units
     *
     * @return self
     */
    public function setDefaultDimensionsUnits($default_dimensions_units)
    {
        if (is_null($default_dimensions_units)) {
            throw new \InvalidArgumentException('non-nullable default_dimensions_units cannot be null');
        }
        $this->container['default_dimensions_units'] = $default_dimensions_units;

        return $this;
    }

    /**
     * Gets lock_date
     *
     * @return string|null
     */
    public function getLockDate()
    {
        return $this->container['lock_date'];
    }

    /**
     * Sets lock_date
     *
     * @param string|null $lock_date lock_date
     *
     * @return self
     */
    public function setLockDate($lock_date)
    {
        if (is_null($lock_date)) {
            throw new \InvalidArgumentException('non-nullable lock_date cannot be null');
        }
        $this->container['lock_date'] = $lock_date;

        return $this;
    }

    /**
     * Gets opening_balance_date
     *
     * @return string|null
     */
    public function getOpeningBalanceDate()
    {
        return $this->container['opening_balance_date'];
    }

    /**
     * Sets opening_balance_date
     *
     * @param string|null $opening_balance_date opening_balance_date
     *
     * @return self
     */
    public function setOpeningBalanceDate($opening_balance_date)
    {
        if (is_null($opening_balance_date)) {
            throw new \InvalidArgumentException('non-nullable opening_balance_date cannot be null');
        }
        $this->container['opening_balance_date'] = $opening_balance_date;

        return $this;
    }

    /**
     * Gets tax_calculation_method
     *
     * @return string|null
     */
    public function getTaxCalculationMethod()
    {
        return $this->container['tax_calculation_method'];
    }

    /**
     * Sets tax_calculation_method
     *
     * @param string|null $tax_calculation_method tax_calculation_method
     *
     * @return self
     */
    public function setTaxCalculationMethod($tax_calculation_method)
    {
        if (is_null($tax_calculation_method)) {
            throw new \InvalidArgumentException('non-nullable tax_calculation_method cannot be null');
        }
        $this->container['tax_calculation_method'] = $tax_calculation_method;

        return $this;
    }

    /**
     * Gets default_sale_tax_rule_id
     *
     * @return string|null
     */
    public function getDefaultSaleTaxRuleId()
    {
        return $this->container['default_sale_tax_rule_id'];
    }

    /**
     * Sets default_sale_tax_rule_id
     *
     * @param string|null $default_sale_tax_rule_id default_sale_tax_rule_id
     *
     * @return self
     */
    public function setDefaultSaleTaxRuleId($default_sale_tax_rule_id)
    {
        if (is_null($default_sale_tax_rule_id)) {
            throw new \InvalidArgumentException('non-nullable default_sale_tax_rule_id cannot be null');
        }
        $this->container['default_sale_tax_rule_id'] = $default_sale_tax_rule_id;

        return $this;
    }

    /**
     * Gets default_sale_tax_rule_name
     *
     * @return string|null
     */
    public function getDefaultSaleTaxRuleName()
    {
        return $this->container['default_sale_tax_rule_name'];
    }

    /**
     * Sets default_sale_tax_rule_name
     *
     * @param string|null $default_sale_tax_rule_name default_sale_tax_rule_name
     *
     * @return self
     */
    public function setDefaultSaleTaxRuleName($default_sale_tax_rule_name)
    {
        if (is_null($default_sale_tax_rule_name)) {
            throw new \InvalidArgumentException('non-nullable default_sale_tax_rule_name cannot be null');
        }
        $this->container['default_sale_tax_rule_name'] = $default_sale_tax_rule_name;

        return $this;
    }

    /**
     * Gets maximum_decimal_places_in_quantity
     *
     * @return string|null
     */
    public function getMaximumDecimalPlacesInQuantity()
    {
        return $this->container['maximum_decimal_places_in_quantity'];
    }

    /**
     * Sets maximum_decimal_places_in_quantity
     *
     * @param string|null $maximum_decimal_places_in_quantity maximum_decimal_places_in_quantity
     *
     * @return self
     */
    public function setMaximumDecimalPlacesInQuantity($maximum_decimal_places_in_quantity)
    {
        if (is_null($maximum_decimal_places_in_quantity)) {
            throw new \InvalidArgumentException('non-nullable maximum_decimal_places_in_quantity cannot be null');
        }
        $this->container['maximum_decimal_places_in_quantity'] = $maximum_decimal_places_in_quantity;

        return $this;
    }

    /**
     * Gets apply_customer_discounts_after_other_discounts
     *
     * @return bool|null
     */
    public function getApplyCustomerDiscountsAfterOtherDiscounts()
    {
        return $this->container['apply_customer_discounts_after_other_discounts'];
    }

    /**
     * Sets apply_customer_discounts_after_other_discounts
     *
     * @param bool|null $apply_customer_discounts_after_other_discounts apply_customer_discounts_after_other_discounts
     *
     * @return self
     */
    public function setApplyCustomerDiscountsAfterOtherDiscounts($apply_customer_discounts_after_other_discounts)
    {
        if (is_null($apply_customer_discounts_after_other_discounts)) {
            throw new \InvalidArgumentException('non-nullable apply_customer_discounts_after_other_discounts cannot be null');
        }
        $this->container['apply_customer_discounts_after_other_discounts'] = $apply_customer_discounts_after_other_discounts;

        return $this;
    }

    /**
     * Gets discount_rule
     *
     * @return string|null
     */
    public function getDiscountRule()
    {
        return $this->container['discount_rule'];
    }

    /**
     * Sets discount_rule
     *
     * @param string|null $discount_rule discount_rule
     *
     * @return self
     */
    public function setDiscountRule($discount_rule)
    {
        if (is_null($discount_rule)) {
            throw new \InvalidArgumentException('non-nullable discount_rule cannot be null');
        }
        $this->container['discount_rule'] = $discount_rule;

        return $this;
    }

    /**
     * Gets automatically_apply_discounts
     *
     * @return bool|null
     */
    public function getAutomaticallyApplyDiscounts()
    {
        return $this->container['automatically_apply_discounts'];
    }

    /**
     * Sets automatically_apply_discounts
     *
     * @param bool|null $automatically_apply_discounts automatically_apply_discounts
     *
     * @return self
     */
    public function setAutomaticallyApplyDiscounts($automatically_apply_discounts)
    {
        if (is_null($automatically_apply_discounts)) {
            throw new \InvalidArgumentException('non-nullable automatically_apply_discounts cannot be null');
        }
        $this->container['automatically_apply_discounts'] = $automatically_apply_discounts;

        return $this;
    }

    /**
     * Gets rounding_table
     *
     * @return \Cin7\Model\Rounding|null
     */
    public function getRoundingTable()
    {
        return $this->container['rounding_table'];
    }

    /**
     * Sets rounding_table
     *
     * @param \Cin7\Model\Rounding|null $rounding_table rounding_table
     *
     * @return self
     */
    public function setRoundingTable($rounding_table)
    {
        if (is_null($rounding_table)) {
            throw new \InvalidArgumentException('non-nullable rounding_table cannot be null');
        }
        $this->container['rounding_table'] = $rounding_table;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


