<?php
/**
 * Fulfilment
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * Fulfilment Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Fulfilment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Fulfilment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'task_id' => 'string',
        'fulfillment_number' => 'int',
        'linked_invoice_number' => 'string',
        'ful_filment_status' => 'string',
        'pick' => '\Cin7\Model\Pick',
        'pack' => '\Cin7\Model\Pack',
        'ship' => '\Cin7\Model\Ship'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'task_id' => null,
        'fulfillment_number' => null,
        'linked_invoice_number' => null,
        'ful_filment_status' => null,
        'pick' => null,
        'pack' => null,
        'ship' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'task_id' => false,
        'fulfillment_number' => false,
        'linked_invoice_number' => false,
        'ful_filment_status' => false,
        'pick' => false,
        'pack' => false,
        'ship' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'task_id' => 'TaskID',
        'fulfillment_number' => 'FulfillmentNumber',
        'linked_invoice_number' => 'LinkedInvoiceNumber',
        'ful_filment_status' => 'FulFilmentStatus',
        'pick' => 'Pick',
        'pack' => 'Pack',
        'ship' => 'Ship'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'task_id' => 'setTaskId',
        'fulfillment_number' => 'setFulfillmentNumber',
        'linked_invoice_number' => 'setLinkedInvoiceNumber',
        'ful_filment_status' => 'setFulFilmentStatus',
        'pick' => 'setPick',
        'pack' => 'setPack',
        'ship' => 'setShip'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'task_id' => 'getTaskId',
        'fulfillment_number' => 'getFulfillmentNumber',
        'linked_invoice_number' => 'getLinkedInvoiceNumber',
        'ful_filment_status' => 'getFulFilmentStatus',
        'pick' => 'getPick',
        'pack' => 'getPack',
        'ship' => 'getShip'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('task_id', $data ?? [], null);
        $this->setIfExists('fulfillment_number', $data ?? [], null);
        $this->setIfExists('linked_invoice_number', $data ?? [], null);
        $this->setIfExists('ful_filment_status', $data ?? [], null);
        $this->setIfExists('pick', $data ?? [], null);
        $this->setIfExists('pack', $data ?? [], null);
        $this->setIfExists('ship', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets task_id
     *
     * @return string|null
     */
    public function getTaskId()
    {
        return $this->container['task_id'];
    }

    /**
     * Sets task_id
     *
     * @param string|null $task_id task_id
     *
     * @return self
     */
    public function setTaskId($task_id)
    {
        if (is_null($task_id)) {
            throw new \InvalidArgumentException('non-nullable task_id cannot be null');
        }
        $this->container['task_id'] = $task_id;

        return $this;
    }

    /**
     * Gets fulfillment_number
     *
     * @return int|null
     */
    public function getFulfillmentNumber()
    {
        return $this->container['fulfillment_number'];
    }

    /**
     * Sets fulfillment_number
     *
     * @param int|null $fulfillment_number fulfillment_number
     *
     * @return self
     */
    public function setFulfillmentNumber($fulfillment_number)
    {
        if (is_null($fulfillment_number)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_number cannot be null');
        }
        $this->container['fulfillment_number'] = $fulfillment_number;

        return $this;
    }

    /**
     * Gets linked_invoice_number
     *
     * @return string|null
     */
    public function getLinkedInvoiceNumber()
    {
        return $this->container['linked_invoice_number'];
    }

    /**
     * Sets linked_invoice_number
     *
     * @param string|null $linked_invoice_number linked_invoice_number
     *
     * @return self
     */
    public function setLinkedInvoiceNumber($linked_invoice_number)
    {
        if (is_null($linked_invoice_number)) {
            throw new \InvalidArgumentException('non-nullable linked_invoice_number cannot be null');
        }
        $this->container['linked_invoice_number'] = $linked_invoice_number;

        return $this;
    }

    /**
     * Gets ful_filment_status
     *
     * @return string|null
     */
    public function getFulFilmentStatus()
    {
        return $this->container['ful_filment_status'];
    }

    /**
     * Sets ful_filment_status
     *
     * @param string|null $ful_filment_status ful_filment_status
     *
     * @return self
     */
    public function setFulFilmentStatus($ful_filment_status)
    {
        if (is_null($ful_filment_status)) {
            throw new \InvalidArgumentException('non-nullable ful_filment_status cannot be null');
        }
        $this->container['ful_filment_status'] = $ful_filment_status;

        return $this;
    }

    /**
     * Gets pick
     *
     * @return \Cin7\Model\Pick|null
     */
    public function getPick()
    {
        return $this->container['pick'];
    }

    /**
     * Sets pick
     *
     * @param \Cin7\Model\Pick|null $pick pick
     *
     * @return self
     */
    public function setPick($pick)
    {
        if (is_null($pick)) {
            throw new \InvalidArgumentException('non-nullable pick cannot be null');
        }
        $this->container['pick'] = $pick;

        return $this;
    }

    /**
     * Gets pack
     *
     * @return \Cin7\Model\Pack|null
     */
    public function getPack()
    {
        return $this->container['pack'];
    }

    /**
     * Sets pack
     *
     * @param \Cin7\Model\Pack|null $pack pack
     *
     * @return self
     */
    public function setPack($pack)
    {
        if (is_null($pack)) {
            throw new \InvalidArgumentException('non-nullable pack cannot be null');
        }
        $this->container['pack'] = $pack;

        return $this;
    }

    /**
     * Gets ship
     *
     * @return \Cin7\Model\Ship|null
     */
    public function getShip()
    {
        return $this->container['ship'];
    }

    /**
     * Sets ship
     *
     * @param \Cin7\Model\Ship|null $ship ship
     *
     * @return self
     */
    public function setShip($ship)
    {
        if (is_null($ship)) {
            throw new \InvalidArgumentException('non-nullable ship cannot be null');
        }
        $this->container['ship'] = $ship;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


