<?php
/**
 * CreditNote
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Model;

use \ArrayAccess;
use \Cin7\ObjectSerializer;

/**
 * CreditNote Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreditNote implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreditNote';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'task_id' => 'string',
        'credit_note_invoice_number' => 'string',
        'memo' => 'string',
        'status' => 'string',
        'credit_note_date' => 'string',
        'credit_note_number' => 'string',
        'credit_note_conversion_rate' => 'int',
        'lines' => '\Cin7\Model\Line[]',
        'additional_charges' => '\Cin7\Model\AdditionalCharge[]',
        'refunds' => '\Cin7\Model\Refund[]',
        'restock' => '\Cin7\Model\Restock[]',
        'total_before_tax' => 'int',
        'tax' => 'int',
        'total' => 'int',
        'sale_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'task_id' => null,
        'credit_note_invoice_number' => null,
        'memo' => null,
        'status' => null,
        'credit_note_date' => null,
        'credit_note_number' => null,
        'credit_note_conversion_rate' => null,
        'lines' => null,
        'additional_charges' => null,
        'refunds' => null,
        'restock' => null,
        'total_before_tax' => null,
        'tax' => null,
        'total' => null,
        'sale_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'task_id' => false,
        'credit_note_invoice_number' => false,
        'memo' => false,
        'status' => false,
        'credit_note_date' => false,
        'credit_note_number' => false,
        'credit_note_conversion_rate' => false,
        'lines' => false,
        'additional_charges' => false,
        'refunds' => false,
        'restock' => false,
        'total_before_tax' => false,
        'tax' => false,
        'total' => false,
        'sale_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'task_id' => 'TaskID',
        'credit_note_invoice_number' => 'CreditNoteInvoiceNumber',
        'memo' => 'Memo',
        'status' => 'Status',
        'credit_note_date' => 'CreditNoteDate',
        'credit_note_number' => 'CreditNoteNumber',
        'credit_note_conversion_rate' => 'CreditNoteConversionRate',
        'lines' => 'Lines',
        'additional_charges' => 'AdditionalCharges',
        'refunds' => 'Refunds',
        'restock' => 'Restock',
        'total_before_tax' => 'TotalBeforeTax',
        'tax' => 'Tax',
        'total' => 'Total',
        'sale_id' => 'SaleID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'task_id' => 'setTaskId',
        'credit_note_invoice_number' => 'setCreditNoteInvoiceNumber',
        'memo' => 'setMemo',
        'status' => 'setStatus',
        'credit_note_date' => 'setCreditNoteDate',
        'credit_note_number' => 'setCreditNoteNumber',
        'credit_note_conversion_rate' => 'setCreditNoteConversionRate',
        'lines' => 'setLines',
        'additional_charges' => 'setAdditionalCharges',
        'refunds' => 'setRefunds',
        'restock' => 'setRestock',
        'total_before_tax' => 'setTotalBeforeTax',
        'tax' => 'setTax',
        'total' => 'setTotal',
        'sale_id' => 'setSaleId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'task_id' => 'getTaskId',
        'credit_note_invoice_number' => 'getCreditNoteInvoiceNumber',
        'memo' => 'getMemo',
        'status' => 'getStatus',
        'credit_note_date' => 'getCreditNoteDate',
        'credit_note_number' => 'getCreditNoteNumber',
        'credit_note_conversion_rate' => 'getCreditNoteConversionRate',
        'lines' => 'getLines',
        'additional_charges' => 'getAdditionalCharges',
        'refunds' => 'getRefunds',
        'restock' => 'getRestock',
        'total_before_tax' => 'getTotalBeforeTax',
        'tax' => 'getTax',
        'total' => 'getTotal',
        'sale_id' => 'getSaleId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('task_id', $data ?? [], null);
        $this->setIfExists('credit_note_invoice_number', $data ?? [], null);
        $this->setIfExists('memo', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('credit_note_date', $data ?? [], null);
        $this->setIfExists('credit_note_number', $data ?? [], null);
        $this->setIfExists('credit_note_conversion_rate', $data ?? [], null);
        $this->setIfExists('lines', $data ?? [], null);
        $this->setIfExists('additional_charges', $data ?? [], null);
        $this->setIfExists('refunds', $data ?? [], null);
        $this->setIfExists('restock', $data ?? [], null);
        $this->setIfExists('total_before_tax', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('sale_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets task_id
     *
     * @return string|null
     */
    public function getTaskId()
    {
        return $this->container['task_id'];
    }

    /**
     * Sets task_id
     *
     * @param string|null $task_id task_id
     *
     * @return self
     */
    public function setTaskId($task_id)
    {
        if (is_null($task_id)) {
            throw new \InvalidArgumentException('non-nullable task_id cannot be null');
        }
        $this->container['task_id'] = $task_id;

        return $this;
    }

    /**
     * Gets credit_note_invoice_number
     *
     * @return string|null
     */
    public function getCreditNoteInvoiceNumber()
    {
        return $this->container['credit_note_invoice_number'];
    }

    /**
     * Sets credit_note_invoice_number
     *
     * @param string|null $credit_note_invoice_number credit_note_invoice_number
     *
     * @return self
     */
    public function setCreditNoteInvoiceNumber($credit_note_invoice_number)
    {
        if (is_null($credit_note_invoice_number)) {
            throw new \InvalidArgumentException('non-nullable credit_note_invoice_number cannot be null');
        }
        $this->container['credit_note_invoice_number'] = $credit_note_invoice_number;

        return $this;
    }

    /**
     * Gets memo
     *
     * @return string|null
     */
    public function getMemo()
    {
        return $this->container['memo'];
    }

    /**
     * Sets memo
     *
     * @param string|null $memo memo
     *
     * @return self
     */
    public function setMemo($memo)
    {
        if (is_null($memo)) {
            throw new \InvalidArgumentException('non-nullable memo cannot be null');
        }
        $this->container['memo'] = $memo;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets credit_note_date
     *
     * @return string|null
     */
    public function getCreditNoteDate()
    {
        return $this->container['credit_note_date'];
    }

    /**
     * Sets credit_note_date
     *
     * @param string|null $credit_note_date credit_note_date
     *
     * @return self
     */
    public function setCreditNoteDate($credit_note_date)
    {
        if (is_null($credit_note_date)) {
            throw new \InvalidArgumentException('non-nullable credit_note_date cannot be null');
        }
        $this->container['credit_note_date'] = $credit_note_date;

        return $this;
    }

    /**
     * Gets credit_note_number
     *
     * @return string|null
     */
    public function getCreditNoteNumber()
    {
        return $this->container['credit_note_number'];
    }

    /**
     * Sets credit_note_number
     *
     * @param string|null $credit_note_number credit_note_number
     *
     * @return self
     */
    public function setCreditNoteNumber($credit_note_number)
    {
        if (is_null($credit_note_number)) {
            throw new \InvalidArgumentException('non-nullable credit_note_number cannot be null');
        }
        $this->container['credit_note_number'] = $credit_note_number;

        return $this;
    }

    /**
     * Gets credit_note_conversion_rate
     *
     * @return int|null
     */
    public function getCreditNoteConversionRate()
    {
        return $this->container['credit_note_conversion_rate'];
    }

    /**
     * Sets credit_note_conversion_rate
     *
     * @param int|null $credit_note_conversion_rate credit_note_conversion_rate
     *
     * @return self
     */
    public function setCreditNoteConversionRate($credit_note_conversion_rate)
    {
        if (is_null($credit_note_conversion_rate)) {
            throw new \InvalidArgumentException('non-nullable credit_note_conversion_rate cannot be null');
        }
        $this->container['credit_note_conversion_rate'] = $credit_note_conversion_rate;

        return $this;
    }

    /**
     * Gets lines
     *
     * @return \Cin7\Model\Line[]|null
     */
    public function getLines()
    {
        return $this->container['lines'];
    }

    /**
     * Sets lines
     *
     * @param \Cin7\Model\Line[]|null $lines lines
     *
     * @return self
     */
    public function setLines($lines)
    {
        if (is_null($lines)) {
            throw new \InvalidArgumentException('non-nullable lines cannot be null');
        }
        $this->container['lines'] = $lines;

        return $this;
    }

    /**
     * Gets additional_charges
     *
     * @return \Cin7\Model\AdditionalCharge[]|null
     */
    public function getAdditionalCharges()
    {
        return $this->container['additional_charges'];
    }

    /**
     * Sets additional_charges
     *
     * @param \Cin7\Model\AdditionalCharge[]|null $additional_charges additional_charges
     *
     * @return self
     */
    public function setAdditionalCharges($additional_charges)
    {
        if (is_null($additional_charges)) {
            throw new \InvalidArgumentException('non-nullable additional_charges cannot be null');
        }
        $this->container['additional_charges'] = $additional_charges;

        return $this;
    }

    /**
     * Gets refunds
     *
     * @return \Cin7\Model\Refund[]|null
     */
    public function getRefunds()
    {
        return $this->container['refunds'];
    }

    /**
     * Sets refunds
     *
     * @param \Cin7\Model\Refund[]|null $refunds refunds
     *
     * @return self
     */
    public function setRefunds($refunds)
    {
        if (is_null($refunds)) {
            throw new \InvalidArgumentException('non-nullable refunds cannot be null');
        }
        $this->container['refunds'] = $refunds;

        return $this;
    }

    /**
     * Gets restock
     *
     * @return \Cin7\Model\Restock[]|null
     */
    public function getRestock()
    {
        return $this->container['restock'];
    }

    /**
     * Sets restock
     *
     * @param \Cin7\Model\Restock[]|null $restock restock
     *
     * @return self
     */
    public function setRestock($restock)
    {
        if (is_null($restock)) {
            throw new \InvalidArgumentException('non-nullable restock cannot be null');
        }
        $this->container['restock'] = $restock;

        return $this;
    }

    /**
     * Gets total_before_tax
     *
     * @return int|null
     */
    public function getTotalBeforeTax()
    {
        return $this->container['total_before_tax'];
    }

    /**
     * Sets total_before_tax
     *
     * @param int|null $total_before_tax total_before_tax
     *
     * @return self
     */
    public function setTotalBeforeTax($total_before_tax)
    {
        if (is_null($total_before_tax)) {
            throw new \InvalidArgumentException('non-nullable total_before_tax cannot be null');
        }
        $this->container['total_before_tax'] = $total_before_tax;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return int|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param int|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return int|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param int|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets sale_id
     *
     * @return string|null
     */
    public function getSaleId()
    {
        return $this->container['sale_id'];
    }

    /**
     * Sets sale_id
     *
     * @param string|null $sale_id sale_id
     *
     * @return self
     */
    public function setSaleId($sale_id)
    {
        if (is_null($sale_id)) {
            throw new \InvalidArgumentException('non-nullable sale_id cannot be null');
        }
        $this->container['sale_id'] = $sale_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


