<?php
/**
 * SaleApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Cin7\ApiException;
use Cin7\Configuration;
use Cin7\FormDataProcessor;
use Cin7\HeaderSelector;
use Cin7\ObjectSerializer;

/**
 * SaleApi Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SaleApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteSale' => [
            'application/json',
        ],
        'deleteSaleCreditnote' => [
            'application/json',
        ],
        'deleteSaleFulfilment' => [
            'application/json',
        ],
        'deleteSaleInvoice' => [
            'application/json',
        ],
        'deleteSalePayment' => [
            'application/json',
        ],
        'getSale' => [
            'application/json',
        ],
        'getSaleCreditNoteList' => [
            'application/json',
        ],
        'getSaleCreditnote' => [
            'application/json',
        ],
        'getSaleFulfilment' => [
            'application/json',
        ],
        'getSaleInvoice' => [
            'application/json',
        ],
        'getSaleList' => [
            'application/json',
        ],
        'getSaleOrder' => [
            'application/json',
        ],
        'getSalePayment' => [
            'application/json',
        ],
        'postSale' => [
            'application/json',
        ],
        'postSaleCreditnote' => [
            'application/json',
        ],
        'postSaleFulfilment' => [
            'application/json',
        ],
        'postSaleInvoice' => [
            'application/json',
        ],
        'postSaleOrder' => [
            'application/json',
        ],
        'postSalePayment' => [
            'application/json',
        ],
        'putSale' => [
            'application/json',
        ],
        'putSaleInvoice' => [
            'application/json',
        ],
        'putSalePayment' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteSale
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id id (optional)
     * @param  bool|null $void void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFull
     */
    public function deleteSale($id = null, $void = null, string $contentType = self::contentTypes['deleteSale'][0])
    {
        list($response) = $this->deleteSaleWithHttpInfo($id, $void, $contentType);
        return $response;
    }

    /**
     * Operation deleteSaleWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSaleWithHttpInfo($id = null, $void = null, string $contentType = self::contentTypes['deleteSale'][0])
    {
        $request = $this->deleteSaleRequest($id, $void, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSaleAsync
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleAsync($id = null, $void = null, string $contentType = self::contentTypes['deleteSale'][0])
    {
        return $this->deleteSaleAsyncWithHttpInfo($id, $void, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSaleAsyncWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleAsyncWithHttpInfo($id = null, $void = null, string $contentType = self::contentTypes['deleteSale'][0])
    {
        $returnType = '\Cin7\Model\SaleFull';
        $request = $this->deleteSaleRequest($id, $void, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSale'
     *
     * @param  string|null $id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSaleRequest($id = null, $void = null, string $contentType = self::contentTypes['deleteSale'][0])
    {




        $resourcePath = '/sale';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'Id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $void,
            'Void', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSaleCreditnote
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id task_id (optional)
     * @param  bool|null $void void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleCreditNotes
     */
    public function deleteSaleCreditnote($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleCreditnote'][0])
    {
        list($response) = $this->deleteSaleCreditnoteWithHttpInfo($task_id, $void, $contentType);
        return $response;
    }

    /**
     * Operation deleteSaleCreditnoteWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleCreditNotes, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSaleCreditnoteWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleCreditnote'][0])
    {
        $request = $this->deleteSaleCreditnoteRequest($task_id, $void, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleCreditNotes',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleCreditNotes',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleCreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSaleCreditnoteAsync
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleCreditnoteAsync($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleCreditnote'][0])
    {
        return $this->deleteSaleCreditnoteAsyncWithHttpInfo($task_id, $void, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSaleCreditnoteAsyncWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleCreditnoteAsyncWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleCreditnote'][0])
    {
        $returnType = '\Cin7\Model\SaleCreditNotes';
        $request = $this->deleteSaleCreditnoteRequest($task_id, $void, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSaleCreditnote'
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSaleCreditnoteRequest($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleCreditnote'][0])
    {




        $resourcePath = '/sale/creditnote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $task_id,
            'TaskID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $void,
            'Void', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSaleFulfilment
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id task_id (optional)
     * @param  bool|null $void void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFulfilments
     */
    public function deleteSaleFulfilment($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleFulfilment'][0])
    {
        list($response) = $this->deleteSaleFulfilmentWithHttpInfo($task_id, $void, $contentType);
        return $response;
    }

    /**
     * Operation deleteSaleFulfilmentWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFulfilments, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSaleFulfilmentWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleFulfilment'][0])
    {
        $request = $this->deleteSaleFulfilmentRequest($task_id, $void, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFulfilments',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFulfilments',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFulfilments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSaleFulfilmentAsync
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleFulfilmentAsync($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleFulfilment'][0])
    {
        return $this->deleteSaleFulfilmentAsyncWithHttpInfo($task_id, $void, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSaleFulfilmentAsyncWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleFulfilmentAsyncWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleFulfilment'][0])
    {
        $returnType = '\Cin7\Model\SaleFulfilments';
        $request = $this->deleteSaleFulfilmentRequest($task_id, $void, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSaleFulfilment'
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSaleFulfilmentRequest($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleFulfilment'][0])
    {




        $resourcePath = '/sale/fulfilment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $task_id,
            'TaskID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $void,
            'Void', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSaleInvoice
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id task_id (optional)
     * @param  bool|null $void void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleInvoices
     */
    public function deleteSaleInvoice($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleInvoice'][0])
    {
        list($response) = $this->deleteSaleInvoiceWithHttpInfo($task_id, $void, $contentType);
        return $response;
    }

    /**
     * Operation deleteSaleInvoiceWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleInvoices, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSaleInvoiceWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleInvoice'][0])
    {
        $request = $this->deleteSaleInvoiceRequest($task_id, $void, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleInvoices',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleInvoices',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleInvoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSaleInvoiceAsync
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleInvoiceAsync($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleInvoice'][0])
    {
        return $this->deleteSaleInvoiceAsyncWithHttpInfo($task_id, $void, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSaleInvoiceAsyncWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSaleInvoiceAsyncWithHttpInfo($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleInvoice'][0])
    {
        $returnType = '\Cin7\Model\SaleInvoices';
        $request = $this->deleteSaleInvoiceRequest($task_id, $void, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSaleInvoice'
     *
     * @param  string|null $task_id (optional)
     * @param  bool|null $void (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSaleInvoiceRequest($task_id = null, $void = null, string $contentType = self::contentTypes['deleteSaleInvoice'][0])
    {




        $resourcePath = '/sale/invoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $task_id,
            'TaskID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $void,
            'Void', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSalePayment
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\DeleteSalePayment200Response
     */
    public function deleteSalePayment($id = null, string $contentType = self::contentTypes['deleteSalePayment'][0])
    {
        list($response) = $this->deleteSalePaymentWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation deleteSalePaymentWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\DeleteSalePayment200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalePaymentWithHttpInfo($id = null, string $contentType = self::contentTypes['deleteSalePayment'][0])
    {
        $request = $this->deleteSalePaymentRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\DeleteSalePayment200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\DeleteSalePayment200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\DeleteSalePayment200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSalePaymentAsync
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalePaymentAsync($id = null, string $contentType = self::contentTypes['deleteSalePayment'][0])
    {
        return $this->deleteSalePaymentAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalePaymentAsyncWithHttpInfo
     *
     * Your DELETE endpoint
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalePaymentAsyncWithHttpInfo($id = null, string $contentType = self::contentTypes['deleteSalePayment'][0])
    {
        $returnType = '\Cin7\Model\DeleteSalePayment200Response';
        $request = $this->deleteSalePaymentRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalePayment'
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalePaymentRequest($id = null, string $contentType = self::contentTypes['deleteSalePayment'][0])
    {



        $resourcePath = '/sale/payment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'Id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSale
     *
     * Your GET endpoint
     *
     * @param  string|null $id id (optional)
     * @param  string|null $combine_additional_charges combine_additional_charges (optional)
     * @param  string|null $hide_inventory_movements hide_inventory_movements (optional)
     * @param  string|null $include_transactions include_transactions (optional)
     * @param  string|null $country_format country_format (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFull
     */
    public function getSale($id = null, $combine_additional_charges = null, $hide_inventory_movements = null, $include_transactions = null, $country_format = null, string $contentType = self::contentTypes['getSale'][0])
    {
        list($response) = $this->getSaleWithHttpInfo($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format, $contentType);
        return $response;
    }

    /**
     * Operation getSaleWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $hide_inventory_movements (optional)
     * @param  string|null $include_transactions (optional)
     * @param  string|null $country_format (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleWithHttpInfo($id = null, $combine_additional_charges = null, $hide_inventory_movements = null, $include_transactions = null, $country_format = null, string $contentType = self::contentTypes['getSale'][0])
    {
        $request = $this->getSaleRequest($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $hide_inventory_movements (optional)
     * @param  string|null $include_transactions (optional)
     * @param  string|null $country_format (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleAsync($id = null, $combine_additional_charges = null, $hide_inventory_movements = null, $include_transactions = null, $country_format = null, string $contentType = self::contentTypes['getSale'][0])
    {
        return $this->getSaleAsyncWithHttpInfo($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $hide_inventory_movements (optional)
     * @param  string|null $include_transactions (optional)
     * @param  string|null $country_format (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleAsyncWithHttpInfo($id = null, $combine_additional_charges = null, $hide_inventory_movements = null, $include_transactions = null, $country_format = null, string $contentType = self::contentTypes['getSale'][0])
    {
        $returnType = '\Cin7\Model\SaleFull';
        $request = $this->getSaleRequest($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSale'
     *
     * @param  string|null $id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $hide_inventory_movements (optional)
     * @param  string|null $include_transactions (optional)
     * @param  string|null $country_format (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleRequest($id = null, $combine_additional_charges = null, $hide_inventory_movements = null, $include_transactions = null, $country_format = null, string $contentType = self::contentTypes['getSale'][0])
    {







        $resourcePath = '/sale';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'Id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combine_additional_charges,
            'CombineAdditionalCharges', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $hide_inventory_movements,
            'HideInventoryMovements', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_transactions,
            'IncludeTransactions', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $country_format,
            'CountryFormat', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleCreditNoteList
     *
     * Your GET endpoint
     *
     * @param  float|null $page page (optional)
     * @param  float|null $limit limit (optional)
     * @param  string|null $search search (optional)
     * @param  string|null $created_since created_since (optional)
     * @param  string|null $updated_since updated_since (optional)
     * @param  string|null $credit_note_status credit_note_status (optional)
     * @param  string|null $status status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditNoteList'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\GetSaleCreditNoteList200Response
     */
    public function getSaleCreditNoteList($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $credit_note_status = null, $status = null, string $contentType = self::contentTypes['getSaleCreditNoteList'][0])
    {
        list($response) = $this->getSaleCreditNoteListWithHttpInfo($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status, $contentType);
        return $response;
    }

    /**
     * Operation getSaleCreditNoteListWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditNoteList'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\GetSaleCreditNoteList200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleCreditNoteListWithHttpInfo($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $credit_note_status = null, $status = null, string $contentType = self::contentTypes['getSaleCreditNoteList'][0])
    {
        $request = $this->getSaleCreditNoteListRequest($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\GetSaleCreditNoteList200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\GetSaleCreditNoteList200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\GetSaleCreditNoteList200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleCreditNoteListAsync
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditNoteList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleCreditNoteListAsync($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $credit_note_status = null, $status = null, string $contentType = self::contentTypes['getSaleCreditNoteList'][0])
    {
        return $this->getSaleCreditNoteListAsyncWithHttpInfo($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleCreditNoteListAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditNoteList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleCreditNoteListAsyncWithHttpInfo($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $credit_note_status = null, $status = null, string $contentType = self::contentTypes['getSaleCreditNoteList'][0])
    {
        $returnType = '\Cin7\Model\GetSaleCreditNoteList200Response';
        $request = $this->getSaleCreditNoteListRequest($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleCreditNoteList'
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditNoteList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleCreditNoteListRequest($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $credit_note_status = null, $status = null, string $contentType = self::contentTypes['getSaleCreditNoteList'][0])
    {









        $resourcePath = '/saleCreditNoteList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'Page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'Search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_since,
            'CreatedSince', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_since,
            'UpdatedSince', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $credit_note_status,
            'CreditNoteStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'Status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleCreditnote
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id sale_id (optional)
     * @param  string|null $combine_additional_charges combine_additional_charges (optional)
     * @param  string|null $include_product_info include_product_info (optional)
     * @param  string|null $include_payment_info include_payment_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleCreditNotes
     */
    public function getSaleCreditnote($sale_id = null, $combine_additional_charges = null, $include_product_info = null, $include_payment_info = null, string $contentType = self::contentTypes['getSaleCreditnote'][0])
    {
        list($response) = $this->getSaleCreditnoteWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info, $contentType);
        return $response;
    }

    /**
     * Operation getSaleCreditnoteWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string|null $include_payment_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleCreditNotes, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleCreditnoteWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, $include_payment_info = null, string $contentType = self::contentTypes['getSaleCreditnote'][0])
    {
        $request = $this->getSaleCreditnoteRequest($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleCreditNotes',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleCreditNotes',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleCreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleCreditnoteAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string|null $include_payment_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleCreditnoteAsync($sale_id = null, $combine_additional_charges = null, $include_product_info = null, $include_payment_info = null, string $contentType = self::contentTypes['getSaleCreditnote'][0])
    {
        return $this->getSaleCreditnoteAsyncWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleCreditnoteAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string|null $include_payment_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleCreditnoteAsyncWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, $include_payment_info = null, string $contentType = self::contentTypes['getSaleCreditnote'][0])
    {
        $returnType = '\Cin7\Model\SaleCreditNotes';
        $request = $this->getSaleCreditnoteRequest($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleCreditnote'
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string|null $include_payment_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleCreditnoteRequest($sale_id = null, $combine_additional_charges = null, $include_product_info = null, $include_payment_info = null, string $contentType = self::contentTypes['getSaleCreditnote'][0])
    {






        $resourcePath = '/sale/creditnote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'SaleID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combine_additional_charges,
            'CombineAdditionalCharges', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_product_info,
            'IncludeProductInfo', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_payment_info,
            'IncludePaymentInfo', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleFulfilment
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id sale_id (optional)
     * @param  string|null $include_product_info include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFulfilments
     */
    public function getSaleFulfilment($sale_id = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleFulfilment'][0])
    {
        list($response) = $this->getSaleFulfilmentWithHttpInfo($sale_id, $include_product_info, $contentType);
        return $response;
    }

    /**
     * Operation getSaleFulfilmentWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFulfilments, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleFulfilmentWithHttpInfo($sale_id = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleFulfilment'][0])
    {
        $request = $this->getSaleFulfilmentRequest($sale_id, $include_product_info, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFulfilments',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFulfilments',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFulfilments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleFulfilmentAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleFulfilmentAsync($sale_id = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleFulfilment'][0])
    {
        return $this->getSaleFulfilmentAsyncWithHttpInfo($sale_id, $include_product_info, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleFulfilmentAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleFulfilmentAsyncWithHttpInfo($sale_id = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleFulfilment'][0])
    {
        $returnType = '\Cin7\Model\SaleFulfilments';
        $request = $this->getSaleFulfilmentRequest($sale_id, $include_product_info, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleFulfilment'
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleFulfilmentRequest($sale_id = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleFulfilment'][0])
    {




        $resourcePath = '/sale/fulfilment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'SaleID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_product_info,
            'IncludeProductInfo', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleInvoice
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id sale_id (optional)
     * @param  string|null $combine_additional_charges combine_additional_charges (optional)
     * @param  string|null $include_product_info include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getSaleInvoice($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleInvoice'][0])
    {
        $this->getSaleInvoiceWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $contentType);
    }

    /**
     * Operation getSaleInvoiceWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleInvoiceWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleInvoice'][0])
    {
        $request = $this->getSaleInvoiceRequest($sale_id, $combine_additional_charges, $include_product_info, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleInvoiceAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleInvoiceAsync($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleInvoice'][0])
    {
        return $this->getSaleInvoiceAsyncWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleInvoiceAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleInvoiceAsyncWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleInvoice'][0])
    {
        $returnType = '';
        $request = $this->getSaleInvoiceRequest($sale_id, $combine_additional_charges, $include_product_info, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleInvoice'
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleInvoiceRequest($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleInvoice'][0])
    {





        $resourcePath = '/sale/invoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'SaleID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combine_additional_charges,
            'CombineAdditionalCharges', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_product_info,
            'IncludeProductInfo', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleList
     *
     * Your GET endpoint
     *
     * @param  float|null $page page (optional)
     * @param  float|null $limit limit (optional)
     * @param  string|null $search search (optional)
     * @param  string|null $created_since created_since (optional)
     * @param  string|null $updated_since updated_since (optional)
     * @param  string|null $ship_by ship_by (optional)
     * @param  string|null $quote_status quote_status (optional)
     * @param  string|null $order_status order_status (optional)
     * @param  string|null $combined_pick_status combined_pick_status (optional)
     * @param  string|null $combined_pack_status combined_pack_status (optional)
     * @param  string|null $combined_shipping_status combined_shipping_status (optional)
     * @param  string|null $combined_invoice_status combined_invoice_status (optional)
     * @param  string|null $credit_note_status credit_note_status (optional)
     * @param  string|null $external_id external_id (optional)
     * @param  string|null $status status (optional)
     * @param  bool|null $ready_for_shipping ready_for_shipping (optional)
     * @param  string|null $order_location_id order_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleList'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\GetSaleList200Response
     */
    public function getSaleList($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $ship_by = null, $quote_status = null, $order_status = null, $combined_pick_status = null, $combined_pack_status = null, $combined_shipping_status = null, $combined_invoice_status = null, $credit_note_status = null, $external_id = null, $status = null, $ready_for_shipping = null, $order_location_id = null, string $contentType = self::contentTypes['getSaleList'][0])
    {
        list($response) = $this->getSaleListWithHttpInfo($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id, $contentType);
        return $response;
    }

    /**
     * Operation getSaleListWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $ship_by (optional)
     * @param  string|null $quote_status (optional)
     * @param  string|null $order_status (optional)
     * @param  string|null $combined_pick_status (optional)
     * @param  string|null $combined_pack_status (optional)
     * @param  string|null $combined_shipping_status (optional)
     * @param  string|null $combined_invoice_status (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $external_id (optional)
     * @param  string|null $status (optional)
     * @param  bool|null $ready_for_shipping (optional)
     * @param  string|null $order_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleList'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\GetSaleList200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleListWithHttpInfo($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $ship_by = null, $quote_status = null, $order_status = null, $combined_pick_status = null, $combined_pack_status = null, $combined_shipping_status = null, $combined_invoice_status = null, $credit_note_status = null, $external_id = null, $status = null, $ready_for_shipping = null, $order_location_id = null, string $contentType = self::contentTypes['getSaleList'][0])
    {
        $request = $this->getSaleListRequest($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\GetSaleList200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\GetSaleList200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\GetSaleList200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleListAsync
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $ship_by (optional)
     * @param  string|null $quote_status (optional)
     * @param  string|null $order_status (optional)
     * @param  string|null $combined_pick_status (optional)
     * @param  string|null $combined_pack_status (optional)
     * @param  string|null $combined_shipping_status (optional)
     * @param  string|null $combined_invoice_status (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $external_id (optional)
     * @param  string|null $status (optional)
     * @param  bool|null $ready_for_shipping (optional)
     * @param  string|null $order_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleListAsync($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $ship_by = null, $quote_status = null, $order_status = null, $combined_pick_status = null, $combined_pack_status = null, $combined_shipping_status = null, $combined_invoice_status = null, $credit_note_status = null, $external_id = null, $status = null, $ready_for_shipping = null, $order_location_id = null, string $contentType = self::contentTypes['getSaleList'][0])
    {
        return $this->getSaleListAsyncWithHttpInfo($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleListAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $ship_by (optional)
     * @param  string|null $quote_status (optional)
     * @param  string|null $order_status (optional)
     * @param  string|null $combined_pick_status (optional)
     * @param  string|null $combined_pack_status (optional)
     * @param  string|null $combined_shipping_status (optional)
     * @param  string|null $combined_invoice_status (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $external_id (optional)
     * @param  string|null $status (optional)
     * @param  bool|null $ready_for_shipping (optional)
     * @param  string|null $order_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleListAsyncWithHttpInfo($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $ship_by = null, $quote_status = null, $order_status = null, $combined_pick_status = null, $combined_pack_status = null, $combined_shipping_status = null, $combined_invoice_status = null, $credit_note_status = null, $external_id = null, $status = null, $ready_for_shipping = null, $order_location_id = null, string $contentType = self::contentTypes['getSaleList'][0])
    {
        $returnType = '\Cin7\Model\GetSaleList200Response';
        $request = $this->getSaleListRequest($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleList'
     *
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $search (optional)
     * @param  string|null $created_since (optional)
     * @param  string|null $updated_since (optional)
     * @param  string|null $ship_by (optional)
     * @param  string|null $quote_status (optional)
     * @param  string|null $order_status (optional)
     * @param  string|null $combined_pick_status (optional)
     * @param  string|null $combined_pack_status (optional)
     * @param  string|null $combined_shipping_status (optional)
     * @param  string|null $combined_invoice_status (optional)
     * @param  string|null $credit_note_status (optional)
     * @param  string|null $external_id (optional)
     * @param  string|null $status (optional)
     * @param  bool|null $ready_for_shipping (optional)
     * @param  string|null $order_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleListRequest($page = null, $limit = null, $search = null, $created_since = null, $updated_since = null, $ship_by = null, $quote_status = null, $order_status = null, $combined_pick_status = null, $combined_pack_status = null, $combined_shipping_status = null, $combined_invoice_status = null, $credit_note_status = null, $external_id = null, $status = null, $ready_for_shipping = null, $order_location_id = null, string $contentType = self::contentTypes['getSaleList'][0])
    {



















        $resourcePath = '/saleList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'Page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'Search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_since,
            'CreatedSince', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_since,
            'UpdatedSince', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ship_by,
            'ShipBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $quote_status,
            'QuoteStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status,
            'OrderStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combined_pick_status,
            'CombinedPickStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combined_pack_status,
            'CombinedPackStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combined_shipping_status,
            'CombinedShippingStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combined_invoice_status,
            'CombinedInvoiceStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $credit_note_status,
            'CreditNoteStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_id,
            'ExternalID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'Status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ready_for_shipping,
            'ReadyForShipping', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_location_id,
            'OrderLocationID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSaleOrder
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id sale_id (optional)
     * @param  string|null $combine_additional_charges combine_additional_charges (optional)
     * @param  string|null $include_product_info include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleOrder'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Order
     */
    public function getSaleOrder($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleOrder'][0])
    {
        list($response) = $this->getSaleOrderWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $contentType);
        return $response;
    }

    /**
     * Operation getSaleOrderWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleOrder'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Order, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSaleOrderWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleOrder'][0])
    {
        $request = $this->getSaleOrderRequest($sale_id, $combine_additional_charges, $include_product_info, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Order',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSaleOrderAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleOrderAsync($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleOrder'][0])
    {
        return $this->getSaleOrderAsyncWithHttpInfo($sale_id, $combine_additional_charges, $include_product_info, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSaleOrderAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSaleOrderAsyncWithHttpInfo($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleOrder'][0])
    {
        $returnType = '\Cin7\Model\Order';
        $request = $this->getSaleOrderRequest($sale_id, $combine_additional_charges, $include_product_info, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSaleOrder'
     *
     * @param  string|null $sale_id (optional)
     * @param  string|null $combine_additional_charges (optional)
     * @param  string|null $include_product_info (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSaleOrderRequest($sale_id = null, $combine_additional_charges = null, $include_product_info = null, string $contentType = self::contentTypes['getSaleOrder'][0])
    {





        $resourcePath = '/sale/order';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'SaleID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $combine_additional_charges,
            'CombineAdditionalCharges', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_product_info,
            'IncludeProductInfo', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalePayment
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id sale_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Payment[]
     */
    public function getSalePayment($sale_id = null, string $contentType = self::contentTypes['getSalePayment'][0])
    {
        list($response) = $this->getSalePaymentWithHttpInfo($sale_id, $contentType);
        return $response;
    }

    /**
     * Operation getSalePaymentWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Payment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalePaymentWithHttpInfo($sale_id = null, string $contentType = self::contentTypes['getSalePayment'][0])
    {
        $request = $this->getSalePaymentRequest($sale_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Payment[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Payment[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Payment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSalePaymentAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalePaymentAsync($sale_id = null, string $contentType = self::contentTypes['getSalePayment'][0])
    {
        return $this->getSalePaymentAsyncWithHttpInfo($sale_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalePaymentAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $sale_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalePaymentAsyncWithHttpInfo($sale_id = null, string $contentType = self::contentTypes['getSalePayment'][0])
    {
        $returnType = '\Cin7\Model\Payment[]';
        $request = $this->getSalePaymentRequest($sale_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalePayment'
     *
     * @param  string|null $sale_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalePaymentRequest($sale_id = null, string $contentType = self::contentTypes['getSalePayment'][0])
    {



        $resourcePath = '/sale/payment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'SaleID', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSale
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFull
     */
    public function postSale($sale = null, string $contentType = self::contentTypes['postSale'][0])
    {
        list($response) = $this->postSaleWithHttpInfo($sale, $contentType);
        return $response;
    }

    /**
     * Operation postSaleWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSaleWithHttpInfo($sale = null, string $contentType = self::contentTypes['postSale'][0])
    {
        $request = $this->postSaleRequest($sale, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSaleAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleAsync($sale = null, string $contentType = self::contentTypes['postSale'][0])
    {
        return $this->postSaleAsyncWithHttpInfo($sale, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSaleAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleAsyncWithHttpInfo($sale = null, string $contentType = self::contentTypes['postSale'][0])
    {
        $returnType = '\Cin7\Model\SaleFull';
        $request = $this->postSaleRequest($sale, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSale'
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSaleRequest($sale = null, string $contentType = self::contentTypes['postSale'][0])
    {



        $resourcePath = '/sale';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($sale)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($sale));
            } else {
                $httpBody = $sale;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSaleCreditnote
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\CreditNote|null $credit_note credit_note (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleCreditNotes
     */
    public function postSaleCreditnote($credit_note = null, string $contentType = self::contentTypes['postSaleCreditnote'][0])
    {
        list($response) = $this->postSaleCreditnoteWithHttpInfo($credit_note, $contentType);
        return $response;
    }

    /**
     * Operation postSaleCreditnoteWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\CreditNote|null $credit_note (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleCreditNotes, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSaleCreditnoteWithHttpInfo($credit_note = null, string $contentType = self::contentTypes['postSaleCreditnote'][0])
    {
        $request = $this->postSaleCreditnoteRequest($credit_note, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleCreditNotes',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleCreditNotes',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleCreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSaleCreditnoteAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\CreditNote|null $credit_note (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleCreditnoteAsync($credit_note = null, string $contentType = self::contentTypes['postSaleCreditnote'][0])
    {
        return $this->postSaleCreditnoteAsyncWithHttpInfo($credit_note, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSaleCreditnoteAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\CreditNote|null $credit_note (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleCreditnoteAsyncWithHttpInfo($credit_note = null, string $contentType = self::contentTypes['postSaleCreditnote'][0])
    {
        $returnType = '\Cin7\Model\SaleCreditNotes';
        $request = $this->postSaleCreditnoteRequest($credit_note, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSaleCreditnote'
     *
     * @param  \Cin7\Model\CreditNote|null $credit_note (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleCreditnote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSaleCreditnoteRequest($credit_note = null, string $contentType = self::contentTypes['postSaleCreditnote'][0])
    {



        $resourcePath = '/sale/creditnote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($credit_note)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($credit_note));
            } else {
                $httpBody = $credit_note;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSaleFulfilment
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\SaleFulfilments|null $sale_fulfilments sale_fulfilments (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFulfilments
     */
    public function postSaleFulfilment($sale_fulfilments = null, string $contentType = self::contentTypes['postSaleFulfilment'][0])
    {
        list($response) = $this->postSaleFulfilmentWithHttpInfo($sale_fulfilments, $contentType);
        return $response;
    }

    /**
     * Operation postSaleFulfilmentWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\SaleFulfilments|null $sale_fulfilments (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFulfilments, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSaleFulfilmentWithHttpInfo($sale_fulfilments = null, string $contentType = self::contentTypes['postSaleFulfilment'][0])
    {
        $request = $this->postSaleFulfilmentRequest($sale_fulfilments, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFulfilments',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFulfilments',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFulfilments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSaleFulfilmentAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\SaleFulfilments|null $sale_fulfilments (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleFulfilmentAsync($sale_fulfilments = null, string $contentType = self::contentTypes['postSaleFulfilment'][0])
    {
        return $this->postSaleFulfilmentAsyncWithHttpInfo($sale_fulfilments, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSaleFulfilmentAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\SaleFulfilments|null $sale_fulfilments (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleFulfilmentAsyncWithHttpInfo($sale_fulfilments = null, string $contentType = self::contentTypes['postSaleFulfilment'][0])
    {
        $returnType = '\Cin7\Model\SaleFulfilments';
        $request = $this->postSaleFulfilmentRequest($sale_fulfilments, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSaleFulfilment'
     *
     * @param  \Cin7\Model\SaleFulfilments|null $sale_fulfilments (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleFulfilment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSaleFulfilmentRequest($sale_fulfilments = null, string $contentType = self::contentTypes['postSaleFulfilment'][0])
    {



        $resourcePath = '/sale/fulfilment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($sale_fulfilments)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($sale_fulfilments));
            } else {
                $httpBody = $sale_fulfilments;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSaleInvoice
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleInvoices
     */
    public function postSaleInvoice($invoice = null, string $contentType = self::contentTypes['postSaleInvoice'][0])
    {
        list($response) = $this->postSaleInvoiceWithHttpInfo($invoice, $contentType);
        return $response;
    }

    /**
     * Operation postSaleInvoiceWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleInvoices, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSaleInvoiceWithHttpInfo($invoice = null, string $contentType = self::contentTypes['postSaleInvoice'][0])
    {
        $request = $this->postSaleInvoiceRequest($invoice, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleInvoices',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleInvoices',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleInvoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSaleInvoiceAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleInvoiceAsync($invoice = null, string $contentType = self::contentTypes['postSaleInvoice'][0])
    {
        return $this->postSaleInvoiceAsyncWithHttpInfo($invoice, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSaleInvoiceAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleInvoiceAsyncWithHttpInfo($invoice = null, string $contentType = self::contentTypes['postSaleInvoice'][0])
    {
        $returnType = '\Cin7\Model\SaleInvoices';
        $request = $this->postSaleInvoiceRequest($invoice, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSaleInvoice'
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSaleInvoiceRequest($invoice = null, string $contentType = self::contentTypes['postSaleInvoice'][0])
    {



        $resourcePath = '/sale/invoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($invoice)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($invoice));
            } else {
                $httpBody = $invoice;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSaleOrder
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Order|null $order order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleOrder'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Order
     */
    public function postSaleOrder($order = null, string $contentType = self::contentTypes['postSaleOrder'][0])
    {
        list($response) = $this->postSaleOrderWithHttpInfo($order, $contentType);
        return $response;
    }

    /**
     * Operation postSaleOrderWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleOrder'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Order, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSaleOrderWithHttpInfo($order = null, string $contentType = self::contentTypes['postSaleOrder'][0])
    {
        $request = $this->postSaleOrderRequest($order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Order',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Order',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Order',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSaleOrderAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleOrderAsync($order = null, string $contentType = self::contentTypes['postSaleOrder'][0])
    {
        return $this->postSaleOrderAsyncWithHttpInfo($order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSaleOrderAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSaleOrderAsyncWithHttpInfo($order = null, string $contentType = self::contentTypes['postSaleOrder'][0])
    {
        $returnType = '\Cin7\Model\Order';
        $request = $this->postSaleOrderRequest($order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSaleOrder'
     *
     * @param  \Cin7\Model\Order|null $order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSaleOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSaleOrderRequest($order = null, string $contentType = self::contentTypes['postSaleOrder'][0])
    {



        $resourcePath = '/sale/order';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order));
            } else {
                $httpBody = $order;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSalePayment
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Payment
     */
    public function postSalePayment($payment = null, string $contentType = self::contentTypes['postSalePayment'][0])
    {
        list($response) = $this->postSalePaymentWithHttpInfo($payment, $contentType);
        return $response;
    }

    /**
     * Operation postSalePaymentWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Payment, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSalePaymentWithHttpInfo($payment = null, string $contentType = self::contentTypes['postSalePayment'][0])
    {
        $request = $this->postSalePaymentRequest($payment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Payment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Payment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Payment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postSalePaymentAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalePaymentAsync($payment = null, string $contentType = self::contentTypes['postSalePayment'][0])
    {
        return $this->postSalePaymentAsyncWithHttpInfo($payment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSalePaymentAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalePaymentAsyncWithHttpInfo($payment = null, string $contentType = self::contentTypes['postSalePayment'][0])
    {
        $returnType = '\Cin7\Model\Payment';
        $request = $this->postSalePaymentRequest($payment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSalePayment'
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSalePaymentRequest($payment = null, string $contentType = self::contentTypes['postSalePayment'][0])
    {



        $resourcePath = '/sale/payment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($payment)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($payment));
            } else {
                $httpBody = $payment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSale
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleFull
     */
    public function putSale($sale = null, string $contentType = self::contentTypes['putSale'][0])
    {
        list($response) = $this->putSaleWithHttpInfo($sale, $contentType);
        return $response;
    }

    /**
     * Operation putSaleWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSale'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSaleWithHttpInfo($sale = null, string $contentType = self::contentTypes['putSale'][0])
    {
        $request = $this->putSaleRequest($sale, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation putSaleAsync
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSaleAsync($sale = null, string $contentType = self::contentTypes['putSale'][0])
    {
        return $this->putSaleAsyncWithHttpInfo($sale, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSaleAsyncWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSaleAsyncWithHttpInfo($sale = null, string $contentType = self::contentTypes['putSale'][0])
    {
        $returnType = '\Cin7\Model\SaleFull';
        $request = $this->putSaleRequest($sale, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSale'
     *
     * @param  \Cin7\Model\Sale|null $sale (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSale'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSaleRequest($sale = null, string $contentType = self::contentTypes['putSale'][0])
    {



        $resourcePath = '/sale';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($sale)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($sale));
            } else {
                $httpBody = $sale;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSaleInvoice
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\SaleInvoices
     */
    public function putSaleInvoice($invoice = null, string $contentType = self::contentTypes['putSaleInvoice'][0])
    {
        list($response) = $this->putSaleInvoiceWithHttpInfo($invoice, $contentType);
        return $response;
    }

    /**
     * Operation putSaleInvoiceWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSaleInvoice'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\SaleInvoices, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSaleInvoiceWithHttpInfo($invoice = null, string $contentType = self::contentTypes['putSaleInvoice'][0])
    {
        $request = $this->putSaleInvoiceRequest($invoice, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\SaleInvoices',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\SaleInvoices',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\SaleInvoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation putSaleInvoiceAsync
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSaleInvoiceAsync($invoice = null, string $contentType = self::contentTypes['putSaleInvoice'][0])
    {
        return $this->putSaleInvoiceAsyncWithHttpInfo($invoice, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSaleInvoiceAsyncWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSaleInvoiceAsyncWithHttpInfo($invoice = null, string $contentType = self::contentTypes['putSaleInvoice'][0])
    {
        $returnType = '\Cin7\Model\SaleInvoices';
        $request = $this->putSaleInvoiceRequest($invoice, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSaleInvoice'
     *
     * @param  \Cin7\Model\Invoice|null $invoice (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSaleInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSaleInvoiceRequest($invoice = null, string $contentType = self::contentTypes['putSaleInvoice'][0])
    {



        $resourcePath = '/sale/invoice';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($invoice)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($invoice));
            } else {
                $httpBody = $invoice;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSalePayment
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Payment
     */
    public function putSalePayment($payment = null, string $contentType = self::contentTypes['putSalePayment'][0])
    {
        list($response) = $this->putSalePaymentWithHttpInfo($payment, $contentType);
        return $response;
    }

    /**
     * Operation putSalePaymentWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSalePayment'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Payment, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSalePaymentWithHttpInfo($payment = null, string $contentType = self::contentTypes['putSalePayment'][0])
    {
        $request = $this->putSalePaymentRequest($payment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Payment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Payment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Payment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation putSalePaymentAsync
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalePaymentAsync($payment = null, string $contentType = self::contentTypes['putSalePayment'][0])
    {
        return $this->putSalePaymentAsyncWithHttpInfo($payment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSalePaymentAsyncWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalePaymentAsyncWithHttpInfo($payment = null, string $contentType = self::contentTypes['putSalePayment'][0])
    {
        $returnType = '\Cin7\Model\Payment';
        $request = $this->putSalePaymentRequest($payment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSalePayment'
     *
     * @param  \Cin7\Model\Payment|null $payment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putSalePayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSalePaymentRequest($payment = null, string $contentType = self::contentTypes['putSalePayment'][0])
    {



        $resourcePath = '/sale/payment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($payment)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($payment));
            } else {
                $httpBody = $payment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
