<?php
/**
 * ProductApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * cin7
 *
 * Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.  https://dearinventory.docs.apiary.io/#introduction/api-introduction
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@tideconnects.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cin7\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Cin7\ApiException;
use Cin7\Configuration;
use Cin7\FormDataProcessor;
use Cin7\HeaderSelector;
use Cin7\ObjectSerializer;

/**
 * ProductApi Class Doc Comment
 *
 * @category Class
 * @package  Cin7
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getProduct' => [
            'application/json',
        ],
        'postProduct' => [
            'application/json',
        ],
        'putProduct' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getProduct
     *
     * Your GET endpoint
     *
     * @param  string|null $id id (optional)
     * @param  float|null $page page (optional)
     * @param  float|null $limit limit (optional)
     * @param  string|null $name name (optional)
     * @param  string|null $sku sku (optional)
     * @param  string|null $modified_since modified_since (optional)
     * @param  bool|null $include_deprecated include_deprecated (optional)
     * @param  bool|null $include_bom include_bom (optional)
     * @param  bool|null $include_suppliers include_suppliers (optional)
     * @param  bool|null $include_movements include_movements (optional)
     * @param  bool|null $include_attachments include_attachments (optional)
     * @param  bool|null $include_reorder_levels include_reorder_levels (optional)
     * @param  bool|null $include_custom_prices include_custom_prices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getProduct($id = null, $page = null, $limit = null, $name = null, $sku = null, $modified_since = null, $include_deprecated = null, $include_bom = null, $include_suppliers = null, $include_movements = null, $include_attachments = null, $include_reorder_levels = null, $include_custom_prices = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        $this->getProductWithHttpInfo($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices, $contentType);
    }

    /**
     * Operation getProductWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $name (optional)
     * @param  string|null $sku (optional)
     * @param  string|null $modified_since (optional)
     * @param  bool|null $include_deprecated (optional)
     * @param  bool|null $include_bom (optional)
     * @param  bool|null $include_suppliers (optional)
     * @param  bool|null $include_movements (optional)
     * @param  bool|null $include_attachments (optional)
     * @param  bool|null $include_reorder_levels (optional)
     * @param  bool|null $include_custom_prices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductWithHttpInfo($id = null, $page = null, $limit = null, $name = null, $sku = null, $modified_since = null, $include_deprecated = null, $include_bom = null, $include_suppliers = null, $include_movements = null, $include_attachments = null, $include_reorder_levels = null, $include_custom_prices = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        $request = $this->getProductRequest($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation getProductAsync
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $name (optional)
     * @param  string|null $sku (optional)
     * @param  string|null $modified_since (optional)
     * @param  bool|null $include_deprecated (optional)
     * @param  bool|null $include_bom (optional)
     * @param  bool|null $include_suppliers (optional)
     * @param  bool|null $include_movements (optional)
     * @param  bool|null $include_attachments (optional)
     * @param  bool|null $include_reorder_levels (optional)
     * @param  bool|null $include_custom_prices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductAsync($id = null, $page = null, $limit = null, $name = null, $sku = null, $modified_since = null, $include_deprecated = null, $include_bom = null, $include_suppliers = null, $include_movements = null, $include_attachments = null, $include_reorder_levels = null, $include_custom_prices = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        return $this->getProductAsyncWithHttpInfo($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  string|null $id (optional)
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $name (optional)
     * @param  string|null $sku (optional)
     * @param  string|null $modified_since (optional)
     * @param  bool|null $include_deprecated (optional)
     * @param  bool|null $include_bom (optional)
     * @param  bool|null $include_suppliers (optional)
     * @param  bool|null $include_movements (optional)
     * @param  bool|null $include_attachments (optional)
     * @param  bool|null $include_reorder_levels (optional)
     * @param  bool|null $include_custom_prices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductAsyncWithHttpInfo($id = null, $page = null, $limit = null, $name = null, $sku = null, $modified_since = null, $include_deprecated = null, $include_bom = null, $include_suppliers = null, $include_movements = null, $include_attachments = null, $include_reorder_levels = null, $include_custom_prices = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        $returnType = '';
        $request = $this->getProductRequest($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProduct'
     *
     * @param  string|null $id (optional)
     * @param  float|null $page (optional)
     * @param  float|null $limit (optional)
     * @param  string|null $name (optional)
     * @param  string|null $sku (optional)
     * @param  string|null $modified_since (optional)
     * @param  bool|null $include_deprecated (optional)
     * @param  bool|null $include_bom (optional)
     * @param  bool|null $include_suppliers (optional)
     * @param  bool|null $include_movements (optional)
     * @param  bool|null $include_attachments (optional)
     * @param  bool|null $include_reorder_levels (optional)
     * @param  bool|null $include_custom_prices (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductRequest($id = null, $page = null, $limit = null, $name = null, $sku = null, $modified_since = null, $include_deprecated = null, $include_bom = null, $include_suppliers = null, $include_movements = null, $include_attachments = null, $include_reorder_levels = null, $include_custom_prices = null, string $contentType = self::contentTypes['getProduct'][0])
    {















        $resourcePath = '/product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'Id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'Page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'Name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'Sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_since,
            'ModifiedSince', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_deprecated,
            'IncludeDeprecated', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_bom,
            'IncludeBOM', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_suppliers,
            'IncludeSuppliers', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_movements,
            'IncludeMovements', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_attachments,
            'IncludeAttachments', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_reorder_levels,
            'IncludeReorderLevels', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_custom_prices,
            'IncludeCustomPrices', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postProduct
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Product|null $product product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Product
     */
    public function postProduct($product = null, string $contentType = self::contentTypes['postProduct'][0])
    {
        list($response) = $this->postProductWithHttpInfo($product, $contentType);
        return $response;
    }

    /**
     * Operation postProductWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Product, HTTP status code, HTTP response headers (array of strings)
     */
    public function postProductWithHttpInfo($product = null, string $contentType = self::contentTypes['postProduct'][0])
    {
        $request = $this->postProductRequest($product, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Product',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Product',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Product',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postProductAsync
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postProductAsync($product = null, string $contentType = self::contentTypes['postProduct'][0])
    {
        return $this->postProductAsyncWithHttpInfo($product, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postProductAsyncWithHttpInfo
     *
     * Your POST endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postProductAsyncWithHttpInfo($product = null, string $contentType = self::contentTypes['postProduct'][0])
    {
        $returnType = '\Cin7\Model\Product';
        $request = $this->postProductRequest($product, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postProduct'
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postProductRequest($product = null, string $contentType = self::contentTypes['postProduct'][0])
    {



        $resourcePath = '/product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putProduct
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Product|null $product product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Cin7\Model\Product
     */
    public function putProduct($product = null, string $contentType = self::contentTypes['putProduct'][0])
    {
        list($response) = $this->putProductWithHttpInfo($product, $contentType);
        return $response;
    }

    /**
     * Operation putProductWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putProduct'] to see the possible values for this operation
     *
     * @throws \Cin7\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Cin7\Model\Product, HTTP status code, HTTP response headers (array of strings)
     */
    public function putProductWithHttpInfo($product = null, string $contentType = self::contentTypes['putProduct'][0])
    {
        $request = $this->putProductRequest($product, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Cin7\Model\Product',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Cin7\Model\Product',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cin7\Model\Product',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation putProductAsync
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putProductAsync($product = null, string $contentType = self::contentTypes['putProduct'][0])
    {
        return $this->putProductAsyncWithHttpInfo($product, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putProductAsyncWithHttpInfo
     *
     * Your PUT endpoint
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putProductAsyncWithHttpInfo($product = null, string $contentType = self::contentTypes['putProduct'][0])
    {
        $returnType = '\Cin7\Model\Product';
        $request = $this->putProductRequest($product, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putProduct'
     *
     * @param  \Cin7\Model\Product|null $product (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['putProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putProductRequest($product = null, string $contentType = self::contentTypes['putProduct'][0])
    {



        $resourcePath = '/product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
